/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Offsetable;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.impl.services.ReferenceRepositoryImpl;
import org.netbeans.modules.cnd.modelimpl.trace.TraceModel;
import org.netbeans.modules.cnd.modelimpl.trace.XRefResultSet;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmReferenceStorage;
import org.netbeans.modules.cnd.support.Interrupter;
import org.openide.filesystems.FileUtil;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class TraceXRef
extends TraceModel {
    private String refFile = "";
    private String declarationName = "";
    private int line = 0;
    private int column = 0;
    private static final int FACTOR = 1;
    public static final Comparator<CsmOffsetable> FILE_NAME_START_OFFSET_COMPARATOR = new Comparator<CsmOffsetable>(){

        @Override
        public int compare(CsmOffsetable i1, CsmOffsetable i2) {
            if (i1 == i2) {
                return 0;
            }
            CharSequence path1 = i1.getContainingFile().getAbsolutePath();
            CharSequence path2 = i2.getContainingFile().getAbsolutePath();
            int res = CharSequences.comparator().compare(path1, path2);
            if (res == 0) {
                int ofs1 = i1.getStartOffset();
                int ofs2 = i2.getStartOffset();
                res = ofs1 - ofs2;
            }
            return res;
        }
    };

    public TraceXRef() {
        super(true);
    }

    public static void main(String[] args) {
        TraceXRef.setUp();
        TraceXRef trace = new TraceXRef();
        trace.test(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(String[] args) {
        try {
            this.processArguments(args);
            this.doTest();
            long time = 0L;
            if (super.isShowTime()) {
                time = System.currentTimeMillis();
            }
            CsmDeclaration object = null;
            if (this.declarationName.length() > 0) {
                System.err.println("looking for object with name: " + this.declarationName);
                object = super.getProject().findDeclaration(this.declarationName);
                if (object == null) {
                    System.err.println("No object with name " + this.declarationName + " in model");
                }
            } else if (this.refFile.length() > 0 && this.line > 0 && this.column > 0) {
                System.out.println("looking for object on position: line=" + this.line + " column=" + this.column);
                System.out.println("in file:" + this.refFile);
                CsmFile file = this.getCsmFile(this.refFile);
                if (!(file instanceof FileImpl)) {
                    System.err.println("No CsmFile was found with name: " + this.refFile);
                } else {
                    FileImpl implFile = (FileImpl)file;
                    int offset = implFile.getOffset(this.line, this.column);
                    if (offset < 0) {
                        System.err.println("incorrect offset for position line=" + this.line + " col=" + this.column);
                    } else {
                        CsmReference ref = CsmReferenceResolver.getDefault().findReference((CsmFile)implFile, null, offset);
                        if (ref == null) {
                            System.err.println("no any references were found on position line=" + this.line + " col=" + this.column);
                        } else {
                            object = ref.getReferencedObject();
                        }
                    }
                }
            } else {
                System.err.println("To run xref tests start script with parameter:");
                System.err.println("should be --xref#file_path#1_based_line#1_based_column or --xref#name");
            }
            if (object == null) {
                System.out.println("Nothing to search");
            } else {
                System.out.println("TARGET OBJECT IS\n  " + CsmTracer.toString((CsmObject)object));
                if (CsmKindUtilities.isNamedElement((CsmObject)object)) {
                    System.out.println("NAME IS: " + ((CsmNamedElement)object).getName());
                }
                if (CsmKindUtilities.isDeclaration((CsmObject)object)) {
                    System.out.println("UNIQUE NAME IS: " + object.getUniqueName());
                }
                ReferenceRepositoryImpl xRefRepository = new ReferenceRepositoryImpl();
                CsmObject[] decDef = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)object, (boolean)true);
                CsmObject decl = decDef[0];
                CsmObject def = decDef[1];
                Collection<CsmReference> refs = xRefRepository.getReferences(decl, (CsmProject)this.getProject(), (Set<CsmReferenceKind>)CsmReferenceKind.ALL, Interrupter.DUMMY);
                if (super.isShowTime()) {
                    time = System.currentTimeMillis() - time;
                }
                TraceXRef.traceRefs(refs, decl, def, System.out);
                if (super.isShowTime()) {
                    System.out.println("search took " + time + "ms");
                }
            }
        }
        finally {
            super.shutdown(true);
            APTDriver.close();
            ClankDriver.close();
            APTFileCacheManager.close();
        }
    }

    private static void setUp() {
        FileUtil.setMIMEType((String)"cc", (String)"text/x-c++");
        FileUtil.setMIMEType((String)"h", (String)"text/x-h");
        FileUtil.setMIMEType((String)"c", (String)"text/x-c");
        JEditorPane.registerEditorKitForContentType("text/x-c++", "org.netbeans.modules.cnd.editor.cplusplus.CCKit");
        JEditorPane.registerEditorKitForContentType("text/x-h", "org.netbeans.modules.cnd.editor.cplusplus.HKit");
        JEditorPane.registerEditorKitForContentType("text/x-c", "org.netbeans.modules.cnd.editor.cplusplus.CKit");
    }

    private CsmFile getCsmFile(String path) {
        return super.getProject().findFile(new File(path).getAbsolutePath(), true, false);
    }

    @Override
    protected boolean processFlag(String flag) {
        String xRef = "xref";
        if (flag.startsWith(xRef)) {
            String[] split = flag.split("#");
            boolean error = false;
            if (split.length == 2) {
                this.declarationName = split[1];
                error = this.declarationName == null || this.declarationName.length() == 0;
            } else if (split.length == 4) {
                this.refFile = split[1];
                try {
                    this.line = Integer.parseInt(split[2]);
                    this.column = Integer.parseInt(split[3]);
                }
                catch (NumberFormatException ex) {
                    DiagnosticExceptoins.register(ex);
                    this.line = 0;
                    this.column = 0;
                }
                boolean bl = error = this.refFile == null || this.refFile.length() == 0 || this.line <= 0 || this.column <= 0;
            }
            if (error) {
                this.declarationName = "";
                this.refFile = "";
                System.err.println("unexpected parameter " + flag);
                System.err.println("should be --xref#file_path#1_based_line#1_based_column or --xref#name");
            }
            return true;
        }
        return false;
    }

    public static void traceProjectRefsStatistics(CsmProject csmPrj, final Map<CharSequence, Long> times, final StatisticsParameters params, final PrintWriter printOut, final OutputWriter printErr, final CsmProgressListener callback, final AtomicBoolean canceled) {
        final XRefResultSet<XRefEntry> bag = new XRefResultSet<XRefEntry>();
        final boolean collect = times.isEmpty();
        ArrayList<CsmFile> allFiles = new ArrayList<CsmFile>();
        int i = 0;
        for (CsmFile file : csmPrj.getAllFiles()) {
            ++i;
            allFiles.add(file);
        }
        if (callback != null) {
            callback.projectFilesCounted(csmPrj, allFiles.size());
        }
        RequestProcessor rp = new RequestProcessor("TraceXRef", params.numThreads);
        final CountDownLatch waitFinished = new CountDownLatch(allFiles.size());
        long time = System.nanoTime();
        for (final CsmFile file : allFiles) {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (canceled.get()) {
                            return;
                        }
                        if (callback != null) {
                            callback.fileParsingStarted(file);
                        }
                        String oldName = Thread.currentThread().getName();
                        try {
                            CharSequence absolutePath = file.getAbsolutePath();
                            if (!collect && !times.containsKey(absolutePath)) {
                                return;
                            }
                            Thread.currentThread().setName("Testing xRef " + absolutePath);
                            long time = TraceXRef.analyzeFile(file, params, bag, printOut, printErr, canceled);
                            if (collect && time > params.timeThreshold) {
                                times.put(absolutePath, time);
                            }
                        }
                        finally {
                            Thread.currentThread().setName(oldName);
                        }
                    }
                    finally {
                        waitFinished.countDown();
                    }
                }
            };
            rp.post(task);
        }
        try {
            waitFinished.await();
            bag.setTime(System.nanoTime() - time);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (callback != null) {
            callback.projectParsingFinished(csmPrj);
        }
        TraceXRef.traceStatistics(bag, params, printOut, printErr);
    }

    public static void traceRefs(Collection<CsmReference> out, CsmObject target, PrintStream streamOut) {
        assert (target != null);
        CsmObject[] decDef = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)target, (boolean)true);
        CsmObject decl = decDef[0];
        CsmObject def = decDef[1];
        assert (decl != null);
        TraceXRef.traceRefs(out, decl, def, streamOut);
    }

    public static void traceRefs(Collection<CsmReference> out, CsmObject targetDecl, CsmObject targetDef, PrintStream streamOut) {
        if (out.isEmpty()) {
            streamOut.println("REFERENCES ARE NOT FOUND");
        } else {
            streamOut.println("REFERENCES ARE:");
            out = TraceXRef.sortRefs(out);
            for (CsmReference ref : out) {
                streamOut.println(TraceXRef.toString(ref, targetDecl, targetDef));
            }
        }
    }

    public static String toString(CsmReference ref, CsmObject targetDecl, CsmObject targetDef) {
        String out = CsmTracer.getOffsetString((CsmObject)ref, (boolean)true);
        String postfix = "";
        if (CsmReferenceResolver.getDefault().isKindOf(ref, EnumSet.of(CsmReferenceKind.DECLARATION))) {
            postfix = " (DECLARATION)";
        } else if (CsmReferenceResolver.getDefault().isKindOf(ref, EnumSet.of(CsmReferenceKind.DEFINITION))) {
            postfix = " (DEFINITION)";
        } else if (CsmReferenceResolver.getDefault().isKindOf(ref, EnumSet.of(CsmReferenceKind.UNKNOWN))) {
            System.err.println("unknown reference kind " + ref);
        }
        return out + postfix;
    }

    public static Collection<CsmReference> sortRefs(Collection<CsmReference> refs) {
        ArrayList<CsmReference> out = new ArrayList<CsmReference>(refs);
        Collections.sort(out, FILE_NAME_START_OFFSET_COMPARATOR);
        return out;
    }

    private static long analyzeFile(CsmFile file, StatisticsParameters params, XRefResultSet<XRefEntry> bag, PrintWriter out, OutputWriter printErr, AtomicBoolean canceled) {
        long time = System.currentTimeMillis();
        if (params.analyzeSmartAlgorith) {
            TraceXRef.visitDeclarations(file.getDeclarations(), params, bag, out, printErr, canceled);
        } else if (params.reportIndex) {
            CsmFileReferences.getDefault().accept((CsmScope)file, null, (CsmFileReferences.Visitor)new LWReportIndexVisitor(bag, printErr, canceled, params.reportIndex), params.interestedReferences);
        } else {
            CsmFileReferences.getDefault().accept((CsmScope)file, null, (CsmFileReferences.Visitor)new LWCheckReferenceVisitor(bag, printErr, canceled, params.reportUnresolved), params.interestedReferences);
        }
        time = System.currentTimeMillis() - time;
        CharSequence text = file.getText();
        int lineCount = 1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++lineCount;
        }
        bag.incrementLineCounter(lineCount);
        if (params.printFileStatistic) {
            out.println(file.getAbsolutePath() + " has " + lineCount + " lines; took " + time + "ms");
        }
        return time;
    }

    private static void visitDeclarations(Collection<? extends CsmOffsetableDeclaration> decls, StatisticsParameters params, XRefResultSet<XRefEntry> bag, PrintWriter printOut, OutputWriter printErr, AtomicBoolean canceled) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : decls) {
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
                TraceXRef.handleFunctionDefinition((CsmFunctionDefinition)csmOffsetableDeclaration, params, bag, printOut, printErr);
            } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) {
                TraceXRef.visitDeclarations(((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations(), params, bag, printOut, printErr, canceled);
            } else if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
                TraceXRef.visitDeclarations(((CsmClass)csmOffsetableDeclaration).getMembers(), params, bag, printOut, printErr, canceled);
            }
            if (!canceled.get()) continue;
            break;
        }
    }

    private static void handleFunctionDefinition(CsmFunctionDefinition fun, final StatisticsParameters params, final XRefResultSet<XRefEntry> bag, final PrintWriter printOut, final OutputWriter printErr) {
        CsmCompoundStatement scope = fun.getBody();
        if (scope != null) {
            final XRefResultSet.ContextScope funScope = TraceXRef.classifyFunctionScope((CsmFunction)fun, printOut);
            final ObjectContext<CsmFunctionDefinition> funContext = TraceXRef.createContextObject(fun, printOut);
            final HashSet objectsUsedInScope = new HashSet();
            bag.incrementScopeCounter(funScope);
            CsmFileReferences.getDefault().accept((CsmScope)scope, null, new CsmFileReferences.Visitor(){

                public void visit(CsmReferenceContext context) {
                    CsmReference ref = context.getReference();
                    XRefResultSet.ContextEntry entry = TraceXRef.createEntry(objectsUsedInScope, params, ref, funContext, printOut, printErr);
                    if (entry != null) {
                        bag.addEntry(funScope, entry);
                        if (entry == XRefResultSet.ContextEntry.UNRESOLVED) {
                            CharSequence text = ref.getText();
                            UnresolvedEntry unres = (UnresolvedEntry)bag.getUnresolvedEntry(text);
                            if (unres == null) {
                                RefLink refLink = params.reportUnresolved ? new RefLink(ref) : null;
                                unres = new UnresolvedEntry(text, refLink);
                                bag.addUnresolvedEntry(text, unres);
                            }
                            unres.increment();
                        }
                    }
                }

                public boolean cancelled() {
                    return false;
                }
            }, params.interestedReferences);
        } else {
            printOut.println("function definition without body " + fun);
        }
    }

    private static XRefResultSet.ContextEntry createLightWeightEntry(CsmReferenceContext context, OutputWriter printErr, boolean reportUnresolved) {
        XRefResultSet.ContextEntry entry;
        CsmReference ref = context.getReference();
        CsmObject target = ref.getReferencedObject();
        if (target == null) {
            String kind = "UNRESOLVED";
            entry = XRefResultSet.ContextEntry.UNRESOLVED;
            boolean important = true;
            if (CsmFileReferences.isAfterUnresolved((CsmReferenceContext)context)) {
                entry = XRefResultSet.ContextEntry.UNRESOLVED_AFTER_UNRESOLVED;
                kind = "UNRESOLVED_AFTER_UNRESOLVED";
                important = false;
            } else if (CsmFileReferences.isTemplateBased((CsmReferenceContext)context)) {
                entry = XRefResultSet.ContextEntry.UNRESOLVED_TEMPLATE_BASED;
                kind = "UNRESOLVED_TEMPLATE_BASED";
                important = false;
            } else if (CsmFileReferences.isMacroBased((CsmReferenceContext)context)) {
                entry = XRefResultSet.ContextEntry.UNRESOLVED_MACRO_BASED;
                kind = "UNRESOLVED_MACRO_BASED";
            } else if (CsmFileReferences.isBuiltInBased((CsmReference)ref)) {
                entry = XRefResultSet.ContextEntry.UNRESOLVED_BUILTIN_BASED;
                kind = "UNRESOLVED_BUILTIN_BASED";
            }
            if (reportUnresolved) {
                try {
                    printErr.println(kind + ":" + ref, (OutputListener)new RefLink(ref), important);
                }
                catch (IOException ioe) {}
            }
        } else {
            entry = XRefResultSet.ContextEntry.RESOLVED;
        }
        return entry;
    }

    private static XRefResultSet.ContextEntry createEntry(Set<CsmObject> objectsUsedInScope, StatisticsParameters params, CsmReference ref, ObjectContext<CsmFunctionDefinition> fun, PrintWriter printOut, OutputWriter printErr) {
        XRefResultSet.ContextEntry entry;
        CsmObject target = ref.getReferencedObject();
        if (target == null) {
            entry = XRefResultSet.ContextEntry.UNRESOLVED;
            try {
                printErr.println("UNRESOLVED:" + ref, (OutputListener)new RefLink(ref), true);
            }
            catch (IOException ioe) {}
        } else if (CsmReferenceResolver.getDefault().isKindOf(ref, params.interestedReferences)) {
            XRefResultSet.DeclarationKind declaration = TraceXRef.classifyDeclaration(target, printOut);
            XRefResultSet.DeclarationScope declarationScope = TraceXRef.classifyDeclarationScopeForFunction(declaration, target, fun, printOut);
            XRefResultSet.IncludeLevel declarationIncludeLevel = TraceXRef.classifyIncludeLevel(target, ((ObjectContext)fun).objFile, printOut);
            XRefResultSet.UsageStatistics usageStat = XRefResultSet.UsageStatistics.FIRST_USAGE;
            if (objectsUsedInScope.contains(target)) {
                usageStat = XRefResultSet.UsageStatistics.NEXT_USAGE;
            } else {
                objectsUsedInScope.add(target);
            }
            entry = new XRefResultSet.ContextEntry(declaration, declarationScope, declarationIncludeLevel, usageStat);
        } else {
            entry = null;
        }
        return entry;
    }

    private static XRefResultSet.ContextScope classifyFunctionScope(CsmFunction fun, PrintWriter printOut) {
        assert (fun != null);
        XRefResultSet.ContextScope out = XRefResultSet.ContextScope.UNRESOLVED;
        CsmScope outScope = fun.getScope();
        if (outScope == null) {
            printOut.println("ERROR: no scope for function " + fun);
            return out;
        }
        if (CsmKindUtilities.isConstructor((CsmObject)fun)) {
            out = CsmBaseUtilities.isInlineFunction((CsmFunction)fun) ? XRefResultSet.ContextScope.INLINED_CONSTRUCTOR : XRefResultSet.ContextScope.CONSTRUCTOR;
        } else if (CsmKindUtilities.isMethod((CsmObject)fun)) {
            out = CsmBaseUtilities.isInlineFunction((CsmFunction)fun) ? XRefResultSet.ContextScope.INLINED_METHOD : XRefResultSet.ContextScope.METHOD;
        } else if (CsmKindUtilities.isFile((CsmObject)outScope)) {
            out = XRefResultSet.ContextScope.FILE_LOCAL_FUNCTION;
        } else {
            CsmNamespace ns = CsmBaseUtilities.getFunctionNamespace((CsmFunction)fun);
            if (ns != null) {
                XRefResultSet.ContextScope contextScope = out = ns.isGlobal() ? XRefResultSet.ContextScope.GLOBAL_FUNCTION : XRefResultSet.ContextScope.NAMESPACE_FUNCTION;
            }
        }
        if (out == XRefResultSet.ContextScope.UNRESOLVED) {
            printOut.println("ERROR: non classified function " + fun);
        }
        return out;
    }

    private static XRefResultSet.DeclarationKind classifyDeclaration(CsmObject obj, PrintWriter printOut) {
        XRefResultSet.DeclarationKind out = XRefResultSet.DeclarationKind.UNRESOLVED;
        if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
            out = XRefResultSet.DeclarationKind.CLASSIFIER;
        } else if (CsmKindUtilities.isEnumerator((Object)obj)) {
            out = XRefResultSet.DeclarationKind.ENUMERATOR;
        } else if (CsmKindUtilities.isParamVariable((CsmObject)obj)) {
            out = XRefResultSet.DeclarationKind.PARAMETER;
        } else if (CsmKindUtilities.isVariable((CsmObject)obj)) {
            out = XRefResultSet.DeclarationKind.VARIABLE;
        } else if (CsmKindUtilities.isFunction((CsmObject)obj)) {
            out = XRefResultSet.DeclarationKind.FUNCTION;
        } else if (CsmKindUtilities.isNamespace((Object)obj)) {
            out = XRefResultSet.DeclarationKind.NAMESPACE;
        } else if (CsmKindUtilities.isMacro((CsmObject)obj)) {
            out = XRefResultSet.DeclarationKind.MACRO;
        } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)obj)) {
            out = XRefResultSet.DeclarationKind.CLASS_FORWARD;
        } else if (obj != null) {
            printOut.println("ERROR: non classified declaration " + obj);
        }
        return out;
    }

    private static XRefResultSet.IncludeLevel classifyIncludeLevel(CsmObject obj, CsmFile file, PrintWriter printOut) {
        XRefResultSet.IncludeLevel out = XRefResultSet.IncludeLevel.UNRESOLVED;
        CsmInclude incl = null;
        CsmProject objPrj = null;
        if (CsmKindUtilities.isOffsetable((Object)obj)) {
            CsmFile objFile = ((CsmOffsetable)obj).getContainingFile();
            if (file.equals(objFile)) {
                out = XRefResultSet.IncludeLevel.THIS_FILE;
            } else {
                objPrj = objFile.getProject();
                incl = TraceXRef.findFirstLevelInclude(file, objFile);
            }
        } else if (CsmKindUtilities.isNamespace((Object)obj)) {
            CsmFile defFile;
            CsmNamespace ns = (CsmNamespace)obj;
            objPrj = ns.getProject();
            for (CsmNamespaceDefinition nsDef : ns.getDefinitions()) {
                defFile = nsDef.getContainingFile();
                if (!file.equals(defFile)) continue;
                out = XRefResultSet.IncludeLevel.THIS_FILE;
                break;
            }
            if (out != XRefResultSet.IncludeLevel.THIS_FILE) {
                for (CsmNamespaceDefinition nsDef : ns.getDefinitions()) {
                    defFile = nsDef.getContainingFile();
                    CsmInclude curIncl = TraceXRef.findFirstLevelInclude(file, defFile);
                    if (curIncl == null) continue;
                    incl = curIncl;
                    break;
                }
            }
        } else {
            printOut.println("ERROR: non classified declaration " + obj);
        }
        if (out != XRefResultSet.IncludeLevel.THIS_FILE) {
            out = incl != null ? (incl.isSystem() ? XRefResultSet.IncludeLevel.LIBRARY_DIRECT : XRefResultSet.IncludeLevel.PROJECT_DIRECT) : (file.getProject().equals(objPrj) ? XRefResultSet.IncludeLevel.PROJECT_DEEP : XRefResultSet.IncludeLevel.LIBRARY_DEEP);
        }
        return out;
    }

    private static XRefResultSet.DeclarationScope classifyDeclarationScopeForFunction(XRefResultSet.DeclarationKind kind, CsmObject obj, ObjectContext<CsmFunctionDefinition> csmFunction, PrintWriter printOut) {
        XRefResultSet.DeclarationScope out = XRefResultSet.DeclarationScope.UNRESOLVED;
        ObjectContext<CsmObject> objContext = TraceXRef.createContextObject(obj, printOut);
        switch (kind) {
            case NAMESPACE: {
                out = TraceXRef.checkNamespaceContainers(objContext, csmFunction);
                break;
            }
            case CLASSIFIER: {
                if (((ObjectContext)objContext).objClass != null) {
                    out = TraceXRef.checkClassContainers(objContext, csmFunction);
                    break;
                }
                if (((ObjectContext)objContext).objNs != null) {
                    out = TraceXRef.checkNamespaceContainers(objContext, csmFunction);
                    break;
                }
                if (CsmKindUtilities.isFunction((CsmObject)((ObjectContext)objContext).objScope) && ((CsmFunctionDefinition)((ObjectContext)csmFunction).csmObject).equals(((ObjectContext)objContext).objScope)) {
                    out = XRefResultSet.DeclarationScope.FUNCTION_THIS;
                    break;
                }
                if (printOut == null) break;
                printOut.println("unknown classifier " + ((ObjectContext)objContext).csmObject + " in context of " + ((ObjectContext)csmFunction).csmObject);
                break;
            }
            case FUNCTION: {
                out = TraceXRef.checkFileClassNamespaceContainers(objContext, csmFunction, printOut);
                break;
            }
            case MACRO: {
                out = TraceXRef.checkFileContainer(objContext, csmFunction);
                break;
            }
            case PARAMETER: {
                out = XRefResultSet.DeclarationScope.FUNCTION_THIS;
                break;
            }
            case ENUMERATOR: 
            case VARIABLE: {
                int stOffset = ((CsmOffsetable)obj).getStartOffset();
                if (((CsmFunctionDefinition)((ObjectContext)csmFunction).csmObject).getStartOffset() < stOffset && stOffset < ((CsmFunctionDefinition)((ObjectContext)csmFunction).csmObject).getEndOffset()) {
                    out = XRefResultSet.DeclarationScope.FUNCTION_THIS;
                    break;
                }
                out = TraceXRef.checkFileClassNamespaceContainers(objContext, csmFunction, printOut);
                break;
            }
            case UNRESOLVED: {
                break;
            }
            default: {
                printOut.println("unhandled kind " + (Object)((Object)kind) + " for object " + ((ObjectContext)objContext).csmObject);
            }
        }
        return out;
    }

    private static XRefResultSet.DeclarationScope checkFileContainer(ObjectContext<CsmObject> objContext, ObjectContext<CsmFunctionDefinition> csmFunction) {
        XRefResultSet.DeclarationScope out = ((ObjectContext)csmFunction).objFile.equals(((ObjectContext)objContext).objFile) ? XRefResultSet.DeclarationScope.FILE_THIS : (((ObjectContext)csmFunction).objPrj.equals(((ObjectContext)objContext).objPrj) ? XRefResultSet.DeclarationScope.PROJECT_FILE : XRefResultSet.DeclarationScope.LIBRARY_FILE);
        return out;
    }

    private static XRefResultSet.DeclarationScope checkNamespaceContainers(ObjectContext<CsmObject> objContext, ObjectContext<CsmFunctionDefinition> csmFunction) {
        XRefResultSet.DeclarationScope out = XRefResultSet.DeclarationScope.UNRESOLVED;
        if (((ObjectContext)objContext).objNs != null) {
            boolean isNested = false;
            if (!((ObjectContext)objContext).objNs.isGlobal() && ((ObjectContext)csmFunction).objNs != null && !((ObjectContext)csmFunction).objNs.isGlobal()) {
                CsmNamespace ns = ((ObjectContext)csmFunction).objNs;
                if (ns.equals(((ObjectContext)objContext).objNs)) {
                    out = XRefResultSet.DeclarationScope.NAMESPACE_THIS;
                    isNested = true;
                } else {
                    while (ns != null && !ns.isGlobal()) {
                        if (ns.equals(((ObjectContext)objContext).objNs)) {
                            out = XRefResultSet.DeclarationScope.NAMESPACE_PARENT;
                            isNested = true;
                            break;
                        }
                        ns = ns.getParent();
                    }
                }
            }
            if (!isNested) {
                out = ((ObjectContext)objContext).objNs.isGlobal() ? (((ObjectContext)csmFunction).objPrj.equals(((ObjectContext)objContext).objPrj) ? XRefResultSet.DeclarationScope.PROJECT_GLOBAL : XRefResultSet.DeclarationScope.LIBRARY_GLOBAL) : (((ObjectContext)csmFunction).objPrj.equals(((ObjectContext)objContext).objPrj) ? XRefResultSet.DeclarationScope.PROJECT_NAMESPACE : XRefResultSet.DeclarationScope.LIBRARY_NAMESPACE);
            }
        }
        return out;
    }

    private static XRefResultSet.DeclarationScope checkClassContainers(ObjectContext<CsmObject> objContext, ObjectContext<CsmFunctionDefinition> csmFunction) {
        XRefResultSet.DeclarationScope out = XRefResultSet.DeclarationScope.UNRESOLVED;
        if (((ObjectContext)objContext).objClass != null) {
            boolean isInherited = false;
            if (((ObjectContext)csmFunction).objClass != null) {
                if (((ObjectContext)csmFunction).objClass.equals(((ObjectContext)objContext).objClass)) {
                    out = XRefResultSet.DeclarationScope.CLASSIFIER_THIS;
                    isInherited = true;
                } else if (CsmInheritanceUtilities.isAssignableFrom((CsmClass)((ObjectContext)objContext).objClass, (CsmClass)((ObjectContext)csmFunction).objClass)) {
                    out = XRefResultSet.DeclarationScope.CLASSIFIER_PARENT;
                    isInherited = true;
                }
            }
            if (!isInherited) {
                out = ((ObjectContext)csmFunction).objPrj.equals(((ObjectContext)objContext).objPrj) ? XRefResultSet.DeclarationScope.PROJECT_CLASSIFIER : XRefResultSet.DeclarationScope.LIBRARY_CLASSIFIER;
            }
        }
        return out;
    }

    private static XRefResultSet.DeclarationScope checkFileClassNamespaceContainers(ObjectContext<CsmObject> objContext, ObjectContext<CsmFunctionDefinition> csmFunction, PrintWriter printOut) {
        XRefResultSet.DeclarationScope out = XRefResultSet.DeclarationScope.UNRESOLVED;
        if (CsmKindUtilities.isFile((CsmObject)((ObjectContext)objContext).objScope)) {
            out = TraceXRef.checkFileContainer(objContext, csmFunction);
        } else if (((ObjectContext)objContext).objClass != null) {
            out = TraceXRef.checkClassContainers(objContext, csmFunction);
        } else if (((ObjectContext)objContext).objNs != null) {
            out = TraceXRef.checkNamespaceContainers(objContext, csmFunction);
        } else if (printOut != null) {
            printOut.println("unknown scope of " + ((ObjectContext)objContext).csmObject + " in context of " + ((ObjectContext)csmFunction).csmObject);
        }
        return out;
    }

    private static CsmInclude findFirstLevelInclude(CsmFile startFile, CsmFile searchFile) {
        assert (startFile != null) : "start file must be not null";
        assert (searchFile != null) : "search file must be not null";
        for (CsmInclude incl : startFile.getIncludes()) {
            CsmFile included = incl.getIncludeFile();
            if (searchFile.equals(included)) {
                return incl;
            }
            if (included == null || !included.getDeclarations().isEmpty()) continue;
            return TraceXRef.findFirstLevelInclude(included, searchFile);
        }
        return null;
    }

    private static void traceStatistics(XRefResultSet<XRefEntry> bag, StatisticsParameters params, PrintWriter printOut, OutputWriter printErr) {
        Collection<XRefResultSet.ContextEntry> entries;
        printOut.println("Number of analyzed contexts " + bag.getNumberOfAllContexts());
        Collection<XRefResultSet.ContextScope> sortedContextScopes = XRefResultSet.sortedContextScopes(bag, false);
        int numProjectProints = 0;
        int numUnresolvedPoints = 0;
        int numMacroBasedUnresolvedPoints = 0;
        int numBuiltinBasedUnresolvedPoints = 0;
        int numTemplateBasedUnresolvedPoints = 0;
        for (XRefResultSet.ContextScope scope : sortedContextScopes) {
            Collection<XRefResultSet.ContextEntry> entries3 = bag.getEntries(scope);
            numProjectProints += entries3.size();
            for (XRefResultSet.ContextEntry contextEntry : entries3) {
                if (contextEntry == XRefResultSet.ContextEntry.UNRESOLVED) {
                    ++numUnresolvedPoints;
                    continue;
                }
                if (contextEntry == XRefResultSet.ContextEntry.UNRESOLVED_MACRO_BASED) {
                    ++numMacroBasedUnresolvedPoints;
                    continue;
                }
                if (contextEntry == XRefResultSet.ContextEntry.UNRESOLVED_TEMPLATE_BASED) {
                    ++numTemplateBasedUnresolvedPoints;
                    continue;
                }
                if (contextEntry != XRefResultSet.ContextEntry.UNRESOLVED_BUILTIN_BASED) continue;
                ++numBuiltinBasedUnresolvedPoints;
            }
        }
        if (bag.getNumberOfContexts(XRefResultSet.ContextScope.CHECK_POINT, false) > 0) {
            numProjectProints = bag.getNumberOfContexts(XRefResultSet.ContextScope.CHECK_POINT, false);
        }
        int allUnresolvedPoints = numUnresolvedPoints + numMacroBasedUnresolvedPoints + numBuiltinBasedUnresolvedPoints;
        double unresolvedRatio = numProjectProints == 0 ? 0.0 : 100.0 * (double)allUnresolvedPoints / (double)numProjectProints;
        double unresolvedMacroBasedRatio = numProjectProints == 0 ? 0.0 : 100.0 * (double)numMacroBasedUnresolvedPoints / (double)numProjectProints;
        double unresolvedBuiltinBasedRatio = numProjectProints == 0 ? 0.0 : 100.0 * (double)numBuiltinBasedUnresolvedPoints / (double)numProjectProints;
        double unresolvedTemplateBasedRatio = numProjectProints == 0 ? 0.0 : 100.0 * (double)numTemplateBasedUnresolvedPoints / (double)numProjectProints;
        String unresolvedStatistics = String.format("Unresolved %d (%.2f%%) where MacroBased %d (%.2f%%) of %d checkpoints [TemplateBased warnings %d (%.2f%%), Builtin %d (%.2f%%)]", allUnresolvedPoints, unresolvedRatio, numMacroBasedUnresolvedPoints, unresolvedMacroBasedRatio, numProjectProints, numTemplateBasedUnresolvedPoints, unresolvedTemplateBasedRatio, numBuiltinBasedUnresolvedPoints, unresolvedBuiltinBasedRatio);
        printOut.println(unresolvedStatistics);
        String performanceStatistics = String.format("Line count: %d, time %.0f ms, %nspeed %.2f lines/sec, %.2f refs/sec", bag.getLineCount(), bag.getTimeMs(), bag.getLinesPerSec(), (double)numProjectProints / bag.getTimeSec());
        printOut.println(performanceStatistics);
        if (params.reportIndex) {
            printOut.println("Index stats:");
            HashMap<CharSequence, Integer> indexStats = new HashMap<CharSequence, Integer>();
            HashMap<CharSequence, Integer> allStats = new HashMap<CharSequence, Integer>();
            int totalAll = 0;
            int totalIndex = 0;
            Collection<XRefEntry> entries2 = bag.getIndexedEntries(new Comparator<XRefEntry>(){

                @Override
                public int compare(XRefEntry o1, XRefEntry o2) {
                    if (o1 instanceof IndexedEntry && o2 instanceof IndexedEntry) {
                        return ((IndexedEntry)o2).getNrIndexed() - ((IndexedEntry)o1).getNrIndexed();
                    }
                    return 0;
                }
            });
            for (XRefEntry xRefEntry : entries2) {
                if (!(xRefEntry instanceof IndexedEntry)) continue;
                IndexedEntry indexed = (IndexedEntry)xRefEntry;
                totalAll += indexed.getNrAll();
                totalIndex += indexed.getNrIndexed();
                if (indexStats.containsKey(indexed.getKind())) {
                    indexStats.put(indexed.getKind(), (Integer)indexStats.get(indexed.getKind()) + indexed.getNrIndexed());
                } else {
                    indexStats.put(indexed.getKind(), indexed.getNrIndexed());
                }
                if (allStats.containsKey(indexed.getKind())) {
                    allStats.put(indexed.getKind(), (Integer)allStats.get(indexed.getKind()) + indexed.getNrAll());
                    continue;
                }
                allStats.put(indexed.getKind(), indexed.getNrAll());
            }
            String header = String.format("%20s %10s %10s %5s", "Kind", "Indexed", "Checked", "%%");
            printOut.println(header);
            for (CharSequence kind : indexStats.keySet()) {
                if (kind == null) continue;
                String s2 = String.format("%20s %10d %10d %.2f%%", kind, indexStats.get(kind), allStats.get(kind), (double)((Integer)indexStats.get(kind)).intValue() * 100.0 / (double)((Integer)allStats.get(kind)).intValue());
                printOut.println(s2);
            }
            String string = String.format("%20s %10d %10d %.2f%%", "Total", totalIndex, totalAll, (double)totalIndex * 100.0 / (double)totalAll);
            printOut.println(string);
        }
        if (!params.reportUnresolved) {
            return;
        }
        if (!params.analyzeSmartAlgorith) {
            if (allUnresolvedPoints > 0) {
                Collection<XRefEntry> entries4 = bag.getUnresolvedEntries(new Comparator<XRefEntry>(){

                    @Override
                    public int compare(XRefEntry o1, XRefEntry o2) {
                        if (o1 instanceof UnresolvedEntry && o2 instanceof UnresolvedEntry) {
                            return ((UnresolvedEntry)o2).getNrUnnamed() - ((UnresolvedEntry)o1).getNrUnnamed();
                        }
                        return 0;
                    }
                });
                for (XRefEntry entry : entries4) {
                    if (!(entry instanceof UnresolvedEntry)) continue;
                    UnresolvedEntry unresolvedEntry = (UnresolvedEntry)entry;
                    double unresolvedEntryRatio = 100.0 * (double)unresolvedEntry.getNrUnnamed() / (double)allUnresolvedPoints;
                    String string = String.format("%20s\t|%6s\t| %.2f%% ", unresolvedEntry.getName(), unresolvedEntry.getNrUnnamed(), unresolvedEntryRatio);
                    try {
                        printErr.println(string, (OutputListener)unresolvedEntry.getLink(), false);
                    }
                    catch (IOException ex) {}
                }
            }
            return;
        }
        String contextFmt = "%20s\t|%6s\t| %2s |%n";
        String msg = String.format(contextFmt, "Name", "Num", "%");
        printOut.println(msg);
        for (XRefResultSet.ContextScope scope : sortedContextScopes) {
            Collection<XRefResultSet.ContextEntry> entries2 = bag.getEntries(scope);
            if (scope == XRefResultSet.ContextScope.UNRESOLVED && entries2.isEmpty()) continue;
            msg = String.format(contextFmt, new Object[]{scope, bag.getNumberOfContexts(scope, false), bag.getNumberOfContexts(scope, true)});
            printOut.print(msg);
        }
        printOut.println("\nAnalyzed entries per scopes ");
        boolean printTitle = true;
        sortedContextScopes = XRefResultSet.sortedContextScopes(bag, true);
        for (XRefResultSet.ContextScope scope : sortedContextScopes) {
            entries = bag.getEntries(scope);
            TraceXRef.traceEntriesStatistics(scope, entries, printTitle, printOut);
            printTitle = false;
        }
        printOut.println("\nNumbers for \"first\" items approach");
        printTitle = true;
        for (XRefResultSet.ContextScope scope : sortedContextScopes) {
            entries = bag.getEntries(scope);
            TraceXRef.traceFirstItemsStatistics(scope, entries, printTitle, printOut);
            printTitle = false;
        }
        printOut.println("\nDetails about file inclusion level");
        printTitle = true;
        for (XRefResultSet.ContextScope scope : sortedContextScopes) {
            entries = bag.getEntries(scope);
            TraceXRef.traceFileBasedEntriesStatistics(scope, entries, printTitle, printOut);
            printTitle = false;
        }
        printOut.println("\nDetails about scope of referenced declarations");
        printTitle = true;
        for (XRefResultSet.ContextScope scope : sortedContextScopes) {
            entries = bag.getEntries(scope);
            TraceXRef.traceUsedDeclarationScopeEntriesStatistics(scope, entries, printTitle, printOut);
            printTitle = false;
        }
    }

    private static void traceFirstItemsStatistics(XRefResultSet.ContextScope scope, Collection<XRefResultSet.ContextEntry> entries, boolean printTitle, PrintWriter printOut) {
        String entryFmtFileInfo = "%20s\t|%10s\t|%20s\t|%20s\t|%20s\t|%20s\t|%20s%n";
        if (printTitle) {
            String title = String.format(entryFmtFileInfo, "scope name", "All", "local+cls+ns", "file+#incl-1", "local+cls+ns+#incl-1", "was usages", "context+used");
            printOut.print(title);
        }
        if (scope == XRefResultSet.ContextScope.UNRESOLVED && entries.isEmpty()) {
            return;
        }
        EnumSet<XRefResultSet.IncludeLevel> nearestIncludes = EnumSet.of(XRefResultSet.IncludeLevel.THIS_FILE, XRefResultSet.IncludeLevel.PROJECT_DIRECT, XRefResultSet.IncludeLevel.LIBRARY_DIRECT);
        EnumSet<XRefResultSet.DeclarationScope[]> nearestScopes = EnumSet.of(XRefResultSet.DeclarationScope.FUNCTION_THIS, new XRefResultSet.DeclarationScope[]{XRefResultSet.DeclarationScope.CLASSIFIER_THIS, XRefResultSet.DeclarationScope.CLASSIFIER_PARENT, XRefResultSet.DeclarationScope.FILE_THIS, XRefResultSet.DeclarationScope.NAMESPACE_THIS, XRefResultSet.DeclarationScope.NAMESPACE_PARENT});
        EnumSet<XRefResultSet.DeclarationScope> nonScopes = EnumSet.noneOf(XRefResultSet.DeclarationScope.class);
        EnumSet<XRefResultSet.IncludeLevel> nonIncludes = EnumSet.noneOf(XRefResultSet.IncludeLevel.class);
        EnumSet<XRefResultSet.UsageStatistics> nonUsages = EnumSet.noneOf(XRefResultSet.UsageStatistics.class);
        EnumSet<XRefResultSet.UsageStatistics> wasUsages = EnumSet.of(XRefResultSet.UsageStatistics.SECOND_USAGE, XRefResultSet.UsageStatistics.NEXT_USAGE);
        String msg = String.format(entryFmtFileInfo, new Object[]{scope, entries.size(), TraceXRef.getDeclScopeAndIncludeLevelInfo(entries, nearestScopes, nonIncludes, nonUsages), TraceXRef.getDeclScopeAndIncludeLevelInfo(entries, nonScopes, nearestIncludes, nonUsages), TraceXRef.getDeclScopeAndIncludeLevelInfo(entries, nearestScopes, nearestIncludes, nonUsages), TraceXRef.getDeclScopeAndIncludeLevelInfo(entries, nonScopes, nonIncludes, wasUsages), TraceXRef.getDeclScopeAndIncludeLevelInfo(entries, nearestScopes, nearestIncludes, wasUsages)});
        printOut.print(msg);
    }

    private static void traceFileBasedEntriesStatistics(XRefResultSet.ContextScope scope, Collection<XRefResultSet.ContextEntry> entries, boolean printTitle, PrintWriter printOut) {
        String entryFmtFileInfo = "%20s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s%n";
        if (printTitle) {
            String title = String.format(entryFmtFileInfo, "scope name", "this file", "direct \"\"", "direct <>", "project", "library", "unresolved", "All");
            printOut.print(title);
        }
        if (scope == XRefResultSet.ContextScope.UNRESOLVED && entries.isEmpty()) {
            return;
        }
        String msg = String.format(entryFmtFileInfo, new Object[]{scope, TraceXRef.getIncludeLevelInfo(entries, XRefResultSet.IncludeLevel.THIS_FILE), TraceXRef.getIncludeLevelInfo(entries, XRefResultSet.IncludeLevel.PROJECT_DIRECT), TraceXRef.getIncludeLevelInfo(entries, XRefResultSet.IncludeLevel.LIBRARY_DIRECT), TraceXRef.getIncludeLevelInfo(entries, XRefResultSet.IncludeLevel.PROJECT_DEEP), TraceXRef.getIncludeLevelInfo(entries, XRefResultSet.IncludeLevel.LIBRARY_DEEP), TraceXRef.getIncludeLevelInfo(entries, XRefResultSet.IncludeLevel.UNRESOLVED), entries.size()});
        printOut.print(msg);
    }

    private static void traceUsedDeclarationScopeEntriesStatistics(XRefResultSet.ContextScope scope, Collection<XRefResultSet.ContextEntry> entries, boolean printTitle, PrintWriter printOut) {
        String entryDeclScopeInfo = "%20s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s|%n";
        if (printTitle) {
            String title = String.format(entryDeclScopeInfo, "scope name", "this fun", "this class", "parent class", "prj class", "lib class", "this ns", "parent ns", "prj ns", "lib ns", "this file", "prj file", "lib file", "project", "library", "unresolved", "All");
            printOut.print(title);
        }
        if (scope == XRefResultSet.ContextScope.UNRESOLVED && entries.isEmpty()) {
            return;
        }
        String msg = String.format(entryDeclScopeInfo, new Object[]{scope, TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.FUNCTION_THIS), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.CLASSIFIER_THIS), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.CLASSIFIER_PARENT), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.PROJECT_CLASSIFIER), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.LIBRARY_CLASSIFIER), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.NAMESPACE_THIS), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.NAMESPACE_PARENT), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.PROJECT_NAMESPACE), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.LIBRARY_NAMESPACE), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.FILE_THIS), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.PROJECT_FILE), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.LIBRARY_FILE), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.PROJECT_GLOBAL), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.LIBRARY_GLOBAL), TraceXRef.getDeclarationScopeInfo(entries, XRefResultSet.DeclarationScope.UNRESOLVED), entries.size()});
        printOut.print(msg);
    }

    private static String getDeclScopeAndIncludeLevelInfo(Collection<XRefResultSet.ContextEntry> entries, Set<XRefResultSet.DeclarationScope> declScopes, Set<XRefResultSet.IncludeLevel> levels, Set<XRefResultSet.UsageStatistics> usages) {
        int num = 0;
        for (XRefResultSet.ContextEntry contextEntry : entries) {
            if (!declScopes.contains((Object)contextEntry.declarationScope) && !levels.contains((Object)contextEntry.declarationIncludeLevel) && !usages.contains((Object)contextEntry.usageStatistics)) continue;
            ++num;
        }
        return TraceXRef.toRelString(num, entries.size());
    }

    private static String getIncludeLevelInfo(Collection<XRefResultSet.ContextEntry> entries, XRefResultSet.IncludeLevel level) {
        int num = 0;
        for (XRefResultSet.ContextEntry contextEntry : entries) {
            if (contextEntry.declarationIncludeLevel != level) continue;
            ++num;
        }
        return TraceXRef.toRelString(num, entries.size());
    }

    private static String getDeclarationScopeInfo(Collection<XRefResultSet.ContextEntry> entries, XRefResultSet.DeclarationScope declScope) {
        int num = 0;
        for (XRefResultSet.ContextEntry contextEntry : entries) {
            if (contextEntry.declarationScope != declScope) continue;
            ++num;
        }
        return TraceXRef.toRelString(num, entries.size());
    }

    private static String toRelString(int num, int size) {
        assert (size != 0 || num == 0);
        int rel = num == 0 ? 0 : num * 100 / size;
        return rel + "%(" + num + ")";
    }

    private static void traceEntriesStatistics(XRefResultSet.ContextScope scope, Collection<XRefResultSet.ContextEntry> entries, boolean printTitle, PrintWriter printOut) {
        String entryFmt = "%20s\t|%10s\t|%10s\t|%10s|%n";
        if (printTitle) {
            String title = String.format(entryFmt, "Entries for scope", "Num", "Resolved", "Unresolved");
            printOut.print(title);
        }
        if (scope == XRefResultSet.ContextScope.UNRESOLVED && entries.isEmpty()) {
            return;
        }
        int unresolved = 0;
        for (XRefResultSet.ContextEntry contextEntry : entries) {
            if (contextEntry.declaration != XRefResultSet.DeclarationKind.UNRESOLVED) continue;
            ++unresolved;
        }
        String msg = String.format(entryFmt, new Object[]{scope, entries.size(), entries.size() - unresolved, unresolved});
        printOut.print(msg);
    }

    private static <T extends CsmObject> ObjectContext<T> createContextObject(T obj, PrintWriter printOut) {
        T csmObject = obj;
        CsmClass objClass = null;
        CsmFile objFile = null;
        CsmProject objPrj = null;
        CsmNamespace objNs = null;
        CsmScope objScope = null;
        if (CsmKindUtilities.isOffsetable(obj)) {
            objFile = ((CsmOffsetable)obj).getContainingFile();
            assert (objFile != null);
            objPrj = objFile.getProject();
        } else if (CsmKindUtilities.isNamespace(obj)) {
            objPrj = ((CsmNamespace)obj).getProject();
        } else {
            printOut.println("not handled object " + obj);
        }
        objNs = CsmBaseUtilities.getObjectNamespace(obj);
        objClass = CsmBaseUtilities.getObjectClass(obj);
        if (CsmKindUtilities.isEnumerator(obj)) {
            objScope = ((CsmEnumerator)obj).getEnumeration().getScope();
        } else if (CsmKindUtilities.isScopeElement(obj)) {
            objScope = ((CsmScopeElement)obj).getScope();
        }
        while (objScope != null && !CsmKindUtilities.isNamespaceDefinition((CsmObject)objScope) && !CsmKindUtilities.isClass((CsmObject)objScope) && !CsmKindUtilities.isFunction((CsmObject)objScope) && CsmKindUtilities.isScopeElement((CsmObject)objScope)) {
            objScope = ((CsmScopeElement)objScope).getScope();
        }
        return new ObjectContext<T>(csmObject, objClass, objFile, objPrj, objNs, objScope);
    }

    private static final class IndexedEntry
    implements XRefEntry {
        private final RefLink link;
        private final AtomicInteger nrIndexed;
        private final AtomicInteger nrAll;
        private final CharSequence name;
        private final CharSequence kind;

        public IndexedEntry(CharSequence name, RefLink link, CharSequence kind) {
            this.link = link;
            this.name = name;
            this.nrIndexed = new AtomicInteger(0);
            this.nrAll = new AtomicInteger(0);
            this.kind = kind;
        }

        public CharSequence getName() {
            return this.name;
        }

        public int getNrIndexed() {
            return this.nrIndexed.get();
        }

        public int getNrAll() {
            return this.nrAll.get();
        }

        public RefLink getLink() {
            return this.link;
        }

        public CharSequence getKind() {
            return this.kind;
        }

        private void increment(boolean indexed) {
            if (indexed) {
                this.nrIndexed.incrementAndGet();
            }
            this.nrAll.incrementAndGet();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexedEntry other = (IndexedEntry)obj;
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class UnresolvedEntry
    implements XRefEntry {
        private final RefLink link;
        private final AtomicInteger nrUnnamed;
        private final CharSequence name;

        public UnresolvedEntry(CharSequence name, RefLink link) {
            this.link = link;
            this.name = name;
            this.nrUnnamed = new AtomicInteger(0);
        }

        public CharSequence getName() {
            return this.name;
        }

        public int getNrUnnamed() {
            return this.nrUnnamed.get();
        }

        public RefLink getLink() {
            return this.link;
        }

        private void increment() {
            this.nrUnnamed.incrementAndGet();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnresolvedEntry other = (UnresolvedEntry)obj;
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static interface XRefEntry {
    }

    static final class RefLink
    implements OutputListener {
        private final CsmUID<CsmFile> fileUID;
        private final int offset;

        RefLink(CsmReference ref) {
            this.fileUID = UIDs.get((Object)ref.getContainingFile());
            this.offset = ref.getStartOffset();
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            CsmFile file = (CsmFile)this.fileUID.getObject();
            if (file != null) {
                CsmUtilities.openSource((CsmObject)new Offsetable(file, this.offset, this.offset));
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public boolean equals(Object o) {
            return ((CsmFile)this.fileUID.getObject()).equals(this.fileUID.getObject()) && this.offset == this.offset;
        }

        public int hashCode() {
            return this.offset;
        }
    }

    private static final class ObjectContext<T extends CsmObject> {
        private final T csmObject;
        private final CsmClass objClass;
        private final CsmFile objFile;
        private final CsmProject objPrj;
        private final CsmNamespace objNs;
        private final CsmScope objScope;

        public ObjectContext(T csmObject, CsmClass objClass, CsmFile objFile, CsmProject objPrj, CsmNamespace objNs, CsmScope objScope) {
            this.csmObject = csmObject;
            this.objClass = objClass;
            this.objFile = objFile;
            this.objPrj = objPrj;
            this.objNs = objNs;
            this.objScope = objScope;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Object: ").append(this.csmObject);
            buf.append("\nFile: ").append(this.objFile);
            buf.append("\nClass: ").append(this.objClass);
            buf.append("\nNS: ").append(this.objNs);
            buf.append("\nProject: ").append(this.objPrj);
            buf.append("\nScope: ").append(this.objScope);
            return buf.toString();
        }
    }

    public static final class StatisticsParameters {
        public final Set<CsmReferenceKind> interestedReferences;
        public final boolean analyzeSmartAlgorith;
        public final boolean reportUnresolved;
        public final boolean reportIndex;
        public final int numThreads;
        public final long timeThreshold;
        public boolean printFileStatistic = true;

        public StatisticsParameters(Set<CsmReferenceKind> kinds, boolean analyzeSmartAlgorith, boolean reportUnresolved, boolean reportIndex, int numThreads, long timeThreshold) {
            this.analyzeSmartAlgorith = analyzeSmartAlgorith;
            this.interestedReferences = kinds;
            this.reportUnresolved = reportUnresolved;
            this.reportIndex = reportIndex;
            this.numThreads = numThreads;
            this.timeThreshold = timeThreshold;
        }

        public void printFileStatistic(boolean printFileStatistic) {
            this.printFileStatistic = printFileStatistic;
        }
    }

    private static final class LWReportIndexVisitor
    implements CsmFileReferences.Visitor {
        private final XRefResultSet<XRefEntry> bag;
        private final OutputWriter printErr;
        private final AtomicBoolean canceled;

        public LWReportIndexVisitor(XRefResultSet<XRefEntry> bag, OutputWriter printErr, AtomicBoolean canceled, boolean reportUnresolved) {
            this.bag = bag;
            this.printErr = printErr;
            this.canceled = canceled;
        }

        public void visit(CsmReferenceContext context) {
            CsmReference ref = context.getReference();
            if (this.canceled.get()) {
                return;
            }
            CsmReference refFromStorage = CsmReferenceStorage.getDefault().get((CsmOffsetable)ref);
            boolean fromStorage = refFromStorage != null && refFromStorage.getReferencedObject() != null;
            CsmObject target = ref.getReferencedObject();
            if (target == null) {
                if (fromStorage) {
                    try {
                        this.printErr.println("INDEXED UNRESOLVED:" + ref, (OutputListener)new RefLink(ref), true);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                return;
            }
            if (CsmKindUtilities.isParameter((CsmObject)target)) {
                return;
            }
            if (UIDProviderIml.isSelfUID(UIDs.get((Object)target))) {
                return;
            }
            XRefResultSet.ContextEntry entry = XRefResultSet.ContextEntry.RESOLVED;
            String skind = CsmKindUtilities.isParameter((CsmObject)target) ? "PARAMETER" : (CsmKindUtilities.isDeclaration((CsmObject)target) ? ((CsmDeclaration)target).getKind().toString() : (CsmKindUtilities.isNamespace((Object)target) ? "NAMESPACE" : "UNKNOWN"));
            if (!fromStorage) {
                try {
                    this.printErr.println(skind + ":" + ref, (OutputListener)new RefLink(ref), false);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (entry != null) {
                RefLink refLink = new RefLink(ref);
                CharSequence text = ref.getText();
                IndexedEntry indexed = (IndexedEntry)this.bag.getIndexedEntry(refLink);
                if (indexed == null) {
                    indexed = new IndexedEntry(text, refLink, skind);
                    indexed = (IndexedEntry)this.bag.addIndexedEntry(refLink, indexed);
                }
                indexed.increment(fromStorage);
            }
        }

        public boolean cancelled() {
            return this.canceled.get();
        }
    }

    private static final class LWCheckReferenceVisitor
    implements CsmFileReferences.Visitor {
        private final XRefResultSet<XRefEntry> bag;
        private final OutputWriter printErr;
        private final AtomicBoolean canceled;
        private final boolean reportUnresolved;

        public LWCheckReferenceVisitor(XRefResultSet<XRefEntry> bag, OutputWriter printErr, AtomicBoolean canceled, boolean reportUnresolved) {
            this.bag = bag;
            this.printErr = printErr;
            this.canceled = canceled;
            this.reportUnresolved = reportUnresolved;
        }

        public void visit(CsmReferenceContext context) {
            CsmReference ref = context.getReference();
            if (this.canceled.get()) {
                return;
            }
            XRefResultSet.ContextEntry entry = TraceXRef.createLightWeightEntry(context, this.printErr, this.reportUnresolved);
            if (!this.reportUnresolved) {
                this.bag.incrementScopeCounter(XRefResultSet.ContextScope.CHECK_POINT);
            }
            if (this.reportUnresolved || entry != XRefResultSet.ContextEntry.RESOLVED) {
                this.bag.addEntry(XRefResultSet.ContextScope.UNRESOLVED, entry);
                if (this.reportUnresolved && (entry == XRefResultSet.ContextEntry.UNRESOLVED || entry == XRefResultSet.ContextEntry.UNRESOLVED_MACRO_BASED || entry == XRefResultSet.ContextEntry.UNRESOLVED_BUILTIN_BASED)) {
                    CharSequence text = ref.getText();
                    UnresolvedEntry unres = (UnresolvedEntry)this.bag.getUnresolvedEntry(text);
                    if (unres == null) {
                        unres = new UnresolvedEntry(text, new RefLink(ref));
                        unres = (UnresolvedEntry)this.bag.addUnresolvedEntry(text, unres);
                    }
                    unres.increment();
                }
            }
        }

        public boolean cancelled() {
            return this.canceled.get();
        }
    }
}

