/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.RequestNotSupportedException;
import org.netbeans.modules.debugger.jpda.breakpoints.SourceRootsCache;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ModificationWatchpointEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.WatchpointEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.WatchpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.jpda.BreakpointsClassFilter;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FieldBreakpointImpl
extends ClassBasedBreakpoint {
    private final FieldBreakpoint breakpoint;

    FieldBreakpointImpl(FieldBreakpoint breakpoint, JPDADebuggerImpl debugger, Session session, SourceRootsCache sourceRootsCache) {
        super((JPDABreakpoint)breakpoint, debugger, session, sourceRootsCache);
        this.breakpoint = breakpoint;
        this.setSourceRoot("");
        this.set();
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    @Override
    protected void setRequests() {
        BreakpointsClassFilter.ClassNames classNames = this.getClassFilter().filterClassNames(new BreakpointsClassFilter.ClassNames(new String[]{this.breakpoint.getClassName()}, new String[0]), (JPDABreakpoint)this.breakpoint);
        String[] names = classNames.getClassNames();
        String[] disabledRootPtr = new String[]{null};
        if ((names = this.checkSourcesEnabled(names, disabledRootPtr)).length == 0) {
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_DisabledSourceRoot", (Object)disabledRootPtr[0]));
            return;
        }
        String[] excludedNames = classNames.getExcludedClassNames();
        boolean access = (this.breakpoint.getBreakpointType() & 1) != 0;
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return;
        }
        try {
            boolean modification;
            if (access && !VirtualMachineWrapper.canWatchFieldAccess(vm)) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoFieldAccess"));
                return;
            }
            boolean bl = modification = (this.breakpoint.getBreakpointType() & 2) != 0;
            if (modification && !VirtualMachineWrapper.canWatchFieldModification(vm)) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoFieldModification"));
                return;
            }
            boolean wasSet = this.setClassRequests(names, excludedNames, 1);
            if (wasSet) {
                for (String cn : names) {
                    this.checkLoadedClasses(cn, excludedNames);
                }
            }
        }
        catch (InternalExceptionWrapper e) {
        }
        catch (VMDisconnectedExceptionWrapper e) {
            // empty catch block
        }
    }

    @Override
    protected void classLoaded(List<ReferenceType> referenceTypes) {
        boolean submitted = false;
        int type = this.breakpoint.getBreakpointType();
        boolean fieldAccessType = (type & 1) != 0;
        boolean fieldModificationType = (type & 2) != 0;
        int customHitCountFilter = this.breakpoint.getHitCountFilter();
        if (!fieldAccessType || !fieldModificationType) {
            customHitCountFilter = 0;
        }
        this.setCustomHitCountFilter(customHitCountFilter);
        for (ReferenceType referenceType : referenceTypes) {
            try {
                Field f = ReferenceTypeWrapper.fieldByName(referenceType, this.breakpoint.getFieldName());
                if (f == null) continue;
                if (fieldAccessType) {
                    AccessWatchpointRequest awr = EventRequestManagerWrapper.createAccessWatchpointRequest(this.getEventRequestManager(), f);
                    this.setFilters(awr);
                    this.addEventRequest(awr);
                }
                if (fieldModificationType) {
                    ModificationWatchpointRequest mwr = EventRequestManagerWrapper.createModificationWatchpointRequest(this.getEventRequestManager(), f);
                    this.setFilters(mwr);
                    this.addEventRequest(mwr);
                }
                submitted = true;
            }
            catch (InternalExceptionWrapper e) {
            }
            catch (ClassNotPreparedExceptionWrapper e) {
            }
            catch (ObjectCollectedExceptionWrapper e) {
            }
            catch (VMDisconnectedExceptionWrapper e) {
                return;
            }
            catch (InvalidRequestStateExceptionWrapper irse) {
                Exceptions.printStackTrace((Throwable)irse);
            }
            catch (RequestNotSupportedException rnsex) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_RequestNotSupported"));
                return;
            }
        }
        if (submitted) {
            this.setValidity(Breakpoint.VALIDITY.VALID, null);
        } else {
            String name;
            try {
                name = ReferenceTypeWrapper.name(referenceTypes.get(0));
            }
            catch (InternalExceptionWrapper e) {
                name = e.getLocalizedMessage();
            }
            catch (ObjectCollectedExceptionWrapper e) {
                name = e.getLocalizedMessage();
            }
            catch (VMDisconnectedExceptionWrapper e) {
                return;
            }
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoField", (Object)name, (Object)this.breakpoint.getFieldName()));
        }
    }

    @Override
    protected EventRequest createEventRequest(EventRequest oldRequest) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        if (oldRequest instanceof AccessWatchpointRequest) {
            Field field = WatchpointRequestWrapper.field((AccessWatchpointRequest)oldRequest);
            AccessWatchpointRequest awr = EventRequestManagerWrapper.createAccessWatchpointRequest(this.getEventRequestManager(), field);
            this.setFilters(awr);
            return awr;
        }
        if (oldRequest instanceof ModificationWatchpointRequest) {
            Field field = WatchpointRequestWrapper.field((ModificationWatchpointRequest)oldRequest);
            ModificationWatchpointRequest mwr = EventRequestManagerWrapper.createModificationWatchpointRequest(this.getEventRequestManager(), field);
            this.setFilters(mwr);
            return mwr;
        }
        return null;
    }

    private void setFilters(WatchpointRequest wr) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        ObjectVariable[] varFilters;
        JPDAThread[] threadFilters = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
        if (threadFilters != null && threadFilters.length > 0) {
            for (JPDAThread t : threadFilters) {
                WatchpointRequestWrapper.addThreadFilter(wr, ((JPDAThreadImpl)t).getThreadReference());
            }
        }
        if ((varFilters = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && varFilters.length > 0) {
            for (ObjectVariable v : varFilters) {
                ObjectReference value = (ObjectReference)((JDIVariable)v).getJDIValue();
                if (value != null) {
                    WatchpointRequestWrapper.addInstanceFilter(wr, value);
                    continue;
                }
                Logger.getLogger(FieldBreakpointImpl.class.getName()).log(Level.CONFIG, "", new IllegalStateException("Null instance filter of breakpoint " + this.breakpoint + ", v = " + v));
            }
        }
    }

    @Override
    public boolean processCondition(Event event) {
        ThreadReference thread;
        block5: {
            try {
                if (event instanceof ModificationWatchpointEvent) {
                    thread = LocatableEventWrapper.thread((ModificationWatchpointEvent)event);
                    break block5;
                }
                if (event instanceof AccessWatchpointEvent) {
                    thread = LocatableEventWrapper.thread((AccessWatchpointEvent)event);
                    break block5;
                }
                return true;
            }
            catch (InternalExceptionWrapper ex) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return false;
            }
        }
        ObjectReference object = ((WatchpointEvent)event).object();
        return this.processCondition(event, this.breakpoint.getCondition(), thread, null, object);
    }

    @Override
    public boolean exec(Event event) {
        try {
            if (event instanceof ModificationWatchpointEvent) {
                ModificationWatchpointEvent me = (ModificationWatchpointEvent)event;
                return this.perform(event, LocatableEventWrapper.thread(me), LocationWrapper.declaringType(LocatableWrapper.location(me)), ModificationWatchpointEventWrapper.valueToBe(me));
            }
            if (event instanceof AccessWatchpointEvent) {
                AccessWatchpointEvent ae = (AccessWatchpointEvent)event;
                return this.perform(event, LocatableEventWrapper.thread((WatchpointEvent)event), LocationWrapper.declaringType(LocatableWrapper.location((LocatableEvent)event)), WatchpointEventWrapper.valueCurrent(ae));
            }
        }
        catch (InternalExceptionWrapper ex) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return false;
        }
        return super.exec(event);
    }
}

