/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JavaExpression;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TreeEvaluator {
    private JavaExpression expression;
    private EvaluationContext evaluationContext;
    private static final Logger loggerMethod = Logger.getLogger("org.netbeans.modules.debugger.jpda.invokeMethod");

    TreeEvaluator(JavaExpression expression, EvaluationContext context) {
        this.expression = expression;
        this.evaluationContext = context;
    }

    public Value evaluate() throws EvaluationException, IncompatibleThreadStateException, InvalidExpressionException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper, ObjectCollectedExceptionWrapper {
        Mirror mirror;
        block30: {
            int line;
            String url;
            ThreadReference frameThread = StackFrameWrapper.thread(this.evaluationContext.getFrame());
            int frameIndex = -1;
            try {
                int numTries = 100;
                StackFrame currentFrame = this.evaluationContext.getFrame();
                try {
                    frameIndex = this.indexOf(ThreadReferenceWrapper.frames(frameThread), currentFrame);
                }
                catch (InvalidStackFrameExceptionWrapper isfex) {
                    if (numTries-- <= 0) {
                        throw isfex;
                    }
                }
            }
            catch (ObjectCollectedExceptionWrapper ocex) {
                throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_collected_context"));
            }
            catch (IllegalThreadStateExceptionWrapper ex) {
                throw new InvalidExpressionException(ex.getCause().getLocalizedMessage());
            }
            if (frameIndex == -1) {
                throw new IncompatibleThreadStateException("Thread does not contain current frame");
            }
            ObjectReference contextVar = this.evaluationContext.getContextVariable();
            if (contextVar != null) {
                String className = contextVar.referenceType().name();
                String relPath = SourcePath.convertClassNameToRelativePath(className);
                url = this.evaluationContext.getDebugger().getEngineContext().getURL(relPath, true);
                line = EditorContextBridge.getContext().getFieldLineNumber(url, className, null);
            } else {
                FileObject systemFO;
                line = LocationWrapper.lineNumber(StackFrameWrapper.location(this.evaluationContext.getFrame()));
                url = this.evaluationContext.getDebugger().getEngineContext().getURL(this.evaluationContext.getFrame(), "Java");
                if (url == null && (systemFO = GlobalPathRegistry.getDefault().findResource("java/lang/System.java")) != null) {
                    try {
                        url = systemFO.getURL().toString();
                        line = 100;
                    }
                    catch (FileStateInvalidException ex) {
                        // empty catch block
                    }
                }
            }
            mirror = null;
            mirror = EditorContextBridge.parseExpression(this.expression.getExpression(), url, line, new EvaluatorVisitor(this.expression), this.evaluationContext, this.evaluationContext.getDebugger().getEngineContext().getContext());
            if (mirror instanceof EvaluatorVisitor.ArtificialMirror) {
                mirror = ((EvaluatorVisitor.ArtificialMirror)mirror).getVMMirror();
            }
            if (!(mirror instanceof Value) && mirror != null) break block30;
            Value ex = (Value)mirror;
            this.evaluationContext.enableCollectionOfObjects(mirror instanceof Value ? (Value)mirror : null);
            return ex;
        }
        try {
            try {
                throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_notAValue") + ": " + this.expression.getExpression());
            }
            catch (IllegalStateException isex) {
                loggerMethod.log(Level.CONFIG, "During evaluation of '" + this.expression.getExpression() + "'", isex);
                Throwable thr = isex.getCause();
                if (thr instanceof IncompatibleThreadStateException) {
                    throw (IncompatibleThreadStateException)thr;
                }
                if (thr instanceof InvalidExpressionException) {
                    throw (InvalidExpressionException)thr;
                }
                if (thr instanceof ClassNotLoadedException) {
                    throw new InvalidExpressionException("Class " + ((ClassNotLoadedException)thr).className() + " not loaded.");
                }
                throw isex;
            }
            catch (InternalException e) {
                if (Exceptions.findLocalizedMessage((Throwable)e) != null) {
                    throw new InvalidExpressionException(Exceptions.findLocalizedMessage((Throwable)e));
                }
                JDIExceptionReporter.report(e);
                throw new InvalidExpressionException(e.getLocalizedMessage());
            }
            catch (VMDisconnectedException e) {
                throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_disconnected"));
            }
            catch (ObjectCollectedException e) {
                loggerMethod.log(Level.CONFIG, "During evaluation of '" + this.expression.getExpression() + "'", e);
                throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_collected"));
            }
            catch (ClassNotPreparedException e) {
                throw new InvalidExpressionException((Throwable)e);
            }
            catch (NativeMethodException e) {
                throw new InvalidExpressionException(e.getLocalizedMessage());
            }
            catch (InvalidStackFrameException e) {
                JPDAThreadImpl t = this.evaluationContext.getThread();
                e = (InvalidStackFrameException)Exceptions.attachMessage((Throwable)e, (String)t.getThreadStateLog());
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)("During evaluation of '" + this.expression.getExpression() + "'")));
                throw new InvalidExpressionException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NoCurrentContext"));
            }
            catch (RuntimeException re) {
                re = (RuntimeException)Exceptions.attachMessage((Throwable)re, (String)("During evaluation of '" + this.expression.getExpression() + "'"));
                throw re;
            }
        }
        catch (Throwable throwable) {
            this.evaluationContext.enableCollectionOfObjects(mirror instanceof Value ? (Value)mirror : null);
            throw throwable;
        }
    }

    private int indexOf(List<StackFrame> frames, StackFrame frame) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        int n = frames.size();
        Location loc = StackFrameWrapper.location(frame);
        for (int i = 0; i < n; ++i) {
            if (!loc.equals(StackFrameWrapper.location(frames.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public static Value invokeVirtual(ObjectReference objectReference, Method method, ThreadReference evaluationThread, List<Value> args, JPDADebuggerImpl debugger) throws InvalidExpressionException {
        return TreeEvaluator.invokeVirtual(objectReference, null, method, evaluationThread, args, debugger, null);
    }

    public static Value invokeVirtual(ObjectReference objectReference, Method method, ThreadReference evaluationThread, List<Value> args, JPDADebuggerImpl debugger, InvocationExceptionTranslated existingInvocationException) throws InvalidExpressionException {
        return TreeEvaluator.invokeVirtual(objectReference, null, method, evaluationThread, args, debugger, existingInvocationException);
    }

    public static Value invokeVirtual(ClassType classType, Method method, ThreadReference evaluationThread, List<Value> args, JPDADebuggerImpl debugger) throws InvalidExpressionException {
        return TreeEvaluator.invokeVirtual(null, classType, method, evaluationThread, args, debugger, null);
    }

    public static Value invokeVirtual(ClassType classType, Method method, ThreadReference evaluationThread, List<Value> args, JPDADebuggerImpl debugger, InvocationExceptionTranslated existingInvocationException) throws InvalidExpressionException {
        return TreeEvaluator.invokeVirtual(null, classType, method, evaluationThread, args, debugger, existingInvocationException);
    }

    private static Value invokeVirtual(ObjectReference objectReference, ClassType classType, Method method, ThreadReference evaluationThread, List<Value> args, JPDADebuggerImpl debugger, InvocationExceptionTranslated existingInvocationException) throws InvalidExpressionException {
        try {
            if (loggerMethod.isLoggable(Level.FINE)) {
                if (objectReference != null) {
                    loggerMethod.fine("STARTED : " + objectReference + "." + method + " (" + args + ") in thread " + evaluationThread);
                } else {
                    loggerMethod.fine("STARTED : " + classType + "." + method + " (" + args + ") in thread " + evaluationThread);
                }
            }
            EvaluatorVisitor.autoboxArguments(method.argumentTypes(), args, evaluationThread, null);
            Value value = objectReference != null ? ObjectReferenceWrapper.invokeMethod(objectReference, evaluationThread, method, args, 1) : ClassTypeWrapper.invokeMethod(classType, evaluationThread, method, args, 1);
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("   return = " + value);
            }
            Value value2 = value;
            return value2;
        }
        catch (InvalidTypeException itex) {
            throw new InvalidExpressionException((Throwable)itex);
        }
        catch (ClassNotLoadedException cnlex) {
            throw new InvalidExpressionException((Throwable)cnlex);
        }
        catch (IncompatibleThreadStateException itsex) {
            String message = NbBundle.getMessage(EvaluatorVisitor.class, (String)"MSG_IncompatibleThreadStateMessage");
            InvalidExpressionException ieex = new InvalidExpressionException(message, (Throwable)itsex);
            throw ieex;
        }
        catch (InvocationException iex) {
            InvocationExceptionTranslated ex;
            if (existingInvocationException != null) {
                ex = existingInvocationException;
            } else {
                ex = new InvocationExceptionTranslated(iex, debugger);
                JPDAThreadImpl trImpl = debugger.getThread(evaluationThread);
                ex.setPreferredThread(trImpl);
                trImpl.notifyMethodInvokeDone();
                ex.getMessage();
                ex.getLocalizedMessage();
                ex.getStackTrace();
            }
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)((Object)ex));
            throw ieex;
        }
        catch (UnsupportedOperationException uoex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)uoex);
            throw ieex;
        }
        catch (InternalExceptionWrapper iex) {
            throw new InvalidExpressionException(iex.getLocalizedMessage());
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_collected"));
        }
        catch (VMDisconnectedExceptionWrapper e) {
            throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_disconnected"));
        }
        finally {
            if (loggerMethod.isLoggable(Level.FINE)) {
                if (objectReference != null) {
                    loggerMethod.fine("FINISHED: " + objectReference + "." + method + " (" + args + ") in thread " + evaluationThread);
                } else {
                    loggerMethod.fine("FINISHED: " + classType + "." + method + " (" + args + ") in thread " + evaluationThread);
                }
            }
        }
    }
}

