/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Mirror;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.io.Serializable;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class MonitorInfoWrapper {
    private MonitorInfoWrapper() {
    }

    public static ObjectReference monitor(MonitorInfo a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.MonitorInfo", "monitor", "JDI CALL: com.sun.jdi.MonitorInfo({0}).monitor()", new Object[]{a});
        }
        Object retValue = null;
        try {
            ObjectReference ret = a.monitor();
            retValue = ret;
            ObjectReference objectReference = ret;
            return objectReference;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.MonitorInfo", "monitor", retValue);
            }
        }
    }

    public static int stackDepth0(MonitorInfo a) throws InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.MonitorInfo", "stackDepth", "JDI CALL: com.sun.jdi.MonitorInfo({0}).stackDepth()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.stackDepth();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            int n = 0;
            return n;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            int n = 0;
            return n;
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.MonitorInfo", "stackDepth", retValue);
            }
        }
    }

    public static int stackDepth(MonitorInfo a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.MonitorInfo", "stackDepth", "JDI CALL: com.sun.jdi.MonitorInfo({0}).stackDepth()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.stackDepth();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.MonitorInfo", "stackDepth", retValue);
            }
        }
    }

    public static ThreadReference thread(MonitorInfo a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.MonitorInfo", "thread", "JDI CALL: com.sun.jdi.MonitorInfo({0}).thread()", new Object[]{a});
        }
        Object retValue = null;
        try {
            ThreadReference ret = a.thread();
            retValue = ret;
            ThreadReference threadReference = ret;
            return threadReference;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.MonitorInfo", "thread", retValue);
            }
        }
    }
}

