/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Mirror;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMOutOfMemoryException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.NativeMethodExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMOutOfMemoryExceptionWrapper;

public final class ThreadReferenceWrapper {
    private ThreadReferenceWrapper() {
    }

    public static ObjectReference currentContendedMonitor(ThreadReference a) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        int status = ThreadReferenceWrapper.status0(a);
        if (status == 5 || status == 0 || status == -1) {
            return null;
        }
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "currentContendedMonitor", "JDI CALL: com.sun.jdi.ThreadReference({0}).currentContendedMonitor()", new Object[]{a});
        }
        Object retValue = null;
        try {
            ObjectReference ret = a.currentContendedMonitor();
            retValue = ret;
            ObjectReference objectReference = ret;
            return objectReference;
        }
        catch (InternalException iex) {
            try {
                if (iex.errorCode() == 13) {
                    throw new IncompatibleThreadStateException(iex.getMessage());
                }
                throw iex;
            }
            catch (InternalException ex) {
                retValue = ex;
                JDIExceptionReporter.report(ex);
                throw new InternalExceptionWrapper(ex);
            }
            catch (VMDisconnectedException ex) {
                retValue = ex;
                if (a instanceof Mirror) {
                    VirtualMachine vm = a.virtualMachine();
                    try {
                        vm.dispose();
                    }
                    catch (VMDisconnectedException vmdex) {
                        // empty catch block
                    }
                }
                throw new VMDisconnectedExceptionWrapper(ex);
            }
            catch (ObjectCollectedException ex) {
                retValue = ex;
                throw new ObjectCollectedExceptionWrapper(ex);
            }
            catch (IllegalThreadStateException ex) {
                retValue = ex;
                throw new IllegalThreadStateExceptionWrapper(ex);
            }
            catch (IncompatibleThreadStateException ex) {
                retValue = ex;
                throw ex;
            }
            catch (Error err) {
                retValue = err;
                throw err;
            }
            catch (RuntimeException rex) {
                retValue = rex;
                throw rex;
            }
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "currentContendedMonitor", retValue);
            }
        }
    }

    public static void forceEarlyReturn(ThreadReference a, Value b) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper, NativeMethodExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "forceEarlyReturn", "JDI CALL: com.sun.jdi.ThreadReference({0}).forceEarlyReturn({1})", new Object[]{a, b});
        }
        try {
            a.forceEarlyReturn(b);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (NativeMethodException ex) {
            throw new NativeMethodExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "forceEarlyReturn", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static StackFrame frame(ThreadReference a, int b) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "frame", "JDI CALL: com.sun.jdi.ThreadReference({0}).frame({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            StackFrame ret = a.frame(b);
            retValue = ret;
            StackFrame stackFrame = ret;
            return stackFrame;
        }
        catch (NullPointerException npex) {
            try {
                throw new IncompatibleThreadStateException(npex.getMessage());
            }
            catch (InternalException ex) {
                retValue = ex;
                JDIExceptionReporter.report(ex);
                throw new InternalExceptionWrapper(ex);
            }
            catch (VMDisconnectedException ex) {
                retValue = ex;
                if (a instanceof Mirror) {
                    VirtualMachine vm = a.virtualMachine();
                    try {
                        vm.dispose();
                    }
                    catch (VMDisconnectedException vmdex) {
                        // empty catch block
                    }
                }
                throw new VMDisconnectedExceptionWrapper(ex);
            }
            catch (ObjectCollectedException ex) {
                retValue = ex;
                throw new ObjectCollectedExceptionWrapper(ex);
            }
            catch (IllegalThreadStateException ex) {
                retValue = ex;
                throw new IllegalThreadStateExceptionWrapper(ex);
            }
            catch (IncompatibleThreadStateException ex) {
                retValue = ex;
                throw ex;
            }
            catch (Error err) {
                retValue = err;
                throw err;
            }
            catch (RuntimeException rex) {
                retValue = rex;
                throw rex;
            }
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "frame", retValue);
            }
        }
    }

    public static int frameCount0(ThreadReference a) throws IncompatibleThreadStateException, IllegalThreadStateExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "frameCount", "JDI CALL: com.sun.jdi.ThreadReference({0}).frameCount()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.frameCount();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            int n = 0;
            return n;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            int n = 0;
            return n;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            int n = 0;
            return n;
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "frameCount", retValue);
            }
        }
    }

    public static int frameCount(ThreadReference a) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "frameCount", "JDI CALL: com.sun.jdi.ThreadReference({0}).frameCount()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.frameCount();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "frameCount", retValue);
            }
        }
    }

    public static List<StackFrame> frames0(ThreadReference a) throws IncompatibleThreadStateException, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "frames", "JDI CALL: com.sun.jdi.ThreadReference({0}).frames()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<StackFrame> ret = a.frames();
            retValue = ret;
            List<StackFrame> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<StackFrame> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            List<StackFrame> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            List<StackFrame> list = Collections.emptyList();
            return list;
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "frames", retValue);
            }
        }
    }

    public static List<StackFrame> frames(ThreadReference a) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "frames", "JDI CALL: com.sun.jdi.ThreadReference({0}).frames()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<StackFrame> ret = a.frames();
            retValue = ret;
            List<StackFrame> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "frames", retValue);
            }
        }
    }

    public static List<StackFrame> frames0(ThreadReference a, int b, int c) throws IncompatibleThreadStateException, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "frames", "JDI CALL: com.sun.jdi.ThreadReference({0}).frames({1}, {2})", new Object[]{a, b, c});
        }
        Object retValue = null;
        try {
            List<StackFrame> ret = a.frames(b, c);
            retValue = ret;
            List<StackFrame> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<StackFrame> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            List<StackFrame> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            List<StackFrame> list = Collections.emptyList();
            return list;
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "frames", retValue);
            }
        }
    }

    public static List<StackFrame> frames(ThreadReference a, int b, int c) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "frames", "JDI CALL: com.sun.jdi.ThreadReference({0}).frames({1}, {2})", new Object[]{a, b, c});
        }
        Object retValue = null;
        try {
            List<StackFrame> ret = a.frames(b, c);
            retValue = ret;
            List<StackFrame> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "frames", retValue);
            }
        }
    }

    public static void interrupt(ThreadReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "interrupt", "JDI CALL: com.sun.jdi.ThreadReference({0}).interrupt()", new Object[]{a});
        }
        try {
            a.interrupt();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "interrupt", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static boolean isAtBreakpoint0(ThreadReference a) throws IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "isAtBreakpoint", "JDI CALL: com.sun.jdi.ThreadReference({0}).isAtBreakpoint()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            boolean ret = a.isAtBreakpoint();
            retValue = Boolean.valueOf(ret);
            boolean bl = ret;
            return bl;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            boolean bl = false;
            return bl;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            boolean bl = false;
            return bl;
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "isAtBreakpoint", retValue);
            }
        }
    }

    public static boolean isAtBreakpoint(ThreadReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "isAtBreakpoint", "JDI CALL: com.sun.jdi.ThreadReference({0}).isAtBreakpoint()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            boolean ret = a.isAtBreakpoint();
            retValue = Boolean.valueOf(ret);
            boolean bl = ret;
            return bl;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "isAtBreakpoint", retValue);
            }
        }
    }

    public static boolean isSuspended0(ThreadReference a) throws IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "isSuspended", "JDI CALL: com.sun.jdi.ThreadReference({0}).isSuspended()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            boolean ret = a.isSuspended();
            retValue = Boolean.valueOf(ret);
            boolean bl = ret;
            return bl;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            boolean bl = false;
            return bl;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            boolean bl = false;
            return bl;
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "isSuspended", retValue);
            }
        }
    }

    public static boolean isSuspended(ThreadReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "isSuspended", "JDI CALL: com.sun.jdi.ThreadReference({0}).isSuspended()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            boolean ret = a.isSuspended();
            retValue = Boolean.valueOf(ret);
            boolean bl = ret;
            return bl;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "isSuspended", retValue);
            }
        }
    }

    public static String name(ThreadReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "name", "JDI CALL: com.sun.jdi.ThreadReference({0}).name()", new Object[]{a});
        }
        Object retValue = null;
        try {
            String ret = a.name();
            retValue = ret;
            String string = ret;
            return string;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "name", retValue);
            }
        }
    }

    public static List<ObjectReference> ownedMonitors0(ThreadReference a) throws IncompatibleThreadStateException, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "ownedMonitors", "JDI CALL: com.sun.jdi.ThreadReference({0}).ownedMonitors()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<ObjectReference> ret = a.ownedMonitors();
            retValue = ret;
            List<ObjectReference> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<ObjectReference> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            List<ObjectReference> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            List<ObjectReference> list = Collections.emptyList();
            return list;
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "ownedMonitors", retValue);
            }
        }
    }

    public static List<ObjectReference> ownedMonitors(ThreadReference a) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "ownedMonitors", "JDI CALL: com.sun.jdi.ThreadReference({0}).ownedMonitors()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<ObjectReference> ret = a.ownedMonitors();
            retValue = ret;
            List<ObjectReference> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "ownedMonitors", retValue);
            }
        }
    }

    public static List<MonitorInfo> ownedMonitorsAndFrames0(ThreadReference a) throws IncompatibleThreadStateException, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "ownedMonitorsAndFrames", "JDI CALL: com.sun.jdi.ThreadReference({0}).ownedMonitorsAndFrames()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<MonitorInfo> ret = a.ownedMonitorsAndFrames();
            retValue = ret;
            List<MonitorInfo> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<MonitorInfo> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            List<MonitorInfo> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            List<MonitorInfo> list = Collections.emptyList();
            return list;
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "ownedMonitorsAndFrames", retValue);
            }
        }
    }

    public static List<MonitorInfo> ownedMonitorsAndFrames(ThreadReference a) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "ownedMonitorsAndFrames", "JDI CALL: com.sun.jdi.ThreadReference({0}).ownedMonitorsAndFrames()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<MonitorInfo> ret = a.ownedMonitorsAndFrames();
            retValue = ret;
            List<MonitorInfo> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "ownedMonitorsAndFrames", retValue);
            }
        }
    }

    public static void popFrames(ThreadReference a, StackFrame b) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper, NativeMethodExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "popFrames", "JDI CALL: com.sun.jdi.ThreadReference({0}).popFrames({1})", new Object[]{a, b});
        }
        try {
            try {
                a.popFrames(b);
            }
            catch (InternalException iex) {
                if (iex.errorCode() == 32) {
                    throw new NativeMethodException(iex.getMessage());
                }
                throw iex;
            }
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (NativeMethodException ex) {
            throw new NativeMethodExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "popFrames", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static void resume(ThreadReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        block16: {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "resume", "JDI CALL: com.sun.jdi.ThreadReference({0}).resume()", new Object[]{a});
            }
            try {
                try {
                    a.resume();
                }
                catch (InternalException iex) {
                    if (iex.errorCode() == 13) {
                        break block16;
                    }
                    throw iex;
                }
            }
            catch (InternalException ex) {
                JDIExceptionReporter.report(ex);
                throw new InternalExceptionWrapper(ex);
            }
            catch (VMDisconnectedException ex) {
                if (a instanceof Mirror) {
                    VirtualMachine vm = a.virtualMachine();
                    try {
                        vm.dispose();
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        // empty catch block
                    }
                }
                throw new VMDisconnectedExceptionWrapper(ex);
            }
            catch (ObjectCollectedException ex) {
                throw new ObjectCollectedExceptionWrapper(ex);
            }
            catch (IllegalThreadStateException ex) {
                throw new IllegalThreadStateExceptionWrapper(ex);
            }
            finally {
                if (JDIExceptionReporter.isLoggable()) {
                    JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "resume", JDIExceptionReporter.RET_VOID);
                }
            }
        }
    }

    public static int status0(ThreadReference a) throws IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "status", "JDI CALL: com.sun.jdi.ThreadReference({0}).status()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.status();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            int n = 0;
            return n;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            int n = 0;
            return n;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            int n = 0;
            return n;
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "status", retValue);
            }
        }
    }

    public static int status(ThreadReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "status", "JDI CALL: com.sun.jdi.ThreadReference({0}).status()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.status();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "status", retValue);
            }
        }
    }

    public static void stop(ThreadReference a, ObjectReference b) throws InvalidTypeException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "stop", "JDI CALL: com.sun.jdi.ThreadReference({0}).stop({1})", new Object[]{a, b});
        }
        try {
            a.stop(b);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "stop", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static void suspend(ThreadReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "suspend", "JDI CALL: com.sun.jdi.ThreadReference({0}).suspend()", new Object[]{a});
        }
        try {
            a.suspend();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "suspend", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static int suspendCount0(ThreadReference a) throws IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "suspendCount", "JDI CALL: com.sun.jdi.ThreadReference({0}).suspendCount()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.suspendCount();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            int n = 0;
            return n;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            int n = 0;
            return n;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            int n = 0;
            return n;
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "suspendCount", retValue);
            }
        }
    }

    public static int suspendCount(ThreadReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "suspendCount", "JDI CALL: com.sun.jdi.ThreadReference({0}).suspendCount()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.suspendCount();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "suspendCount", retValue);
            }
        }
    }

    public static ThreadGroupReference threadGroup(ThreadReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper, VMOutOfMemoryExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ThreadReference", "threadGroup", "JDI CALL: com.sun.jdi.ThreadReference({0}).threadGroup()", new Object[]{a});
        }
        Object retValue = null;
        try {
            ThreadGroupReference ret = a.threadGroup();
            retValue = ret;
            ThreadGroupReference threadGroupReference = ret;
            return threadGroupReference;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalThreadStateException ex) {
            retValue = ex;
            throw new IllegalThreadStateExceptionWrapper(ex);
        }
        catch (VMOutOfMemoryException ex) {
            retValue = ex;
            throw new VMOutOfMemoryExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ThreadReference", "threadGroup", retValue);
            }
        }
    }
}

