/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadGroupReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMOutOfMemoryExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadDeathEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadStartEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.util.Exceptions;

public class ThreadsCache
implements Executor {
    public static final String PROP_THREAD_STARTED = "threadStarted";
    public static final String PROP_THREAD_DIED = "threadDied";
    public static final String PROP_GROUP_ADDED = "groupAdded";
    public static final String THREAD_NAME_FILTER_PATTERN = "org.netbeans.modules.debugger.jpda";
    private static final Logger logger = Logger.getLogger(ThreadsCache.class.getName());
    private VirtualMachine vm;
    private JPDADebuggerImpl debugger;
    private Map<ThreadGroupReference, List<ThreadGroupReference>> groupMap;
    private final List<ThreadGroupReference> uninitializedGroupList = Collections.emptyList();
    private Map<ThreadGroupReference, List<ThreadReference>> threadMap;
    private List<ThreadReference> allThreads;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final boolean[] canFireChanges = new boolean[]{false};

    public ThreadsCache(JPDADebuggerImpl debugger) {
        this.debugger = debugger;
        this.allThreads = new ArrayList<ThreadReference>();
        VirtualMachine vm = debugger.getVirtualMachine();
        if (vm != null) {
            this.setVirtualMachine(vm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVirtualMachine(VirtualMachine vm) {
        List<Object> _allGroups;
        ArrayList<ThreadReference> _allThreads;
        Object object = this;
        synchronized (object) {
            if (this.vm == vm) {
                return;
            }
            try {
                this.vm = vm;
                ThreadStartRequest threadStartRequest = EventRequestManagerWrapper.createThreadStartRequest(VirtualMachineWrapper.eventRequestManager(vm));
                ThreadDeathRequest tdr = EventRequestManagerWrapper.createThreadDeathRequest(VirtualMachineWrapper.eventRequestManager(vm));
                EventRequestWrapper.setSuspendPolicy(threadStartRequest, 0);
                EventRequestWrapper.setSuspendPolicy(tdr, 0);
                this.debugger.getOperator().register(threadStartRequest, this);
                this.debugger.getOperator().register(tdr, this);
                EventRequestWrapper.enable(threadStartRequest);
                EventRequestWrapper.enable(tdr);
                this.init();
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                this.vm = null;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                this.vm = null;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                this.vm = null;
            }
            catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                Exceptions.printStackTrace((Throwable)invalidRequestStateExceptionWrapper);
                this.vm = null;
            }
            _allThreads = new ArrayList<ThreadReference>(this.allThreads);
            _allGroups = this.groupMap != null ? this.getAllGroups() : Collections.emptyList();
        }
        for (ThreadReference threadReference : _allThreads) {
            this.pcs.firePropertyChange(PROP_THREAD_STARTED, null, threadReference);
        }
        for (ThreadGroupReference threadGroupReference : _allGroups) {
            this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, threadGroupReference);
        }
        object = this.canFireChanges;
        synchronized (this.canFireChanges) {
            this.canFireChanges[0] = true;
            this.canFireChanges.notifyAll();
            // ** MonitorExit[object] (shouldn't be in output)
            return;
        }
    }

    private synchronized void init() throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        this.allThreads = new ArrayList<ThreadReference>(VirtualMachineWrapper.allThreads(this.vm));
        this.filterThreads(this.allThreads);
    }

    private void filterThreads(List<ThreadReference> threads) {
        for (int i = 0; i < threads.size(); ++i) {
            ThreadReference tr = threads.get(i);
            try {
                if (!ThreadReferenceWrapper.name(tr).contains(THREAD_NAME_FILTER_PATTERN)) continue;
                threads.remove(i);
                --i;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void initGroups(ThreadGroupReference group) {
        try {
            ArrayList<ThreadGroupReference> groups = new ArrayList<ThreadGroupReference>(ThreadGroupReferenceWrapper.threadGroups0(group));
            ArrayList<ThreadReference> threads = new ArrayList<ThreadReference>(ThreadGroupReferenceWrapper.threads0(group));
            this.filterThreads(threads);
            this.groupMap.put(group, groups);
            this.threadMap.put(group, threads);
            for (ThreadGroupReference g : groups) {
                this.initGroups(g);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    private synchronized void initThreadGroups() throws VMDisconnectedExceptionWrapper, VMOutOfMemoryExceptionWrapper {
        Collection<ThreadGroupReference> groups;
        this.threadMap = new HashMap<ThreadGroupReference, List<ThreadReference>>();
        if (this.groupMap == null) {
            this.groupMap = new HashMap<ThreadGroupReference, List<ThreadGroupReference>>();
        } else {
            groups = new HashSet<ThreadGroupReference>(this.groupMap.keySet());
            for (ThreadGroupReference g : groups) {
                if (this.groupMap.get(g) != this.uninitializedGroupList) continue;
                this.groupMap.remove(g);
            }
        }
        groups = this.groupMap.get(null);
        if (groups == null) {
            try {
                groups = new ArrayList<ThreadGroupReference>(VirtualMachineWrapper.topLevelThreadGroups(this.vm));
            }
            catch (InternalExceptionWrapper ex) {
                return;
            }
            this.groupMap.put((ThreadGroupReference)null, (List<ThreadGroupReference>)groups);
        }
        for (ThreadGroupReference group : groups) {
            this.initGroups(group);
        }
        ArrayList<ThreadReference> mainThreads = new ArrayList<ThreadReference>();
        this.threadMap.put(null, mainThreads);
        for (ThreadReference thread : this.allThreads) {
            try {
                if (ThreadReferenceWrapper.threadGroup(thread) != null) continue;
                mainThreads.add(thread);
            }
            catch (ObjectCollectedExceptionWrapper e) {
            }
            catch (IllegalThreadStateExceptionWrapper e) {
            }
            catch (InternalExceptionWrapper e) {}
        }
    }

    public synchronized List<ThreadReference> getAllThreads() {
        return Collections.unmodifiableList(new ArrayList<ThreadReference>(this.allThreads));
    }

    public synchronized List<ThreadGroupReference> getTopLevelThreadGroups() {
        boolean uninitialized;
        if (this.groupMap == null) {
            this.groupMap = new HashMap<ThreadGroupReference, List<ThreadGroupReference>>();
            uninitialized = true;
        } else {
            uninitialized = false;
        }
        List<ThreadGroupReference> topGroups = this.groupMap.get(null);
        if (topGroups == null) {
            if (this.vm == null) {
                return Collections.EMPTY_LIST;
            }
            topGroups = new ArrayList<ThreadGroupReference>(VirtualMachineWrapper.topLevelThreadGroups0(this.vm));
            this.groupMap.put(null, topGroups);
            if (uninitialized) {
                for (ThreadGroupReference g : topGroups) {
                    this.groupMap.put(g, this.uninitializedGroupList);
                }
            }
        }
        return Collections.unmodifiableList(new ArrayList<ThreadGroupReference>(topGroups));
    }

    public synchronized List<ThreadReference> getThreads(ThreadGroupReference group) {
        List<ThreadReference> threads;
        if (this.threadMap == null) {
            try {
                this.initThreadGroups();
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return Collections.emptyList();
            }
            catch (VMOutOfMemoryExceptionWrapper ex) {
                return Collections.emptyList();
            }
        }
        threads = (threads = this.threadMap.get(group)) == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ThreadReference>(threads));
        return threads;
    }

    public synchronized List<ThreadGroupReference> getGroups(ThreadGroupReference group) {
        List<ThreadGroupReference> groups;
        if (this.groupMap == null) {
            try {
                this.initThreadGroups();
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return Collections.emptyList();
            }
            catch (VMOutOfMemoryExceptionWrapper ex) {
                return Collections.emptyList();
            }
        }
        if ((groups = this.groupMap.get(group)) == this.uninitializedGroupList) {
            groups = new ArrayList<ThreadGroupReference>(ThreadGroupReferenceWrapper.threadGroups0(group));
            this.groupMap.put(group, groups);
        }
        groups = groups == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ThreadGroupReference>(groups));
        return groups;
    }

    private synchronized List<ThreadGroupReference> getAllGroups() {
        if (this.groupMap == null) {
            try {
                this.initThreadGroups();
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return Collections.emptyList();
            }
            catch (VMOutOfMemoryExceptionWrapper ex) {
                return Collections.emptyList();
            }
        }
        ArrayList<ThreadGroupReference> groups = new ArrayList<ThreadGroupReference>();
        this.fillAllGroups(groups, null);
        return groups;
    }

    private void fillAllGroups(List<ThreadGroupReference> groups, ThreadGroupReference g) {
        List<ThreadGroupReference> gs = this.groupMap.get(g);
        if (gs != null) {
            if (gs == this.uninitializedGroupList) {
                gs = new ArrayList<ThreadGroupReference>(ThreadGroupReferenceWrapper.threadGroups0(g));
                this.groupMap.put(g, gs);
            }
            groups.addAll(gs);
            for (ThreadGroupReference gg : gs) {
                this.fillAllGroups(groups, gg);
            }
        }
    }

    private List<ThreadGroupReference> addGroups(ThreadGroupReference group) throws ObjectCollectedExceptionWrapper {
        List<ThreadGroupReference> parentsGroups;
        ThreadGroupReference parent;
        if (this.threadMap != null && !this.threadMap.containsKey(group)) {
            ArrayList threads = new ArrayList();
            this.threadMap.put(group, threads);
        }
        if (this.groupMap == null) {
            return Collections.emptyList();
        }
        ArrayList<ThreadGroupReference> addedGroups = new ArrayList<ThreadGroupReference>();
        try {
            parent = ThreadGroupReferenceWrapper.parent(group);
        }
        catch (InternalExceptionWrapper ex) {
            return Collections.emptyList();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return Collections.emptyList();
        }
        if (this.groupMap.get(parent) == null) {
            if (parent != null) {
                addedGroups.addAll(this.addGroups(parent));
            } else {
                ArrayList<ThreadGroupReference> topGroups = new ArrayList<ThreadGroupReference>(VirtualMachineWrapper.topLevelThreadGroups0(this.vm));
                this.groupMap.put(null, topGroups);
                addedGroups.addAll(topGroups);
            }
        }
        if ((parentsGroups = this.groupMap.get(parent)) != null && !parentsGroups.contains(group)) {
            if (parentsGroups == this.uninitializedGroupList) {
                parentsGroups = new ArrayList<ThreadGroupReference>(ThreadGroupReferenceWrapper.threadGroups0(parent));
                this.groupMap.put(parent, parentsGroups);
                addedGroups.addAll(parentsGroups);
            } else {
                parentsGroups.add(group);
                addedGroups.add(group);
            }
            ArrayList groups = new ArrayList();
            this.groupMap.put(group, groups);
        }
        return addedGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean exec(Event event) {
        ThreadGroupReference group;
        List<ThreadReference> threads;
        Object addedGroups;
        ThreadReference thread;
        if (event instanceof ThreadStartEvent) {
            boolean handleGroups = this.debugger.isInterestedInThreadGroups();
            ThreadGroupReference group2 = null;
            try {
                thread = ThreadStartEventWrapper.thread((ThreadStartEvent)event);
                String name = ThreadReferenceWrapper.name(thread);
                if (name.contains(THREAD_NAME_FILTER_PATTERN)) {
                    return true;
                }
                if (handleGroups) {
                    group2 = ThreadReferenceWrapper.threadGroup(thread);
                }
            }
            catch (InternalExceptionWrapper ex) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return true;
            }
            catch (VMOutOfMemoryExceptionWrapper ex) {
                return true;
            }
            catch (IllegalThreadStateExceptionWrapper ex) {
                return true;
            }
            catch (ObjectCollectedExceptionWrapper ocex) {
                return true;
            }
            addedGroups = null;
            if (logger.isLoggable(Level.FINE)) {
                try {
                    logger.fine("ThreadStartEvent: " + thread + ", group = " + group2 + ", handleGroups = " + handleGroups);
                }
                catch (Exception ex) {
                    logger.log(Level.FINE, ex.getLocalizedMessage(), ex);
                }
            }
            Object ex = this;
            // MONITORENTER : ex
            if (group2 != null) {
                try {
                    addedGroups = this.addGroups(group2);
                }
                catch (ObjectCollectedExceptionWrapper ex2) {
                    try {
                        if (ObjectReferenceWrapper.isCollected(thread)) {
                            // MONITOREXIT : ex
                            return true;
                        }
                    }
                    catch (InternalExceptionWrapper ex1) {
                        // MONITOREXIT : ex
                        return true;
                    }
                    catch (VMDisconnectedExceptionWrapper ex1) {
                        // MONITOREXIT : ex
                        return true;
                    }
                    catch (ObjectCollectedExceptionWrapper ex1) {
                        // MONITOREXIT : ex
                        return true;
                    }
                }
            }
            if (!handleGroups) {
                this.groupMap = null;
                this.threadMap = null;
            } else if (this.threadMap != null && (threads = this.threadMap.get(group2)) != null && !threads.contains(thread)) {
                threads.add(thread);
            }
            if (!this.allThreads.contains(thread)) {
                this.allThreads.add(thread);
            }
            // MONITOREXIT : ex
            ex = this.canFireChanges;
            // MONITORENTER : this.canFireChanges
            if (!this.canFireChanges[0]) {
                try {
                    this.canFireChanges.wait();
                }
                catch (InterruptedException ex3) {
                    // empty catch block
                }
            }
            // MONITOREXIT : ex
            if (addedGroups != null) {
                Iterator i$ = addedGroups.iterator();
                while (i$.hasNext()) {
                    ThreadGroupReference g = (ThreadGroupReference)i$.next();
                    this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, g);
                }
            }
            this.pcs.firePropertyChange(PROP_THREAD_STARTED, null, thread);
        }
        if (!(event instanceof ThreadDeathEvent)) return true;
        try {
            thread = ThreadDeathEventWrapper.thread((ThreadDeathEvent)event);
        }
        catch (InternalExceptionWrapper ex) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return true;
        }
        addedGroups = this;
        // MONITORENTER : addedGroups
        boolean getGroup = this.groupMap != null || this.threadMap != null;
        // MONITOREXIT : addedGroups
        if (getGroup) {
            try {
                group = ThreadReferenceWrapper.threadGroup(thread);
            }
            catch (InternalExceptionWrapper ex) {
                group = null;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return true;
            }
            catch (VMOutOfMemoryExceptionWrapper ex) {
                return true;
            }
            catch (IllegalThreadStateExceptionWrapper ex) {
                group = null;
            }
            catch (ObjectCollectedExceptionWrapper ocex) {
                group = null;
            }
        } else {
            group = null;
        }
        if (logger.isLoggable(Level.FINE)) {
            try {
                logger.fine("ThreadDeathEvent: " + thread + ", group = " + group + ", groupMap = " + this.groupMap);
            }
            catch (Exception ex) {
                logger.log(Level.FINE, ex.getLocalizedMessage(), ex);
            }
        }
        boolean removed = false;
        Object object = this;
        // MONITORENTER : object
        if (this.threadMap != null) {
            if (group != null) {
                threads = this.threadMap.get(group);
            } else {
                threads = null;
                for (List<ThreadReference> testThreads : this.threadMap.values()) {
                    if (!testThreads.contains(thread)) continue;
                    threads = testThreads;
                }
            }
            if (threads != null) {
                threads.remove(thread);
            }
        }
        removed = this.allThreads.remove(thread);
        // MONITOREXIT : object
        if (!removed) return true;
        object = this.canFireChanges;
        // MONITORENTER : this.canFireChanges
        if (!this.canFireChanges[0]) {
            try {
                this.canFireChanges.wait();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        // MONITOREXIT : object
        this.pcs.firePropertyChange(PROP_THREAD_DIED, thread, null);
        return true;
    }

    @Override
    public void removed(EventRequest eventRequest) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assureThreadIsCached(ThreadReference tref) {
        boolean contains;
        ThreadsCache threadsCache = this;
        synchronized (threadsCache) {
            contains = this.allThreads.contains(tref);
        }
        if (!contains) {
            String tname;
            try {
                tname = tref.toString();
                if (tname.contains(THREAD_NAME_FILTER_PATTERN)) {
                    return;
                }
            }
            catch (Exception ex) {
                tname = ex.getLocalizedMessage();
            }
            logger.info("Must SYNCHRONIZE ThreadsCache, did not found " + tname);
            this.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        ArrayList<ThreadReference> oldThreads;
        ArrayList<ThreadReference> newThreads;
        List<ThreadGroupReference> addedGroups = null;
        Object object = this;
        synchronized (object) {
            List<ThreadReference> threads;
            ThreadGroupReference group;
            ArrayList<ThreadReference> allThreadsNew;
            try {
                allThreadsNew = new ArrayList<ThreadReference>(VirtualMachineWrapper.allThreads(this.vm));
            }
            catch (InternalExceptionWrapper iex) {
                return;
            }
            catch (VMDisconnectedExceptionWrapper vmdex) {
                return;
            }
            this.filterThreads(allThreadsNew);
            newThreads = new ArrayList<ThreadReference>(allThreadsNew);
            newThreads.removeAll(this.allThreads);
            oldThreads = new ArrayList<ThreadReference>(this.allThreads);
            oldThreads.removeAll(allThreadsNew);
            for (ThreadReference thread : newThreads) {
                try {
                    group = ThreadReferenceWrapper.threadGroup(thread);
                }
                catch (InternalExceptionWrapper ex) {
                    continue;
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    return;
                }
                catch (VMOutOfMemoryExceptionWrapper ex) {
                    return;
                }
                catch (IllegalThreadStateExceptionWrapper ex) {
                    continue;
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    continue;
                }
                if (group != null) {
                    try {
                        if (addedGroups == null) {
                            addedGroups = this.addGroups(group);
                        } else {
                            addedGroups.addAll(this.addGroups(group));
                        }
                    }
                    catch (ObjectCollectedExceptionWrapper occex) {
                        try {
                            if (ObjectReferenceWrapper.isCollected(thread)) {
                                continue;
                            }
                        }
                        catch (InternalExceptionWrapper ex1) {
                            continue;
                        }
                        catch (VMDisconnectedExceptionWrapper ex1) {
                            return;
                        }
                        catch (ObjectCollectedExceptionWrapper ex1) {
                            continue;
                        }
                    }
                }
                if (this.threadMap == null || (threads = this.threadMap.get(group)) == null || threads.contains(thread)) continue;
                threads.add(thread);
            }
            this.allThreads.addAll(newThreads);
            if (this.threadMap != null) {
                for (ThreadReference thread : oldThreads) {
                    try {
                        group = ThreadReferenceWrapper.threadGroup(thread);
                    }
                    catch (InternalExceptionWrapper ex) {
                        group = null;
                    }
                    catch (VMDisconnectedExceptionWrapper ex) {
                        return;
                    }
                    catch (VMOutOfMemoryExceptionWrapper ex) {
                        return;
                    }
                    catch (IllegalThreadStateExceptionWrapper ex) {
                        group = null;
                    }
                    catch (ObjectCollectedExceptionWrapper ocex) {
                        group = null;
                    }
                    if (group != null) {
                        threads = this.threadMap.get(group);
                    } else {
                        threads = null;
                        for (List<ThreadReference> testThreads : this.threadMap.values()) {
                            if (!testThreads.contains(thread)) continue;
                            threads = testThreads;
                        }
                    }
                    if (threads == null) continue;
                    threads.remove(thread);
                }
            }
            this.allThreads.removeAll(oldThreads);
        }
        object = this.canFireChanges;
        synchronized (this.canFireChanges) {
            if (!this.canFireChanges[0]) {
                try {
                    this.canFireChanges.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("SYNCHRONIZE of ThreadsCache discovered new threads: " + ThreadsCache.threadsListing(newThreads));
                logger.config("                      and removed obsolete threads: " + ThreadsCache.threadsListing(oldThreads));
            }
            if (addedGroups != null) {
                for (ThreadGroupReference g : addedGroups) {
                    this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, g);
                }
            }
            for (ThreadReference thread : newThreads) {
                this.pcs.firePropertyChange(PROP_THREAD_STARTED, null, thread);
            }
            for (ThreadReference thread : oldThreads) {
                this.pcs.firePropertyChange(PROP_THREAD_DIED, thread, null);
            }
            return;
        }
    }

    private static String threadsListing(List<ThreadReference> threads) {
        StringBuilder nt = new StringBuilder("[\n");
        for (ThreadReference t : threads) {
            String s;
            try {
                s = t.toString();
            }
            catch (Exception ex) {
                s = ex.toString();
            }
            nt.append(s);
            nt.append(",\n");
        }
        int l = nt.length();
        if (l > 1) {
            nt.delete(l - 2, l);
        }
        nt.append(']');
        return nt.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }
}

