/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.base.att;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.asm.base.att.TokenIterator;
import org.netbeans.modules.cnd.asm.base.syntax.AntlrScanner;
import org.netbeans.modules.cnd.asm.base.syntax.AntlrToken;
import org.netbeans.modules.cnd.asm.base.syntax.BranchElementImpl;
import org.netbeans.modules.cnd.asm.base.syntax.IdentResolver;
import org.netbeans.modules.cnd.asm.base.syntax.InstructionToken;
import org.netbeans.modules.cnd.asm.base.syntax.LabelElementImpl;
import org.netbeans.modules.cnd.asm.base.syntax.RegisterElementImpl;
import org.netbeans.modules.cnd.asm.base.syntax.ScannerFactory;
import org.netbeans.modules.cnd.asm.base.syntax.fake.FakeInstruction;
import org.netbeans.modules.cnd.asm.model.lang.AsmElement;
import org.netbeans.modules.cnd.asm.model.lang.AsmElementBuilder;
import org.netbeans.modules.cnd.asm.model.lang.OperandElement;
import org.netbeans.modules.cnd.asm.model.lang.Register;
import org.netbeans.modules.cnd.asm.model.lang.impl.AbstractAsmElement;
import org.netbeans.modules.cnd.asm.model.lang.impl.AsmRootElement;
import org.netbeans.modules.cnd.asm.model.lang.impl.BaseInstructionElement;
import org.netbeans.modules.cnd.asm.model.lang.instruction.Instruction;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmBaseTokenId;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmParser;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmToken;
import org.netbeans.modules.cnd.asm.model.lang.syntax.FunctionBoundsResolver;
import org.netbeans.modules.cnd.asm.model.util.IntervalSet;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ATTParser
implements AsmParser {
    private final IdentResolver resolver;
    private final ScannerFactory scannerFactory;
    private final Lookup myLookup;
    private List<AsmToken> tokens;
    private AsmElementBuilder result;
    private TokenIterator cur;
    private Set<String> globals;
    private IntervalSet<FunctionBoundsResolver.Entry> funcs;
    private String memOpBeginMark;
    private String memOpEndMark;
    private FunctionNameDetector funcDetector;

    public ATTParser(ScannerFactory scannerFactory, IdentResolver resolver) {
        this.resolver = resolver;
        this.scannerFactory = scannerFactory;
        InstanceContent ic = new InstanceContent();
        ic.add((Object)new FunctionBoundsResolverImpl());
        this.myLookup = new AbstractLookup((AbstractLookup.Content)ic);
        this.tokens = new ArrayList<AsmToken>();
        this.globals = new HashSet<String>();
        this.funcs = new IntervalSet();
        this.setMemOpMarks("(", ")");
        this.setFunctionNameDetector(new DefaultFunctionNameDetector());
    }

    public void setMemOpMarks(String memOpBeginMark, String memOpEndMark) {
        this.memOpBeginMark = memOpBeginMark;
        this.memOpEndMark = memOpEndMark;
    }

    public void setFunctionNameDetector(FunctionNameDetector funcDetector) {
        this.funcDetector = funcDetector;
    }

    @Override
    public Lookup getServices() {
        return this.myLookup;
    }

    private void reset(Reader src) {
        AsmToken tok;
        this.tokens.clear();
        this.globals.clear();
        this.funcs.clear();
        this.result = AsmElementBuilder.create(null);
        AntlrScanner scanner = this.scannerFactory.createScanner(src, null);
        int lastOffset = 0;
        do {
            try {
                tok = ((AntlrToken)scanner.nextToken()).createAsmToken(this.resolver);
                lastOffset = tok.getEndOffset();
            }
            catch (Exception ex) {
                this.tokens.add(new AsmToken(AsmBaseTokenId.ASM_EOF, null, lastOffset, lastOffset));
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Antlr lexer faced error token on position " + lastOffset);
                break;
            }
            if (tok.getId() == AsmBaseTokenId.ASM_EMPTY) continue;
            this.tokens.add(tok);
        } while (tok.getId() != AsmBaseTokenId.ASM_EOF);
        this.cur = new TokenIteratorImpl();
    }

    @Override
    public AsmElement parse(Reader src) {
        AsmToken tok;
        int lastInstrIdx = -1;
        int lastFuncIdx = -1;
        String lastFuncName = "";
        this.reset(src);
        while (this.cur.hasNext() && (tok = this.cur.next()).getId() != AsmBaseTokenId.ASM_EOF) {
            if (tok.getId() == AsmBaseTokenId.ASM_INSTRUCTION) {
                this.result.add(this.readInstruction((InstructionToken)tok));
                lastInstrIdx = this.getLastResultIdx();
                continue;
            }
            if (tok.getId() == AsmBaseTokenId.ASM_DIRECTIVE) {
                if (!this.isDefinitionMark(tok.getText())) continue;
                this.globals.add(this.cur.getCurrect().getText());
                continue;
            }
            if (tok.getId() == AsmBaseTokenId.ASM_UNKWN_ID || tok.getId() == AsmBaseTokenId.ASM_LABEL) {
                AbstractAsmElement branch = BranchElementImpl.create(tok.getText());
                branch.setOffset(tok);
                lastInstrIdx = this.getLastResultIdx();
                InstructionToken newTok = new InstructionToken(FakeInstruction.getInstance(), tok.getText(), tok.getStartOffset(), tok.getEndOffset());
                AsmElement iinst = this.readInstruction(newTok);
                iinst.getCompounds().add(0, branch);
                this.result.add(iinst);
                continue;
            }
            if (tok.getId() != AsmBaseTokenId.ASM_LABEL_INST) continue;
            String name = tok.getText();
            String cleanName = this.funcDetector.getCleanName(name);
            AbstractAsmElement comp = LabelElementImpl.create(cleanName);
            comp.setOffset(tok);
            this.result.add(comp);
            if (!this.funcDetector.isFunctionLabel(name)) continue;
            if (lastFuncIdx != -1 && lastFuncIdx != lastInstrIdx) {
                this.funcs.add(new FunctionBoundsResolver.Entry(lastFuncName, lastFuncIdx, lastInstrIdx));
            }
            lastFuncName = cleanName;
            lastFuncIdx = lastInstrIdx = this.getLastResultIdx();
        }
        if (lastFuncIdx != -1 && lastFuncIdx != lastInstrIdx) {
            this.funcs.add(new FunctionBoundsResolver.Entry(lastFuncName, lastFuncIdx, lastInstrIdx));
        }
        this.tokens = null;
        return AsmRootElement.create(this.result.get());
    }

    private boolean isDefinitionMark(String str) {
        return ".globl".equals(str) || ".local".equals(str) || ".global".equals(str);
    }

    private int getLastResultIdx() {
        return this.result.size() - 1;
    }

    private AsmElement readInstruction(InstructionToken instr) {
        AsmToken tok;
        List<String> params;
        ArrayList<Register> read = new ArrayList<Register>();
        ArrayList<Register> write = new ArrayList<Register>();
        AsmElementBuilder instrBuilder = AsmElementBuilder.create(null);
        Instruction instruction = instr.getInstruction();
        int inner = 0;
        int argNo = 2;
        if (!instruction.getArguments().isEmpty() && !(params = instruction.getArguments().iterator().next().getParamMnemonic()).isEmpty()) {
            argNo = params.size();
        }
        while ((tok = this.cur.getCurrect()).getId() != AsmBaseTokenId.ASM_EOF) {
            if (tok.getId() == AsmBaseTokenId.ASM_REGISTER) {
                Register reg = this.resolver.getRegister(tok.getText());
                if (reg != null) {
                    AbstractAsmElement regInst;
                    if (inner == 0) {
                        OperandElement.Usage usage = OperandElement.Usage.OP_USE_NO_USE;
                        if (instruction.getReadArgIdxs().contains(argNo)) {
                            read.add(reg);
                            usage = OperandElement.Usage.OP_USE_READ;
                        }
                        if (instruction.getWriteArgIdxs().contains(argNo)) {
                            write.add(reg);
                            usage = usage.apply(OperandElement.Usage.OP_USE_READ_WRITE);
                        }
                        regInst = RegisterElementImpl.create(reg, usage);
                    } else {
                        read.add(reg);
                        regInst = RegisterElementImpl.create(reg, OperandElement.Usage.OP_USE_READ);
                    }
                    regInst.setOffset(tok);
                    instrBuilder.add(regInst);
                }
            } else if (tok.getId() == AsmBaseTokenId.ASM_MARK) {
                if (tok.getText().equals(",") && inner == 0) {
                    --argNo;
                } else if (tok.getText().equals(this.memOpBeginMark)) {
                    ++inner;
                } else if (tok.getText().equals(this.memOpEndMark)) {
                    --inner;
                }
            } else if (tok.getId() == AsmBaseTokenId.ASM_UNKWN_ID || tok.getId() == AsmBaseTokenId.ASM_INSTRUCTION || tok.getId() == AsmBaseTokenId.ASM_LABEL_INST || tok.getId() == AsmBaseTokenId.ASM_DIRECTIVE) break;
            this.cur.next();
        }
        AbstractAsmElement resInstr = BaseInstructionElement.create(instrBuilder.get(), instruction, read, write);
        resInstr.setStartOffset(instr.getStartOffset());
        resInstr.setEndOffset(this.cur.getCurrect().getStartOffset());
        return resInstr;
    }

    private class TokenIteratorImpl
    implements TokenIterator {
        private int curPos;

        public TokenIteratorImpl() {
            this(0);
        }

        private TokenIteratorImpl(int pos) {
            assert (ATTParser.this.tokens.size() > 0);
            this.curPos = pos;
        }

        @Override
        public AsmToken getCurrect() {
            if (this.curPos >= ATTParser.this.tokens.size()) {
                return (AsmToken)ATTParser.this.tokens.get(ATTParser.this.tokens.size() - 1);
            }
            return (AsmToken)ATTParser.this.tokens.get(this.curPos);
        }

        @Override
        public AsmToken guess(int pos) {
            if (this.curPos + pos < ATTParser.this.tokens.size()) {
                return (AsmToken)ATTParser.this.tokens.get(this.curPos + pos);
            }
            return (AsmToken)ATTParser.this.tokens.get(ATTParser.this.tokens.size() - 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AsmToken next() {
            try {
                AsmToken asmToken = this.getCurrect();
                return asmToken;
            }
            finally {
                ++this.curPos;
            }
        }

        @Override
        public TokenIterator createRecovery() {
            return new TokenIteratorImpl(this.curPos);
        }

        @Override
        public boolean hasNext() {
            return this.curPos < ATTParser.this.tokens.size() - 1;
        }
    }

    public class DefaultFunctionNameDetector
    implements FunctionNameDetector {
        @Override
        public boolean isFunctionLabel(String name) {
            return !(name = name.substring(0, name.length() - 1)).startsWith(".") && !Character.isDigit(name.charAt(0)) || ATTParser.this.globals.contains(name);
        }

        @Override
        public String getCleanName(String name) {
            if (name.endsWith(":")) {
                return name.substring(0, name.length() - 1);
            }
            return name;
        }
    }

    public static interface FunctionNameDetector {
        public boolean isFunctionLabel(String var1);

        public String getCleanName(String var1);
    }

    private class FunctionBoundsResolverImpl
    implements FunctionBoundsResolver {
        private FunctionBoundsResolverImpl() {
        }

        @Override
        public IntervalSet<FunctionBoundsResolver.Entry> getFunctions() {
            return ATTParser.this.funcs;
        }
    }
}

