/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.cnd.asm.model.AsmModelProvider;
import org.netbeans.modules.cnd.asm.model.AsmSyntaxProvider;
import org.netbeans.modules.cnd.asm.model.AsmTypesProvider;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ModelChooser
extends AbstractAction
implements Presenter.Menu {
    private static AsmModelProvider curModel;
    private static AsmSyntaxProvider curSyntax;
    private static final JMenu menu;

    public static AsmModelProvider getModelProvider() {
        return curModel;
    }

    public static AsmSyntaxProvider getSyntaxProvider() {
        return curSyntax;
    }

    public ModelChooser() {
        super(NbBundle.getMessage(ModelChooser.class, (String)"CTL_ModelChooser"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        assert (false);
    }

    public JMenuItem getMenuPresenter() {
        String label = NbBundle.getMessage(ModelChooser.class, (String)"CTL_ModelChooser");
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)label);
        return menu;
    }

    static {
        menu = new UpdatingMenu();
    }

    private static final class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private final JComponent[] models = this.calcPresenters();

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.models;
        }

        public JComponent[] getMenuPresenters() {
            return this.models;
        }

        public JComponent[] calcPresenters() {
            this.removeAll();
            ButtonGroup group = new ButtonGroup();
            boolean isFirst = true;
            Collection mods = Lookup.getDefault().lookup(new Lookup.Template(AsmTypesProvider.class)).allInstances();
            for (AsmTypesProvider p : mods) {
                for (AsmTypesProvider.AsmTypesEntry type : p.getAsmTypes()) {
                    Iterator<AsmSyntaxProvider> i$ = type.getSyntaxProviders().iterator();
                    while (i$.hasNext()) {
                        AsmSyntaxProvider synt;
                        final AsmSyntaxProvider closureSyntax = synt = i$.next();
                        final AsmModelProvider closureModel = type.getModelProvider();
                        String modelName = closureModel.toString();
                        String syntName = closureSyntax.toString();
                        JRadioButtonMenuItem item = new JRadioButtonMenuItem(modelName + " - " + syntName);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                curModel = closureModel;
                                curSyntax = closureSyntax;
                            }
                        });
                        group.add(item);
                        this.add(item);
                        if (!isFirst) continue;
                        group.setSelected(item.getModel(), true);
                        curModel = closureModel;
                        curSyntax = closureSyntax;
                        isFirst = false;
                    }
                }
            }
            this.setEnabled(true);
            return new JComponent[]{this};
        }
    }
}

