/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.impl;

import java.util.Comparator;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;

public class StdQuicksortIters {
    private static final int MAX_THRESH = 4;
    private static long STACK_SIZE = 64L;

    public static <T, Iter extends type$iterator<Iter, T>> void _quicksort(Iter pbase, long total_elems, Comparator<T> cmp) {
        Iter base_ptr = Native.$tryClone(pbase);
        long max_thresh = 4L;
        if (total_elems == 0L) {
            return;
        }
        if (total_elems > 4L) {
            Object lo = Native.$tryClone(base_ptr);
            type$iterator hi = (type$iterator)lo.$add(total_elems - 1L);
            stack_node<T, Iter>[] stack2 = StdQuicksortIters.createStack();
            type$ptr<stack_node<T, Iter>> top = NativePointer.create_type$ptr(stack2);
            StdQuicksortIters.PUSH(top, null, null);
            while (StdQuicksortIters.STACK_NOT_EMPTY(stack2, top)) {
                type$iterator mid = (type$iterator)lo.$add(hi.$sub(lo) >> 1);
                boolean jump_over = false;
                if (cmp.compare(mid.$star(), lo.$star()) < 0) {
                    StdQuicksortIters.SWAP(mid, lo);
                }
                if (cmp.compare(hi.$star(), mid.$star()) < 0) {
                    StdQuicksortIters.SWAP(mid, hi);
                } else {
                    jump_over = true;
                }
                if (!jump_over && cmp.compare(mid.$star(), lo.$star()) < 0) {
                    StdQuicksortIters.SWAP(mid, lo);
                }
                type$iterator left_ptr = (type$iterator)lo.$add(1);
                type$iterator right_ptr = (type$iterator)hi.$sub(1);
                while (true) {
                    if (cmp.compare(left_ptr.$star(), mid.$star()) < 0) {
                        left_ptr.$inc(1);
                        continue;
                    }
                    while (cmp.compare(mid.$star(), right_ptr.$star()) < 0) {
                        right_ptr.$dec(1);
                    }
                    if (StdQuicksortIters.$less(left_ptr, right_ptr)) {
                        StdQuicksortIters.SWAP(left_ptr, right_ptr);
                        if (mid.$eq(left_ptr)) {
                            mid = Native.$tryClone(right_ptr);
                        } else if (mid.$eq(right_ptr)) {
                            mid = Native.$tryClone(left_ptr);
                        }
                        left_ptr.$inc(1);
                        right_ptr.$dec(1);
                    } else if (left_ptr.$eq(right_ptr)) {
                        left_ptr.$inc(1);
                        right_ptr.$dec(1);
                        break;
                    }
                    if (!StdQuicksortIters.$lesseq(left_ptr, right_ptr)) break;
                }
                if ((long)right_ptr.$sub(lo) <= 4L) {
                    if ((long)hi.$sub(left_ptr) <= 4L) {
                        StdQuicksortIters.POP(top, lo, hi);
                        continue;
                    }
                    lo = Native.$tryAssign(lo, left_ptr, false);
                    continue;
                }
                if ((long)hi.$sub(left_ptr) <= 4L) {
                    hi = Native.$tryAssign(hi, right_ptr, false);
                    continue;
                }
                if (right_ptr.$sub(lo) > hi.$sub(left_ptr)) {
                    StdQuicksortIters.PUSH(top, lo, right_ptr);
                    lo = Native.$tryAssign(lo, left_ptr, false);
                    continue;
                }
                StdQuicksortIters.PUSH(top, left_ptr, hi);
                hi = Native.$tryAssign(hi, right_ptr, false);
            }
        }
        type$iterator end_ptr = (type$iterator)base_ptr.$add(total_elems - 1L);
        Object tmp_ptr = Native.$tryClone(base_ptr);
        type$iterator thresh = Native.$tryClone(StdQuicksortIters.min(end_ptr, (type$iterator)base_ptr.$add(4L)));
        type$iterator run_ptr = (type$iterator)tmp_ptr.$add(1);
        while (StdQuicksortIters.$lesseq(run_ptr, thresh)) {
            if (cmp.compare(run_ptr.$star(), tmp_ptr.$star()) < 0) {
                tmp_ptr = Native.$tryClone(run_ptr);
            }
            run_ptr.$preInc();
        }
        if (tmp_ptr.$noteq(base_ptr)) {
            StdQuicksortIters.SWAP(tmp_ptr, base_ptr);
        }
        run_ptr = (type$iterator)base_ptr.$add(1);
        while (StdQuicksortIters.$lesseq((type$iterator)run_ptr.$inc(1), end_ptr)) {
            tmp_ptr = (type$iterator)run_ptr.$sub(1);
            while (cmp.compare(run_ptr.$star(), tmp_ptr.$star()) < 0) {
                tmp_ptr.$dec(1);
            }
            tmp_ptr.$inc(1);
            if (!tmp_ptr.$noteq(run_ptr)) continue;
            type$iterator trav = (type$iterator)run_ptr.$add(1);
            while (StdQuicksortIters.$greatereq((type$iterator)trav.$preDec(), run_ptr)) {
                Object c = trav.$star();
                type$iterator lo = Native.$tryClone(trav);
                type$iterator hi = Native.$tryClone(lo);
                while (StdQuicksortIters.$greatereq((type$iterator)lo.$preDec(), tmp_ptr)) {
                    hi.star$ref().$set(lo.$star());
                    hi = Native.$tryClone(lo);
                }
                hi.star$ref().$set(c);
            }
        }
    }

    private static <T, Iter extends type$iterator<Iter, T>> stack_node<T, Iter>[] createStack() {
        stack_node[] stack2 = new stack_node[(int)STACK_SIZE];
        for (int i = 0; i < stack2.length; ++i) {
            stack2[i] = new stack_node();
        }
        return stack2;
    }

    private static <T, Iter extends type$iterator<Iter, T>> boolean $less(Iter lhs, Iter rhs) {
        int diff = lhs.$sub(rhs);
        return diff < 0;
    }

    private static <T, Iter extends type$iterator<Iter, T>> boolean $lesseq(Iter lhs, Iter rhs) {
        int diff = lhs.$sub(rhs);
        return diff <= 0;
    }

    private static <T, Iter extends type$iterator<Iter, T>> boolean $greatereq(Iter lhs, Iter rhs) {
        int diff = lhs.$sub(rhs);
        return diff >= 0;
    }

    private static <T, Iter extends type$iterator<Iter, T>> Iter min(Iter x, Iter y) {
        return StdQuicksortIters.$less(x, y) ? x : y;
    }

    private static <T, Iter extends type$iterator<Iter, T>> void SWAP(Iter left, Iter right) {
        std.swap_iter(left, right);
    }

    private static <T, Iter extends type$iterator<Iter, T>> void PUSH(type$ptr<stack_node<T, Iter>> top, Iter low, Iter high) {
        top.$star().lo = Native.$tryClone(low);
        top.$star().hi = Native.$tryClone(high);
        top.$preInc();
    }

    private static <T, Iter extends type$iterator<Iter, T>> void POP(type$ptr<stack_node<T, Iter>> top, Iter low, Iter high) {
        top.$preDec();
        if (top.$star().lo != null && top.$star().hi != null) {
            Native.$tryAssign(low, top.$star().lo, false);
            Native.$tryAssign(high, top.$star().hi, false);
        } else assert (top.$index() == 0);
    }

    private static <T, Iter extends type$iterator<Iter, T>> boolean STACK_NOT_EMPTY(stack_node<T, Iter>[] stack2, type$ptr<stack_node<T, Iter>> top) {
        return NativePointer.create_type$ptr(stack2).$noteq((stack_node<type$ptr<stack_node<T, Iter>>, Iter>)((Object)top));
    }

    private static class stack_node<T, Iter extends type$iterator<Iter, T>> {
        Iter lo;
        Iter hi;

        private stack_node() {
        }
    }
}

