/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl;

import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVectorChar;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char$iterator;
import org.clank.support.aliases.char$ptr;

public abstract class StdString
implements Native.NativeComparable,
Native.ComparableLowerGreater,
Comparable<std.string>,
Native.OpCapable,
NativeCloneable<std.string>,
Native.assignable<std.string>,
Destructors.ClassWithDestructor {
    public static final std.string EMPTY = new std.string("");
    public static int npos = Integer.MAX_VALUE;
    public static final byte TERM = NativePointer.$TERM;
    private static final byte[] TERM_ARRAY = new byte[]{TERM};
    protected std.vectorChar array;

    protected StdString() {
        this.array = new std.vectorChar(TERM_ARRAY, 1L);
    }

    protected StdString(byte[] ar) {
        this.array = new std.vectorChar(ar, (long)std.strlen(ar));
        this._postModUpdate();
    }

    protected StdString(char$iterator<?> data, int length) {
        this.array = new std.vectorChar(data, (long)length);
        this._postModUpdate();
    }

    protected StdString(int __n, char __c) {
        this.array = new std.vectorChar((long)__n, (byte)__c);
        this._postModUpdate();
    }

    protected StdString(int __n, byte __c) {
        this.array = new std.vectorChar((long)__n, __c);
        this._postModUpdate();
    }

    protected StdString(CharSequence value) {
        this.array = new std.vectorChar();
        this.array.reserve(value.length() + 1);
        for (int i = 0; i < value.length(); ++i) {
            this.array.append(1, (byte)value.charAt(i));
        }
        this._postModUpdate();
    }

    protected StdString(std.string other) {
        this.array = Native.$tryClone(other.array);
    }

    protected StdString(JavaDifferentiators.Move _dparam, std.string other) {
        std.vectorChar tmp = this.array;
        this.array = other.array;
        other.array = tmp;
    }

    protected StdString(char$ptr value) {
        this(value, std.strlen(value));
    }

    protected StdString(char$ptr value, int length) {
        this(value, 0, length);
    }

    protected StdString(char$iterator<?> begin, char$iterator<?> end) {
        this(begin, end.$sub(begin));
    }

    protected StdString(char$ptr from, int StartIdx, int length) {
        byte[] ar = NativePointer.new$char(length + 1, new byte[0]);
        int i = 0;
        while (i < length) {
            ar[i++] = from.$at(StartIdx++);
        }
        ar[length] = TERM;
        this.array = new std.vectorChar(ar, (long)(length + 1));
    }

    @Override
    public std.string $assign(std.string other) {
        this.array.$assign(other.array);
        return (std.string)this;
    }

    @Override
    public std.string $assign(CharSequence other) {
        this.$assign(new std.string(other));
        return (std.string)this;
    }

    @Override
    public std.string $assign(char$ptr value) {
        this.$assign(new std.string(value));
        return (std.string)this;
    }

    public char$ptr c_str() {
        return this.array.data();
    }

    public char$ptr data() {
        return this.array.data();
    }

    public char$ptr begin() {
        return this.array.data();
    }

    public char$ptr end() {
        return (char$ptr)this.begin().$add(this.length());
    }

    @Override
    public void $destroy() {
    }

    public void reserve(int size) {
        this.array.reserve(size);
        this._postModUpdate();
    }

    public void resize(int size) {
        this.resize(size, TERM);
    }

    public void resize(int size, char defaultValue) {
        this.resize(size, NativePointer.$(defaultValue));
    }

    public void resize(int size, byte defaultValue) {
        assert (this.array.size() > 0);
        this.array.pop_back();
        this.array.resize(size, defaultValue);
        this._postModUpdate();
    }

    public int size() {
        return this.length();
    }

    public int max_size() {
        return Integer.MAX_VALUE;
    }

    public int length() {
        return this.array.size() - 1;
    }

    public int capacity() {
        return this.array.capacity();
    }

    public boolean empty() {
        assert (this.length() >= 0);
        return this.length() == 0;
    }

    public std.string assign(int __n, byte __c) {
        return this._M_replace_aux(0, this.size(), __n, __c);
    }

    public std.string assign(char$ptr begin, char$ptr end) {
        this.$assign(new std.string(begin, end));
        return (std.string)this;
    }

    public std.string assign(char$iterator begin, char$iterator end) {
        this.$assign(new std.string(begin, end));
        return (std.string)this;
    }

    public char$ptr erase(char$ptr __position) {
        return this.erase(this.convertPtrToIter(__position)).star$ref().deref$ptr();
    }

    public char$ptr erase(char$ptr __first, char$ptr __last) {
        return this.erase(this.convertPtrToIter(__first), this.convertPtrToIter(__last)).star$ref().deref$ptr();
    }

    public std.string erase() {
        return this.erase(0, npos);
    }

    public std.string erase(int __pos) {
        return this.erase(__pos, npos);
    }

    public std.string erase(int __pos, int __n) {
        StdVectorChar.iterator first = this.array.begin().$add(__pos);
        StdVectorChar.iterator last = __n != npos ? first.$add(__n) : this.array.end();
        this.erase(first, last);
        return (std.string)this;
    }

    public char$ptr insert(char$ptr __p, char __c) {
        char$ptr result = this.array.insert(this.convertPtrToIter(__p), (byte)__c).star$ref().deref$ptr();
        this._postModUpdate();
        return result;
    }

    public char$ptr insert(char$ptr __p, char$iterator<?> __k1, char$iterator<?> __k2) {
        char$ptr result = this.array.insert(this.convertPtrToIter(__p), __k1, __k2).star$ref().deref$ptr();
        this._postModUpdate();
        return result;
    }

    public std.string append(char$iterator<?> __first, char$iterator<?> __last) {
        return this.replace(this._M_iend(), this._M_iend(), __first, __last);
    }

    public std.string append(char$iterator<?> __first, int Size) {
        return this.replace(this._M_iend(), this._M_iend(), __first, (char$iterator)__first.$add(Size));
    }

    public std.string append(char$ptr __first, int __firstStartIdx, int Size) {
        return this.replace(this._M_iend(), this._M_iend(), __first, __firstStartIdx, Size);
    }

    public void push_back(byte c) {
        this.array.insert(this.array.begin().$add(this.length()), c);
        this._postModUpdate();
    }

    public void clear() {
        this.array = new std.vectorChar();
        this._postModUpdate();
    }

    public std.string $addassign(byte c) {
        this.array.insert(this.array.begin().$add(this.length()), c);
        this._postModUpdate();
        return (std.string)this;
    }

    public std.string $addassign(char c) {
        return this.$addassign(NativePointer.$(c));
    }

    public std.string $addassign(std.string extra) {
        this.array.insert(this.array.begin().$add(this.length()), extra.begin(), extra.end());
        this._postModUpdate();
        return (std.string)this;
    }

    public std.string $addassign(char$ptr extra) {
        this.array.insert(this.array.begin().$add(this.length()), extra, (char$iterator)extra.$add(std.strlen(extra)));
        this._postModUpdate();
        return (std.string)this;
    }

    public std.string $addassign(CharSequence extra) {
        return this.$addassign(NativePointer.create_char$ptr(extra));
    }

    public byte $at(int val) {
        return this.array.$at(val);
    }

    public byte $set(int idx, long val) {
        return this.array.$set(idx, (byte)val);
    }

    public byte $set(int idx, byte val) {
        return this.array.$set(idx, val);
    }

    public std.string substr(int idx) {
        return new std.string((char$iterator)this.begin().$add(idx), this.end());
    }

    public std.string substr(int first, int last) {
        if (last == npos) {
            return this.substr(first);
        }
        return new std.string((char$iterator)this.begin().$add(first), (char$iterator)this.begin().$add(last));
    }

    public std.string replace(int __pos, int __n1, char$ptr __s, int __n2) {
        char$ptr _M_data = this._M_data();
        if (this._M_disjunct(__s)) {
            return this._M_replace_safe(__pos, __n1, __s, __n2);
        }
        boolean __left = __s.$index() + __n2 <= _M_data.$index() + __pos;
        if (__left || _M_data.$index() + __pos + __n1 <= __s.$index()) {
            int __off = __s.$sub(_M_data);
            __off = __left ? __off : __off + __n2 - __n1;
            this._M_mutate(__pos, __n1, __n2);
            _M_data = this._M_data();
            this._M_copy(_M_data, __pos, _M_data, __off, __n2);
            this._postModUpdate();
            return (std.string)this;
        }
        std.string __tmp = new std.string(__s, __n2);
        return this._M_replace_safe(__pos, __n1, __tmp._M_data(), __n2);
    }

    public std.string replace(int __pos, int __n1, CharSequence __s, int __n2) {
        return this.replace(__pos, __n1, NativePointer.create_char$ptr(__s), __n2);
    }

    public std.string replace(int __pos, int __n1, char$ptr __s) {
        return this.replace(__pos, __n1, __s, std.strlen(__s));
    }

    public std.string replace(int __pos, int __n, std.string __str) {
        return this.replace(__pos, __n, __str._M_data(), __str.size());
    }

    public std.string replace(int __pos, int __n, CharSequence __str) {
        return this.replace(__pos, __n, NativePointer.create_char$ptr(__str));
    }

    public std.string replace(int __pos1, int __n1, std.string __str, int __pos2, int __n2) {
        return this.replace(__pos1, __n1, (char$ptr)__str._M_data().$add(__str._M_check(__pos2, "basic_string::replace")), __str._M_limit(__pos2, __n2));
    }

    public std.string replace(int __pos, int __n1, int __n2, byte __c) {
        return this._M_replace_aux(this._M_check(__pos, "basic_string::replace"), this._M_limit(__pos, __n1), __n2, __c);
    }

    public std.string replace(int __pos, int __n1, int __n2, char __c) {
        return this.replace(__pos, __n1, __n2, (byte)__c);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, std.string __str) {
        return this.replace(__i1, __i2, __str._M_data(), __str.size());
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, char$ptr __s, int __n) {
        return this.replace(__i1.$sub(this._M_ibegin()), __i2.$sub(__i1), __s, __n);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, CharSequence __s, int __n) {
        return this.replace(__i1.$sub(this._M_ibegin()), __i2.$sub(__i1), NativePointer.create_char$ptr(__s), __n);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, char$ptr __s) {
        return this.replace(__i1, __i2, __s, std.strlen(__s));
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, CharSequence __s) {
        return this.replace(__i1, __i2, NativePointer.create_char$ptr(__s), __s.length());
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, int __n, byte __c) {
        return this._M_replace_aux(__i1.$sub(this._M_ibegin()), __i2.$sub(__i1), __n, __c);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, int __n, char __c) {
        return this.replace(__i1, __i2, __n, (byte)__c);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, char$iterator<?> __k1, char$iterator<?> __k2) {
        return this.replace(__i1, __i2, __k1, 0, __k2.$sub(__k1));
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, char$iterator<?> __k1, int __k1_Idx, int Size) {
        return this._M_replace_dispatch(__i1, __i2, __k1, __k1_Idx, Size);
    }

    public int find(char$ptr __s, int __pos, int __n) {
        int __size = this.size();
        char$ptr __data = this._M_data();
        if (__n == 0) {
            return __pos <= __size ? __pos : npos;
        }
        if (__n <= __size) {
            while (__pos <= __size - __n) {
                if (Native.$eq(__data.$at(__pos), __s.$at(0)) && std.strncmp((char$ptr)__data.$add(__pos + 1), (char$ptr)__s.$add(1), (long)(__n - 1)) == 0) {
                    return __pos;
                }
                ++__pos;
            }
        }
        return npos;
    }

    public int find(CharSequence __s, int __pos, int __n) {
        return this.find(NativePointer.create_char$ptr(__s), __pos, __n);
    }

    public int find(std.string __str) {
        return this.find(__str, 0);
    }

    public int find(std.string __str, int __pos) {
        return this.find(__str.data(), __pos, __str.size());
    }

    public int find(char$ptr __s) {
        return this.find(__s, 0);
    }

    public int find(CharSequence __s) {
        return this.find(NativePointer.create_char$ptr(__s));
    }

    public int find(char$ptr __s, int __pos) {
        return this.find(__s, __pos, std.strlen(__s));
    }

    public int find(CharSequence __s, int __pos) {
        return this.find(NativePointer.create_char$ptr(__s), __pos);
    }

    public int find(byte __c) {
        return this.find(__c, 0);
    }

    public int find(char __c) {
        return this.find((byte)__c);
    }

    public int find(byte __c, int __pos) {
        int __ret = npos;
        int __size = this.size();
        if (__pos < __size) {
            char$ptr __to;
            char$ptr __data = this._M_data();
            int __n = __size - __pos;
            char$ptr __from = (char$ptr)__data.$add(__pos);
            char$ptr __p = std.find(__from, __to = (char$ptr)__data.$add(__pos + __n), __c);
            if (__p.$noteq(__to)) {
                __ret = __p.$sub(__data);
            }
        }
        return __ret;
    }

    public int find(char __c, int __pos) {
        return this.find((byte)__c, __pos);
    }

    public int rfind(std.string __str) {
        return this.rfind(__str, npos);
    }

    public int rfind(std.string __str, int __pos) {
        return this.rfind(__str.data(), __pos, __str.size());
    }

    public int rfind(char$ptr __s, int __pos, int __n) {
        int __size = this.size();
        if (__n <= __size) {
            __pos = std.min(__size - __n, __pos);
            char$ptr __data = this._M_data();
            do {
                if (std.strncmp((char$ptr)__data.$add(__pos), __s, (long)__n) != 0) continue;
                return __pos;
            } while (__pos-- > 0);
        }
        return npos;
    }

    public int rfind(CharSequence __s, int __pos, int __n) {
        return this.rfind(NativePointer.create_char$ptr(__s), __pos, __n);
    }

    public int rfind(char$ptr __s) {
        return this.rfind(__s, npos);
    }

    public int rfind(CharSequence __s) {
        return this.rfind(NativePointer.create_char$ptr(__s));
    }

    public int rfind(char$ptr __s, int __pos) {
        return this.rfind(__s, __pos, std.strlen(__s));
    }

    public int rfind(CharSequence __s, int __pos) {
        return this.rfind(NativePointer.create_char$ptr(__s), __pos);
    }

    public int rfind(byte __c) {
        return this.rfind(__c, npos);
    }

    public int rfind(char __c) {
        return this.rfind((byte)__c);
    }

    public int rfind(byte __c, int __pos) {
        block3: {
            int __size = this.size();
            if (__size > 0) {
                if (--__size > __pos) {
                    __size = __pos;
                }
                do {
                    int n = ++__size;
                    --__size;
                    if (n <= 0) break block3;
                } while (!Native.$eq(this._M_data().$at(__size), __c));
                return __size;
            }
        }
        return npos;
    }

    public int rfind(char __c, int __pos) {
        return this.rfind((byte)__c, __pos);
    }

    public boolean $eq(Object __other) {
        if (!(__other instanceof std.string)) {
            return false;
        }
        std.string other = (std.string)__other;
        if (this.length() == other.length()) {
            for (int i = 0; i < this.length(); ++i) {
                if (this.array.$at(i) == other.array.$at(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean $noteq(Object other) {
        return !this.$eq(other);
    }

    @Override
    public int compareTo(std.string o) {
        if (this.$less(o)) {
            return -1;
        }
        if (o.$less(this)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean $less(Object __other) {
        int pos;
        StdString other = (StdString)__other;
        byte ch1 = 0;
        byte ch2 = 0;
        int len = std.min(this.length(), other.length());
        for (pos = 0; pos < len && (ch1 = this.$at(pos)) == (ch2 = other.$at(pos)); ++pos) {
            if (ch1 != 0) continue;
            return false;
        }
        return pos == len ? false : ch1 < ch2;
    }

    @Override
    public boolean $lesseq(Object obj) {
        return !((StdString)obj).$less(this);
    }

    @Override
    public boolean $greater(Object obj) {
        return ((StdString)obj).$less(this);
    }

    @Override
    public boolean $greatereq(Object obj) {
        return !this.$less((StdString)obj);
    }

    @Override
    public Boolean $op(Native.OpCapable.Op k, Object obj) {
        if (Native.OpCapable.Op.EQ == k) {
            if (obj instanceof StdString) {
                return this.$eq((StdString)obj);
            }
            if (obj instanceof CharSequence) {
                return this.$eq(new std.string((CharSequence)obj));
            }
            if (obj instanceof char$iterator) {
                return this.$eq(new std.string((char$iterator)obj, std.strlen((char$iterator)obj)));
            }
        }
        assert (false) : "can not check " + (Object)((Object)k) + " for " + obj.getClass();
        return null;
    }

    public std.string $assignMove(std.string other) {
        std.vectorChar tmp = this.array;
        this.array = other.array;
        other.array = tmp;
        return (std.string)this;
    }

    @Override
    public std.string clone() {
        return new std.string((std.string)this);
    }

    public String toString() {
        return "[string size=" + this.length() + "+'0']\n" + this.toJavaString();
    }

    public String toJavaString() {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            out.append((char)this.$at(i));
        }
        return out.toString();
    }

    protected char$ptr _M_data() {
        return this.data();
    }

    protected char$ptr _M_ibegin() {
        return this.data();
    }

    protected char$ptr _M_iend() {
        return (char$ptr)this.data().$add(this.size());
    }

    protected int _M_limit(int __pos, int __off) {
        boolean __testoff = __off < this.size() - __pos;
        return __testoff ? __off : this.size() - __pos;
    }

    protected boolean _M_disjunct(char$ptr __s) {
        return !__s.isComparableTo(this._M_data()) || __s.$less(this.data()) || ((char$ptr)this.data().$add(this.size())).$less(__s);
    }

    protected std.string _M_replace_aux(int __pos1, int __n1, int __n2, byte __c) {
        this._M_check_length(__n1, __n2, "basic_string::_M_replace_aux");
        this._M_mutate(__pos1, __n1, __n2);
        if (__n2 > 0) {
            std.memset((char$ptr)this._M_data().$add(__pos1), __c, __n2);
        }
        this._postModUpdate();
        return (std.string)this;
    }

    protected std.string _M_replace_safe(int __pos1, int __n1, char$ptr __s, int __n2) {
        this._M_mutate(__pos1, __n1, __n2);
        if (__n2 > 0) {
            this._M_copy(this._M_data(), __pos1, __s, 0, __n2);
        }
        this._postModUpdate();
        return (std.string)this;
    }

    protected std.string _M_replace_dispatch(char$ptr __i1, char$ptr __i2, char$iterator<?> __k1, char$iterator<?> __k2) {
        return this._M_replace_dispatch(__i1, __i2, __k1, 0, __k2.$sub(__k1));
    }

    protected std.string _M_replace_dispatch(char$ptr __i1, char$ptr __i2, char$iterator<?> __from, int __fromIdx, int Size) {
        std.string __s = new std.string(__from, __fromIdx, Size);
        int __n1 = __i2.$sub(__i1);
        this._M_check_length(__n1, __s.size(), "basic_string::_M_replace_dispatch");
        return this._M_replace_safe(__i1.$sub(this._M_ibegin()), __n1, __s._M_data(), __s.size());
    }

    protected void _M_mutate(int __pos, int __len1, int __len2) {
        int __old_size = this.size();
        int __new_size = __old_size + __len2 - __len1;
        int __how_much = __old_size - __pos - __len1;
        if (__new_size > this.capacity()) {
            this.array.reserve(__new_size);
        }
        if (__how_much > 0 && __len1 != __len2) {
            char$ptr _M_data = this._M_data();
            if (__len2 > __len1) {
                int downToIdx = __pos + __len1;
                int fromIdx = downToIdx + __how_much;
                int destIdx = __pos + __len2 + __how_much;
                std.copy_backward(_M_data, downToIdx, fromIdx, _M_data, destIdx);
            } else {
                int fromIdx = __pos + __len1;
                int toIdx = fromIdx + __how_much;
                int destIdx = __pos + __len2;
                std.copy(_M_data, fromIdx, toIdx, _M_data, destIdx);
            }
        }
        this.array.set_size(__new_size);
    }

    protected void _M_copy(char$ptr __d, int __dIdx, char$ptr __s, int __sIdx, int __n) {
        std.copy(__s, __sIdx, __sIdx + __n, __d, __dIdx);
    }

    protected void _M_move(char$ptr __d, int __dIdx, char$ptr __s, int __sIdx, int __n) {
        std.copy(__s, __sIdx, __sIdx + __n, __d, __dIdx);
    }

    protected int _M_check(int __pos, CharSequence __s) {
        if (__pos > this.size()) {
            throw new RuntimeException(__s.toString());
        }
        return __pos;
    }

    protected void _M_check_length(int __n1, int __n2, CharSequence __s) {
        if (this.max_size() - (this.size() - __n1) < __n2) {
            throw new RuntimeException(__s.toString());
        }
    }

    private StdVectorChar.iterator convertPtrToIter(char$ptr ptr2) {
        return this.array.begin().$add(ptr2.$sub(this.begin()));
    }

    private void _postModUpdate() {
        if (this.array.empty() || this.array.$at(this.array.size() - 1) != TERM) {
            this.array.append(1, TERM);
        }
    }

    private char$iterator erase(StdVectorChar.iterator __position) {
        StdVectorChar.iterator res = this.array.erase(__position);
        this._postModUpdate();
        return res;
    }

    private char$iterator erase(StdVectorChar.iterator __first, StdVectorChar.iterator __last) {
        StdVectorChar.iterator res = this.array.erase(__first, __last);
        this._postModUpdate();
        return res;
    }
}

