/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jade.editor.indent;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.javascript2.jade.editor.lexer.JadeTokenId;
import org.openide.util.Exceptions;

public class IndentationCounter {
    private final BaseDocument doc;

    public IndentationCounter(BaseDocument doc) {
        this.doc = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Indentation count(int caretOffset) {
        Indentation result = Indentation.NONE;
        this.doc.readLock();
        try {
            result = this.countUnderReadLock(caretOffset);
        }
        finally {
            this.doc.readUnlock();
        }
        return result;
    }

    private Indentation countUnderReadLock(int caretOffset) {
        int newIndent = 0;
        try {
            TokenSequence ts = TokenHierarchy.get((Document)this.doc).tokenSequence(JadeTokenId.jadeLanguage());
            int caretLineStart = LineDocumentUtils.getLineStart((LineDocument)this.doc, (int)(LineDocumentUtils.getLineStart((LineDocument)this.doc, (int)caretOffset) - 1));
            if (ts != null) {
                ts.move(caretOffset);
                ts.moveNext();
                if (ts.token() == null) {
                    return Indentation.NONE;
                }
                while ((ts.token().id() == JadeTokenId.EOL || ts.token().id() == JadeTokenId.WHITESPACE) && ts.movePrevious()) {
                }
                if (ts.token().id() == JadeTokenId.COMMENT || ts.token().id() == JadeTokenId.UNBUFFERED_COMMENT) {
                    int firstNonWsIndex = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)this.doc, (int)(LineDocumentUtils.getLineStart((LineDocument)this.doc, (int)caretOffset) - 1));
                    ts.move(firstNonWsIndex);
                    ts.moveNext();
                    if (ts.token() != null && (ts.token().id() == JadeTokenId.COMMENT_DELIMITER || ts.token().id() == JadeTokenId.UNBUFFERED_COMMENT_DELIMITER)) {
                        return new IndentationImpl(Utilities.getRowIndent((BaseDocument)this.doc, (int)caretLineStart) + 1);
                    }
                }
                newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)caretLineStart);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (newIndent < 0) {
            newIndent = 0;
        }
        return new IndentationImpl(newIndent);
    }

    private static final class IndentationImpl
    implements Indentation {
        private final int indentation;

        public IndentationImpl(int indentation) {
            this.indentation = indentation;
        }

        @Override
        public int getIndentation() {
            return this.indentation;
        }

        @Override
        public void modify(final Context context) {
            assert (context != null);
            context.document().render(new Runnable(){

                @Override
                public void run() {
                    IndentationImpl.this.modifyUnderWriteLock(context);
                }
            });
        }

        private void modifyUnderWriteLock(Context context) {
            try {
                context.modifyIndent(LineDocumentUtils.getLineStart((LineDocument)((BaseDocument)context.document()), (int)context.caretOffset()), this.indentation);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static interface Indentation {
        public static final Indentation NONE = new Indentation(){

            @Override
            public int getIndentation() {
                return 0;
            }

            @Override
            public void modify(Context context) {
            }
        };

        public int getIndentation();

        public void modify(Context var1);
    }
}

