/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core.api;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.modules.versioning.core.APIAccessor;
import org.netbeans.modules.versioning.core.DelegatingVCS;
import org.netbeans.modules.versioning.core.Utils;
import org.netbeans.modules.versioning.core.VersioningConfig;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.filesystems.VCSFileProxyOperations;
import org.netbeans.modules.versioning.core.spi.VersioningSystem;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.openide.filesystems.FileUtil;

public final class VersioningSupport {
    public static final String PREF_BOOLEAN_TEXT_ANNOTATIONS_VISIBLE = "textAnnotationsVisible";

    private VersioningSupport() {
    }

    public static Preferences getPreferences() {
        return VersioningConfig.getDefault().getPreferences();
    }

    public static VersioningSystem getOwner(VCSFileProxy file) {
        VCSSystemProvider.VersioningSystem owner = VersioningManager.getInstance().getOwner(file);
        if (owner != null) {
            Object delegate = owner.getDelegate();
            if (delegate instanceof DelegatingVCS) {
                return ((DelegatingVCS)delegate).getDelegate();
            }
            if (delegate instanceof VersioningSystem) {
                return (VersioningSystem)delegate;
            }
        }
        return null;
    }

    public static boolean isFlat(VCSFileProxy file) {
        return APIAccessor.IMPL.isFlat(file);
    }

    public static void versionedRootsChanged() {
        VersioningManager.getInstance().versionedRootsChanged();
    }

    public static boolean isExcluded(VCSFileProxy folder) {
        if (folder.getPath().startsWith("\\\\")) {
            return folder.getParentFile() == null || folder.getParentFile().getPath().equals("\\\\");
        }
        for (String unversionedFolderPath : Utils.getUnversionedFolders()) {
            if (!Utils.isAncestorOrEqual(unversionedFolderPath, folder)) continue;
            return true;
        }
        return false;
    }

    public static ProcessBuilder createProcessBuilder(VCSFileProxy file) {
        return file.createProcessBuilder();
    }

    public static void refreshFor(VCSFileProxy[] files) {
        HashSet<File> fileList = new HashSet<File>();
        HashMap<VCSFileProxyOperations, HashSet<VCSFileProxy>> proxyMap = new HashMap<VCSFileProxyOperations, HashSet<VCSFileProxy>>();
        for (VCSFileProxy file : files) {
            File javaFile = file.toFile();
            if (javaFile != null) {
                fileList.add(javaFile);
                continue;
            }
            VCSFileProxyOperations fileProxyOperations = file.getFileProxyOperations();
            if (fileProxyOperations == null) continue;
            HashSet<VCSFileProxy> set = (HashSet<VCSFileProxy>)proxyMap.get(fileProxyOperations);
            if (set == null) {
                set = new HashSet<VCSFileProxy>();
                proxyMap.put(fileProxyOperations, set);
            }
            set.add(file);
        }
        if (fileList.size() > 0) {
            FileUtil.refreshFor((File[])fileList.toArray(new File[fileList.size()]));
        }
        for (Map.Entry e : proxyMap.entrySet()) {
            VCSFileProxyOperations fileProxyOperations = (VCSFileProxyOperations)e.getKey();
            fileProxyOperations.refreshFor(((Set)e.getValue()).toArray(new VCSFileProxy[fileList.size()]));
        }
    }
}

