/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.wizard;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.cnd.mixeddev.java.JNISupport;
import org.netbeans.modules.cnd.mixeddev.wizard.Generator;
import org.netbeans.modules.cnd.mixeddev.wizard.LocationJNIWizardPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class GenerateProjectAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        final FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
        BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    GenerateProjectAction.this.actionPerformedImpl(fo);
                } else {
                    Generator generator = new Generator(null, fo);
                    String validate = generator.validate();
                    if (validate == null) {
                        SwingUtilities.invokeLater(this);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)validate, 2));
                    }
                }
            }
        }, (String)NbBundle.getMessage(GenerateProjectAction.class, (String)"Generator_Validating"), (AtomicBoolean)new AtomicBoolean(), (boolean)false);
    }

    protected boolean enable(Node[] activatedNodes) {
        FileObject fo;
        if (activatedNodes.length == 1 && (fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class)) != null) {
            List<String> jniClasses = JNISupport.getJNIClassNames(fo);
            return jniClasses != null && !jniClasses.isEmpty();
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(GenerateProjectAction.class, (String)"Action.Name");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("MixedDevelopment");
    }

    public void actionPerformedImpl(FileObject fo) {
        ArrayList<LocationJNIWizardPanel> panels = new ArrayList<LocationJNIWizardPanel>();
        panels.add(new LocationJNIWizardPanel());
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            Component c = ((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", true);
            jc.putClientProperty("WizardPanel_contentDisplayed", true);
            jc.putClientProperty("WizardPanel_contentNumbered", true);
        }
        WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(panels));
        wiz.setTitleFormat(new MessageFormat("{0}"));
        wiz.setTitle(NbBundle.getMessage(GenerateProjectAction.class, (String)"Wizard.Name"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)wiz) == WizardDescriptor.FINISH_OPTION) {
            try {
                new Generator(wiz, fo).instantiate();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

