/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakSet;

public class MakeProjectClassPathProvider
implements ClassPathProvider {
    private static final Logger LOG = Logger.getLogger(MakeProjectClassPathProvider.class.getName());
    private static final Set<ClassPath> PROJECT_CPS = new WeakSet();
    private static final ReadWriteLock PROJECT_LOCK = new ReentrantReadWriteLock();

    public static void addProjectCP(final ClassPath[] cp) {
        MakeProjectClassPathProvider.runUnderWriteLock(new Runnable(){

            @Override
            public void run() {
                Collections.addAll(PROJECT_CPS, cp);
            }
        });
    }

    public static void removeProjectCP(final ClassPath[] cp) {
        MakeProjectClassPathProvider.runUnderWriteLock(new Runnable(){

            @Override
            public void run() {
                for (ClassPath classPath : cp) {
                    PROJECT_CPS.remove(classPath);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath findClassPath(FileObject file, String type) {
        if ("org.netbeans.modules.cnd.makeproject/SOURCES".equals(type)) {
            PROJECT_LOCK.readLock().lock();
            try {
                for (ClassPath spc : PROJECT_CPS) {
                    Project owner;
                    boolean accept = false;
                    if (spc.contains(file) && (owner = FileOwnerQuery.getOwner((FileObject)file)) instanceof MakeProject) {
                        accept = true;
                    }
                    if (!accept) continue;
                    LOG.log(Level.FINE, "findClassPath({0}, {1}) -> {2} from {3}", new Object[]{file, type, spc, MakeProjectClassPathProvider.class});
                    ClassPath classPath = spc;
                    return classPath;
                }
            }
            finally {
                PROJECT_LOCK.readLock().unlock();
            }
        }
        LOG.log(Level.FINE, "findClassPath({0}, {1}) -> null", new Object[]{file, type});
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runUnderWriteLock(Runnable runnable) {
        PROJECT_LOCK.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            PROJECT_LOCK.writeLock().unlock();
        }
    }
}

