/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.spi.project.NativeProjectRelocationMapperProvider;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public class NativeProjectRelocationMapperProviderImpl
implements NativeProjectRelocationMapperProvider {
    public static final String NAME = "path_mapper.properties";
    private static final String PROJECT_TAG = "project";
    private static final String SOURCE_NAME = "source_name";
    private static final String DESTINATION_NAME = "dest_name";
    private static final String SOURCE_ROOT = "source_root";
    private static final String DESTINATION_ROOT = "dest_root";
    private static final HashMap<FileObject, ProjectMapper> projectMappers = new HashMap();

    public CharSequence getDestinationPath(NativeProject project, CharSequence sourceFilePath) {
        if (!(project instanceof NativeProjectProvider)) {
            return null;
        }
        FileObject projectDir = CndFileUtils.toFileObject((FileSystem)project.getFileSystem(), (CharSequence)project.getProjectRoot());
        ProjectMapper projectMapper = NativeProjectRelocationMapperProviderImpl.get(projectDir);
        if (projectMapper == null || projectMapper.getDestinationFilePath(sourceFilePath) == null) {
            return sourceFilePath;
        }
        return projectMapper.getDestinationFilePath(sourceFilePath);
    }

    public CharSequence getSourceProjectName(NativeProject project) {
        if (!(project instanceof NativeProjectProvider)) {
            return null;
        }
        FileObject projectDir = CndFileUtils.toFileObject((FileSystem)project.getFileSystem(), (CharSequence)project.getProjectRoot());
        ProjectMapper projectMapper = NativeProjectRelocationMapperProviderImpl.get(projectDir);
        if (projectMapper == null || projectMapper.getSourceProjectName() == null) {
            return project.getProjectRoot();
        }
        return projectMapper.getSourceProjectName();
    }

    public NativeProject findDestinationProject(CharSequence sourceProjectName) {
        Collection openProjects = NativeProjectRegistry.getDefault().getOpenProjects();
        for (NativeProject project : openProjects) {
            CharSequence sourceProjectName1 = this.getSourceProjectName(project);
            if (sourceProjectName1 == null || !sourceProjectName1.equals(sourceProjectName)) continue;
            return project;
        }
        return null;
    }

    static synchronized ProjectMapper get(FileObject projectDir) {
        ProjectMapper mapper = projectMappers.get(projectDir);
        if (mapper == null) {
            mapper = ProjectMapper.create(projectDir);
            projectMappers.put(projectDir, mapper);
        }
        return mapper;
    }

    static class ProjectMapper {
        private CharSequence sourceProjectName;
        private CharSequence destinationProjectName;
        private final HashMap<CharSequence, CharSequence> sourceRoots = new HashMap();

        static ProjectMapper create(FileObject projectDir) {
            Properties properties = new Properties();
            FileObject nbProjectFolder = projectDir.getFileObject("nbproject");
            ProjectMapper mapper = new ProjectMapper();
            if (nbProjectFolder == null) {
                return mapper;
            }
            FileObject publicLaunchers = nbProjectFolder.getFileObject(NativeProjectRelocationMapperProviderImpl.NAME);
            FileObject privateNbFolder = projectDir.getFileObject("nbproject/private");
            FileObject privateLaunchers = null;
            if (privateNbFolder != null && privateNbFolder.isValid()) {
                privateLaunchers = privateNbFolder.getFileObject(NativeProjectRelocationMapperProviderImpl.NAME);
            }
            try {
                InputStream inputStream;
                if (publicLaunchers != null && publicLaunchers.isValid()) {
                    inputStream = publicLaunchers.getInputStream();
                    properties.load(inputStream);
                    inputStream.close();
                }
                if (privateLaunchers != null && privateLaunchers.isValid()) {
                    inputStream = privateLaunchers.getInputStream();
                    properties.load(inputStream);
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (properties.isEmpty()) {
                return mapper;
            }
            mapper.load(properties, projectDir);
            return mapper;
        }

        private ProjectMapper() {
        }

        void load(Properties properties, FileObject projectDir) {
            try {
                this.sourceRoots.clear();
                this.sourceProjectName = CharSequences.create((CharSequence)properties.getProperty("project.source_name"));
                String destName = properties.getProperty("project.dest_name");
                this.destinationProjectName = CharSequences.create((CharSequence)(destName == null ? CndFileUtils.getCanonicalPath((FileObject)projectDir) : destName));
                for (String key : properties.stringPropertyNames()) {
                    if (!key.matches("project\\d*[.]source_root")) continue;
                    String keyValue = key.substring(0, key.indexOf(".source_root"));
                    String sourceRoot = properties.getProperty(key);
                    String destRoot = properties.getProperty(keyValue + "." + NativeProjectRelocationMapperProviderImpl.DESTINATION_ROOT);
                    this.addMapping(CharSequences.create((CharSequence)sourceRoot), CharSequences.create((CharSequence)destRoot));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        CharSequence getSourceProjectName() {
            return this.sourceProjectName;
        }

        CharSequence getDestinationProjectName() {
            return this.destinationProjectName;
        }

        private void addMapping(CharSequence sourceRoot, CharSequence destRoot) {
            this.sourceRoots.put(sourceRoot, destRoot);
        }

        CharSequence getDestinationFilePath(CharSequence sourceFilePath) {
            Set<CharSequence> keySet = this.sourceRoots.keySet();
            for (CharSequence sourceRoot : keySet) {
                if (!CharSequenceUtils.startsWith((CharSequence)sourceFilePath, (CharSequence)sourceRoot)) continue;
                StringBuilder sb = new StringBuilder(this.sourceRoots.get(sourceRoot));
                sb.append(sourceFilePath.subSequence(sourceRoot.length(), sourceFilePath.length()));
                return sb;
            }
            return sourceFilePath;
        }
    }
}

