/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.MakeSharabilityQuery;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakeCustomizerProvider
implements CustomizerProvider {
    private final Project project;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final int OPTION_APPLY = 2;
    public static final String COMMAND_OK = "OK";
    public static final String COMMAND_CANCEL = "CANCEL";
    public static final String COMMAND_APPLY = "APPLY";
    private DialogDescriptor dialogDescriptor;
    private final Map<Project, Dialog> customizerPerProject = new WeakHashMap<Project, Dialog>();
    private final ConfigurationDescriptorProvider projectDescriptorProvider;
    private String currentCommand;
    private final Map<MakeContext.Kind, String> lastCurrentNodeName = new EnumMap<MakeContext.Kind, String>(MakeContext.Kind.class);
    private final Set<ActionListener> actionListenerList = new HashSet<ActionListener>();
    private static final RequestProcessor RP = new RequestProcessor("MakeCustomizerProvider", 1);
    private static final RequestProcessor RP_SAVE = new RequestProcessor("MakeCustomizerProviderSave", 1);

    public MakeCustomizerProvider(Project project, ConfigurationDescriptorProvider projectDescriptorProvider) {
        this.project = project;
        this.projectDescriptorProvider = projectDescriptorProvider;
    }

    public void showCustomizer() {
        this.showCustomizer(this.lastCurrentNodeName.get((Object)MakeContext.Kind.Project), null, null);
    }

    public void showCustomizer(Item item) {
        this.showCustomizer(this.lastCurrentNodeName.get((Object)MakeContext.Kind.Item), Arrays.asList(item), null);
    }

    public void showCustomizer(Folder folder) {
        this.showCustomizer(this.lastCurrentNodeName.get((Object)MakeContext.Kind.Folder), null, Arrays.asList(folder));
    }

    public void showCustomizer(String preselectedNodeName) {
        this.showCustomizer(preselectedNodeName, null, null);
    }

    public void showCustomizer(final String preselectedNodeName, final List<Item> items, final List<Folder> folders) {
        if (!this.projectDescriptorProvider.gotDescriptor() || this.projectDescriptorProvider.getConfigurationDescriptor().getConfs().size() == 0) {
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                MakeCustomizerProvider.this.showCustomizerWorker(preselectedNodeName, items, folders);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCustomizerWorker(String preselectedNodeName, List<Item> items, List<Folder> folders) {
        String dialogTitle;
        String name;
        StringBuilder sb;
        Dialog dlg;
        if (this.customizerPerProject.containsKey(this.project) && (dlg = this.customizerPerProject.get(this.project)).isShowing()) {
            dlg.setVisible(true);
            return;
        }
        if (folders != null) {
            for (Folder folder : folders) {
                if (folder == null) continue;
                Configuration[] configurations = this.projectDescriptorProvider.getConfigurationDescriptor().getConfs().toArray();
                for (int i = 0; i < configurations.length; ++i) {
                    folder.getFolderConfiguration(configurations[i]);
                }
            }
        }
        this.projectDescriptorProvider.getConfigurationDescriptor().refreshRequiredLanguages();
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Customizer_Cancel_Option")), new JButton(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Customizer_Apply_Option"))};
        options[0].setActionCommand(COMMAND_OK);
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"ACSD_Customizer_Ok_Option"));
        options[1].setActionCommand(COMMAND_CANCEL);
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"ACSD_Customizer_Cancel_Option"));
        options[2].setActionCommand(COMMAND_APPLY);
        options[2].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"ACSD_Customizer_Apply_Option"));
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"AD_MakeCustomizerProviderOk"));
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"AD_MakeCustomizerProviderCancel"));
        options[2].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"AD_MakeCustomizerProviderApply"));
        options[2].setMnemonic(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"MNE_Customizer_Apply_Option").charAt(0));
        ConfigurationDescriptor clonedProjectdescriptor = this.projectDescriptorProvider.getConfigurationDescriptor().cloneProjectDescriptor();
        ArrayList<JButton> controls = new ArrayList<JButton>();
        controls.add(options[0]);
        MakeCustomizer innerPane = new MakeCustomizer(this.project, preselectedNodeName, clonedProjectdescriptor, items, folders, Collections.unmodifiableCollection(controls));
        OptionListener optionsListener = new OptionListener(this.project, this.projectDescriptorProvider.getConfigurationDescriptor(), clonedProjectdescriptor, innerPane, folders, items);
        options[0].addActionListener(optionsListener);
        options[1].addActionListener(optionsListener);
        options[2].addActionListener(optionsListener);
        if (items != null && !items.isEmpty()) {
            sb = new StringBuilder();
            for (Item i : items) {
                sb.append(i.getName()).append(", ");
            }
            name = sb.toString().substring(0, sb.length() - 2);
            dialogTitle = NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_File_Customizer_Title", (Object)name);
        } else if (folders != null && !folders.isEmpty()) {
            sb = new StringBuilder();
            for (Folder f : folders) {
                sb.append(f.getName()).append(", ");
            }
            name = sb.toString().substring(0, sb.length() - 2);
            dialogTitle = NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Folder_Customizer_Title", (Object)name);
        } else {
            dialogTitle = NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Project_Customizer_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName());
        }
        this.dialogDescriptor = new DialogDescriptor((Object)innerPane, dialogTitle, true, options, (Object)options[0], 0, null, null);
        this.dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        innerPane.setDialogDescriptor(this.dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.customizerPerProject.put(this.project, dialog);
        this.currentCommand = COMMAND_CANCEL;
        try {
            dialog.setVisible(true);
        }
        catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
            this.dialogDescriptor.setValue(DialogDescriptor.CANCEL_OPTION);
        }
        finally {
            dialog.dispose();
        }
        MakeContext lastContext = innerPane.getLastContext();
        String nodeName = innerPane.getCurrentNodeName();
        if (lastContext != null) {
            this.lastCurrentNodeName.put(lastContext.getKind(), nodeName);
        }
        if (this.currentCommand.equals(COMMAND_CANCEL)) {
            this.fireActionEvent(new ActionEvent(this.project, 0, this.currentCommand));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener cl) {
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            this.actionListenerList.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener cl) {
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            this.actionListenerList.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionEvent(ActionEvent e) {
        Iterator<ActionListener> it;
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            it = new HashSet<ActionListener>(this.actionListenerList).iterator();
        }
        while (it.hasNext()) {
            it.next().actionPerformed(e);
        }
    }

    public String getLastCurrentNodeName(MakeContext.Kind kind) {
        return this.lastCurrentNodeName.get((Object)kind);
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeCustomizerProvider.class, (String)s);
    }

    private final class OptionListener
    implements ActionListener {
        private final Project project;
        private final ConfigurationDescriptor projectDescriptor;
        private final ConfigurationDescriptor clonedProjectdescriptor;
        private final MakeCustomizer makeCustomizer;
        private final List<Folder> folders;
        private final List<Item> items;

        OptionListener(Project project, ConfigurationDescriptor projectDescriptor, ConfigurationDescriptor clonedProjectdescriptor, MakeCustomizer makeCustomizer, List<Folder> folders, List<Item> items) {
            this.project = project;
            this.projectDescriptor = projectDescriptor;
            this.clonedProjectdescriptor = clonedProjectdescriptor;
            this.makeCustomizer = makeCustomizer;
            this.folders = folders;
            this.items = items;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MakeCustomizerProvider.this.currentCommand = e.getActionCommand();
            if (MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_OK) || MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_APPLY)) {
                this.makeCustomizer.save();
                RP_SAVE.post(new Runnable(){

                    @Override
                    public void run() {
                        int currentVersion;
                        int previousVersion = OptionListener.this.projectDescriptor.getVersion();
                        if (previousVersion < (currentVersion = 97)) {
                            boolean issueRequiredProjectBuildWarning = false;
                            if (previousVersion < 76) {
                                block0: for (Configuration configuration : OptionListener.this.projectDescriptor.getConfs().getConfigurations()) {
                                    MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
                                    if (!makeConfiguration.isMakefileConfiguration()) continue;
                                    List projectLinkItems = makeConfiguration.getRequiredProjectsConfiguration().getValue();
                                    for (LibraryItem.ProjectItem projectItem : projectLinkItems) {
                                        if (!projectItem.getMakeArtifact().getBuild()) continue;
                                        issueRequiredProjectBuildWarning = true;
                                        continue block0;
                                    }
                                }
                            }
                            String txt = issueRequiredProjectBuildWarning ? MakeCustomizerProvider.getString("UPGRADE_RQ_TXT") : MakeCustomizerProvider.getString("UPGRADE_TXT");
                            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)txt, MakeCustomizerProvider.getString("UPGRADE_DIALOG_TITLE"), 0);
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                                return;
                            }
                            OptionListener.this.projectDescriptor.setVersion(currentVersion);
                        }
                        ConfigurationDescriptorProvider.Delta delta = null;
                        if (OptionListener.this.folders == null && OptionListener.this.items == null) {
                            ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)OptionListener.this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                            delta = (ConfigurationDescriptorProvider.Delta)cdp.startModifications();
                        }
                        List<String> oldSourceRoots = ((MakeConfigurationDescriptor)OptionListener.this.projectDescriptor).getSourceRoots();
                        List<String> newSourceRoots = ((MakeConfigurationDescriptor)OptionListener.this.clonedProjectdescriptor).getSourceRoots();
                        List<String> oldTestRoots = ((MakeConfigurationDescriptor)OptionListener.this.projectDescriptor).getTestRoots();
                        List<String> newTestRoots = ((MakeConfigurationDescriptor)OptionListener.this.clonedProjectdescriptor).getTestRoots();
                        Configuration oldActive = OptionListener.this.projectDescriptor.getConfs().getActive();
                        if (oldActive != null) {
                            oldActive = oldActive.cloneConf();
                        }
                        Configuration[] oldConf = OptionListener.this.projectDescriptor.getConfs().toArray();
                        Configuration newActive = OptionListener.this.clonedProjectdescriptor.getConfs().getActive();
                        Configuration[] newConf = OptionListener.this.clonedProjectdescriptor.getConfs().toArray();
                        OptionListener.this.projectDescriptor.assign(OptionListener.this.clonedProjectdescriptor);
                        OptionListener.this.projectDescriptor.getConfs().fireChangedConfigurations(oldConf, newConf);
                        OptionListener.this.projectDescriptor.setModified();
                        OptionListener.this.projectDescriptor.save();
                        MakeSharabilityQuery query = (MakeSharabilityQuery)OptionListener.this.project.getLookup().lookup(MakeSharabilityQuery.class);
                        if (query != null) {
                            query.update();
                        }
                        if (OptionListener.this.folders == null && OptionListener.this.items == null) {
                            ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)OptionListener.this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                            cdp.endModifications(delta, true, null);
                        } else {
                            if (OptionListener.this.folders != null) {
                                for (Folder folder : OptionListener.this.folders) {
                                    ((MakeConfigurationDescriptor)OptionListener.this.projectDescriptor).checkForChangedItems(OptionListener.this.project, folder, null);
                                }
                            }
                            if (OptionListener.this.items != null) {
                                for (Item item : OptionListener.this.items) {
                                    ((MakeConfigurationDescriptor)OptionListener.this.projectDescriptor).checkForChangedItems(OptionListener.this.project, null, item);
                                }
                            }
                        }
                        ((MakeConfigurationDescriptor)OptionListener.this.projectDescriptor).checkForChangedSourceRoots(oldSourceRoots, newSourceRoots);
                        ((MakeConfigurationDescriptor)OptionListener.this.projectDescriptor).checkForChangedTestRoots(oldTestRoots, newTestRoots);
                        ((MakeConfigurationDescriptor)OptionListener.this.projectDescriptor).checkConfigurations(oldActive, newActive);
                    }
                });
            }
            if (!MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_CANCEL)) {
                MakeCustomizerProvider.this.fireActionEvent(new ActionEvent(this.project, 0, MakeCustomizerProvider.this.currentCommand));
            }
            if (MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_APPLY)) {
                this.makeCustomizer.refresh();
            }
        }
    }
}

