/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.List;
import java.util.Locale;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.LibrariesNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.VectorNodeProp;
import org.netbeans.modules.cnd.makeproject.platform.Platforms;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.ui.utils.TokenizerFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LinkerConfiguration
implements AllOptionsProvider,
Cloneable {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration output;
    private VectorConfiguration<String> additionalLibs;
    private VectorConfiguration<String> dynamicSearch;
    private BooleanConfiguration stripOption;
    private BooleanConfiguration picOption;
    private BooleanConfiguration norunpathOption;
    private BooleanConfiguration nameassignOption;
    private OptionsConfiguration commandLineConfiguration;
    private OptionsConfiguration additionalDependencies;
    private LibrariesConfiguration librariesConfiguration;
    private StringConfiguration tool;

    public LinkerConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.output = new StringConfiguration(null, "");
        this.additionalLibs = new VectorConfiguration(null);
        this.dynamicSearch = new VectorConfiguration(null);
        this.stripOption = new BooleanConfiguration(false);
        this.picOption = new BooleanConfiguration(true);
        this.norunpathOption = new BooleanConfiguration(true);
        this.nameassignOption = new BooleanConfiguration(true);
        this.commandLineConfiguration = new OptionsConfiguration();
        this.additionalDependencies = new OptionsConfiguration();
        this.additionalDependencies.setPreDefined(this.getAdditionalDependenciesPredefined());
        this.librariesConfiguration = new LibrariesConfiguration();
        this.tool = new StringConfiguration(null, "");
    }

    public boolean getModified() {
        return this.getOutput().getModified() || this.getAdditionalLibs().getModified() || this.getDynamicSearch().getModified() || this.getStripOption().getModified() || this.getPICOption().getModified() || this.getNorunpathOption().getModified() || this.getNameassignOption().getModified() || this.getAdditionalDependencies().getModified() || this.getTool().getModified() || this.getLibrariesConfiguration().getModified() || this.getCommandLineConfiguration().getModified();
    }

    private String getAdditionalDependenciesPredefined() {
        String pd = "${BUILD_SUBPROJECTS} ${OBJECTFILES}";
        return pd;
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setOutput(StringConfiguration output) {
        this.output = output;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public VectorConfiguration<String> getAdditionalLibs() {
        return this.additionalLibs;
    }

    public void setAdditionalLibs(VectorConfiguration<String> additionalLibs) {
        this.additionalLibs = additionalLibs;
    }

    public VectorConfiguration<String> getDynamicSearch() {
        return this.dynamicSearch;
    }

    public void setDynamicSearch(VectorConfiguration<String> dynamicSearch) {
        this.dynamicSearch = dynamicSearch;
    }

    public void setStripOption(BooleanConfiguration stripOption) {
        this.stripOption = stripOption;
    }

    public BooleanConfiguration getStripOption() {
        return this.stripOption;
    }

    public void setPICOption(BooleanConfiguration picOption) {
        this.picOption = picOption;
    }

    public BooleanConfiguration getPICOption() {
        return this.picOption;
    }

    public void setNorunpathOption(BooleanConfiguration norunpathOption) {
        this.norunpathOption = norunpathOption;
    }

    public BooleanConfiguration getNorunpathOption() {
        return this.norunpathOption;
    }

    public void setNameassignOption(BooleanConfiguration nameassignOption) {
        this.nameassignOption = nameassignOption;
    }

    public BooleanConfiguration getNameassignOption() {
        return this.nameassignOption;
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.commandLineConfiguration;
    }

    public void setCommandLineConfiguration(OptionsConfiguration commandLineConfiguration) {
        this.commandLineConfiguration = commandLineConfiguration;
    }

    public OptionsConfiguration getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public void setAdditionalDependencies(OptionsConfiguration additionalDependencies) {
        this.additionalDependencies = additionalDependencies;
    }

    public LibrariesConfiguration getLibrariesConfiguration() {
        return this.librariesConfiguration;
    }

    public void setLibrariesConfiguration(LibrariesConfiguration librariesConfiguration) {
        this.librariesConfiguration = librariesConfiguration;
    }

    public void setTool(StringConfiguration tool) {
        this.tool = tool;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void assign(LinkerConfiguration conf) {
        this.getOutput().assign(conf.getOutput());
        this.getAdditionalLibs().assign(conf.getAdditionalLibs());
        this.getDynamicSearch().assign(conf.getDynamicSearch());
        this.getCommandLineConfiguration().assign(conf.getCommandLineConfiguration());
        this.getAdditionalDependencies().assign(conf.getAdditionalDependencies());
        this.getStripOption().assign(conf.getStripOption());
        this.getPICOption().assign(conf.getPICOption());
        this.getNorunpathOption().assign(conf.getNorunpathOption());
        this.getNameassignOption().assign(conf.getNameassignOption());
        this.getLibrariesConfiguration().assign(conf.getLibrariesConfiguration());
        this.getTool().assign(conf.getTool());
    }

    public LinkerConfiguration clone() {
        LinkerConfiguration clone = new LinkerConfiguration(this.getMakeConfiguration());
        clone.setOutput(this.getOutput().clone());
        clone.setAdditionalLibs((VectorConfiguration<String>)this.getAdditionalLibs().clone());
        clone.setDynamicSearch((VectorConfiguration<String>)this.getDynamicSearch().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setStripOption(this.getStripOption().clone());
        clone.setPICOption(this.getPICOption().clone());
        clone.setNorunpathOption(this.getNorunpathOption().clone());
        clone.setNameassignOption(this.getNameassignOption().clone());
        clone.setLibrariesConfiguration(this.getLibrariesConfiguration().clone());
        clone.setTool(this.getTool().clone());
        return clone;
    }

    public String getOutputOptions() {
        String options = "";
        CompilerSet cs = this.getMakeConfiguration().getCompilerSet().getCompilerSet();
        if (cs != null) {
            options = options + cs.getCompilerFlavor().getToolchainDescriptor().getLinker().getOutputFileFlag() + this.getOutputValue() + " ";
        }
        return CppUtils.reformatWhitespaces(options);
    }

    public String getBasicOptions() {
        String options = "";
        CompilerSet cs = this.getMakeConfiguration().getCompilerSet().getCompilerSet();
        if (this.getMakeConfiguration().isDynamicLibraryConfiguration()) {
            String libName = this.getOutputValue();
            int sep = libName.lastIndexOf(47);
            if (sep >= 0 && libName.length() > 1) {
                libName = libName.substring(sep + 1);
            }
            if (cs != null) {
                options = options + cs.getCompilerFlavor().getToolchainDescriptor().getLinker().getDynamicLibraryBasicFlag();
                if (cs.getCompilerFlavor().isGnuCompiler() && this.getMakeConfiguration().getDevelopmentHost().getBuildPlatform() == 4) {
                    options = options + libName + " ";
                }
            }
        }
        if (cs != null && this.getStripOption().getValue()) {
            options = options + cs.getCompilerFlavor().getToolchainDescriptor().getLinker().getStripFlag() + " ";
        }
        if (this.getMakeConfiguration().isDynamicLibraryConfiguration() && cs != null) {
            if (this.getPICOption().getValue()) {
                options = options + this.getPICOption(cs);
            }
            if (cs.getCompilerFlavor().isSunStudioCompiler()) {
                if (this.getNorunpathOption().getValue()) {
                    options = options + "-norunpath ";
                }
                options = options + this.getNameassignOption(this.getNameassignOption().getValue()) + " ";
            }
        }
        return CppUtils.reformatWhitespaces(options);
    }

    public String getPICOption(CompilerSet cs) {
        ToolchainManager.LinkerDescriptor linker = cs.getCompilerFlavor().getToolchainDescriptor().getLinker();
        if (linker != null) {
            return linker.getPICFlag();
        }
        return null;
    }

    public String getLibraryItems() {
        ToolchainManager.LinkerDescriptor linker;
        CompilerSet cs = this.getMakeConfiguration().getCompilerSet().getCompilerSet();
        ToolchainManager.LinkerDescriptor linkerDescriptor = linker = cs == null ? null : cs.getCompilerFlavor().getToolchainDescriptor().getLinker();
        if (linker == null) {
            return "";
        }
        String options = "";
        CCCCompilerConfiguration.OptionToString staticSearchVisitor = new CCCCompilerConfiguration.OptionToString(cs, linker.getLibrarySearchFlag());
        options = options + this.getAdditionalLibs().toString(staticSearchVisitor) + " ";
        if (linker.getDynamicLibrarySearchFlag() != null && linker.getDynamicLibrarySearchFlag().length() > 0) {
            CCCCompilerConfiguration.OptionToString dynamicSearchVisitor = new CCCCompilerConfiguration.OptionToString(cs, linker.getDynamicLibrarySearchFlag());
            options = options + this.getDynamicSearch().toString(dynamicSearchVisitor) + " ";
        }
        LibraryToString libVisitor = new LibraryToString(this.getMakeConfiguration());
        options = options + this.getLibrariesConfiguration().toString(libVisitor) + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        String options = this.getOutputOptions() + " ";
        options = options + this.getLibraryItems() + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        options = options + this.getBasicOptions() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    public Sheet getGeneralSheet(Project project, MakeConfigurationDescriptor configurationDescriptor, MakeConfiguration conf, boolean isQtMode, boolean inheritablePropertiesOnly) {
        String[] texts;
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        ToolchainManager.LinkerDescriptor linker = null;
        String linkDriver = null;
        if (compilerSet != null) {
            linker = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker();
            if (conf.hasCPPFiles(configurationDescriptor)) {
                AbstractCompiler ccCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
                linkDriver = ccCompiler.getName();
            } else {
                AbstractCompiler cCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
                linkDriver = cCompiler.getName();
            }
        }
        Sheet.Set set1 = new Sheet.Set();
        set1.setName("General");
        set1.setDisplayName(LinkerConfiguration.getString("GeneralTxt"));
        set1.setShortDescription(LinkerConfiguration.getString("GeneralHint"));
        if (!isQtMode) {
            if (!inheritablePropertiesOnly) {
                set1.put((Node.Property)new OutputNodeProp(this.getOutput(), this.getOutputDefault(), "Output", LinkerConfiguration.getString("OutputTxt"), LinkerConfiguration.getString("OutputHint")));
            }
            set1.put((Node.Property)new VectorNodeProp(this.getAdditionalLibs(), null, this.getMakeConfiguration().getBaseFSPath(), new String[]{"AdditionalLibraryDirectories", LinkerConfiguration.getString("AdditionalLibraryDirectoriesTxt"), LinkerConfiguration.getString("AdditionalLibraryDirectoriesHint")}, true, true, new HelpCtx("AddtlLibraryDirectories")){

                @Override
                protected List<String> convertToList(String text) {
                    return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
                }

                @Override
                protected String convertToString(List<String> list) {
                    return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
                }
            });
        }
        if (linker != null && linker.getDynamicLibrarySearchFlag() != null && linker.getDynamicLibrarySearchFlag().length() > 0) {
            set1.put((Node.Property)new VectorNodeProp(this.getDynamicSearch(), null, this.getMakeConfiguration().getBaseFSPath(), new String[]{"RuntimeSearchDirectories", LinkerConfiguration.getString("RuntimeSearchDirectoriesTxt"), LinkerConfiguration.getString("RuntimeSearchDirectoriesHint")}, false, true, new HelpCtx("RuntimeSearchDirectories")){

                @Override
                protected List<String> convertToList(String text) {
                    return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
                }

                @Override
                protected String convertToString(List<String> list) {
                    return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
                }
            });
        }
        sheet.put(set1);
        if (!isQtMode) {
            Sheet.Set set2 = new Sheet.Set();
            if (!inheritablePropertiesOnly) {
                set2.setName("Options");
                set2.setDisplayName(LinkerConfiguration.getString("OptionsTxt"));
                set2.setShortDescription(LinkerConfiguration.getString("OptionsHint"));
                set2.put((Node.Property)new BooleanNodeProp(this.getStripOption(), true, "StripSymbols", LinkerConfiguration.getString("StripSymbolsTxt"), LinkerConfiguration.getString("StripSymbolsHint")));
                if (conf.isDynamicLibraryConfiguration()) {
                    set2.put((Node.Property)new BooleanNodeProp(this.getPICOption(), true, "PositionIndependantCode", LinkerConfiguration.getString("PositionIndependantCodeTxt"), LinkerConfiguration.getString("PositionIndependantCodeHint")));
                    if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
                        set2.put((Node.Property)new BooleanNodeProp(this.getNorunpathOption(), true, "NoRunPath", LinkerConfiguration.getString("NoRunPathTxt"), LinkerConfiguration.getString("NoRunPathHint")));
                        set2.put((Node.Property)new BooleanNodeProp(this.getNameassignOption(), true, "AssignName", LinkerConfiguration.getString("AssignNameTxt"), LinkerConfiguration.getString("AssignNameHint")));
                    }
                }
                sheet.put(set2);
            }
            Sheet.Set set3 = new Sheet.Set();
            texts = new String[]{LinkerConfiguration.getString("AdditionalDependenciesTxt1"), LinkerConfiguration.getString("AdditionalDependenciesHint"), LinkerConfiguration.getString("AdditionalDependenciesTxt2"), LinkerConfiguration.getString("InheritedValuesTxt")};
            set3.setName("Input");
            set3.setDisplayName(LinkerConfiguration.getString("InputTxt"));
            set3.setShortDescription(LinkerConfiguration.getString("InputHint"));
            set3.put((Node.Property)new OptionsNodeProp(this.getAdditionalDependencies(), null, new AdditionalDependenciesOptions(), null, ",", texts));
            sheet.put(set3);
            Sheet.Set set4 = new Sheet.Set();
            if (!inheritablePropertiesOnly) {
                set4.setName("Tool");
                set4.setDisplayName(LinkerConfiguration.getString("ToolTxt1"));
                set4.setShortDescription(LinkerConfiguration.getString("ToolHint1"));
                if (linkDriver != null) {
                    set4.put((Node.Property)new StringNodeProp(this.getTool(), linkDriver, "Tool", LinkerConfiguration.getString("ToolTxt1"), LinkerConfiguration.getString("ToolHint1")));
                }
                sheet.put(set4);
            }
        }
        texts = new String[]{LinkerConfiguration.getString("LibrariesTxt1"), LinkerConfiguration.getString("LibrariesHint"), LinkerConfiguration.getString("LibrariesTxt2"), LinkerConfiguration.getString("AllOptionsTxt2")};
        Sheet.Set set5 = new Sheet.Set();
        set5.setName("Libraries");
        set5.setDisplayName(LinkerConfiguration.getString("LibrariesTxt1"));
        set5.setShortDescription(LinkerConfiguration.getString("LibrariesHint"));
        set5.put((Node.Property)new LibrariesNodeProp(this.getLibrariesConfiguration(), project, conf, this.getMakeConfiguration().getBaseFSPath(), texts));
        sheet.put(set5);
        if (!isQtMode) {
            texts = new String[]{LinkerConfiguration.getString("AdditionalOptionsTxt1"), LinkerConfiguration.getString("AdditionalOptionsHint"), LinkerConfiguration.getString("AdditionalOptionsTxt2"), LinkerConfiguration.getString("AllOptionsTxt")};
            Sheet.Set set6 = new Sheet.Set();
            set6.setName("CommandLine");
            set6.setDisplayName(LinkerConfiguration.getString("CommandLineTxt"));
            set6.setShortDescription(LinkerConfiguration.getString("CommandLineHint"));
            set6.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, null, null, texts));
            sheet.put(set6);
        }
        return sheet;
    }

    private String getNameassignOption(boolean val) {
        if (val) {
            return "-h " + CndPathUtilities.getBaseName((String)this.getOutputValue());
        }
        return "";
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    private String getOutputDefault() {
        String outputName = CndPathUtilities.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        switch (this.getMakeConfiguration().getConfigurationType().getValue()) {
            case 1: 
            case 7: {
                outputName = outputName.toLowerCase(Locale.getDefault());
                break;
            }
            case 2: 
            case 10: {
                outputName = Platforms.getPlatform(this.getMakeConfiguration().getDevelopmentHost().getBuildPlatform()).getLibraryNameWithoutExtension(outputName);
            }
        }
        outputName = ConfigurationSupport.makeNameLegal(outputName);
        if (this.getMakeConfiguration().isDynamicLibraryConfiguration()) {
            return "${CND_DISTDIR}/${CND_CONF}/${CND_PLATFORM}/" + outputName + "." + "${CND_DLIB_EXT}";
        }
        return "${CND_DISTDIR}/${CND_CONF}/${CND_PLATFORM}/" + outputName;
    }

    public String getOutputDefault27() {
        String outputName = CndPathUtilities.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 1 || this.getMakeConfiguration().getConfigurationType().getValue() == 7) {
            outputName = outputName.toLowerCase(Locale.getDefault());
        } else if (this.getMakeConfiguration().isDynamicLibraryConfiguration()) {
            outputName = "lib" + outputName + ".so";
        }
        return "dist/" + this.getMakeConfiguration().getName() + "/" + outputName;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(LinkerConfiguration.class, (String)s);
    }

    public String toString() {
        return "{output=" + this.output + " additionalLibs=" + this.additionalLibs + " dynamicSearch=" + this.dynamicSearch + " stripOption=" + this.stripOption + " picOption=" + this.picOption + " norunpathOption=" + this.norunpathOption + " nameassignOption=" + this.nameassignOption + " commandLineConfiguration=" + this.commandLineConfiguration + " additionalDependencies=" + this.additionalDependencies + " librariesConfiguration=" + this.librariesConfiguration + " tool=" + this.tool + '}';
    }

    public static class LibraryToString
    implements VectorConfiguration.ToString<LibraryItem> {
        private final MakeConfiguration conf;

        public LibraryToString(MakeConfiguration conf) {
            this.conf = conf;
        }

        @Override
        public String toString(LibraryItem item) {
            return item.getOption(this.conf);
        }
    }

    private static class OutputNodeProp
    extends StringNodeProp {
        public OutputNodeProp(StringConfiguration stringConfiguration, String def, String txt1, String txt2, String txt3) {
            super(stringConfiguration, def, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            if (CndPathUtilities.hasMakeSpecialCharacters((String)v)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)LinkerConfiguration.getString("SPECIAL_CHARATERS_ERROR"), 0));
                return;
            }
            super.setValue(v);
        }
    }

    private final class AdditionalDependenciesOptions
    implements AllOptionsProvider {
        private AdditionalDependenciesOptions() {
        }

        @Override
        public String getAllOptions(Tool tool) {
            String options = "";
            options = options + LinkerConfiguration.this.additionalDependencies.getPreDefined();
            return CppUtils.reformatWhitespaces(options);
        }
    }
}

