/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.MacroExpandedEditorPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PreBuildConfiguration
implements Cloneable {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration preBuildCommandWorkingDir;
    private StringConfiguration preBuildCommand;
    private BooleanConfiguration preBuildFirst;
    private static final RequestProcessor RP = new RequestProcessor("MakeConfiguration", 1);
    private static ResourceBundle bundle;

    public PreBuildConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.preBuildCommandWorkingDir = new StringConfiguration(null, ".");
        this.preBuildCommand = new StringConfiguration(null, "");
        this.preBuildFirst = new BooleanConfiguration(false);
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setPreBuildFirst(BooleanConfiguration preBuildFirst) {
        this.preBuildFirst = preBuildFirst;
    }

    public BooleanConfiguration getPreBuildFirst() {
        return this.preBuildFirst;
    }

    public StringConfiguration getPreBuildCommandWorkingDir() {
        return this.preBuildCommandWorkingDir;
    }

    public String getPreBuildCommandWorkingDirValue() {
        if (this.preBuildCommandWorkingDir.getValue().length() == 0) {
            return ".";
        }
        return this.preBuildCommandWorkingDir.getValue();
    }

    public void setPreBuildCommandWorkingDir(StringConfiguration buildCommandWorkingDir) {
        this.preBuildCommandWorkingDir = buildCommandWorkingDir;
    }

    public StringConfiguration getPreBuildCommand() {
        return this.preBuildCommand;
    }

    public void setPreBuildCommand(StringConfiguration buildCommand) {
        this.preBuildCommand = buildCommand;
    }

    public FileObject getAbsPreBuildCommandFileObject() {
        String path = this.getAbsPreBuildCommandWorkingDir();
        return FileSystemProvider.getFileObject((ExecutionEnvironment)this.getSourceExecutionEnvironment(), (String)path);
    }

    public String getAbsPreBuildCommandWorkingDir() {
        String wd = this.getPreBuildCommandWorkingDirValue().length() > 0 && CndPathUtilities.isPathAbsolute((CharSequence)this.getPreBuildCommandWorkingDirValue()) ? this.getPreBuildCommandWorkingDirValue() : this.getMakeConfiguration().getBaseDir() + "/" + this.getPreBuildCommandWorkingDirValue();
        wd = FileSystemProvider.normalizeAbsolutePath((String)wd, (ExecutionEnvironment)this.getSourceExecutionEnvironment());
        return wd;
    }

    public void assign(PreBuildConfiguration conf) {
        this.getPreBuildCommandWorkingDir().assign(conf.getPreBuildCommandWorkingDir());
        this.getPreBuildCommand().assign(conf.getPreBuildCommand());
        this.getPreBuildFirst().assign(conf.getPreBuildFirst());
    }

    public PreBuildConfiguration clone() {
        PreBuildConfiguration clone = new PreBuildConfiguration(this.getMakeConfiguration());
        clone.setPreBuildCommandWorkingDir(this.getPreBuildCommandWorkingDir().clone());
        clone.setPreBuildCommand(this.getPreBuildCommand().clone());
        clone.setPreBuildFirst(this.getPreBuildFirst().clone());
        return clone;
    }

    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("PreBuild");
        set.setDisplayName(PreBuildConfiguration.getString("PreBuildTxt"));
        set.setShortDescription(PreBuildConfiguration.getString("PreBuildHint"));
        set.put((Node.Property)new DirStringNodeProp(this.getPreBuildCommandWorkingDir(), "PreBuildWorkingDirectory", PreBuildConfiguration.getString("PreBuildWorkingDirectory_LBL"), PreBuildConfiguration.getString("PreBuildWorkingDirectory_TT")));
        set.put((Node.Property)new PreviewStringNodeProp(this.getPreBuildCommand(), "PreBuildCommandLine", PreBuildConfiguration.getString("PreBuildCommandLine_LBL"), PreBuildConfiguration.getString("PreBuildCommandLine_TT")));
        set.put((Node.Property)new BooleanNodeProp(this.getPreBuildFirst(), true, "PreBuildFirst", PreBuildConfiguration.getString("PreBuildFirst_LBL"), PreBuildConfiguration.getString("PreBuildFirst_TT")));
        sheet.put(set);
        return sheet;
    }

    private ExecutionEnvironment getSourceExecutionEnvironment() {
        ExecutionEnvironment env = null;
        MakeConfiguration mc = this.getMakeConfiguration();
        if (mc != null) {
            return FileSystemProvider.getExecutionEnvironment((FileSystem)mc.getBaseFSPath().getFileSystem());
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.getLocal();
        }
        return env;
    }

    private JFileChooser createDirPanel(String seed, final PropertyEditorSupport editor, PropertyEnv propenv) {
        String titleText = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("Run_Directory");
        String buttonText = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("SelectLabel");
        final JFileChooser chooser = RemoteFileUtil.createFileChooser((ExecutionEnvironment)this.getSourceExecutionEnvironment(), (String)titleText, (String)buttonText, (int)1, null, (String)seed, (boolean)true);
        chooser.putClientProperty("title", chooser.getDialogTitle());
        chooser.setControlButtonsAreShown(false);
        propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propenv.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
                    File selectedFile = chooser.getSelectedFile();
                    String path = CndPathUtilities.toRelativePath((String)PreBuildConfiguration.this.makeConfiguration.getBaseDir(), (String)selectedFile.getPath());
                    path = CndPathUtilities.normalizeSlashes((String)path);
                    editor.setValue(path);
                }
            }
        });
        return chooser;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PreBuildConfiguration.class);
        }
        return bundle.getString(s);
    }

    private static class PreviewCommandLinePropEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv env;
        private final Map<String, String> macros;

        private PreviewCommandLinePropEditor(Map<String, String> macros) {
            this.macros = macros;
        }

        @Override
        public Component getCustomEditor() {
            MacroExpandedEditorPanel commandLineEditorPanel = new MacroExpandedEditorPanel(this, this.env, this.macros);
            return commandLineEditorPanel;
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
    }

    private final class PreviewStringNodeProp
    extends StringNodeProp {
        private PreviewStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3) {
            super(stringConfiguration, txt1, txt2, txt3);
        }

        public PropertyEditor getPropertyEditor() {
            HashMap<String, String> macros = new HashMap<String, String>();
            CompilerSet cs = PreBuildConfiguration.this.makeConfiguration.getCompilerSet().getCompilerSet();
            if (cs != null) {
                Tool tool = cs.getTool((ToolKind)PredefinedToolKind.CCompiler);
                if (tool != null) {
                    macros.put("${IDE_CC}", tool.getPath());
                }
                if ((tool = cs.getTool((ToolKind)PredefinedToolKind.CCCompiler)) != null) {
                    macros.put("${IDE_CXX}", tool.getPath());
                }
            }
            return new PreviewCommandLinePropEditor(macros);
        }
    }

    private class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private final String seed;

        public DirEditor(String seed) {
            this.seed = seed;
        }

        @Override
        public void setAsText(String text) {
            PreBuildConfiguration.this.getPreBuildCommandWorkingDir().setValue(text);
        }

        @Override
        public String getAsText() {
            return PreBuildConfiguration.this.getPreBuildCommandWorkingDir().getValue();
        }

        @Override
        public Object getValue() {
            return PreBuildConfiguration.this.getPreBuildCommandWorkingDir().getValue();
        }

        @Override
        public void setValue(Object v) {
            PreBuildConfiguration.this.getPreBuildCommandWorkingDir().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return PreBuildConfiguration.this.createDirPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private class DirStringNodeProp
    extends StringNodeProp {
        public DirStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3) {
            super(stringConfiguration, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilities.toRelativePath((String)PreBuildConfiguration.this.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilities.normalizeSlashes((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            return new DirEditor(PreBuildConfiguration.this.getAbsPreBuildCommandWorkingDir());
        }
    }
}

