/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations.ui;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ComboStringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.StringPanel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class ComboStringNodeProp
extends Node.Property {
    private final ComboStringConfiguration comboStringConfiguration;
    private final String name;
    private final String description;
    private final boolean canWrite;
    StringEditor intEditor = null;

    public ComboStringNodeProp(ComboStringConfiguration comboStringConfiguration, boolean canWrite, String name, String description) {
        super(String.class);
        this.comboStringConfiguration = comboStringConfiguration;
        this.canWrite = canWrite;
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.description;
    }

    public String getHtmlDisplayName() {
        if (this.comboStringConfiguration.getModified()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public Object getValue() {
        return this.comboStringConfiguration.getValue();
    }

    public void setValue(Object v) {
        this.comboStringConfiguration.setValue((String)v);
        this.comboStringConfiguration.getPicklist().addElement((String)v);
    }

    public void restoreDefaultValue() {
        this.comboStringConfiguration.reset();
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return !this.comboStringConfiguration.getModified();
    }

    public boolean canWrite() {
        return true;
    }

    public boolean canRead() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.intEditor == null) {
            this.intEditor = new StringEditor();
        }
        return this.intEditor;
    }

    protected class StringEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv env;

        protected StringEditor() {
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
            env.getFeatureDescriptor().setValue("canEditAsText", Boolean.TRUE);
        }

        @Override
        public String getJavaInitializationString() {
            return this.getAsText();
        }

        @Override
        public String getAsText() {
            return ComboStringNodeProp.this.comboStringConfiguration.getValue();
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            super.setValue(text);
        }

        @Override
        public String[] getTags() {
            return ComboStringNodeProp.this.comboStringConfiguration.getPicklist().getElementsDisplayName();
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return new StringPanel(this, this.env);
        }
    }
}

