/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.SmartOutputStream;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectCustomizer;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DefaultMakefileWriter;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationWarningPanel;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.QmakeProjectWriter;
import org.netbeans.modules.cnd.makeproject.packaging.DummyPackager;
import org.netbeans.modules.cnd.makeproject.platform.Platform;
import org.netbeans.modules.cnd.makeproject.platform.Platforms;
import org.netbeans.modules.cnd.makeproject.spi.DatabaseProjectProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.MakefileWriter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ConfigurationMakefileWriter {
    private final MakeConfigurationDescriptor projectDescriptor;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");

    public ConfigurationMakefileWriter(MakeConfigurationDescriptor projectDescriptor) {
        this.projectDescriptor = projectDescriptor;
    }

    public void write() throws IOException {
        Collection<MakeConfiguration> okConfs = this.getOKConfigurations(false);
        this.cleanup();
        if (this.isMakefileProject()) {
            for (MakeConfiguration conf : okConfs) {
                this.writePackagingScript(conf);
            }
        } else {
            this.writeMakefileImpl();
            for (MakeConfiguration conf : okConfs) {
                this.writeMakefileConf(conf);
                this.writePackagingScript(conf);
            }
            this.writeMakefileVariables(this.projectDescriptor, okConfs);
        }
    }

    private boolean isMakefileProject() {
        for (Configuration conf : this.projectDescriptor.getConfs().getConfigurations()) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)conf;
            if (!makeConfiguration.isMakefileConfiguration()) continue;
            return true;
        }
        return false;
    }

    private String getMakefileName(Configuration conf) {
        return "Makefile-" + conf.getName() + ".mk";
    }

    private String getPackageScriptName(Configuration conf) {
        return "Package-" + conf.getName() + ".bash";
    }

    private Collection<MakeConfiguration> getOKConfigurations(boolean showWarning) {
        ArrayList<MakeConfiguration> ok = new ArrayList<MakeConfiguration>();
        ArrayList<MakeConfiguration> noCompilerSet = new ArrayList<MakeConfiguration>();
        ArrayList<MakeConfiguration> wrongPlatform = new ArrayList<MakeConfiguration>();
        Configuration[] confs = this.projectDescriptor.getConfs().toArray();
        for (int i = 0; i < confs.length; ++i) {
            MakeConfiguration conf = (MakeConfiguration)confs[i];
            if (conf.getDevelopmentHost().isLocalhost() && CompilerSetManager.get((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).getPlatform() != conf.getDevelopmentHost().getBuildPlatformConfiguration().getValue()) {
                wrongPlatform.add(conf);
                continue;
            }
            if (conf.getCompilerSet().getCompilerSet() == null) {
                noCompilerSet.add(conf);
                continue;
            }
            ok.add(conf);
        }
        if (!wrongPlatform.isEmpty() && showWarning && MakeOptions.getInstance().getShowConfigurationWarning()) {
            ExecutionEnvironment execEnv = ExecutionEnvironmentFactory.fromUniqueID((String)"localhost");
            int platformID = CompilerSetManager.get((ExecutionEnvironment)execEnv).getPlatform();
            Platform platform = Platforms.getPlatform(platformID);
            StringBuilder list = new StringBuilder();
            for (MakeConfiguration c : wrongPlatform) {
                list.append(ConfigurationMakefileWriter.getString("CONF", c.getName(), c.getDevelopmentHost().getBuildPlatformConfiguration().getName())).append("\n");
            }
            final String msg = ConfigurationMakefileWriter.getString("TARGET_MISMATCH_TXT", platform.getDisplayName(), list.toString());
            final String title = ConfigurationMakefileWriter.getString("TARGET_MISMATCH_DIALOG_TITLE.TXT");
            if (CndUtils.isUnitTestMode() || CndUtils.isStandalone()) {
                new Exception(msg).printStackTrace(System.err);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object[] options = new Object[]{NotifyDescriptor.OK_OPTION};
                        DialogDescriptor nd = new DialogDescriptor((Object)new ConfigurationWarningPanel(msg), title, true, options, NotifyDescriptor.OK_OPTION, 0, null, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                });
            }
        }
        return ok;
    }

    private void cleanup() throws IOException {
        FileObject folder = this.projectDescriptor.getBaseDirFileObject().getFileObject("nbproject");
        if (folder != null && folder.isValid()) {
            IOException lastException = null;
            FileObject[] children = folder.getChildren();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    String filename = children[i].getNameExt();
                    if (filename.equals("Makefile-impl.mk") || filename.equals("Makefile-variables.mk") || !filename.startsWith("Makefile-") && !filename.startsWith("Package-")) continue;
                    boolean known = false;
                    for (Configuration conf : this.projectDescriptor.getConfs().toArray()) {
                        if (!filename.equals(this.getMakefileName(conf)) && !filename.equals(this.getPackageScriptName(conf))) continue;
                        known = true;
                        break;
                    }
                    if (known) continue;
                    try {
                        children[i].delete();
                        continue;
                    }
                    catch (IOException ex) {
                        lastException = ex;
                    }
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMakefileImpl() throws IOException {
        InputStream is;
        String resource = "/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile-impl.mk";
        OutputStream os = null;
        try {
            URL url = new URL("nbresloc:" + resource);
            is = url.openStream();
        }
        catch (Exception e) {
            is = MakeConfigurationDescriptor.class.getResourceAsStream(resource);
        }
        if (is == null) {
            return;
        }
        FileObject masterMF = null;
        try {
            FileObject nbprojectFileObject = this.projectDescriptor.getNbprojectFileObject();
            if (nbprojectFileObject == null) {
                return;
            }
            masterMF = FileUtil.createData((FileObject)nbprojectFileObject, (String)"Makefile-impl.mk");
            os = SmartOutputStream.getSmartOutputStream(masterMF);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        if (os == null) {
            this.closeInputStream(is);
            return;
        }
        Charset encoding = FileEncodingQuery.getEncoding(masterMF);
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, encoding));
        String projectName = CndPathUtilities.getBaseName((String)this.projectDescriptor.getProjectDir());
        StringBuilder configurations = new StringBuilder();
        for (int i = 0; i < this.projectDescriptor.getConfs().toArray().length; ++i) {
            configurations.append(this.projectDescriptor.getConfs().toArray()[i].getName());
            configurations.append(" ");
        }
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.contains("<PN>")) {
                    line = line.replaceFirst("<PN>", projectName);
                } else if (line.contains("<CNS>")) {
                    line = line.replaceFirst("<CNS>", configurations.toString());
                } else if (line.contains("<CN>")) {
                    line = this.projectDescriptor.getConfs().getConf(0) != null ? line.replaceFirst("<CN>", this.projectDescriptor.getConfs().getConf(0).getName()) : line.replaceFirst("<CN>", "");
                }
                bw.write(line + "\n");
            }
        }
        finally {
            this.closeReader(br);
            this.closeWriter(bw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMakefileConf(MakeConfiguration conf) throws IOException {
        FileObject nbProjFO;
        MakeProjectCustomizer makeProjectCustomizer;
        String makefileWriterClassName;
        String makefileWriterClassName2;
        MakefileWriter makefileWriter = null;
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        if (compilerSet != null && (makefileWriterClassName2 = compilerSet.getCompilerFlavor().getToolchainDescriptor().getMakefileWriter()) != null) {
            Collection mwc = Lookup.getDefault().lookupAll(MakefileWriter.class);
            for (MakefileWriter instance : mwc) {
                if (!makefileWriterClassName2.equals(instance.getClass().getName())) continue;
                makefileWriter = instance;
                break;
            }
            if (makefileWriter == null) {
                System.err.println("ERROR: class" + makefileWriterClassName2 + " is not found or is not instance of MakefileWriter");
            }
        }
        if (conf.isCustomConfiguration() && conf.getProjectCustomizer().getMakefileWriter() != null && (makefileWriterClassName = (makeProjectCustomizer = conf.getProjectCustomizer()).getMakefileWriter()) != null) {
            Collection mwc = Lookup.getDefault().lookupAll(MakefileWriter.class);
            for (MakefileWriter instance : mwc) {
                if (!makefileWriterClassName.equals(instance.getClass().getName())) continue;
                makefileWriter = instance;
                break;
            }
            if (makefileWriter == null) {
                System.err.println("ERROR: class" + makefileWriterClassName + " is not found or is not instance of MakefileWriter");
            }
        }
        if (makefileWriter == null) {
            makefileWriter = new DefaultMakefileWriter();
        }
        if ((nbProjFO = this.projectDescriptor.getNbprojectFileObject()) == null) {
            LOGGER.info("Error writing makefiles: can not find nbproject");
            return;
        }
        FileObject makefileFO = FileUtil.createData((FileObject)nbProjFO, (String)this.getMakefileName(conf));
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)makefileFO);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(SmartOutputStream.getSmartOutputStream(makefileFO), encoding));
        try {
            makefileWriter.writePrelude(this.projectDescriptor, conf, bw);
            this.writeBuildTargets(makefileWriter, this.projectDescriptor, conf, bw);
            this.writeBuildTestTargets(makefileWriter, this.projectDescriptor, conf, bw);
            makefileWriter.writeRunTestTarget(this.projectDescriptor, conf, bw);
            makefileWriter.writeCleanTarget(this.projectDescriptor, conf, bw);
            if (conf.getDependencyChecking().getValue() && !conf.isMakefileConfiguration() && !conf.isQmakeConfiguration() && conf.getCompilerSet().getCompilerSet() != null) {
                makefileWriter.writeDependencyChecking(this.projectDescriptor, conf, bw);
            }
        }
        finally {
            this.closeWriter(bw);
        }
        if (conf.isQmakeConfiguration()) {
            new QmakeProjectWriter(this.projectDescriptor, conf).write();
        }
    }

    public static String getCompilerName(MakeConfiguration conf, PredefinedToolKind tool) {
        Tool compiler;
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        if (compilerSet != null && (compiler = compilerSet.getTool((ToolKind)tool)) != null) {
            String[] names;
            BasicCompilerConfiguration compilerConf = null;
            switch (tool) {
                case CCompiler: {
                    compilerConf = conf.getCCompilerConfiguration();
                    break;
                }
                case CCCompiler: {
                    compilerConf = conf.getCCCompilerConfiguration();
                    break;
                }
                case FortranCompiler: {
                    compilerConf = conf.getFortranCompilerConfiguration();
                    break;
                }
                case Assembler: {
                    compilerConf = conf.getAssemblerConfiguration();
                }
            }
            if (compilerConf != null && compilerConf.getTool().getModified()) {
                return compilerConf.getTool().getValue();
            }
            if (compiler.getName().length() > 0) {
                return compiler.getName();
            }
            if (compiler.getDescriptor() != null && (names = compiler.getDescriptor().getNames()) != null && names.length > 0) {
                return names[0];
            }
        }
        return "";
    }

    public static void writePrelude(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return;
        }
        AbstractCompiler cCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
        AbstractCompiler ccCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
        AbstractCompiler fortranCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.FortranCompiler);
        AbstractCompiler assemblerCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.Assembler);
        bw.write("#\n");
        bw.write("# Generated Makefile - do not edit!\n");
        bw.write("#\n");
        bw.write("# Edit the Makefile in the project folder instead (../Makefile). Each target\n");
        bw.write("# has a -pre and a -post target defined where you can add customized code.\n");
        bw.write("#\n");
        bw.write("# This makefile implements configuration specific macros and targets.\n");
        bw.write("\n");
        bw.write("\n");
        bw.write("# Environment\n");
        bw.write("MKDIR=mkdir\n");
        bw.write("CP=cp\n");
        bw.write("GREP=grep\n");
        bw.write("NM=nm\n");
        bw.write("CCADMIN=CCadmin\n");
        bw.write("RANLIB=" + conf.getArchiverConfiguration().getRanlibTool().getValue() + "\n");
        bw.write("CC=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.CCompiler) + "\n");
        bw.write("CCC=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.CCCompiler) + "\n");
        bw.write("CXX=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.CCCompiler) + "\n");
        bw.write("FC=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.FortranCompiler) + "\n");
        bw.write("AS=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.Assembler) + "\n");
        DatabaseProjectProvider provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class);
        if (provider != null) {
            provider.writePrelude(projectDescriptor, conf, bw);
        }
        if (conf.getArchiverConfiguration().getTool().getModified()) {
            bw.write("AR=" + conf.getArchiverConfiguration().getTool().getValue() + "\n");
        }
        if (conf.isQmakeConfiguration()) {
            bw.write("QMAKE=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.QMakeTool) + "\n");
        }
        bw.write("\n");
        bw.write("# Macros\n");
        bw.write("CND_PLATFORM=" + conf.getVariant() + "\n");
        bw.write("CND_DLIB_EXT=" + conf.getLibraryExtension() + "\n");
        bw.write("CND_CONF=" + conf.getName() + "\n");
        bw.write("CND_DISTDIR=dist\n");
        bw.write("CND_BUILDDIR=build\n");
        bw.write("\n");
        if (!projectDescriptor.getProjectMakefileName().isEmpty()) {
            bw.write("# Include project Makefile\n");
            bw.write("include " + projectDescriptor.getProjectMakefileName() + "\n");
            bw.write("\n");
        }
        bw.write("# Object Directory\n");
        bw.write("OBJECTDIR=" + ConfigurationMakefileWriter.getObjectDir(conf) + "\n");
        bw.write("\n");
        bw.write("# Object Files\n");
        bw.write("OBJECTFILES=" + ConfigurationMakefileWriter.getObjectFiles(projectDescriptor, conf) + "\n");
        bw.write("\n");
        if (ConfigurationMakefileWriter.hasTests(projectDescriptor)) {
            bw.write("# Test Directory\n");
            bw.write("TESTDIR=" + ConfigurationMakefileWriter.getObjectDir(conf) + "/tests\n");
            bw.write("\n");
            bw.write("# Test Files\n");
            bw.write("TESTFILES=" + ConfigurationMakefileWriter.getTestTargetFiles(projectDescriptor, conf) + "\n");
            bw.write("\n");
            bw.write("# Test Object Files\n");
            bw.write("TESTOBJECTFILES=" + ConfigurationMakefileWriter.getTestObjectFiles(projectDescriptor, conf) + "\n");
        }
        bw.write("\n");
        if (cCompiler != null) {
            bw.write("# C Compiler Flags\n");
            bw.write("CFLAGS=" + conf.getCCompilerConfiguration().getCFlags(cCompiler) + "\n");
            bw.write("\n");
        }
        if (ccCompiler != null) {
            bw.write("# CC Compiler Flags\n");
            bw.write("CCFLAGS=" + conf.getCCCompilerConfiguration().getCCFlags(ccCompiler) + "\n");
            bw.write("CXXFLAGS=" + conf.getCCCompilerConfiguration().getCCFlags(ccCompiler) + "\n");
            bw.write("\n");
        }
        if (fortranCompiler != null) {
            bw.write("# Fortran Compiler Flags\n");
            bw.write("FFLAGS=" + conf.getFortranCompilerConfiguration().getFFlags(fortranCompiler) + "\n");
            bw.write("\n");
        }
        if (assemblerCompiler != null) {
            bw.write("# Assembler Flags\n");
            bw.write("ASFLAGS=" + conf.getAssemblerConfiguration().getAsFlags(assemblerCompiler) + "\n");
            bw.write("\n");
        }
        bw.write("# Link Libraries and Options\n");
        String oicLibOptionsPrefix = "";
        String oicLibOptionsPostfix = "";
        if (provider != null) {
            oicLibOptionsPrefix = provider.getLibraryOptionsPrefix(projectDescriptor, conf);
            oicLibOptionsPostfix = provider.getLibraryOptionsPostfix(projectDescriptor, conf);
        }
        bw.write("LDLIBSOPTIONS=" + oicLibOptionsPrefix + conf.getLinkerConfiguration().getLibraryItems() + oicLibOptionsPostfix + "\n");
        bw.write("\n");
        if (conf.isQmakeConfiguration()) {
            String qmakeSpec = conf.getQmakeConfiguration().getQmakeSpec().getValue();
            if (qmakeSpec.length() == 0 && (conf.getDevelopmentHost().getBuildPlatform() == 4 || conf.getDevelopmentHost().getBuildPlatform() == 3) && (qmakeSpec = CppUtils.getQmakeSpec(compilerSet, conf.getDevelopmentHost().getBuildPlatform())) == null) {
                if (conf.getDevelopmentHost().getBuildPlatform() == 4) {
                    qmakeSpec = "macx-g++";
                }
                if (conf.getDevelopmentHost().getBuildPlatform() == 3) {
                    qmakeSpec = "win32-g++";
                }
            }
            if (qmakeSpec.length() == 0 && (conf.getDevelopmentHost().getBuildPlatform() == 1 || conf.getDevelopmentHost().getBuildPlatform() == 0) && compilerSet.getCompilerFlavor().isSunStudioCompiler() && (qmakeSpec = CppUtils.getQmakeSpec(compilerSet, conf.getDevelopmentHost().getBuildPlatform())) == null) {
                qmakeSpec = "solaris-cc";
            }
            if (!qmakeSpec.isEmpty()) {
                qmakeSpec = "-spec " + qmakeSpec + " ";
            }
            bw.write("nbproject/qt-${CND_CONF}.mk: nbproject/qt-${CND_CONF}.pro FORCE\n");
            bw.write("\t${QMAKE} VPATH=. " + qmakeSpec + "-o qttmp-" + "${CND_CONF}" + ".mk nbproject/qt-" + "${CND_CONF}" + ".pro\n");
            bw.write("\tmv -f qttmp-${CND_CONF}.mk nbproject/qt-${CND_CONF}.mk\n");
            if (conf.getDevelopmentHost().getBuildPlatform() == 3) {
                bw.write("\t@sed -e 's/\\/qt\\/bin/\\/qt\\/bin\\//g' nbproject/qt-${CND_CONF}.mk >nbproject/qt-${CND_CONF}.tmp\n");
                bw.write("\t@mv -f nbproject/qt-${CND_CONF}.tmp nbproject/qt-${CND_CONF}.mk\n");
            }
            bw.write(10);
            bw.write("FORCE:\n\n");
        }
    }

    protected void writeBuildTargets(MakefileWriter makefileWriter, MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, BufferedWriter bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            bw.write(".build-conf:\n");
            bw.write("\t@echo 'Tool collection " + conf.getCompilerSet().getCompilerSetName().getValue() + " was missing when this makefile was generated'\n");
            bw.write("\t@echo 'Please specify existing tool collection in project properties'\n");
            bw.write("\t@exit 1\n\n");
            return;
        }
        if (conf.isCompileConfiguration()) {
            makefileWriter.writeBuildTarget(projectDescriptor, conf, bw);
            if (conf.isLinkerConfiguration()) {
                makefileWriter.writeLinkTarget(projectDescriptor, conf, bw);
            }
            if (conf.isArchiverConfiguration()) {
                makefileWriter.writeArchiveTarget(projectDescriptor, conf, bw);
            }
            if (conf.isCompileConfiguration()) {
                makefileWriter.writeCompileTargets(projectDescriptor, conf, bw);
            }
        } else if (conf.isMakefileConfiguration()) {
            makefileWriter.writeMakefileTarget(projectDescriptor, conf, bw);
        } else if (conf.isQmakeConfiguration()) {
            makefileWriter.writeQTTarget(projectDescriptor, conf, bw);
        }
        makefileWriter.writeSubProjectBuildTargets(projectDescriptor, conf, bw);
    }

    protected void writeBuildTestTargets(MakefileWriter makefileWriter, MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, BufferedWriter bw) throws IOException {
        if (ConfigurationMakefileWriter.hasTests(projectDescriptor)) {
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                bw.write(".build-test-conf:\n");
                bw.write("\t@echo 'Tool collection " + conf.getCompilerSet().getCompilerSetName().getValue() + " was missing when this makefile was generated'\n");
                bw.write("\t@echo 'Please specify existing tool collection in project properties'\n");
                bw.write("\t@exit 1\n\n");
                return;
            }
            if (conf.isCompileConfiguration()) {
                makefileWriter.writeBuildTestTarget(projectDescriptor, conf, bw);
                makefileWriter.writeLinkTestTarget(projectDescriptor, conf, bw);
                makefileWriter.writeCompileTestTargets(projectDescriptor, conf, bw);
            }
        }
    }

    public static void writeQTTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String output = ConfigurationMakefileWriter.getOutput(projectDescriptor, conf, compilerSet);
        bw.write("# Build Targets\n");
        bw.write(".build-conf: ${BUILD_SUBPROJECTS} nbproject/qt-${CND_CONF}.mk\n");
        bw.write("\t\"${MAKE}\" -f nbproject/qt-${CND_CONF}.mk " + output + "\n\n");
        bw.write("${CND_BUILDDIR}/" + conf.getName() + "/%.o: nbproject/qt-" + "${CND_CONF}" + ".mk\n");
        bw.write("\t${MAKE} -f nbproject/qt-${CND_CONF}.mk \"$@\"\n");
    }

    public static void writeBuildTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String output = ConfigurationMakefileWriter.getOutput(projectDescriptor, conf, compilerSet);
        bw.write("# Build Targets\n");
        bw.write(".build-conf: ${BUILD_SUBPROJECTS}\n");
        bw.write("\t\"${MAKE}\"  -f nbproject/Makefile-${CND_CONF}.mk " + output + "\n\n");
    }

    public static void writeBuildTestTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (ConfigurationMakefileWriter.hasTests(projectDescriptor)) {
            bw.write("# Build Test Targets\n");
            bw.write(".build-tests-conf: .build-tests-subprojects .build-conf ${TESTFILES}\n");
            bw.write(".build-tests-subprojects:\n");
            HashSet<MakeArtifact> subProjects = new HashSet<MakeArtifact>();
            for (Folder folder : ConfigurationMakefileWriter.getTests(projectDescriptor)) {
                List<LinkerConfiguration> linkerConfigurations = ConfigurationMakefileWriter.getLinkerConfigurations(folder, conf);
                for (LinkerConfiguration lc : linkerConfigurations) {
                    LibrariesConfiguration librariesConfiguration = lc.getLibrariesConfiguration();
                    for (LibraryItem item : librariesConfiguration.getValue()) {
                        LibraryItem.ProjectItem projectItem;
                        MakeArtifact makeArtifact;
                        if (!(item instanceof LibraryItem.ProjectItem) || !(makeArtifact = (projectItem = (LibraryItem.ProjectItem)item).getMakeArtifact()).getBuild()) continue;
                        subProjects.add(makeArtifact);
                    }
                }
            }
            for (MakeArtifact makeArtifact : subProjects) {
                bw.write("\tcd " + CndPathUtilities.escapeOddCharacters((String)CndPathUtilities.normalizeSlashes((String)makeArtifact.getWorkingDirectory())) + " && " + makeArtifact.getBuildCommand() + "\n");
            }
            bw.write("\n");
        }
    }

    public static void writeLinkTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String output = ConfigurationMakefileWriter.getOutput(projectDescriptor, conf, compilerSet);
        LinkerConfiguration linkerConfiguration = conf.getLinkerConfiguration();
        String command = ConfigurationMakefileWriter.getLinkerTool(projectDescriptor, conf, conf.getLinkerConfiguration(), compilerSet);
        command = conf.getDevelopmentHost().isLocalhost() ? command + linkerConfiguration.getOutputOptions() + " " : command + linkerConfiguration.getOutputOptions().replace(conf.getOutputValue(), output) + " ";
        command = command + "${OBJECTFILES} ";
        command = command + "${LDLIBSOPTIONS}";
        String options = linkerConfiguration.getCommandLineConfiguration().getValue();
        if (options.length() > 0) {
            command = command + " " + options;
        }
        if ((options = linkerConfiguration.getBasicOptions()).length() > 0) {
            command = command + " " + options;
        }
        String[] additionalDependencies = linkerConfiguration.getAdditionalDependencies().getValues();
        for (int i = 0; i < additionalDependencies.length; ++i) {
            bw.write(output + ": " + additionalDependencies[i] + "\n\n");
        }
        for (LibraryItem lib : linkerConfiguration.getLibrariesConfiguration().getValue()) {
            String libPath = lib.getPath();
            if (libPath == null || libPath.length() <= 0) continue;
            bw.write(output + ": " + CndPathUtilities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, libPath)) + "\n\n");
        }
        bw.write(output + ": ${OBJECTFILES}\n");
        String folders = CndPathUtilities.getDirName((String)output);
        if (folders != null) {
            bw.write("\t${MKDIR} -p " + folders + "\n");
        }
        bw.write("\t" + command + "\n");
    }

    private static String getLinkerTool(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, LinkerConfiguration linkerConfiguration, CompilerSet compilerSet) {
        if (linkerConfiguration.getTool().getModified()) {
            return linkerConfiguration.getTool().getValue() + " ";
        }
        String getPreferredCompiler = null;
        if (compilerSet != null) {
            getPreferredCompiler = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getPreferredCompiler();
        }
        if (getPreferredCompiler != null) {
            if ("c".equals(getPreferredCompiler)) {
                return "${LINK.c} ";
            }
            if ("cpp".equals(getPreferredCompiler)) {
                return "${LINK.cc} ";
            }
            if ("fortran".equals(getPreferredCompiler)) {
                return "${LINK.f} ";
            }
        }
        if (conf.hasCPPFiles(projectDescriptor)) {
            int hasCpp11;
            if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler() && (hasCpp11 = ConfigurationMakefileWriter.hasCpp11(projectDescriptor, conf)) > 0) {
                AbstractCompiler cpp = (AbstractCompiler)compilerSet.findTool((ToolKind)PredefinedToolKind.CCCompiler);
                return "${LINK.cc} " + cpp.getCppStandardOptions(hasCpp11) + " ";
            }
            return "${LINK.cc} ";
        }
        if (conf.hasFortranFiles(projectDescriptor)) {
            return "${LINK.f} ";
        }
        return "${LINK.c} ";
    }

    private static int hasCpp11(MakeConfigurationDescriptor configurationDescriptor, MakeConfiguration conf) {
        Item[] items = configurationDescriptor.getProjectItems();
        for (int x = 0; x < items.length; ++x) {
            BasicCompilerConfiguration compilerConfiguration;
            PredefinedToolKind tool;
            ItemConfiguration itemConfiguration = items[x].getItemConfiguration(conf);
            if (itemConfiguration == null || itemConfiguration.getExcluded() == null || itemConfiguration.getExcluded().getValue() || (tool = itemConfiguration.getTool()) != PredefinedToolKind.CCCompiler || !((compilerConfiguration = itemConfiguration.getCompilerConfiguration()) instanceof CCCompilerConfiguration)) continue;
            CCCompilerConfiguration cppConf = (CCCompilerConfiguration)compilerConfiguration;
            if (cppConf.getInheritedCppStandard() == 2) {
                return 2;
            }
            if (cppConf.getInheritedCppStandard() != 3) continue;
            return 3;
        }
        return 0;
    }

    public static void writeLinkTestTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (conf.isCompileConfiguration()) {
            List<Folder> tests = ConfigurationMakefileWriter.getTests(projectDescriptor);
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return;
            }
            if (!tests.isEmpty()) {
                for (Folder folder : tests) {
                    LinkerConfiguration testLinkerConfiguration = folder.getFolderConfiguration(conf).getLinkerConfiguration();
                    String output = testLinkerConfiguration.getOutputValue();
                    List<LinkerConfiguration> linkerConfigurations = ConfigurationMakefileWriter.getLinkerConfigurations(folder, conf);
                    CompilerSet cs = conf.getCompilerSet().getCompilerSet();
                    output = CppUtils.normalizeDriveLetter(cs, output);
                    String command = ConfigurationMakefileWriter.getLinkerTool(projectDescriptor, conf, testLinkerConfiguration, compilerSet);
                    for (LinkerConfiguration lc : linkerConfigurations) {
                        command = command + lc.getCommandLineConfiguration().getValue() + " ";
                    }
                    command = command + "-o " + output + " ";
                    if (cs != null && testLinkerConfiguration.getStripOption().getValue()) {
                        command = command + cs.getCompilerFlavor().getToolchainDescriptor().getLinker().getStripFlag() + " ";
                    }
                    command = command + "$^ ";
                    command = command + "${LDLIBSOPTIONS} ";
                    ArrayList<String> additionalDependencies = new ArrayList<String>();
                    for (LinkerConfiguration lc : linkerConfigurations) {
                        additionalDependencies.addAll(lc.getAdditionalDependencies().getValuesAsList());
                    }
                    for (String dep : additionalDependencies) {
                        bw.write(output + ": " + dep + "\n\n");
                    }
                    for (LinkerConfiguration lc : linkerConfigurations) {
                        String libraryItems = lc.getLibraryItems();
                        if (libraryItems == null || libraryItems.isEmpty()) continue;
                        command = command + libraryItems + " ";
                    }
                    String objectFiles = "";
                    Item[] items = folder.getAllItemsAsArray();
                    for (int k = 0; k < items.length; ++k) {
                        ItemConfiguration itemConfiguration = items[k].getItemConfiguration(conf);
                        if (itemConfiguration == null || itemConfiguration.getExcluded().getValue() || !itemConfiguration.isCompilerToolConfiguration() || items[k].hasHeaderOrSourceExtension(false, false)) continue;
                        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
                        String file = CndPathUtilities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[k].getPath()));
                        String objectFile = compilerConfiguration.getOutputFile(items[k], conf, false);
                        objectFile = objectFile.replace("${OBJECTDIR}", "${TESTDIR}");
                        objectFiles = objectFiles + objectFile + " ";
                    }
                    objectFiles = objectFiles + "${OBJECTFILES:%.o=%_nomain.o}";
                    bw.write(output + ": " + objectFiles + "\n");
                    String folders = CndPathUtilities.getDirName((String)output);
                    bw.write("\t${MKDIR} -p " + folders + "\n");
                    bw.write("\t" + command + "\n\n");
                }
            }
        }
    }

    private static List<LinkerConfiguration> getLinkerConfigurations(Folder test, MakeConfiguration conf) {
        ArrayList<LinkerConfiguration> linkerConfigurations = new ArrayList<LinkerConfiguration>();
        if (test == null || conf == null) {
            return linkerConfigurations;
        }
        ConfigurationMakefileWriter.getLinkerConfigurations(linkerConfigurations, test, conf);
        return linkerConfigurations;
    }

    private static void getLinkerConfigurations(List<LinkerConfiguration> confs, Folder folder, MakeConfiguration conf) {
        if (folder == null) {
            return;
        }
        FolderConfiguration folderConfiguration = folder.getFolderConfiguration(conf);
        if (folderConfiguration == null) {
            return;
        }
        LinkerConfiguration testLinkerConfiguration = folderConfiguration.getLinkerConfiguration();
        if (testLinkerConfiguration == null) {
            return;
        }
        Folder parentFolder = folder.getParent();
        if (parentFolder != null) {
            ConfigurationMakefileWriter.getLinkerConfigurations(confs, parentFolder, conf);
        }
        confs.add(testLinkerConfiguration);
    }

    public static void writeArchiveTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String output = ConfigurationMakefileWriter.getOutput(projectDescriptor, conf, compilerSet);
        ArchiverConfiguration archiverConfiguration = conf.getArchiverConfiguration();
        String command = "${AR} ";
        command = command + archiverConfiguration.getOptions() + " ";
        command = command + "${OBJECTFILES} ";
        bw.write(output + ": " + "${OBJECTFILES}" + "\n");
        String folders = CndPathUtilities.getDirName((String)output);
        if (folders != null) {
            bw.write("\t${MKDIR} -p " + folders + "\n");
        }
        bw.write("\t${RM} " + output + "\n");
        bw.write("\t" + command + "\n");
        if (archiverConfiguration.getRunRanlib().getValue()) {
            bw.write("\t" + archiverConfiguration.getRunRanlib().getOption() + " " + output + "\n");
        }
    }

    public static Item[] getSortedProjectItems(MakeConfigurationDescriptor projectDescriptor) {
        ArrayList<Item> res = new ArrayList<Item>(Arrays.asList(projectDescriptor.getProjectItems()));
        Collections.sort(res, new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return res.toArray(new Item[res.size()]);
    }

    public static void writeCompileTargets(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        Item[] items = ConfigurationMakefileWriter.getSortedProjectItems(projectDescriptor);
        if (conf.isCompileConfiguration()) {
            String target = null;
            for (int i = 0; i < items.length; ++i) {
                CompilerSet compilerSet;
                ItemConfiguration itemConfiguration;
                Folder folder = items[i].getFolder();
                if (folder.isTest() || folder.isTestLogicalFolder() || folder.isTestRootFolder() || (itemConfiguration = items[i].getItemConfiguration(conf)) == null || itemConfiguration.getExcluded().getValue() || (compilerSet = conf.getCompilerSet().getCompilerSet()) == null) continue;
                String file = CndPathUtilities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[i].getPath(true)));
                DatabaseProjectProvider provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class);
                if (provider != null && provider.isProCItem(items[i])) {
                    file = provider.getProCOutput(items[i], conf);
                }
                String command = "";
                String comment = null;
                String additionalDep = null;
                PredefinedToolKind tool = itemConfiguration.getTool();
                if (itemConfiguration.isCompilerToolConfiguration()) {
                    AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)tool);
                    BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
                    target = compilerConfiguration.getOutputFile(items[i], conf, false);
                    if (compiler != null && compiler.getDescriptor() != null) {
                        String fromLinker = "";
                        if (conf.isDynamicLibraryConfiguration() && conf.getLinkerConfiguration().getPICOption().getValue() && compiler.getKind() != PredefinedToolKind.Assembler) {
                            fromLinker = " " + conf.getLinkerConfiguration().getPICOption(compilerSet);
                        }
                        command = command + compilerConfiguration.getOptions(compiler);
                        if (provider != null && provider.isProCItem(items[i])) {
                            command = command + provider.getCompileOptions(items[i], conf);
                        }
                        command = command + fromLinker + " ";
                        if (conf.getDependencyChecking().getValue() && compiler.getDependencyGenerationOption().length() > 0) {
                            command = "${RM} \"$@.d\"\n\t" + command + compiler.getDependencyGenerationOption() + " ";
                        }
                        if (items[i].hasHeaderOrSourceExtension(false, false)) {
                            String flags = compiler.getDescriptor().getPrecompiledHeaderFlags();
                            if (flags == null) {
                                command = "# command to precompile header ";
                                comment = "Current compiler does not support header precompilation";
                            } else {
                                command = command + compiler.getDescriptor().getPrecompiledHeaderFlags() + " ";
                            }
                        } else {
                            command = command + compiler.getDescriptor().getOutputObjectFileFlags() + target + " ";
                        }
                        command = command + file;
                    }
                    additionalDep = compilerConfiguration.getAdditionalDependencies().getValue();
                } else if (tool == PredefinedToolKind.CustomTool) {
                    CustomToolConfiguration customToolConfiguration = itemConfiguration.getCustomToolConfiguration();
                    if (!customToolConfiguration.getModified()) continue;
                    target = customToolConfiguration.getOutputs().getValue();
                    command = customToolConfiguration.getCommandLine().getValue();
                    comment = customToolConfiguration.getDescription().getValue();
                    additionalDep = customToolConfiguration.getAdditionalDependencies().getValue();
                } else assert (false);
                StringTokenizer tokennizer = new StringTokenizer(target);
                StringBuilder foldersBuffer = new StringBuilder();
                while (tokennizer.hasMoreTokens()) {
                    String dir = CndPathUtilities.getDirName((String)tokennizer.nextToken());
                    if (dir == null) continue;
                    foldersBuffer.append(dir);
                    foldersBuffer.append(" ");
                }
                String folders = foldersBuffer.toString().trim();
                bw.write("\n");
                if (target.contains(" ")) {
                    bw.write(".NO_PARALLEL:" + target + "\n");
                }
                bw.write(target + ": ");
                if (conf.getRebuildPropChanged().getValue()) {
                    bw.write("nbproject/Makefile-${CND_CONF}.mk ");
                }
                if (additionalDep != null) {
                    bw.write(file + " " + additionalDep + "\n");
                } else {
                    bw.write(file + "\n");
                }
                if (folders != null && folders.length() > 0) {
                    bw.write("\t${MKDIR} -p " + folders + "\n");
                }
                if (comment != null) {
                    bw.write("\t@echo " + comment + "\n");
                }
                bw.write("\t" + command + "\n");
            }
            DatabaseProjectProvider provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class);
            if (provider != null) {
                provider.writeProCTargets(projectDescriptor, conf, bw);
            }
        }
    }

    public static void writeCompileTestTargets(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (conf.isCompileConfiguration()) {
            List<Folder> tests = ConfigurationMakefileWriter.getTests(projectDescriptor);
            if (!tests.isEmpty()) {
                for (Folder folder : tests) {
                    Item[] items = folder.getAllItemsAsArray();
                    String target = null;
                    for (int i = 0; i < items.length; ++i) {
                        CompilerSet compilerSet;
                        ItemConfiguration itemConfiguration = items[i].getItemConfiguration(conf);
                        if (itemConfiguration == null || itemConfiguration.getExcluded().getValue() || (compilerSet = conf.getCompilerSet().getCompilerSet()) == null) continue;
                        String file = CndPathUtilities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[i].getPath(true)));
                        DatabaseProjectProvider provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class);
                        if (provider != null && provider.isProCItem(items[i])) {
                            file = provider.getProCOutput(items[i], conf);
                        }
                        String command = "";
                        String comment = null;
                        String additionalDep = null;
                        if (itemConfiguration.isCompilerToolConfiguration()) {
                            AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
                            BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
                            target = compilerConfiguration.getOutputFile(items[i], conf, false);
                            if (compiler != null && compiler.getDescriptor() != null) {
                                command = command + compilerConfiguration.getOptions(compiler) + " ";
                                if (provider != null && provider.isProCItem(items[i])) {
                                    command = command + provider.getCompileOptions(items[i], conf);
                                }
                                if (conf.getDependencyChecking().getValue() && compiler.getDependencyGenerationOption().length() > 0) {
                                    command = "${RM} \"$@.d\"\n\t" + command + compiler.getDependencyGenerationOption() + " ";
                                }
                                if (items[i].hasHeaderOrSourceExtension(false, false)) {
                                    String flags = compiler.getDescriptor().getPrecompiledHeaderFlags();
                                    if (flags == null) {
                                        command = "# command to precompile header ";
                                        comment = "Current compiler does not support header precompilation";
                                    } else {
                                        command = command + compiler.getDescriptor().getPrecompiledHeaderFlags() + " ";
                                    }
                                } else {
                                    command = command + compiler.getDescriptor().getOutputObjectFileFlags() + target + " ";
                                }
                                command = command + file;
                            }
                            additionalDep = compilerConfiguration.getAdditionalDependencies().getValue();
                        } else if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool) {
                            CustomToolConfiguration customToolConfiguration = itemConfiguration.getCustomToolConfiguration();
                            if (!customToolConfiguration.getModified()) continue;
                            target = customToolConfiguration.getOutputs().getValue();
                            command = customToolConfiguration.getCommandLine().getValue();
                            comment = customToolConfiguration.getDescription().getValue();
                            additionalDep = customToolConfiguration.getAdditionalDependencies().getValue();
                        } else assert (false);
                        target = target.replace("${OBJECTDIR}", "${TESTDIR}");
                        command = command.replace("${OBJECTDIR}", "${TESTDIR}");
                        String folders = CndPathUtilities.getDirName((String)target);
                        bw.write("\n");
                        if (target.contains(" ")) {
                            bw.write(".NO_PARALLEL:" + target + "\n");
                        }
                        if (additionalDep != null) {
                            bw.write(target + ": " + file + " " + additionalDep + "\n");
                        } else {
                            bw.write(target + ": " + file + "\n");
                        }
                        if (folders != null) {
                            bw.write("\t${MKDIR} -p " + folders + "\n");
                        }
                        if (comment != null) {
                            bw.write("\t@echo " + comment + "\n");
                        }
                        bw.write("\t" + command + "\n\n");
                    }
                }
            }
            ConfigurationMakefileWriter.writeCompileTargetsWithoutMain(projectDescriptor, conf, bw);
            DatabaseProjectProvider provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class);
            if (provider != null) {
                provider.writeProCTargets(projectDescriptor, conf, bw);
            }
        }
    }

    private static String changeToNoMain(String target, String name) {
        String nomainTarget;
        if (target.contains("/")) {
            String baseDir = CndPathUtilities.getDirName((String)target);
            String baseName = CndPathUtilities.getBaseName((String)target);
            nomainTarget = baseDir + "/" + baseName.replace(name, name + "_nomain");
        } else {
            nomainTarget = target.replace(name, name + "_nomain");
        }
        return nomainTarget;
    }

    public static void writeCompileTargetsWithoutMain(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        Item[] items = ConfigurationMakefileWriter.getSortedProjectItems(projectDescriptor);
        if (conf.isCompileConfiguration()) {
            String target = null;
            for (int i = 0; i < items.length; ++i) {
                String nomainTarget;
                CompilerSet compilerSet;
                ItemConfiguration itemConfiguration;
                Folder folder = items[i].getFolder();
                if (folder.isTest() || folder.isTestLogicalFolder() || folder.isTestRootFolder() || (itemConfiguration = items[i].getItemConfiguration(conf)) == null || itemConfiguration.getExcluded().getValue() || (compilerSet = conf.getCompilerSet().getCompilerSet()) == null) continue;
                String file = CndPathUtilities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[i].getPath(true)));
                DatabaseProjectProvider provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class);
                if (provider != null && provider.isProCItem(items[i])) {
                    file = provider.getProCOutput(items[i], conf);
                }
                String command = "";
                String comment = null;
                String additionalDep = null;
                String name = items[i].getName();
                String extension = FileUtil.getExtension((String)name);
                name = name.substring(0, name.length() - (extension.isEmpty() ? 0 : extension.length() + 1));
                if (itemConfiguration.isCompilerToolConfiguration()) {
                    AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
                    BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
                    target = compilerConfiguration.getOutputFile(items[i], conf, false);
                    nomainTarget = ConfigurationMakefileWriter.changeToNoMain(target, name);
                    if (compiler != null && compiler.getDescriptor() != null) {
                        String fromLinker = "";
                        if (conf.isDynamicLibraryConfiguration() && conf.getLinkerConfiguration().getPICOption().getValue() && compiler.getKind() != PredefinedToolKind.Assembler) {
                            fromLinker = " " + conf.getLinkerConfiguration().getPICOption(compilerSet);
                        }
                        command = command + compilerConfiguration.getOptions(compiler);
                        if (provider != null && provider.isProCItem(items[i])) {
                            command = command + provider.getCompileOptions(items[i], conf);
                        }
                        command = command + fromLinker + " -Dmain=__nomain ";
                        if (conf.getDependencyChecking().getValue() && compiler.getDependencyGenerationOption().length() > 0) {
                            command = "${RM} \"$@.d\";\\\n\t    " + command + compiler.getDependencyGenerationOption() + " ";
                        }
                        if (items[i].hasHeaderOrSourceExtension(false, false)) {
                            String flags = compiler.getDescriptor().getPrecompiledHeaderFlags();
                            if (flags == null) {
                                command = "# command to precompile header ";
                                comment = "Current compiler does not support header precompilation";
                            } else {
                                command = command + compiler.getDescriptor().getPrecompiledHeaderFlags() + " ";
                            }
                        } else {
                            command = command + compiler.getDescriptor().getOutputObjectFileFlags() + nomainTarget + " ";
                        }
                        command = command + file;
                    }
                    additionalDep = compilerConfiguration.getAdditionalDependencies().getValue();
                } else if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool) {
                    CustomToolConfiguration customToolConfiguration = itemConfiguration.getCustomToolConfiguration();
                    if (!customToolConfiguration.getModified()) continue;
                    target = customToolConfiguration.getOutputs().getValue();
                    command = customToolConfiguration.getCommandLine().getValue();
                    comment = customToolConfiguration.getDescription().getValue();
                    additionalDep = customToolConfiguration.getAdditionalDependencies().getValue();
                } else assert (false);
                nomainTarget = ConfigurationMakefileWriter.changeToNoMain(target, name);
                String folders = CndPathUtilities.getDirName(target);
                bw.write("\n");
                if (target.contains(" ")) {
                    bw.write(".NO_PARALLEL:" + target + "\n");
                }
                if (additionalDep != null) {
                    bw.write(nomainTarget + ": " + target + " " + file + " " + additionalDep + "\n");
                } else {
                    bw.write(nomainTarget + ": " + target + " " + file + "\n");
                }
                if (folders != null) {
                    bw.write("\t${MKDIR} -p " + folders + "\n");
                }
                if (comment != null) {
                    bw.write("\t@echo " + comment + "\n");
                }
                bw.write("\t@NMOUTPUT=`${NM} " + target + "`; \\\n");
                bw.write("\tif (echo \"$$NMOUTPUT\" | ${GREP} '|main$$') || \\\n");
                bw.write("\t   (echo \"$$NMOUTPUT\" | ${GREP} 'T main$$') || \\\n");
                bw.write("\t   (echo \"$$NMOUTPUT\" | ${GREP} 'T _main$$'); \\\n");
                bw.write("\tthen  \\\n");
                bw.write("\t    " + command + ";\\\n");
                bw.write("\telse  \\\n");
                bw.write("\t    ${CP} " + target + " " + nomainTarget + ";\\\n");
                bw.write("\tfi\n");
            }
            bw.write("\n");
        }
    }

    public static void writeRunTestTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (ConfigurationMakefileWriter.hasTests(projectDescriptor)) {
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            bw.write("# Run Test Targets\n");
            bw.write(".test-conf:\n");
            bw.write("\t@if [ \"${TEST}\" = \"\" ]; \\\n");
            bw.write("\tthen  \\\n");
            for (Folder folder : ConfigurationMakefileWriter.getTests(projectDescriptor)) {
                String target = folder.getFolderConfiguration(conf).getLinkerConfiguration().getOutputValue();
                bw.write("\t    " + target + " || true; \\\n");
            }
            bw.write("\telse  \\\n");
            bw.write("\t    ./${TEST} || true; \\\n");
            bw.write("\tfi\n\n");
        }
    }

    public static void writeMakefileTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        MakefileConfiguration makefileConfiguration = conf.getMakefileConfiguration();
        String target = makefileConfiguration.getOutput().getValue();
        String cwd = makefileConfiguration.getBuildCommandWorkingDirValue();
        String command = makefileConfiguration.getBuildCommand().getValue();
        bw.write("# Build Targets\n");
        bw.write(".build-conf: ${BUILD_SUBPROJECTS}\n");
        bw.write("\tcd " + CndPathUtilities.escapeOddCharacters((String)CndPathUtilities.normalizeSlashes((String)cwd)) + " && " + command + "\n");
    }

    public static void writeSubProjectBuildTargets(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        bw.write("\n");
        bw.write("# Subprojects\n");
        bw.write(".build-subprojects:\n");
        if (conf.isLinkerConfiguration()) {
            LibrariesConfiguration librariesConfiguration = conf.getLinkerConfiguration().getLibrariesConfiguration();
            for (LibraryItem item : librariesConfiguration.getValue()) {
                if (!(item instanceof LibraryItem.ProjectItem)) continue;
                LibraryItem projectItem = item;
                MakeArtifact makeArtifact = ((LibraryItem.ProjectItem)projectItem).getMakeArtifact();
                String location = makeArtifact.getWorkingDirectory();
                if (!makeArtifact.getBuild()) continue;
                bw.write("\tcd " + CndPathUtilities.escapeOddCharacters((String)CndPathUtilities.normalizeSlashes((String)location)) + " && " + makeArtifact.getBuildCommand() + "\n");
            }
        }
        for (LibraryItem item : conf.getRequiredProjectsConfiguration().getValue()) {
            MakeArtifact makeArtifact = ((LibraryItem.ProjectItem)item).getMakeArtifact();
            String location = makeArtifact.getWorkingDirectory();
            if (!makeArtifact.getBuild()) continue;
            bw.write("\tcd " + CndPathUtilities.escapeOddCharacters((String)CndPathUtilities.normalizeSlashes((String)location)) + " && " + makeArtifact.getBuildCommand() + "\n");
        }
        bw.write("\n");
    }

    public static void writeSubProjectCleanTargets(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        bw.write("\n");
        bw.write("# Subprojects\n");
        bw.write(".clean-subprojects:\n");
        if (conf.isLinkerConfiguration()) {
            LibrariesConfiguration librariesConfiguration = conf.getLinkerConfiguration().getLibrariesConfiguration();
            for (LibraryItem item : librariesConfiguration.getValue()) {
                if (!(item instanceof LibraryItem.ProjectItem)) continue;
                LibraryItem projectItem = item;
                MakeArtifact makeArtifact = ((LibraryItem.ProjectItem)projectItem).getMakeArtifact();
                String location = makeArtifact.getWorkingDirectory();
                if (!makeArtifact.getBuild()) continue;
                bw.write("\tcd " + CndPathUtilities.escapeOddCharacters((String)CndPathUtilities.normalizeSlashes((String)location)) + " && " + makeArtifact.getCleanCommand() + "\n");
            }
        }
        for (LibraryItem item : conf.getRequiredProjectsConfiguration().getValue()) {
            MakeArtifact makeArtifact = ((LibraryItem.ProjectItem)item).getMakeArtifact();
            String location = makeArtifact.getWorkingDirectory();
            if (!makeArtifact.getBuild()) continue;
            bw.write("\tcd " + CndPathUtilities.escapeOddCharacters((String)CndPathUtilities.normalizeSlashes((String)location)) + " && " + makeArtifact.getCleanCommand() + "\n");
        }
    }

    public static void writeCleanTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        bw.write("# Clean Targets\n");
        bw.write(".clean-conf: ${CLEAN_SUBPROJECTS}");
        if (conf.isQmakeConfiguration()) {
            bw.write(" nbproject/qt-${CND_CONF}.mk");
        }
        bw.write(10);
        if (conf.isCompileConfiguration()) {
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            bw.write("\t${RM} -r ${CND_BUILDDIR}/${CND_CONF}\n");
            bw.write("\t${RM} " + ConfigurationMakefileWriter.getOutput(projectDescriptor, conf, compilerSet) + "\n");
            if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler() && conf.hasCPPFiles(projectDescriptor)) {
                bw.write("\t${CCADMIN} -clean\n");
            }
            if (conf.hasFortranFiles(projectDescriptor)) {
                bw.write("\t${RM} *.mod\n");
            }
            Item[] items = ConfigurationMakefileWriter.getSortedProjectItems(projectDescriptor);
            for (int i = 0; i < items.length; ++i) {
                DatabaseProjectProvider provider;
                CustomToolConfiguration customToolConfiguration;
                ItemConfiguration itemConfiguration = items[i].getItemConfiguration(conf);
                if (itemConfiguration == null || itemConfiguration.getExcluded().getValue()) continue;
                if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool) {
                    if (!itemConfiguration.getCustomToolConfiguration().getModified()) continue;
                    bw.write("\t${RM} " + itemConfiguration.getCustomToolConfiguration().getOutputs().getValue() + "\n");
                    continue;
                }
                if (!itemConfiguration.isCompilerToolConfiguration() || (customToolConfiguration = itemConfiguration.getCustomToolConfiguration()) == null || compilerSet == null || (provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class)) == null || !provider.isProCItem(items[i])) continue;
                String target = provider.getProCOutput(items[i], conf);
                bw.write("\t${RM} " + target + "\n");
            }
        } else if (conf.isMakefileConfiguration()) {
            MakefileConfiguration makefileConfiguration = conf.getMakefileConfiguration();
            String target = makefileConfiguration.getOutput().getValue();
            String cwd = makefileConfiguration.getBuildCommandWorkingDirValue();
            String command = makefileConfiguration.getCleanCommand().getValue();
            bw.write("\tcd " + CndPathUtilities.escapeOddCharacters((String)CndPathUtilities.normalizeSlashes((String)cwd)) + " && " + command + "\n");
        } else if (conf.isQmakeConfiguration()) {
            bw.write("\t${MAKE} -f nbproject/qt-${CND_CONF}.mk distclean\n");
        }
        ConfigurationMakefileWriter.writeSubProjectCleanTargets(projectDescriptor, conf, bw);
    }

    public static void writeDependencyChecking(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (conf.getDependencyChecking().getValue() && !conf.isMakefileConfiguration() && !conf.isQmakeConfiguration() && conf.getCompilerSet().getCompilerSet() != null) {
            bw.write("\n");
            bw.write("# Enable dependency checking\n");
            bw.write(".dep.inc: .depcheck-impl\n");
            bw.write("\n");
            bw.write("include .dep.inc\n");
        }
    }

    private static String getOutput(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, CompilerSet compilerSet) {
        String output = conf.getOutputValue();
        if (!(conf.getDevelopmentHost().isLocalhost() || output.startsWith("$") || CndPathUtilities.isPathAbsolute((CharSequence)output))) {
            PathMap mapper = RemoteSyncSupport.getPathMap((Lookup.Provider)projectDescriptor.getProject());
            if (mapper != null) {
                if ((output = mapper.getRemotePath(output, true)) == null) {
                    output = conf.getOutputValue();
                }
            } else {
                LOGGER.log(Level.SEVERE, "Path Mapper not found for project {0} - using local path {1}", new Object[]{projectDescriptor.getProject(), output});
            }
        }
        switch (conf.getDevelopmentHost().getBuildPlatform()) {
            case 3: {
                switch (conf.getConfigurationType().getValue()) {
                    case 1: 
                    case 4: 
                    case 7: {
                        output = ConfigurationMakefileWriter.mangleAppnameWin(output);
                    }
                }
            }
        }
        if (compilerSet != null) {
            output = CppUtils.normalizeDriveLetter(compilerSet, output);
        }
        return output;
    }

    private static String mangleAppnameWin(String original) {
        if (original.endsWith(".exe")) {
            return original;
        }
        return original + ".exe";
    }

    public static String getObjectDir(MakeConfiguration conf) {
        return "${CND_BUILDDIR}/${CND_CONF}/${CND_PLATFORM}";
    }

    public static String getTestObjectDir(MakeConfiguration conf) {
        return "${CND_BUILDDIR}/${CND_CONF}/${CND_PLATFORM}/tests";
    }

    private static String getObjectFiles(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf) {
        Item[] items = ConfigurationMakefileWriter.getSortedProjectItems(projectDescriptor);
        StringBuilder linkObjects = new StringBuilder();
        if (conf.isCompileConfiguration()) {
            for (int x = 0; x < items.length; ++x) {
                ItemConfiguration itemConfiguration;
                Folder folder = items[x].getFolder();
                if (folder.isTest() || folder.isTestLogicalFolder() || folder.isTestRootFolder() || (itemConfiguration = items[x].getItemConfiguration(conf)) == null || itemConfiguration.getExcluded().getValue() || !itemConfiguration.isCompilerToolConfiguration() || items[x].hasHeaderOrSourceExtension(false, false)) continue;
                BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
                linkObjects.append(" \\\n\t");
                linkObjects.append(compilerConfiguration.getOutputFile(items[x], conf, false));
            }
        }
        return linkObjects.toString();
    }

    private static String getTestObjectFiles(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf) {
        Item[] items = ConfigurationMakefileWriter.getSortedProjectItems(projectDescriptor);
        StringBuilder linkObjects = new StringBuilder();
        if (conf.isCompileConfiguration()) {
            for (int x = 0; x < items.length; ++x) {
                ItemConfiguration itemConfiguration;
                BasicCompilerConfiguration compilerConfiguration;
                Folder folder = items[x].getFolder();
                if (!folder.isTest() || (compilerConfiguration = (itemConfiguration = items[x].getItemConfiguration(conf)).getCompilerConfiguration()) == null) continue;
                String outputFile = compilerConfiguration.getOutputFile(items[x], conf, false);
                linkObjects.append(" \\\n\t");
                linkObjects.append(outputFile);
            }
        }
        return linkObjects.toString();
    }

    private static String getTestTargetFiles(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf) {
        StringBuilder testTargets = new StringBuilder();
        if (conf.isCompileConfiguration()) {
            for (Folder folder : ConfigurationMakefileWriter.getTests(projectDescriptor)) {
                testTargets.append(" \\\n\t");
                String target = folder.getFolderConfiguration(conf).getLinkerConfiguration().getOutputValue();
                testTargets.append(target);
            }
        }
        return testTargets.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMakefileVariables(MakeConfigurationDescriptor conf, Collection<MakeConfiguration> okConfs) throws IOException {
        FileObject nbprojectFileObject = this.projectDescriptor.getNbprojectFileObject();
        if (nbprojectFileObject == null) {
            return;
        }
        OutputStream os = null;
        BufferedWriter bw = null;
        try {
            Map<String, String> old = this.getOldVariables(nbprojectFileObject);
            FileObject vars = FileUtil.createData((FileObject)nbprojectFileObject, (String)"Makefile-variables.mk");
            Charset encoding = FileEncodingQuery.getEncoding((FileObject)vars);
            os = SmartOutputStream.getSmartOutputStream(vars);
            bw = new BufferedWriter(new OutputStreamWriter(os, encoding));
            this.writeMakefileFixedVariablesBody(bw, okConfs, old);
            this.writeMakefileVariablesRedirector(bw);
            this.closeWriter(bw);
            this.closeOutputStream(os);
        }
        catch (Throwable throwable) {
            this.closeWriter(bw);
            this.closeOutputStream(os);
            throw throwable;
        }
        FileObject nbPrivateProjectFileObject = this.projectDescriptor.getNbPrivateProjectFileObject();
        if (nbPrivateProjectFileObject == null) {
            return;
        }
        try {
            Map<String, String> old = this.getOldVariables(nbPrivateProjectFileObject);
            FileObject vars = FileUtil.createData((FileObject)nbPrivateProjectFileObject, (String)"Makefile-variables.mk");
            Charset encoding = FileEncodingQuery.getEncoding((FileObject)vars);
            os = SmartOutputStream.getSmartOutputStream(vars);
            bw = new BufferedWriter(new OutputStreamWriter(os, encoding));
            this.writeMakefilePrivateVariablesBody(bw, okConfs, old);
        }
        finally {
            this.closeWriter(bw);
            this.closeOutputStream(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getOldVariables(FileObject nbprojectFileObject) throws IOException {
        HashMap<String, String> old = new HashMap<String, String>();
        FileObject oldVars = nbprojectFileObject.getFileObject("Makefile-variables.mk");
        BufferedReader reader = null;
        try {
            if (oldVars != null && oldVars.isValid()) {
                Charset encoding = FileEncodingQuery.getEncoding((FileObject)oldVars);
                reader = new BufferedReader(new InputStreamReader(oldVars.getInputStream(), encoding));
                String current = null;
                StringBuilder currentBuf = null;
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).startsWith("#")) {
                        if (current != null) {
                            old.put(current, currentBuf.toString());
                        }
                        current = null;
                        currentBuf = null;
                    }
                    if (line.startsWith("# ") && line.endsWith(" configuration")) {
                        current = line.substring(2, line.length() - 14);
                        currentBuf = new StringBuilder();
                    }
                    if (current != null) {
                        currentBuf.append(line);
                        currentBuf.append('\n');
                    }
                    line = reader.readLine();
                }
                if (current != null) {
                    old.put(current, currentBuf.toString());
                }
            }
        }
        finally {
            this.closeReader(reader);
        }
        return old;
    }

    private void writeMakefileVariablesRedirector(BufferedWriter bw) throws IOException {
        bw.write("#\n");
        bw.write("# include compiler specific variables\n");
        bw.write("#\n");
        bw.write("# dmake command\n");
        bw.write("ROOT:sh = test -f nbproject/private/Makefile-variables.mk || \\\n");
        bw.write("\t(mkdir -p nbproject/private && touch nbproject/private/Makefile-variables.mk)\n");
        bw.write("#\n");
        bw.write("# gmake command\n");
        bw.write(".PHONY: $(shell test -f nbproject/private/Makefile-variables.mk || (mkdir -p nbproject/private && touch nbproject/private/Makefile-variables.mk))\n");
        bw.write("#\n");
        bw.write("include nbproject/private/Makefile-variables.mk\n");
    }

    private void writeMakefileFixedVariablesBody(BufferedWriter bw, Collection<MakeConfiguration> okConfs, Map<String, String> old) throws IOException {
        bw.write("#\n");
        bw.write("# Generated - do not edit!\n");
        bw.write("#\n");
        bw.write("# NOCDDL\n");
        bw.write("#\n");
        bw.write("CND_BASEDIR=`pwd`\n");
        bw.write("CND_BUILDDIR=build\n");
        bw.write("CND_DISTDIR=dist\n");
        Configuration[] confs = this.projectDescriptor.getConfs().toArray();
        for (int i = 0; i < confs.length; ++i) {
            MakeConfiguration makeConf = (MakeConfiguration)confs[i];
            if (okConfs.contains(makeConf)) {
                bw.write("# " + makeConf.getName() + " configuration\n");
                bw.write("CND_PLATFORM_" + makeConf.getName() + "=" + makeConf.getVariant());
                bw.write("\n");
                String outputPath = makeConf.expandMacros(makeConf.getOutputValue());
                String outputDir = CndPathUtilities.getDirName((String)outputPath);
                if (outputDir == null) {
                    outputDir = "";
                }
                String outputName = CndPathUtilities.getBaseName((String)outputPath);
                bw.write("CND_ARTIFACT_DIR_" + makeConf.getName() + "=" + outputDir);
                bw.write("\n");
                bw.write("CND_ARTIFACT_NAME_" + makeConf.getName() + "=" + outputName);
                bw.write("\n");
                bw.write("CND_ARTIFACT_PATH_" + makeConf.getName() + "=" + outputPath);
                bw.write("\n");
                PackagerDescriptor packager = PackagerManager.getDefault().getPackager(makeConf.getPackagingConfiguration().getType().getValue());
                outputPath = makeConf.expandMacros(makeConf.getPackagingConfiguration().getOutputValue());
                if (!packager.isOutputAFolder()) {
                    outputDir = CndPathUtilities.getDirName((String)outputPath);
                    if (outputDir == null) {
                        outputDir = "";
                    }
                    outputName = CndPathUtilities.getBaseName((String)outputPath);
                } else {
                    outputDir = outputPath;
                    outputPath = "";
                    outputName = "";
                }
                bw.write("CND_PACKAGE_DIR_" + makeConf.getName() + "=" + outputDir);
                bw.write("\n");
                bw.write("CND_PACKAGE_NAME_" + makeConf.getName() + "=" + outputName);
                bw.write("\n");
                bw.write("CND_PACKAGE_PATH_" + makeConf.getName() + "=" + outputPath);
                bw.write("\n");
                continue;
            }
            if (!old.containsKey(makeConf.getName())) continue;
            bw.write(old.get(makeConf.getName()));
        }
    }

    private void writeMakefilePrivateVariablesBody(BufferedWriter bw, Collection<MakeConfiguration> okConfs, Map<String, String> old) throws IOException {
        bw.write("#\n");
        bw.write("# Generated - do not edit!\n");
        bw.write("#\n");
        bw.write("# NOCDDL\n");
        bw.write("#\n");
        Configuration[] confs = this.projectDescriptor.getConfs().toArray();
        for (int i = 0; i < confs.length; ++i) {
            MakeConfiguration makeConf = (MakeConfiguration)confs[i];
            if (okConfs.contains(makeConf)) {
                bw.write("# " + makeConf.getName() + " configuration\n");
                DatabaseProjectProvider provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class);
                if (provider == null) continue;
                provider.writePrivateVariables(makeConf, bw);
                continue;
            }
            if (!old.containsKey(makeConf.getName())) continue;
            bw.write(old.get(makeConf.getName()));
        }
    }

    private void writePackagingScript(MakeConfiguration conf) {
        OutputStream os;
        if (conf.getConfigurationType().getValue() == 0) {
            return;
        }
        if (conf.getPackagingConfiguration().getFiles().getValue().isEmpty()) {
            return;
        }
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(conf.getPackagingConfiguration().getType().getValue());
        if (packager == null || packager instanceof DummyPackager) {
            return;
        }
        String scriptName = this.getPackageScriptName(conf);
        FileObject projectBaseFO = this.projectDescriptor.getProject().getProjectDirectory();
        if (projectBaseFO == null) {
            return;
        }
        FileObject nbProjectFO = projectBaseFO.getFileObject("nbproject");
        if (nbProjectFO == null) {
            return;
        }
        FileObject outputFO = null;
        try {
            outputFO = nbProjectFO.getFileObject(scriptName);
            if (outputFO == null) {
                outputFO = nbProjectFO.createData(scriptName);
            }
            os = SmartOutputStream.getSmartOutputStream(outputFO);
        }
        catch (Exception e) {
            System.err.println("Cannot open for writing " + nbProjectFO + '/' + scriptName);
            e.printStackTrace(System.err);
            return;
        }
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)outputFO);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, encoding));
        try {
            this.writePackagingScriptBody(bw, conf);
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void writePackagingScriptBody(BufferedWriter bw, MakeConfiguration conf) throws IOException {
        String tmpDirName = "tmp-packaging";
        String tmpdir = ConfigurationMakefileWriter.getObjectDir(conf) + "/" + tmpDirName;
        PackagingConfiguration packagingConfiguration = conf.getPackagingConfiguration();
        String output = packagingConfiguration.getOutputValue();
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(packagingConfiguration.getType().getValue());
        bw.write("#!/bin/bash");
        if (conf.getPackagingConfiguration().getVerbose().getValue()) {
            bw.write(" -x");
        }
        bw.write("\n");
        bw.write("\n");
        bw.write("#\n");
        bw.write("# Generated - do not edit!\n");
        bw.write("#\n");
        bw.write("\n");
        bw.write("# Macros\n");
        bw.write("TOP=`pwd`\n");
        bw.write("CND_PLATFORM=" + conf.getVariant() + "\n");
        bw.write("CND_CONF=" + conf.getName() + "\n");
        bw.write("CND_DISTDIR=dist\n");
        bw.write("CND_BUILDDIR=build\n");
        bw.write("CND_DLIB_EXT=" + conf.getLibraryExtension() + "\n");
        bw.write("NBTMPDIR=" + tmpdir + "\n");
        bw.write("TMPDIRNAME=" + tmpDirName + "\n");
        String projectOutput = conf.getOutputValue();
        if (projectOutput == null || projectOutput.length() == 0) {
            projectOutput = "MissingOutputInProject";
        }
        bw.write("OUTPUT_PATH=" + projectOutput + "\n");
        bw.write("OUTPUT_BASENAME=" + CndPathUtilities.getBaseName((String)projectOutput) + "\n");
        bw.write("PACKAGE_TOP_DIR=" + (packagingConfiguration.getTopDirValue().length() > 0 ? packagingConfiguration.getTopDirValue() + "/" : "") + "\n");
        bw.write("\n");
        bw.write("# Functions\n");
        bw.write("function checkReturnCode\n");
        bw.write("{\n");
        bw.write("    rc=$?\n");
        bw.write("    if [ $rc != 0 ]\n");
        bw.write("    then\n");
        bw.write("        exit $rc\n");
        bw.write("    fi\n");
        bw.write("}\n");
        bw.write("function makeDirectory\n");
        bw.write("# $1 directory path\n");
        bw.write("# $2 permission (optional)\n");
        bw.write("{\n");
        bw.write("    mkdir -p \"$1\"\n");
        bw.write("    checkReturnCode\n");
        bw.write("    if [ \"$2\" != \"\" ]\n");
        bw.write("    then\n");
        bw.write("      chmod $2 \"$1\"\n");
        bw.write("      checkReturnCode\n");
        bw.write("    fi\n");
        bw.write("}\n");
        bw.write("function copyFileToTmpDir\n");
        bw.write("# $1 from-file path\n");
        bw.write("# $2 to-file path\n");
        bw.write("# $3 permission\n");
        bw.write("{\n");
        bw.write("    cp \"$1\" \"$2\"\n");
        bw.write("    checkReturnCode\n");
        bw.write("    if [ \"$3\" != \"\" ]\n");
        bw.write("    then\n");
        bw.write("        chmod $3 \"$2\"\n");
        bw.write("        checkReturnCode\n");
        bw.write("    fi\n");
        bw.write("}\n");
        bw.write("\n");
        bw.write("# Setup\n");
        bw.write("cd \"${TOP}\"\n");
        if (packager.isOutputAFolder()) {
            bw.write("mkdir -p " + output + "\n");
        } else {
            bw.write("mkdir -p " + CndPathUtilities.getDirName((String)output) + "\n");
        }
        bw.write("rm -rf ${NBTMPDIR}\n");
        bw.write("mkdir -p ${NBTMPDIR}\n");
        bw.write("\n");
        packager.getShellFileWriter().writeShellScript(bw, conf, packagingConfiguration);
        bw.write("# Cleanup\n");
        bw.write("cd \"${TOP}\"\n");
        bw.write("rm -rf ${NBTMPDIR}\n");
    }

    private static boolean hasTests(MakeConfigurationDescriptor projectDescriptor) {
        return !ConfigurationMakefileWriter.getTests(projectDescriptor).isEmpty();
    }

    private static List<Folder> getTests(MakeConfigurationDescriptor projectDescriptor) {
        Folder root = projectDescriptor.getLogicalFolders();
        Folder testRootFolder = null;
        for (Folder folder : root.getFolders()) {
            if (!folder.isTestRootFolder()) continue;
            testRootFolder = folder;
            break;
        }
        if (testRootFolder != null) {
            return testRootFolder.getAllTests();
        }
        return Collections.emptyList();
    }

    private static String getString(String s) {
        return NbBundle.getMessage(ConfigurationMakefileWriter.class, (String)s);
    }

    private static String getString(String s, String arg1) {
        return NbBundle.getMessage(ConfigurationMakefileWriter.class, (String)s, (Object)arg1);
    }

    private static String getString(String s, String arg1, String arg2) {
        return NbBundle.getMessage(ConfigurationMakefileWriter.class, (String)s, (Object)arg1, (Object)arg2);
    }

    private void closeReader(BufferedReader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeWriter(BufferedWriter bw) {
        if (bw != null) {
            try {
                bw.flush();
                bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeOutputStream(OutputStream os) {
        if (os != null) {
            try {
                os.flush();
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

