/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import org.netbeans.modules.cnd.api.project.CodeAssistance;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public enum StateCA {
    ParsedSource,
    ExtraParsedSource,
    ParsedOrphanHeader,
    IncludedHeader,
    ExcludedSource,
    ExcludedHeader,
    NotYetParsed;


    public static StateCA getState(Configuration configuration, Item item, ItemConfiguration itemConfiguration) {
        boolean source = itemConfiguration.isCompilerToolConfiguration();
        CodeAssistance.State caState = StateCA.getCodeAssistanceState(item);
        switch (caState) {
            case ParsedSource: {
                return itemConfiguration.getExcluded().getValue() ? ExtraParsedSource : ParsedSource;
            }
            case ParsedOrphanHeader: {
                return ParsedOrphanHeader;
            }
            case ParsedIncludedHeader: {
                return IncludedHeader;
            }
            case NotParsed: {
                if (!item.isExcluded()) {
                    return NotYetParsed;
                }
                return source ? ExcludedSource : ExcludedHeader;
            }
        }
        throw new IllegalStateException("unexpected CodeAssistance.State " + caState);
    }

    private static CodeAssistance.State getCodeAssistanceState(Item item) {
        CodeAssistance CAProvider = (CodeAssistance)Lookup.getDefault().lookup(CodeAssistance.class);
        if (CAProvider != null) {
            return CAProvider.getCodeAssistanceState((NativeFileItem)item);
        }
        return CodeAssistance.State.NotParsed;
    }

    public String toString() {
        return NbBundle.getMessage(StateCA.class, (String)("CodeAssistanceItem_" + this.name()));
    }
}

