/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.launchers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.netbeans.modules.cnd.makeproject.launchers.LaunchersRegistry;
import org.netbeans.modules.cnd.makeproject.launchers.LaunchersRegistryFactory;
import org.netbeans.modules.cnd.makeproject.spi.ProjectMetadataFactory;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class LaunchersProjectMetadataFactory
implements ProjectMetadataFactory {
    public static final String NAME = "launcher.properties";
    private static final String USG_CND_LAUNCHERS = "USG_CND_LAUNCHERS";

    @Override
    public void read(FileObject projectDir) {
        if (projectDir == null || !projectDir.isValid()) {
            return;
        }
        FileObject nbproject = projectDir.getFileObject("nbproject");
        FileChangeListenerImpl fileChangeListener = new FileChangeListenerImpl(projectDir);
        if (nbproject != null && nbproject.isValid()) {
            nbproject.addFileChangeListener((FileChangeListener)fileChangeListener);
        }
        this.initListeners(fileChangeListener, projectDir);
        LaunchersProjectMetadataFactory.reload(projectDir);
    }

    private void initListeners(FileChangeListener fileChangeListener, FileObject projectDir) {
        FileObject privateNbFolder;
        FileObject nbproject = projectDir.getFileObject("nbproject");
        FileObject publicLaunchers = nbproject.getFileObject(NAME);
        if (publicLaunchers != null) {
            publicLaunchers.removeFileChangeListener(fileChangeListener);
            publicLaunchers.addFileChangeListener(fileChangeListener);
        }
        if ((privateNbFolder = projectDir.getFileObject("nbproject/private")) != null && privateNbFolder.isValid()) {
            privateNbFolder.removeFileChangeListener(fileChangeListener);
            privateNbFolder.addFileChangeListener(fileChangeListener);
            FileObject privateLaunchers = privateNbFolder.getFileObject(NAME);
            if (privateLaunchers != null) {
                privateLaunchers.removeFileChangeListener(fileChangeListener);
                privateLaunchers.addFileChangeListener(fileChangeListener);
                LaunchersRegistryFactory.getInstance(projectDir).setPrivateLaucnhersListener(fileChangeListener);
            }
        }
    }

    @Override
    public void write(FileObject projectDir) {
    }

    private static void reload(FileObject projectDir) {
        LaunchersRegistry launchersRegistry = LaunchersRegistryFactory.getInstance(projectDir);
        Properties properties = new Properties();
        FileObject nbProjectFolder = projectDir.getFileObject("nbproject");
        if (nbProjectFolder == null || !nbProjectFolder.isValid()) {
            return;
        }
        FileObject publicLaunchers = nbProjectFolder.getFileObject(NAME);
        FileObject privateNbFolder = projectDir.getFileObject("nbproject/private");
        FileObject privateLaunchers = null;
        if (privateNbFolder != null && privateNbFolder.isValid()) {
            privateLaunchers = privateNbFolder.getFileObject(NAME);
        }
        try {
            InputStream inputStream;
            if (publicLaunchers != null && publicLaunchers.isValid()) {
                inputStream = publicLaunchers.getInputStream();
                properties.load(inputStream);
                inputStream.close();
            }
            if (privateLaunchers != null && privateLaunchers.isValid()) {
                inputStream = privateLaunchers.getInputStream();
                properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (launchersRegistry.load(properties)) {
            UIGesturesSupport.submit((String)USG_CND_LAUNCHERS, (Object[])new Object[]{launchersRegistry.getLaunchers().size()});
        }
    }

    private class FileChangeListenerImpl
    implements FileChangeListener {
        private final FileObject projectDir;

        public FileChangeListenerImpl(FileObject projectDir) {
            this.projectDir = projectDir;
        }

        public void fileFolderCreated(FileEvent fe) {
            LaunchersProjectMetadataFactory.this.initListeners(this, this.projectDir);
        }

        public void fileDataCreated(FileEvent fe) {
            LaunchersProjectMetadataFactory.this.initListeners(this, this.projectDir);
            LaunchersProjectMetadataFactory.reload(this.projectDir);
        }

        public void fileChanged(FileEvent fe) {
            LaunchersProjectMetadataFactory.reload(this.projectDir);
        }

        public void fileDeleted(FileEvent fe) {
            fe.getFile().removeFileChangeListener((FileChangeListener)this);
            LaunchersProjectMetadataFactory.reload(this.projectDir);
        }

        public void fileRenamed(FileRenameEvent fe) {
            LaunchersProjectMetadataFactory.reload(this.projectDir);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

