/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.util.NbBundle;

public class SVR4Packager
implements PackagerDescriptor {
    public static final String PACKAGER_NAME = "SVR4";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return SVR4Packager.getString("SCR4Package");
    }

    @Override
    public boolean hasInfoList() {
        return true;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        String defArch = makeConfiguration.getDevelopmentHost().getBuildPlatform() == 1 ? "i386" : (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 0 ? "sparc" : "i386");
        ArrayList<PackagerInfoElement> infoList = new ArrayList<PackagerInfoElement>();
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "PKG", packagingConfiguration.getOutputName(), true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "NAME", "Package description ...", true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "ARCH", defArch, true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "CATEGORY", "application", true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "VERSION", "1.0", true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "BASEDIR", "/opt", false, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "PSTAMP", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()), false, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "CLASSES", "none", false, true));
        return infoList;
    }

    @Override
    public List<String> getOptionalInfoList() {
        ArrayList<String> entryComboBox = new ArrayList<String>();
        entryComboBox.add("BASEDIR");
        entryComboBox.add("CLASSES");
        entryComboBox.add("DESC");
        entryComboBox.add("EMAIL");
        entryComboBox.add("HOTLINE");
        entryComboBox.add("INTONLY");
        entryComboBox.add("ISTATES");
        entryComboBox.add("MAXINST");
        entryComboBox.add("ORDER");
        entryComboBox.add("PSTAMP");
        entryComboBox.add("RSTATES");
        entryComboBox.add("SUNW_ISA");
        entryComboBox.add("SUNW_LOC");
        entryComboBox.add("SUNW_PKG_DIR");
        entryComboBox.add("SUNW_PKG_ALLZONES");
        entryComboBox.add("SUNW_PKG_HOLLOW");
        entryComboBox.add("SUNW_PKG_THISZONE");
        entryComboBox.add("SUNW_PKGLIST");
        entryComboBox.add("SUNW_PKGTYPE");
        entryComboBox.add("SUNW_PKGVERS");
        entryComboBox.add("SUNW_PRODNAME");
        entryComboBox.add("SUNW_PRODVERS");
        entryComboBox.add("ULIMIT");
        entryComboBox.add("VENDOR");
        entryComboBox.add("VSTOCK");
        return entryComboBox;
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultTool() {
        return "pkgmk";
    }

    @Override
    public boolean isOutputAFolder() {
        return true;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return null;
    }

    @Override
    public String getOutputFileSuffix() {
        return null;
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return packagingConfiguration.findInfoValueName("PKG");
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return true;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String s) {
        return NbBundle.getMessage(SVR4Packager.class, (String)s);
    }

    public static class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        @Override
        public void writeShellScript(BufferedWriter bw, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodySVR4(bw, makeConfiguration);
        }

        private List<String> findUndefinedDirectories(PackagingConfiguration packagingConfiguration) {
            String path;
            List<PackagerFileElement> fileList = packagingConfiguration.getFiles().getValue();
            HashSet<String> set = new HashSet<String>();
            ArrayList<String> list = new ArrayList<String>();
            for (PackagerFileElement elem : fileList) {
                if (elem.getType() != PackagerFileElement.FileType.DIRECTORY) continue;
                path = packagingConfiguration.expandMacros(elem.getTo());
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                set.add(path);
            }
            for (PackagerFileElement elem : fileList) {
                if (elem.getType() != PackagerFileElement.FileType.FILE && elem.getType() != PackagerFileElement.FileType.SOFTLINK) continue;
                path = CndPathUtilities.getDirName((String)packagingConfiguration.expandMacros(elem.getTo()));
                String base = "";
                if (path == null || path.length() <= 0) continue;
                StringTokenizer tokenizer = new StringTokenizer(path, "/");
                while (tokenizer.hasMoreTokens()) {
                    if (base.length() > 0) {
                        base = base + "/";
                    }
                    if (set.contains(base = base + tokenizer.nextToken())) continue;
                    set.add(base);
                    list.add(base);
                }
            }
            return list;
        }

        private void writePackagingScriptBodySVR4(BufferedWriter bw, MakeConfiguration conf) throws IOException {
            PackagingConfiguration packagingConfiguration = conf.getPackagingConfiguration();
            String packageName = packagingConfiguration.findInfoValueName("PKG");
            bw.write("# Create pkginfo and prototype files\n");
            bw.write("PKGINFOFILE=${NBTMPDIR}/pkginfo\n");
            bw.write("PROTOTYPEFILE=${NBTMPDIR}/prototype\n");
            bw.write("rm -f $PKGINFOFILE $PROTOTYPEFILE\n");
            bw.write("\n");
            bw.write("cd \"${TOP}\"\n");
            List<PackagerInfoElement> infoList = packagingConfiguration.getHeaderSubList(SVR4Packager.PACKAGER_NAME);
            for (PackagerInfoElement elem : infoList) {
                bw.write("echo '" + elem.getName() + "=\"" + packagingConfiguration.expandMacros(elem.getValue()) + "\"'" + " >> $PKGINFOFILE\n");
            }
            bw.write("\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("echo \"i pkginfo=pkginfo\" >> $PROTOTYPEFILE\n");
            bw.write("\n");
            for (String addInfo : packagingConfiguration.getAdditionalInfo().getValue()) {
                bw.write("echo \"i " + addInfo + "\" >> $PROTOTYPEFILE\n");
            }
            bw.write("\n");
            List<String> dirList = this.findUndefinedDirectories(packagingConfiguration);
            for (String dir : dirList) {
                bw.write("echo \"");
                bw.write("d");
                bw.write(" none");
                bw.write(" " + dir);
                bw.write(" 0" + MakeOptions.getInstance().getDefExePerm());
                bw.write(" " + MakeOptions.getInstance().getDefOwner());
                bw.write(" " + MakeOptions.getInstance().getDefGroup());
                bw.write("\"");
                bw.write(" >> $PROTOTYPEFILE\n");
            }
            bw.write("\n");
            List<PackagerFileElement> fileList = packagingConfiguration.getFiles().getValue();
            for (PackagerFileElement elem : fileList) {
                bw.write("echo \"");
                if (elem.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bw.write("d");
                } else if (elem.getType() == PackagerFileElement.FileType.FILE) {
                    bw.write("f");
                } else if (elem.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    bw.write("s");
                } else assert (false);
                bw.write(" none");
                bw.write(" " + elem.getTo());
                if (elem.getFrom().length() > 0) {
                    String from = elem.getFrom();
                    if (CndPathUtilities.isPathAbsolute((CharSequence)from)) {
                        from = CndPathUtilities.toRelativePath((String)conf.getBaseDir(), (String)from);
                    }
                    bw.write("=" + from);
                }
                if (elem.getType() != PackagerFileElement.FileType.SOFTLINK) {
                    bw.write(" 0" + elem.getPermission());
                    bw.write(" " + elem.getOwner());
                    bw.write(" " + elem.getGroup());
                }
                bw.write("\"");
                bw.write(" >> $PROTOTYPEFILE\n");
            }
            bw.write("\n");
            bw.write("# Make package\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write(packagingConfiguration.getToolValue() + " " + packagingConfiguration.getOptionsValue() + " -o -f $PROTOTYPEFILE -r . -d $NBTMPDIR\n");
            bw.write("checkReturnCode\n");
            bw.write("rm -rf " + packagingConfiguration.getOutputValue() + "/" + packageName + "\n");
            bw.write("mv ${NBTMPDIR}/" + packageName + " " + packagingConfiguration.getOutputValue() + "\n");
            bw.write("checkReturnCode\n");
            bw.write("echo Solaris SVR4: " + packagingConfiguration.getOutputValue() + "/" + packageName + "\n");
            bw.write("\n");
        }
    }
}

