/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.CodeAssistance;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.actions.CreateProjectAction;
import org.netbeans.modules.cnd.makeproject.actions.DebugDialogAction;
import org.netbeans.modules.cnd.makeproject.actions.NewTestActionFactory;
import org.netbeans.modules.cnd.makeproject.actions.RunDialogAction;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.NodeActionFactory;
import org.netbeans.modules.cnd.makeproject.ui.ProjectNodesRefreshSupport;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesItemAction;
import org.netbeans.modules.cnd.makeproject.ui.RefreshableItemsContainer;
import org.netbeans.modules.cnd.makeproject.ui.RemoveItemAction;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

final class ViewItemNode
extends FilterNode
implements ChangeListener {
    private static final RequestProcessor RP = new RequestProcessor("ViewItemNode", 1);
    private static CodeAssistance cachedCA;
    private static final MessageFormat ITEM_VIEW_FLAVOR;
    private RefreshableItemsContainer childrenKeys;
    private Folder folder;
    private Item item;
    private volatile boolean itemIsExcludedCache = false;
    private final MakeProject project;
    private final ProjectNodesRefreshSupport.ProjectNodeRefreshListener refreshListener;
    private final boolean simpleRunDebug;
    private Action runAction;
    private final VisualUpdater visualUpdater = new VisualUpdater();
    private static final Map<BufferedImage, Image> grayImageCache;

    public ViewItemNode(RefreshableItemsContainer childrenKeys, Folder folder, Item item, DataObject dataObject, MakeProject project, boolean simpleRunDebug) {
        super(dataObject.getNodeDelegate());
        this.childrenKeys = childrenKeys;
        this.folder = folder;
        this.item = item;
        this.setShortDescription(item.getNormalizedPath());
        this.project = project;
        this.refreshListener = new ProjectNodesRefreshSupport.ProjectNodeRefreshListener(){

            @Override
            public void refresh(Project project) {
                if (ViewItemNode.this.getParentNode() == null) {
                    return;
                }
                if (project == ViewItemNode.this.project) {
                    ViewItemNode.this.visualUpdater.postIfNeed();
                }
            }
        };
        ProjectNodesRefreshSupport.addProjectNodeRefreshListener((ProjectNodesRefreshSupport.ProjectNodeRefreshListener)WeakListeners.create(ProjectNodesRefreshSupport.ProjectNodeRefreshListener.class, (EventListener)this.refreshListener, ProjectNodesRefreshSupport.class));
        this.simpleRunDebug = simpleRunDebug;
        CodeAssistance CAProvider = this.getCodeAssistance();
        if (CAProvider != null) {
            CAProvider.addChangeListener((ChangeListener)this);
        }
        this.itemIsExcludedCache = this.isExcluded();
    }

    public ViewItemNode(RefreshableItemsContainer childrenKeys, Folder folder, Item item, DataObject dataObject, MakeProject project) {
        this(childrenKeys, folder, item, dataObject, project, false);
    }

    public void setName(final String s) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                ViewItemNode.super.setName(s.trim());
            }
        });
    }

    static RequestProcessor getRP() {
        return RP;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Item getItem() {
        return this.item;
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        return this.addViewItemTransferable(super.clipboardCopy(), 1);
    }

    public Transferable clipboardCut() throws IOException {
        return this.addViewItemTransferable(super.clipboardCut(), 2);
    }

    public Transferable drag() throws IOException {
        return this.addViewItemTransferable(super.drag(), 0);
    }

    private ExTransferable addViewItemTransferable(Transferable t, int operation) {
        try {
            ExTransferable extT = ExTransferable.create((Transferable)t);
            ViewItemTransferable viewItem = new ViewItemTransferable(this, operation);
            extT.put((ExTransferable.Single)viewItem);
            return extT;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void destroy() throws IOException {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewItemNode.super.destroy();
                    ViewItemNode.this.folder.removeItemAction(ViewItemNode.this.item);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    public Object getValue(String valstring) {
        if (valstring == null) {
            return super.getValue(null);
        }
        if (valstring.equals("Folder")) {
            return this.getFolder();
        }
        if (valstring.equals("Project")) {
            return this.project;
        }
        if (valstring.equals("Item")) {
            return this.getItem();
        }
        if (valstring.equals("This")) {
            return this;
        }
        if (valstring.equals("slowRename")) {
            return null;
        }
        return super.getValue(valstring);
    }

    private Action getRunAction(Action action) {
        if (action instanceof RunDialogAction && this.runAction == null) {
            RunDialogAction runDialogAction = (RunDialogAction)((Object)action);
            ((Object)((Object)runDialogAction)).getClass();
            this.runAction = runDialogAction.new RunDialogAction.SimpleRunActionProxy(this.project, this.item.getAbsolutePath());
        }
        return this.runAction;
    }

    public Action getPreferredAction() {
        if (this.simpleRunDebug && !this.getItem().getFolder().isDiskFolder() && MIMENames.isBinary((String)MIMESupport.getBinaryFileMIMEType((FileObject)this.getItem().getFileObject()))) {
            return this.getRunAction(super.getPreferredAction());
        }
        return super.getPreferredAction();
    }

    public Action[] getActions(boolean context) {
        Action[] oldActions = super.getActions(false);
        ArrayList<Action> newActions = new ArrayList<Action>();
        if (this.getItem().getFolder() == null) {
            return oldActions;
        }
        if (this.getItem().getFolder().isDiskFolder()) {
            for (int i = 0; i < oldActions.length; ++i) {
                String key = null;
                if (oldActions[i] != null) {
                    key = (String)oldActions[i].getValue("key");
                }
                if (oldActions[i] != null && oldActions[i] instanceof OpenAction) {
                    newActions.add(oldActions[i]);
                    newActions.add(null);
                    continue;
                }
                if (oldActions[i] != null && oldActions[i] instanceof PasteAction) {
                    newActions.add(oldActions[i]);
                    newActions.add(FileSensitiveActions.fileCommandAction((String)"compile.single", (String)NbBundle.getMessage(this.getClass(), (String)"CTL_CompileSingleAction"), null));
                    continue;
                }
                if (oldActions[i] != null && oldActions[i] instanceof RenameAction) {
                    newActions.add((Action)((Object)NodeActionFactory.createRenameAction()));
                    NodeActionFactory.addSyncActions(newActions);
                    continue;
                }
                if (key != null && key.equals("delete")) {
                    newActions.add((Action)((Object)NodeActionFactory.createDeleteAction()));
                    continue;
                }
                if (oldActions[i] != null && oldActions[i] instanceof PropertiesAction && this.getFolder().isProjectFiles()) {
                    newActions.add((Action)SystemAction.get(PropertiesItemAction.class));
                    continue;
                }
                if (key != null && ("CndCompileAction".equals(key) || "CndCompileRunAction".equals(key) || "CndCompileDebugAction".equals(key))) continue;
                newActions.add(oldActions[i]);
            }
            return newActions.toArray(new Action[newActions.size()]);
        }
        for (int i = 0; i < oldActions.length; ++i) {
            String key = null;
            if (oldActions[i] != null) {
                key = (String)oldActions[i].getValue("key");
            }
            if (oldActions[i] != null && oldActions[i] instanceof OpenAction) {
                newActions.add(oldActions[i]);
                newActions.add(null);
                continue;
            }
            if (oldActions[i] != null && oldActions[i] instanceof PasteAction) {
                newActions.add(oldActions[i]);
                newActions.add(FileSensitiveActions.fileCommandAction((String)"compile.single", (String)NbBundle.getMessage(this.getClass(), (String)"CTL_CompileSingleAction"), null));
                if (this.getItem().getFolder().isTest()) continue;
                newActions.add(NewTestActionFactory.createNewTestsSubmenu());
                continue;
            }
            if (oldActions[i] != null && oldActions[i] instanceof RenameAction) {
                newActions.add((Action)((Object)NodeActionFactory.createRenameAction()));
                NodeActionFactory.addSyncActions(newActions);
                continue;
            }
            if (oldActions[i] != null && oldActions[i] instanceof PropertiesAction && this.getFolder().isProjectFiles()) {
                newActions.add((Action)SystemAction.get(PropertiesItemAction.class));
                continue;
            }
            if (key != null && key.equals("delete")) {
                newActions.add((Action)SystemAction.get(RemoveItemAction.class));
                newActions.add((Action)((Object)NodeActionFactory.createDeleteAction()));
                continue;
            }
            if (this.simpleRunDebug && key != null && key.equals("CndDebugCorefileNodeAction") || this.simpleRunDebug && oldActions[i] != null && oldActions[i] instanceof CreateProjectAction) continue;
            if (this.simpleRunDebug && oldActions[i] != null && oldActions[i] instanceof RunDialogAction) {
                newActions.add(this.getRunAction(oldActions[i]));
                continue;
            }
            if (this.simpleRunDebug && oldActions[i] != null && oldActions[i] instanceof DebugDialogAction) {
                DebugDialogAction debugDialogAction = (DebugDialogAction)((Object)oldActions[i]);
                ((Object)((Object)debugDialogAction)).getClass();
                newActions.add(debugDialogAction.new DebugDialogAction.SimpleDebugActionProxy(this.project, this.item.getAbsolutePath()));
                continue;
            }
            if (key != null && ("CndCompileAction".equals(key) || "CndCompileRunAction".equals(key) || "CndCompileDebugAction".equals(key))) continue;
            newActions.add(oldActions[i]);
        }
        return newActions.toArray(new Action[newActions.size()]);
    }

    public Image getIcon(int type) {
        Image image = super.getIcon(type);
        if (this.itemIsExcludedCache && image instanceof BufferedImage) {
            image = ViewItemNode.getGrayImage((BufferedImage)image);
        }
        return image;
    }

    private static Image getGrayImage(BufferedImage image) {
        Image gray = grayImageCache.get(image);
        if (gray == null) {
            ColorSpace gray_space = ColorSpace.getInstance(1003);
            ColorConvertOp convert_to_gray_op = new ColorConvertOp(gray_space, null);
            gray = convert_to_gray_op.filter(image, null);
            grayImageCache.put(image, gray);
        }
        return gray;
    }

    public String getHtmlDisplayName() {
        if (this.itemIsExcludedCache) {
            String baseName = super.getHtmlDisplayName();
            if (baseName != null && baseName.toLowerCase(Locale.getDefault()).contains("color=")) {
                return baseName;
            }
            baseName = baseName != null ? baseName : this.getDisplayName();
            return "<font color='!controlShadow'>" + baseName;
        }
        return super.getHtmlDisplayName();
    }

    private boolean isExcluded() {
        CndUtils.assertNonUiThread();
        if (this.item == null || this.item.getFolder() == null || this.item.getFolder().getConfigurationDescriptor() == null || this.item.getFolder().getConfigurationDescriptor().getConfs() == null) {
            return false;
        }
        MakeConfiguration makeConfiguration = this.item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = this.item.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null) {
            return false;
        }
        CodeAssistance CAProvider = (CodeAssistance)Lookup.getDefault().lookup(CodeAssistance.class);
        if (CAProvider != null && CAProvider.hasCodeAssistance((NativeFileItem)this.item)) {
            return false;
        }
        BooleanConfiguration excl = itemConfiguration.getExcluded();
        return excl.getValue();
    }

    private CodeAssistance getCodeAssistance() {
        CodeAssistance res = cachedCA;
        if (res == null) {
            cachedCA = res = (CodeAssistance)Lookup.getDefault().lookup(CodeAssistance.class);
        }
        return res;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof FileObject) {
            if (source.equals(this.item.getFileObject())) {
                this.visualUpdater.postIfNeed();
            }
        } else if (source instanceof NativeProject) {
            if (source.equals(this.item.getNativeProject())) {
                this.visualUpdater.postIfNeed();
            }
        } else {
            this.visualUpdater.postIfNeed();
        }
    }

    static {
        ITEM_VIEW_FLAVOR = new MessageFormat("application/x-org-netbeans-modules-cnd-makeproject-uidnd; class=org.netbeans.modules.cnd.makeproject.ui.ViewItemNode; mask={0}");
        grayImageCache = new WeakHashMap<BufferedImage, Image>();
    }

    private static final class ViewItemTransferable
    extends ExTransferable.Single {
        private final ViewItemNode node;

        public ViewItemTransferable(ViewItemNode node, int operation) throws ClassNotFoundException {
            super(new DataFlavor(ITEM_VIEW_FLAVOR.format(new Object[]{operation}), null, MakeLogicalViewProvider.class.getClassLoader()));
            this.node = node;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }

    private class VisualUpdater
    implements Runnable {
        private final AtomicBoolean finished = new AtomicBoolean(true);

        private VisualUpdater() {
        }

        private void postIfNeed() {
            ViewItemNode.this.itemIsExcludedCache = ViewItemNode.this.isExcluded();
            if (this.finished.getAndSet(false)) {
                EventQueue.invokeLater(this);
            }
        }

        @Override
        public void run() {
            this.finished.set(true);
            ViewItemNode.this.fireIconChange();
            ViewItemNode.this.fireOpenedIconChange();
            String displayName = ViewItemNode.this.getDisplayName();
            ViewItemNode.this.fireDisplayNameChange(displayName, "");
            ViewItemNode.this.fireDisplayNameChange("", displayName);
        }
    }
}

