/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.AssemblerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.CCCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.CCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.CustomBuildItemCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.FortranCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.GeneralItemCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer;
import org.netbeans.modules.cnd.makeproject.ui.customizer.PropertyNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ItemNodeFactory {
    private ItemNodeFactory() {
    }

    public static Node createRootNodeItem(Lookup lookup) {
        MakeContext context = (MakeContext)lookup.lookup(MakeContext.class);
        PredefinedToolKind tool = context.getItemsTool();
        boolean procFile = context.isProc();
        int count = 1;
        if (tool != PredefinedToolKind.UnknownTool) {
            ++count;
            if (procFile) {
                ++count;
            }
        }
        CustomizerNode[] descriptions = new CustomizerNode[count];
        int index = 0;
        descriptions[index++] = ItemNodeFactory.createGeneralItemDescription(lookup);
        if (tool != PredefinedToolKind.UnknownTool) {
            if (tool == PredefinedToolKind.CCompiler) {
                descriptions[index++] = ItemNodeFactory.createCCompilerDescription(lookup);
                if (procFile) {
                    descriptions[index++] = ItemNodeFactory.createCustomBuildItemDescription(lookup);
                }
            } else if (tool == PredefinedToolKind.CCCompiler) {
                descriptions[index++] = ItemNodeFactory.createCCCompilerDescription(lookup);
                if (procFile) {
                    descriptions[index++] = ItemNodeFactory.createCustomBuildItemDescription(lookup);
                }
            } else {
                descriptions[index++] = tool == PredefinedToolKind.FortranCompiler ? ItemNodeFactory.createFortranCompilerDescription(lookup) : (tool == PredefinedToolKind.Assembler ? ItemNodeFactory.createAssemblerDescription(lookup) : (tool == PredefinedToolKind.CustomTool ? ItemNodeFactory.createCustomBuildItemDescription(lookup) : ItemNodeFactory.createCustomBuildItemDescription(lookup)));
            }
        }
        CustomizerNode rootDescription = new CustomizerNode("Configuration Properties", ItemNodeFactory.getString("CONFIGURATION_PROPERTIES"), descriptions, lookup);
        return new PropertyNode(rootDescription);
    }

    private static CustomizerNode createGeneralItemDescription(Lookup lookup) {
        return new GeneralItemCustomizerNode("GeneralItem", ItemNodeFactory.getString("LBL_Config_General"), null, lookup);
    }

    public static CustomizerNode createFortranCompilerDescription(Lookup lookup) {
        String compilerName = "fortran";
        String compilerDisplayName = PredefinedToolKind.FortranCompiler.getDisplayName();
        FortranCompilerCustomizerNode fortranCompilerCustomizerNode = new FortranCompilerCustomizerNode(compilerName, compilerDisplayName, null, lookup);
        return fortranCompilerCustomizerNode;
    }

    public static CustomizerNode createAssemblerDescription(Lookup lookup) {
        String compilerName = "as";
        String compilerDisplayName = PredefinedToolKind.Assembler.getDisplayName();
        AssemblerCustomizerNode assemblerCustomizerNode = new AssemblerCustomizerNode(compilerName, compilerDisplayName, null, lookup);
        return assemblerCustomizerNode;
    }

    public static CustomizerNode createCCCompilerDescription(Lookup lookup) {
        String compilerName = "cpp";
        String compilerDisplayName = PredefinedToolKind.CCCompiler.getDisplayName();
        CCCompilerCustomizerNode ccCompilerCustomizerNode = new CCCompilerCustomizerNode(compilerName, compilerDisplayName, null, lookup);
        return ccCompilerCustomizerNode;
    }

    public static CustomizerNode createCustomBuildItemDescription(Lookup lookup) {
        return new CustomBuildItemCustomizerNode("Custom Build Step", ItemNodeFactory.getString("LBL_Config_Custom_Build"), null, lookup);
    }

    public static CustomizerNode createCCompilerDescription(Lookup lookup) {
        String compilerName = "c";
        String compilerDisplayName = PredefinedToolKind.CCompiler.getDisplayName();
        CCompilerCustomizerNode cCompilerCustomizerNode = new CCompilerCustomizerNode(compilerName, compilerDisplayName, null, lookup);
        return cCompilerCustomizerNode;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(MakeCustomizer.class).getString(s);
    }
}

