/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectCustomizer;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerRootNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.DebuggerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.ArchiverGeneralCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.BuildCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.CodeAssistanceCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.CompileCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.FormattingCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.GeneralCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.ItemNodeFactory;
import org.netbeans.modules.cnd.makeproject.ui.customizer.LinkerGeneralCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakefileCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.PackagingCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.PreBuildCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.PropertyNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.QtCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.RequiredProjectsCustomizerNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProjectNodeFactory {
    private ProjectNodeFactory() {
    }

    public static Node createRootNodeProject(Lookup lookup) {
        MakeContext context = (MakeContext)lookup.lookup(MakeContext.class);
        boolean includeMakefileDescription = true;
        boolean includeRunDebugDescriptions = true;
        Configuration[] selectedConfigurations = context.getSelectedConfigurations();
        for (int i = 0; i < selectedConfigurations.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)selectedConfigurations[i];
            includeMakefileDescription &= makeConfiguration.isMakefileConfiguration();
        }
        List<CustomizerNode> uncheckedCustomizers = CustomizerRootNodeProvider.getInstance().getCustomizerNodes(lookup);
        ArrayList<CustomizerNode> descriptions = new ArrayList<CustomizerNode>();
        CustomizerNode node = ProjectNodeFactory.createGeneralDescription(lookup);
        if (node != null) {
            descriptions.add(node);
        }
        if ((node = ProjectNodeFactory.createBuildDescription(lookup)) != null) {
            descriptions.add(node);
        }
        List<CustomizerNode> runCustomizers = CustomizerRootNodeProvider.getInstance().getCustomizerNodes("Run", lookup);
        if (includeRunDebugDescriptions && !descriptions.addAll(runCustomizers)) {
            descriptions.add(ProjectNodeFactory.createNotFoundNode("Run"));
        }
        uncheckedCustomizers.removeAll(runCustomizers);
        List<CustomizerNode> profileCustomizers = CustomizerRootNodeProvider.getInstance().getCustomizerNodes("Profile", lookup);
        if (includeRunDebugDescriptions) {
            descriptions.addAll(profileCustomizers);
        }
        uncheckedCustomizers.removeAll(profileCustomizers);
        List<CustomizerNode> debugCustomizers = CustomizerRootNodeProvider.getInstance().getCustomizerNodes("Debug", lookup);
        if (includeRunDebugDescriptions) {
            descriptions.addAll(ProjectNodeFactory.getVisibleDebuggerNodes(debugCustomizers, lookup));
        }
        uncheckedCustomizers.removeAll(debugCustomizers);
        descriptions.addAll(uncheckedCustomizers);
        descriptions.add(ProjectNodeFactory.createRequiredProjectsDescription(lookup));
        if (includeMakefileDescription) {
            descriptions.add(ProjectNodeFactory.createCodeAssistantDescription(lookup));
        }
        descriptions.add(ProjectNodeFactory.createFormattingDescription(lookup));
        CustomizerNode rootDescription = new CustomizerNode("Configuration Properties", ProjectNodeFactory.getString("CONFIGURATION_PROPERTIES"), descriptions.toArray(new CustomizerNode[descriptions.size()]), lookup);
        MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)context.getConfigurationDescriptor();
        if (makeConfigurationDescriptor.hasProjectCustomizer()) {
            MakeProjectCustomizer makeprojectCustomizer = makeConfigurationDescriptor.getProjectCustomizer();
            rootDescription = makeprojectCustomizer.getRootPropertyNode(rootDescription);
        }
        return new PropertyNode(rootDescription);
    }

    private static CustomizerNode createGeneralDescription(Lookup lookup) {
        return new GeneralCustomizerNode("General", ProjectNodeFactory.getString("LBL_Config_General"), null, lookup);
    }

    private static CustomizerNode createFormattingDescription(Lookup lookup) {
        return new FormattingCustomizerNode("Formattinf", ProjectNodeFactory.getString("LBL_Formatting"), null, lookup);
    }

    private static CustomizerNode createBuildDescription(Lookup lookup) {
        MakeContext context = (MakeContext)lookup.lookup(MakeContext.class);
        boolean includeMakefileDescription = true;
        boolean includeQtDescription = true;
        boolean includeCompilerDescription = true;
        boolean includeLinkerDescription = true;
        boolean includeArchiverDescription = true;
        boolean isCompileConfiguration = context.isCompilerConfiguration();
        CompilerSet compilerSet = null;
        Configuration[] selectedConfigurations = context.getSelectedConfigurations();
        for (int i = 0; i < selectedConfigurations.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)selectedConfigurations[i];
            CompilerSet compilerSet2 = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet != null && compilerSet2 != compilerSet) {
                includeCompilerDescription = false;
            }
            compilerSet = compilerSet2;
            if (isCompileConfiguration && !makeConfiguration.isCompileConfiguration() || !isCompileConfiguration && makeConfiguration.isCompileConfiguration()) {
                includeCompilerDescription = false;
            }
            includeMakefileDescription &= makeConfiguration.isMakefileConfiguration();
            includeQtDescription &= makeConfiguration.isQmakeConfiguration();
            includeCompilerDescription &= !makeConfiguration.isMakefileConfiguration();
            includeLinkerDescription &= makeConfiguration.isApplicationConfiguration() || makeConfiguration.isDynamicLibraryConfiguration();
            includeArchiverDescription &= makeConfiguration.isLibraryConfiguration() && !makeConfiguration.isDynamicLibraryConfiguration() && !makeConfiguration.isQmakeConfiguration();
        }
        ArrayList<CustomizerNode> descriptions = new ArrayList<CustomizerNode>();
        if (includeMakefileDescription) {
            descriptions.add(ProjectNodeFactory.createPreBuildDescription(lookup));
            descriptions.add(ProjectNodeFactory.createMakefileDescription(lookup));
            descriptions.add(ProjectNodeFactory.createCompileDescription(lookup));
        }
        if (includeQtDescription) {
            descriptions.add(ProjectNodeFactory.createQtDescription(lookup));
        }
        if (includeCompilerDescription) {
            descriptions.addAll(ProjectNodeFactory.createCompilerNodes(lookup));
        }
        if (includeLinkerDescription) {
            descriptions.add(ProjectNodeFactory.createLinkerDescription(lookup));
        }
        if (includeArchiverDescription) {
            descriptions.add(ProjectNodeFactory.createArchiverDescription(lookup));
        }
        if (((MakeConfigurationDescriptor)context.getConfigurationDescriptor()).getActiveConfiguration() != null && ((MakeConfigurationDescriptor)context.getConfigurationDescriptor()).getActiveConfiguration().getConfigurationType().getValue() != 0) {
            descriptions.add(ProjectNodeFactory.createPackagingDescription(lookup));
        }
        return new BuildCustomizerNode("Build", ProjectNodeFactory.getString("LBL_Config_Build"), descriptions.toArray(new CustomizerNode[descriptions.size()]), lookup);
    }

    private static CustomizerNode createPreBuildDescription(Lookup lookup) {
        return new PreBuildCustomizerNode("PreBuild", ProjectNodeFactory.getString("LBL_PRE_BUILD_NODE"), null, lookup);
    }

    private static CustomizerNode createMakefileDescription(Lookup lookup) {
        return new MakefileCustomizerNode("Make", ProjectNodeFactory.getString("LBL_MAKE_NODE"), null, lookup);
    }

    private static CustomizerNode createCompileDescription(Lookup lookup) {
        return new CompileCustomizerNode("Compile", ProjectNodeFactory.getString("LBL_COMPILE_NODE"), null, lookup);
    }

    private static ArrayList<CustomizerNode> createCompilerNodes(Lookup lookup) {
        MakeContext context = (MakeContext)lookup.lookup(MakeContext.class);
        ArrayList<CustomizerNode> descriptions = new ArrayList<CustomizerNode>();
        if (!context.isQtMode()) {
            descriptions.add(ItemNodeFactory.createCCompilerDescription(lookup));
        }
        descriptions.add(ItemNodeFactory.createCCCompilerDescription(lookup));
        if (!context.isQtMode()) {
            descriptions.add(ItemNodeFactory.createFortranCompilerDescription(lookup));
            descriptions.add(ItemNodeFactory.createAssemblerDescription(lookup));
        }
        return descriptions;
    }

    private static CustomizerNode createLinkerDescription(Lookup lookup) {
        return new LinkerGeneralCustomizerNode("Linker", ProjectNodeFactory.getString("LBL_LINKER_NODE"), null, lookup);
    }

    private static CustomizerNode createArchiverDescription(Lookup lookup) {
        return new ArchiverGeneralCustomizerNode("Archiver", ProjectNodeFactory.getString("LBL_ARCHIVER_NODE"), null, lookup);
    }

    private static CustomizerNode createQtDescription(Lookup lookup) {
        return new QtCustomizerNode("Qt", ProjectNodeFactory.getString("LBL_QT_NODE"), null, lookup);
    }

    private static CustomizerNode createPackagingDescription(Lookup lookup) {
        return new PackagingCustomizerNode("Packaging", ProjectNodeFactory.getString("LBL_PACKAGING_NODE"), null, lookup);
    }

    private static CustomizerNode createRequiredProjectsDescription(Lookup lookup) {
        return new RequiredProjectsCustomizerNode("RequiredProjects", ProjectNodeFactory.getString("LBL_REQUIRED_PROJECTS_NODE"), null, lookup);
    }

    private static List<CustomizerNode> getVisibleDebuggerNodes(List<CustomizerNode> debuggerNodes, Lookup lookup) {
        MakeContext context = (MakeContext)lookup.lookup(MakeContext.class);
        Configuration[] selectedConfigurations = context.getSelectedConfigurations();
        ArrayList<CustomizerNode> res = new ArrayList<CustomizerNode>();
        if (debuggerNodes.size() > 1) {
            HashSet<String> families = new HashSet<String>();
            for (Configuration conf : selectedConfigurations) {
                MakeConfiguration makeConfiguration = (MakeConfiguration)conf;
                CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
                if (compilerSet == null) continue;
                families.addAll(Arrays.asList(compilerSet.getCompilerFlavor().getToolchainDescriptor().getFamily()));
            }
            for (CustomizerNode dNode : debuggerNodes) {
                if (dNode instanceof DebuggerCustomizerNode) {
                    if (!families.contains(((DebuggerCustomizerNode)((Object)dNode)).getFamily())) continue;
                    res.add(dNode);
                    continue;
                }
                res.add(dNode);
            }
        } else if (debuggerNodes.size() == 1) {
            res.addAll(debuggerNodes);
        }
        return res;
    }

    private static CustomizerNode createCodeAssistantDescription(Lookup lookup) {
        ArrayList<CustomizerNode> descriptions = new ArrayList<CustomizerNode>();
        descriptions.add(ItemNodeFactory.createCCompilerDescription(lookup));
        descriptions.add(ItemNodeFactory.createCCCompilerDescription(lookup));
        String nodeLabel = ProjectNodeFactory.getString("LBL_PARSER_NODE");
        return new CodeAssistanceCustomizerNode("CodeAssistance", nodeLabel, descriptions.toArray(new CustomizerNode[descriptions.size()]), lookup);
    }

    private static CustomizerNode createNotFoundNode(String nodeName) {
        return new CustomizerNode(nodeName, nodeName + " - not found", null, null);
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeCustomizer.class, (String)s);
    }
}

