/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.CndPathUtilities;

public final class TokenizerFactory {
    public static final Converter MACRO_CONVERTER = new Converter(){
        private final PathResolver resolver = new TrivialPathResolver();

        @Override
        public String convertToString(List<String> list) {
            return TokenizerFactory.convertToString(list, ' ');
        }

        @Override
        public List<String> convertToList(String text) {
            return TokenizerFactory.tokenize(text, new String[]{"-D"}, " ", this.resolver);
        }
    };
    public static final Converter UNDEF_CONVERTER = new Converter(){
        private final PathResolver resolver = new TrivialPathResolver();

        @Override
        public String convertToString(List<String> list) {
            return TokenizerFactory.convertToString(list, ' ');
        }

        @Override
        public List<String> convertToList(String text) {
            return TokenizerFactory.tokenize(text, new String[]{"-U"}, " ", this.resolver);
        }
    };
    public static final Converter DEFAULT_CONVERTER = new Converter(){

        @Override
        public String convertToString(List<String> list) {
            return TokenizerFactory.convertToString(list, ';');
        }

        @Override
        public List<String> convertToList(String text) {
            ArrayList<String> newList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(text, ";");
            while (st.hasMoreTokens()) {
                newList.add(st.nextToken());
            }
            return newList;
        }
    };

    public static Converter getPathConverter(final Project project, final Folder folder, final Item item, final String flag) {
        return new Converter(){
            private final PathResolver resolver = new PathResolver(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public String resolve(String from) {
                    if (CndPathUtilities.isPathAbsolute((CharSequence)from)) {
                        return from;
                    }
                    if (project != null) {
                        return from;
                    }
                    if (folder != null) {
                        if (!folder.isDiskFolder()) return from;
                        String folderPath = folder.getRootPath();
                        folder.isDiskFolder();
                        if (folderPath == null) return from;
                        from = folderPath + "/" + from;
                        if (!CndPathUtilities.isPathAbsolute((CharSequence)from)) return from;
                        return CndPathUtilities.toAbsoluteOrRelativePath((String)folder.getConfigurationDescriptor().getBaseDir(), (String)from);
                    }
                    if (item == null) return from;
                    from = CndPathUtilities.getDirName((String)item.getAbsolutePath()) + "/" + from;
                    return CndPathUtilities.toAbsoluteOrRelativePath((String)item.getFolder().getConfigurationDescriptor().getBaseDir(), (String)from);
                }
            };

            @Override
            public String convertToString(List<String> list) {
                return TokenizerFactory.convertToString(list, ';');
            }

            @Override
            public List<String> convertToList(String text) {
                return TokenizerFactory.tokenize(text, new String[]{flag}, "; ", this.resolver);
            }
        };
    }

    private static List<String> tokenize(String text, String[] keys, String SEPARATOR, PathResolver resolver) {
        int i;
        int QUOTE = 34;
        ArrayList<String> result = new ArrayList<String>();
        boolean inQuote = false;
        boolean innerQuote = false;
        int start = 0;
        char prev = '\u0000';
        for (i = 0; i < text.length(); ++i) {
            String str = text.substring(start, i).trim();
            if (TokenizerFactory.isSeparator(SEPARATOR, text.charAt(i)) && !inQuote) {
                if (str.length() > 0) {
                    TokenizerFactory.addItem(result, keys, str, resolver);
                    start = i + 1;
                }
            } else if (text.charAt(i) == '\"' && inQuote) {
                if (str.length() > 0) {
                    TokenizerFactory.addItem(result, keys, str + (innerQuote ? Character.valueOf('\"') : ""), resolver);
                    start = i + 1;
                    inQuote = false;
                    innerQuote = false;
                }
            } else if (text.charAt(i) == '\"') {
                inQuote = true;
                if (TokenizerFactory.isSeparator(SEPARATOR, prev)) {
                    start = i + 1;
                } else {
                    innerQuote = true;
                }
            }
            prev = text.charAt(i);
        }
        if (start != i) {
            TokenizerFactory.addItem(result, keys, text.substring(start).trim(), resolver);
        }
        return result;
    }

    private static boolean isSeparator(String separators, char c) {
        return separators.indexOf(c) >= 0;
    }

    private static void addItem(List<String> result, String[] keys, String value, PathResolver resolver) {
        for (String key : keys) {
            if (!value.startsWith(key)) continue;
            String s = TokenizerFactory.removePrefix(key, value, resolver);
            if (!s.isEmpty()) {
                result.add(s);
            }
            return;
        }
        if (!value.startsWith("-") && !value.isEmpty()) {
            result.add(value);
        }
    }

    private static String removePrefix(String prefix, String str, PathResolver resolver) {
        return str.startsWith(prefix) ? resolver.resolve(str.substring(prefix.length())) : str;
    }

    private static String convertToString(List<String> list, char separator) {
        boolean addSep = false;
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (addSep) {
                ret.append(separator);
            }
            ret.append(CndPathUtilities.quoteIfNecessary((String)list.get(i)));
            addSep = true;
        }
        return ret.toString();
    }

    private static final class TrivialPathResolver
    implements PathResolver {
        private TrivialPathResolver() {
        }

        @Override
        public String resolve(String from) {
            return from;
        }
    }

    private static interface PathResolver {
        public String resolve(String var1);
    }

    public static interface Converter {
        public String convertToString(List<String> var1);

        public List<String> convertToList(String var1);
    }
}

