/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.wizards.PreBuildSupport;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ConfigureScriptSupport;
import org.netbeans.modules.cnd.makeproject.ui.wizards.QmakeScriptSupport;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class CmakeScriptSupport
implements PreBuildSupport.PreBuildArtifactProvider {
    @Override
    public PreBuildSupport.PreBuildArtifact findScriptInFolder(FileObject folder, ExecutionEnvironment ee, CompilerSet compilerSet) {
        CmakeScriptArtifact res;
        if (folder == null) {
            return null;
        }
        FileObject configure = folder.getFileObject("CMakeLists.txt");
        if (configure != null && configure.isValid() && (res = new CmakeScriptArtifact(configure)).validate(ee, compilerSet) == null) {
            return res;
        }
        return null;
    }

    @Override
    public PreBuildSupport.PreBuildArtifact scriptToArtifact(FileObject script) {
        if ("CMakeLists.txt".equals(script.getNameExt())) {
            return new CmakeScriptArtifact(script);
        }
        return null;
    }

    @Override
    public String getToolName() {
        return "cmake";
    }

    @Override
    public boolean isSupported(PreBuildSupport.PreBuildArtifact script) {
        return script instanceof CmakeScriptArtifact;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(CmakeScriptSupport.class, (String)"ScriptTypeDisplayName_cmake");
    }

    @Override
    public String getHint() {
        return NbBundle.getMessage(CmakeScriptSupport.class, (String)"SelectModeSimpleInstructionExtraText_CMake");
    }

    @Override
    public String getFileChooserTitle() {
        return NbBundle.getMessage(CmakeScriptSupport.class, (String)"ScriptTypeFileChooser_cmake");
    }

    @Override
    public FileFilter[] getFileFilter() {
        return new FileFilter[]{FileFilterFactory.getCMakeFileFilter()};
    }

    private static final class CmakeScriptArtifact
    implements PreBuildSupport.PreBuildArtifact {
        private final FileObject script;

        CmakeScriptArtifact(FileObject script) {
            this.script = script;
        }

        @Override
        public FileObject getScript() {
            return this.script;
        }

        @Override
        public String getArguments(ExecutionEnvironment ee, CompilerSet def, String flags) {
            ee = ee != null ? ee : ServerList.getDefaultRecord().getExecutionEnvironment();
            def = def != null ? def : CompilerSetManager.get((ExecutionEnvironment)ee).getDefaultCompilerSet();
            StringBuilder buf = new StringBuilder(flags);
            String cCompilerFlags = ConfigureScriptSupport.getCompilerFlags(def);
            String cppCompilerFlags = ConfigureScriptSupport.getCompilerFlags(def);
            ConfigureScriptSupport.appendIfNeed("-G ", flags, buf, "\"Unix Makefiles\"");
            ConfigureScriptSupport.appendIfNeed("-DCMAKE_BUILD_TYPE=", flags, buf, "Debug");
            ConfigureScriptSupport.appendIfNeed("-DCMAKE_C_COMPILER=", flags, buf, "${IDE_CC}");
            ConfigureScriptSupport.appendIfNeed("-DCMAKE_CXX_COMPILER=", flags, buf, "${IDE_CXX}");
            ConfigureScriptSupport.appendIfNeed("-DCMAKE_C_FLAGS_DEBUG=", flags, buf, cCompilerFlags);
            ConfigureScriptSupport.appendIfNeed("-DCMAKE_CXX_FLAGS_DEBUG=", flags, buf, cppCompilerFlags);
            ConfigureScriptSupport.appendIfNeed("-DCMAKE_EXPORT_COMPILE_COMMANDS=", flags, buf, "ON");
            return buf.toString();
        }

        @Override
        public String getCommandLine(String arguments, String workingDir) {
            StringBuilder buf = new StringBuilder();
            buf.append("cmake ");
            buf.append(arguments);
            FileObject parent = this.script.getParent();
            if (parent != null) {
                buf.append(' ');
                buf.append(CndPathUtilities.toRelativePath((String)workingDir, (String)parent.getPath()));
            }
            return buf.toString();
        }

        @Override
        public String validate(ExecutionEnvironment ee, CompilerSet compilerSet) {
            if (this.script.isValid() && this.script.isData() && this.script.canRead()) {
                Tool tool;
                DataObject dObj;
                try {
                    dObj = DataObject.find((FileObject)this.script);
                }
                catch (DataObjectNotFoundException ex) {
                    return NbBundle.getMessage(CmakeScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                if (dObj == null) {
                    return NbBundle.getMessage(CmakeScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                Node node = dObj.getNodeDelegate();
                if (node == null) {
                    return NbBundle.getMessage(CmakeScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                if (compilerSet != null && (tool = compilerSet.findTool((ToolKind)PredefinedToolKind.CMakeTool)) != null && !tool.getPath().isEmpty()) {
                    return null;
                }
                return NbBundle.getMessage(QmakeScriptSupport.class, (String)"NotFoundCMakeTool");
            }
            return NbBundle.getMessage(CmakeScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
        }
    }
}

