/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.wizards.PreBuildSupport;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ConfigureScriptSupport;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class QmakeScriptSupport
implements PreBuildSupport.PreBuildArtifactProvider {
    @Override
    public PreBuildSupport.PreBuildArtifact findScriptInFolder(FileObject folder, ExecutionEnvironment ee, CompilerSet compilerSet) {
        if (folder == null) {
            return null;
        }
        FileObject[] listFiles = folder.getChildren();
        if (listFiles == null) {
            return null;
        }
        for (FileObject file : listFiles) {
            if (!file.getExt().equals("pro")) continue;
            QmakeScriptArtifact res = new QmakeScriptArtifact(file);
            if (res.validate(ee, compilerSet) != null) break;
            return res;
        }
        return null;
    }

    @Override
    public PreBuildSupport.PreBuildArtifact scriptToArtifact(FileObject script) {
        if (script.getExt().equals("pro")) {
            return new QmakeScriptArtifact(script);
        }
        return null;
    }

    @Override
    public String getToolName() {
        return "qmake";
    }

    @Override
    public boolean isSupported(PreBuildSupport.PreBuildArtifact script) {
        return script instanceof QmakeScriptArtifact;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(QmakeScriptSupport.class, (String)"ScriptTypeDisplayName_qmake");
    }

    @Override
    public String getHint() {
        return NbBundle.getMessage(QmakeScriptSupport.class, (String)"SelectModeSimpleInstructionExtraText_QMake");
    }

    @Override
    public String getFileChooserTitle() {
        return NbBundle.getMessage(QmakeScriptSupport.class, (String)"ScriptTypeFileChooser_qmake");
    }

    @Override
    public FileFilter[] getFileFilter() {
        return new FileFilter[]{FileFilterFactory.getQMakeFileFilter()};
    }

    private static final class QmakeScriptArtifact
    implements PreBuildSupport.PreBuildArtifact {
        private final FileObject script;

        QmakeScriptArtifact(FileObject script) {
            this.script = script;
        }

        @Override
        public FileObject getScript() {
            return this.script;
        }

        @Override
        public String getArguments(ExecutionEnvironment ee, CompilerSet def, String flags) {
            ee = ee != null ? ee : ServerList.getDefaultRecord().getExecutionEnvironment();
            def = def != null ? def : CompilerSetManager.get((ExecutionEnvironment)ee).getDefaultCompilerSet();
            StringBuilder buf = new StringBuilder(flags);
            String cCompilerFlags = ConfigureScriptSupport.getCompilerFlags(def);
            String cppCompilerFlags = ConfigureScriptSupport.getCompilerFlags(def);
            int platform = CompilerSetManager.get((ExecutionEnvironment)ee).getPlatform();
            if (def.getCompilerFlavor().isSunStudioCompiler() && (platform == 1 || platform == 0)) {
                ConfigureScriptSupport.appendIfNeed("-spec ", flags, buf, "solaris-cc");
            }
            if (platform == 4) {
                ConfigureScriptSupport.appendIfNeed("-spec ", flags, buf, "macx-g++");
            }
            ConfigureScriptSupport.appendIfNeed("QMAKE_CC=", flags, buf, "${IDE_CC}");
            ConfigureScriptSupport.appendIfNeed("QMAKE_CXX=", flags, buf, "${IDE_CXX}");
            ConfigureScriptSupport.appendIfNeed("QMAKE_CFLAGS=", flags, buf, cCompilerFlags);
            ConfigureScriptSupport.appendIfNeed("QMAKE_CXXFLAGS=", flags, buf, cppCompilerFlags);
            return buf.toString();
        }

        @Override
        public String getCommandLine(String arguments, String workingDir) {
            StringBuilder buf = new StringBuilder();
            buf.append("qmake ");
            buf.append(CndPathUtilities.toRelativePath((String)workingDir, (String)this.script.getPath()));
            buf.append(' ');
            buf.append(arguments);
            return buf.toString();
        }

        @Override
        public String validate(ExecutionEnvironment ee, CompilerSet compilerSet) {
            if (this.script.isValid() && this.script.isData() && this.script.canRead()) {
                Tool tool;
                DataObject dObj;
                try {
                    dObj = DataObject.find((FileObject)this.script);
                }
                catch (DataObjectNotFoundException ex) {
                    return NbBundle.getMessage(QmakeScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                if (dObj == null) {
                    return NbBundle.getMessage(QmakeScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                Node node = dObj.getNodeDelegate();
                if (node == null) {
                    return NbBundle.getMessage(QmakeScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                if (compilerSet != null && (tool = compilerSet.findTool((ToolKind)PredefinedToolKind.QMakeTool)) != null && !tool.getPath().isEmpty()) {
                    return null;
                }
                return NbBundle.getMessage(QmakeScriptSupport.class, (String)"NotFoundQMakeTool");
            }
            return NbBundle.getMessage(QmakeScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
        }
    }
}

