/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modeldiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class ModelSource
implements SourceFileProperties {
    private static final boolean TRACE_AMBIGUOUS = Boolean.getBoolean("cnd.modeldiscovery.trace.ambiguous");
    private static final int MAX_DEPTH = 4;
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.modeldiscovery.provider.SourceFileProperties");
    private final Item item;
    private final CsmFile file;
    private final Map<String, List<String>> searchBase;
    private final Map<String, Item> projectSearchBase;
    private final PkgConfigManager.PkgConfig pkgConfig;
    private String itemPath;
    private List<String> userIncludePaths;
    private final Set<CharSequence> includedFiles;
    private Map<String, String> userMacros;
    private final boolean preferLocal;
    private final FileSystem sourceFileSystem;
    private static final String PATTERN = "/../";

    public ModelSource(Item item, CsmFile file, Map<String, List<String>> searchBase, Map<String, Item> projectSearchBase, PkgConfigManager.PkgConfig pkgConfig, boolean preferLocal) {
        if (TRACE_AMBIGUOUS) {
            logger.setLevel(Level.ALL);
        }
        this.includedFiles = new HashSet<CharSequence>();
        this.item = item;
        this.file = file;
        this.searchBase = searchBase;
        this.projectSearchBase = projectSearchBase;
        this.pkgConfig = pkgConfig;
        this.preferLocal = preferLocal;
        this.sourceFileSystem = item.getFSPath().getFileSystem();
    }

    public Set<CharSequence> getIncludedFiles() {
        if (this.userIncludePaths == null) {
            this.getUserInludePaths();
        }
        return this.includedFiles;
    }

    public String getCompilePath() {
        return CndPathUtilities.getDirName((String)this.getItemPath());
    }

    public String getItemPath() {
        if (this.itemPath == null) {
            this.itemPath = this.item.getAbsPath();
            this.itemPath = this.itemPath.replace('\\', '/');
            this.itemPath = ModelSource.cutLocalRelative(this.itemPath);
            if (Utilities.isWindows() && CndFileUtils.isLocalFileSystem((FileSystem)this.sourceFileSystem)) {
                this.itemPath = this.itemPath.replace('/', File.separatorChar);
            }
        }
        return this.itemPath;
    }

    public static String cutLocalRelative(String path) {
        int i;
        String pattern = PATTERN;
        while ((i = path.indexOf(pattern)) >= 0) {
            int k = -1;
            for (int j = i - 1; j >= 0; --j) {
                if (path.charAt(j) != '/') continue;
                k = j;
                break;
            }
            if (k < 0) break;
            path = path.substring(0, k + 1) + path.substring(i + pattern.length());
        }
        return path;
    }

    public String getItemName() {
        return this.item.getName();
    }

    public List<String> getUserInludePaths() {
        if (this.userIncludePaths == null) {
            List includePaths = CndFileUtils.toPathList((Collection)this.item.getUserIncludePaths());
            LinkedHashSet<String> res = new LinkedHashSet<String>();
            for (String path : includePaths) {
                path = this.getRelativepath(path);
                res.add(path);
            }
            this.analyzeUnresolved(res, this.file, 0);
            this.userIncludePaths = new ArrayList<String>(res);
        }
        return this.userIncludePaths;
    }

    public List<String> getUserInludeFiles() {
        return Collections.emptyList();
    }

    private String getRelativepath(String path) {
        if (Utilities.isWindows() && CndFileUtils.isLocalFileSystem((FileSystem)this.sourceFileSystem)) {
            path = path.replace('/', File.separatorChar);
        }
        path = CndPathUtilities.toRelativePath((String)this.getCompilePath(), (String)path);
        path = CndPathUtilities.normalizeSlashes((String)path);
        return path;
    }

    private void analyzeUnresolved(Set<String> res, CsmFile what, int level) {
        if (what == null) {
            return;
        }
        for (CsmInclude include : what.getIncludes()) {
            CsmFile resolved = include.getIncludeFile();
            if (resolved == null) {
                Collection listRP;
                String path = this.guessPath(include);
                if (path != null) {
                    String fullPath = CndFileUtils.normalizeAbsolutePath((String)(path + File.separatorChar + include.getIncludeName()));
                    if (!this.file.getProject().isArtificial()) {
                        Item aItem = this.projectSearchBase.get(fullPath);
                        if (aItem != null) {
                            resolved = this.file.getProject().findFile((Object)aItem, true, false);
                        }
                    } else {
                        resolved = this.file.getProject().findFile((Object)fullPath, true, false);
                    }
                    path = this.getRelativepath(path);
                    res.add(path);
                    if (level >= 4 || resolved == null) continue;
                    this.analyzeUnresolved(res, resolved, level + 1);
                    continue;
                }
                if (this.pkgConfig == null || (listRP = this.pkgConfig.getResolvedPath(include.getIncludeName().toString())) == null || listRP.isEmpty()) continue;
                PkgConfigManager.ResolvedPath rp = (PkgConfigManager.ResolvedPath)listRP.iterator().next();
                res.add(rp.getIncludePath());
                for (PkgConfigManager.PackageConfiguration pc : rp.getPackages()) {
                    for (String p : pc.getIncludePaths()) {
                        if (this.getSystemInludePaths().contains(p)) continue;
                        res.add(p);
                    }
                    for (String p : pc.getMacros()) {
                        String macro;
                        int i = p.indexOf(61);
                        String value = null;
                        if (i > 0) {
                            macro = p.substring(0, i);
                            value = p.substring(i + 1);
                        } else {
                            macro = p;
                        }
                        if (this.getUserMacros().containsKey(macro)) continue;
                        this.getUserMacros().put(macro, value);
                    }
                }
                continue;
            }
            boolean reResolve = false;
            if (this.preferLocal) {
                String path;
                boolean isSystem = false;
                String resolvedPath = resolved.getAbsolutePath().toString();
                for (String path2 : this.getSystemInludePaths()) {
                    if (!resolvedPath.startsWith(path2)) continue;
                    isSystem = true;
                    break;
                }
                if (isSystem && (path = this.guessPath(include)) != null && !resolvedPath.startsWith(path)) {
                    if (TRACE_AMBIGUOUS) {
                        logger.log(Level.FINE, "Directive resolved in project on path: {0} instead {1}", new Object[]{path, resolvedPath});
                    }
                    String fullPath = CndFileUtils.normalizeAbsolutePath((String)(path + File.separatorChar + include.getIncludeName()));
                    resolved = this.file.getProject().findFile((Object)fullPath, true, false);
                    path = this.getRelativepath(path);
                    res.add(path);
                    reResolve = true;
                }
            }
            if (!reResolve) {
                this.includedFiles.add(resolved.getAbsolutePath());
            }
            if (level >= 4 || resolved == null) continue;
            this.analyzeUnresolved(res, resolved, level + 1);
        }
    }

    private String guessPath(CsmInclude include) {
        List<String> result;
        String name = include.getIncludeName().toString();
        String found = name.replace('\\', '/');
        int i = found.lastIndexOf(47);
        if (i >= 0) {
            String prefix = found.substring(0, i + 1);
            found = found.substring(i + 1);
            i = prefix.lastIndexOf("./");
            if (i >= 0) {
                name = (prefix = prefix.substring(i + 2)).length() == 0 ? found : prefix + '/' + found;
            }
        }
        if ((result = this.searchBase.get(found)) != null && result.size() > 0) {
            int pos = -1;
            for (int j = 0; j < result.size(); ++j) {
                if (!result.get(j).endsWith(name)) continue;
                if (pos >= 0) {
                    if (!TRACE_AMBIGUOUS) continue;
                    logger.log(Level.FINE, "Ambiguous name for item: {0}", this.getItemPath());
                    logger.log(Level.FINE, "  name1: {0}", result.get(pos));
                    logger.log(Level.FINE, "  name2: {0}", result.get(j));
                    continue;
                }
                pos = j;
            }
            if (pos >= 0) {
                String path = result.get(pos);
                path = path.substring(0, path.length() - name.length() - 1);
                return path;
            }
        }
        if (TRACE_AMBIGUOUS) {
            logger.log(Level.FINE, "Unresolved name for item: {0}", this.getItemPath());
            logger.log(Level.FINE, "  from: {0}", include.getContainingFile().getAbsolutePath());
            logger.log(Level.FINE, "  name: {0}", include.getIncludeName());
            if (result != null && result.size() > 0) {
                for (int j = 0; j < result.size(); ++j) {
                    logger.log(Level.FINE, "  candidate: {0}", result.get(j));
                }
            }
        }
        return null;
    }

    public List<String> getSystemInludePaths() {
        return CndFileUtils.toPathList((Collection)this.item.getSystemIncludePaths());
    }

    public Map<String, String> getUserMacros() {
        if (this.userMacros == null) {
            this.userMacros = new HashMap<String, String>();
            List macros = this.item.getUserMacroDefinitions();
            for (String macro : macros) {
                int i = macro.indexOf(61);
                if (i > 0) {
                    this.userMacros.put(macro.substring(0, i).trim(), macro.substring(i + 1).trim());
                    continue;
                }
                this.userMacros.put(macro, null);
            }
        }
        return this.userMacros;
    }

    public List<String> getUndefinedMacros() {
        return new ArrayList<String>(this.item.getUndefinedMacros());
    }

    public Map<String, String> getSystemMacros() {
        return null;
    }

    public ItemProperties.LanguageKind getLanguageKind() {
        switch (this.item.getLanguage()) {
            case C: {
                return ItemProperties.LanguageKind.C;
            }
            case CPP: {
                return ItemProperties.LanguageKind.CPP;
            }
            case FORTRAN: {
                return ItemProperties.LanguageKind.Fortran;
            }
        }
        return ItemProperties.LanguageKind.Unknown;
    }

    public String getCompilerName() {
        return null;
    }

    public ItemProperties.LanguageStandard getLanguageStandard() {
        switch (this.item.getLanguageFlavor()) {
            case C: {
                return ItemProperties.LanguageStandard.C;
            }
            case C89: {
                return ItemProperties.LanguageStandard.C89;
            }
            case C99: {
                return ItemProperties.LanguageStandard.C99;
            }
            case C11: {
                return ItemProperties.LanguageStandard.C11;
            }
            case CPP: {
                return ItemProperties.LanguageStandard.CPP;
            }
            case CPP11: {
                return ItemProperties.LanguageStandard.CPP11;
            }
            case CPP14: {
                return ItemProperties.LanguageStandard.CPP14;
            }
            case DEFAULT: {
                return ItemProperties.LanguageStandard.Default;
            }
            case F77: {
                return ItemProperties.LanguageStandard.F77;
            }
            case F90: {
                return ItemProperties.LanguageStandard.F90;
            }
            case F95: {
                return ItemProperties.LanguageStandard.F95;
            }
        }
        return ItemProperties.LanguageStandard.Unknown;
    }

    public String getCompileLine() {
        return null;
    }

    public String getImportantFlags() {
        return this.item.getImportantFlags();
    }
}

