/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.vars.tooltip;

import java.util.concurrent.CancellationException;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.js.vars.DebuggerSupport;
import org.netbeans.modules.debugger.jpda.js.vars.JSVariable;
import org.netbeans.modules.debugger.jpda.js.vars.tooltip.JPDADebuggerTooltipSupport;
import org.netbeans.modules.javascript2.debug.tooltip.AbstractJSToolTipAnnotation;
import org.openide.util.Pair;

public final class ToolTipAnnotation
extends AbstractJSToolTipAnnotation<JPDADebuggerTooltipSupport> {
    protected JPDADebuggerTooltipSupport getEngineDebugger(Session session, DebuggerEngine engine) {
        if (engine != session.getEngineForLanguage("JS")) {
            return null;
        }
        JPDADebugger d = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return null;
        }
        CallStackFrame frame = d.getCurrentCallStackFrame();
        if (frame == null) {
            return null;
        }
        return new JPDADebuggerTooltipSupport(d, frame);
    }

    protected Pair<String, Object> evaluate(String expression, DebuggerEngine engine, JPDADebuggerTooltipSupport dbg) throws CancellationException {
        String toolTipText;
        CallStackFrame frame = dbg.getFrame();
        JSVariable jsresult = null;
        try {
            Variable result = DebuggerSupport.evaluate(dbg.getDebugger(), frame, expression);
            if (result == null) {
                throw new CancellationException();
            }
            if (result instanceof ObjectVariable) {
                jsresult = JSVariable.createIfScriptObject(dbg.getDebugger(), (ObjectVariable)result, expression);
            }
            toolTipText = jsresult != null ? expression + " = " + jsresult.getValue() : expression + " = " + DebuggerSupport.getVarValue(dbg.getDebugger(), result);
        }
        catch (InvalidExpressionException ex) {
            toolTipText = expression + " = >" + ex.getMessage() + "<";
        }
        return Pair.of((Object)toolTipText, (Object)jsresult);
    }
}

