/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.codegenerator;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.ClassDataRegistry;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.mapping.JavonMappingImpl;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.end2end.classdata.OperationData;
import org.netbeans.modules.mobility.end2end.classdata.PortData;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.netbeans.modules.mobility.end2end.output.OutputLogger;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.modules.mobility.javon.OutputFileFormatter;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ProxyGenerator {
    private final E2EDataObject dataObject;
    private DataObject createdProxy;

    public ProxyGenerator(E2EDataObject dataObject) {
        this.dataObject = dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generate() {
        String generatedProxyName = null;
        try {
            Node serviceNode;
            WsdlService service;
            Configuration configuration = this.dataObject.getConfiguration();
            ServerConfiguration sc = configuration.getServerConfigutation();
            WSDLService wsdlService = (WSDLService)configuration.getServices().get(0);
            Sources s = ProjectUtils.getSources((Project)this.dataObject.getServerProject());
            SourceGroup sourceGroup = Util.getPreselectedGroup(s.getSourceGroups("java"), sc.getClassDescriptor().getLocation());
            FileObject srcDirectory = sourceGroup.getRootFolder();
            ClassPath cp = ClassPath.getClassPath((FileObject)srcDirectory, (String)"classpath/source");
            FileObject fo = cp.getRoots()[0];
            String targetFolderName = sc.getClassDescriptor().getPackageName().replace('.', '/');
            String pkgName = sc.getClassDescriptor().getPackageName();
            FileObject targetFolder = fo.getFileObject(targetFolderName);
            if (targetFolder == null) {
                OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ProxyGenerator.class, (String)"TXT_CreatingFolder"), targetFolderName));
                targetFolder = FileUtil.createFolder((FileObject)fo, (String)targetFolderName);
            }
            if (targetFolder == null) {
                OutputLogger.getInstance().log(OutputLogger.LogLevel.ERROR, MessageFormat.format(NbBundle.getMessage(ProxyGenerator.class, (String)"TXT_FailedFolderCreation"), targetFolderName));
            }
            PortData pd = (PortData)wsdlService.getData().get(0);
            String proxyClassName = wsdlService.getType();
            proxyClassName = proxyClassName.substring(proxyClassName.lastIndexOf(46) + 1);
            proxyClassName = proxyClassName + "_Proxy";
            generatedProxyName = pkgName.length() > 0 ? pkgName + "." + proxyClassName : proxyClassName;
            FileObject outputFile = targetFolder.getFileObject(proxyClassName, "java");
            if (outputFile == null) {
                OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ProxyGenerator.class, (String)"TXT_CreatingProxyClass"), proxyClassName));
                outputFile = targetFolder.createData(proxyClassName, "java");
            }
            if (outputFile == null) {
                OutputLogger.getInstance().log(OutputLogger.LogLevel.ERROR, MessageFormat.format(NbBundle.getMessage(ProxyGenerator.class, (String)"TXT_FailedProxyClassCreation"), proxyClassName));
            }
            Project serverProject = Util.getServerProject(configuration);
            Node rootNode = JAXWSClientView.getJAXWSClientView().createJAXWSClientView(serverProject);
            for (Node nn : rootNode.getChildren().getNodes()) {
                if (!nn.getDisplayName().equals(wsdlService.getName())) continue;
                rootNode = nn;
            }
            FileObject generatedClientFO = serverProject.getProjectDirectory().getFileObject("build/generated/wsimport/client/");
            List<ClasspathInfo> classpaths = Collections.singletonList(ClasspathInfo.create((FileObject)generatedClientFO));
            ClassDataRegistry registry = ClassDataRegistry.getRegistry("default", classpaths);
            String servicePackage = null;
            String serviceClassName = null;
            String portClassName = null;
            String portGetterName = null;
            ArrayList<MethodData> methodList = new ArrayList<MethodData>();
            Node[] arr$ = rootNode.getChildren().getNodes();
            int len$ = arr$.length;
            block8: for (int i$ = 0; i$ < len$ && (service = (WsdlService)(serviceNode = arr$[i$]).getLookup().lookup(WsdlService.class)) != null; ++i$) {
                Node portNode;
                WsdlPort wsdlPort;
                Node[] arr$2 = serviceNode.getChildren().getNodes();
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2 && (wsdlPort = (WsdlPort)(portNode = arr$2[i$2]).getLookup().lookup(WsdlPort.class)) != null; ++i$2) {
                    serviceClassName = service.getJavaName();
                    portGetterName = wsdlPort.getPortGetter();
                    portClassName = wsdlPort.getJavaName();
                    if (!portClassName.equals(pd.getType())) continue;
                    ClassData cd = registry.getClassData(wsdlPort.getJavaName());
                    servicePackage = cd.getPackage();
                    for (Node operationNode : portNode.getChildren().getNodes()) {
                        WsdlOperation wsdlOperation = (WsdlOperation)operationNode.getLookup().lookup(WsdlOperation.class);
                        Object methodData = null;
                        for (MethodData md : cd.getMethods()) {
                            if (!md.getName().equals(wsdlOperation.getJavaName())) continue;
                            for (OperationData op : pd.getOperations()) {
                                if (!md.getName().equals(op.getMethodName())) continue;
                                methodList.add(md);
                            }
                        }
                    }
                    continue block8;
                }
            }
            OutputFileFormatter off = new OutputFileFormatter(outputFile);
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine eng = mgr.getEngineByName("freemarker");
            Bindings bind = eng.getContext().getBindings(100);
            FileObject template = FileUtil.getConfigFile((String)"Templates/Server/Proxy.java");
            JavonMappingImpl mapping = this.dataObject.getMapping();
            mapping.setProperty("target", "server");
            OutputLogger.getInstance().log(NbBundle.getMessage(ProxyGenerator.class, (String)"TXT_ConfigureBindings"));
            bind.put("mapping", (Object)mapping);
            bind.put("proxyClassPackage", (Object)sc.getClassDescriptor().getPackageName());
            bind.put("proxyClassName", (Object)proxyClassName);
            bind.put("servicePackage", (Object)servicePackage);
            bind.put("service", (Object)serviceClassName);
            bind.put("methods", (Object)methodList);
            bind.put("portGetterName", (Object)portGetterName);
            bind.put("portClassName", (Object)portClassName);
            StringWriter w = null;
            Reader is = null;
            OutputLogger.getInstance().log(NbBundle.getMessage(ProxyGenerator.class, (String)"TXT_GenerateProxyClass"));
            try {
                w = new StringWriter();
                is = new InputStreamReader(template.getInputStream());
                eng.getContext().setWriter(w);
                eng.getContext().setAttribute(FileObject.class.getName(), template, 100);
                eng.getContext().setAttribute("javax.script.filename", template.getNameExt(), 100);
                eng.eval(is);
            }
            catch (ScriptException e) {
                OutputLogger.getInstance().log(e);
                ErrorManager.getDefault().notify((Throwable)e);
            }
            finally {
                if (w != null) {
                    off.write(((Object)w).toString());
                    ((Writer)w).close();
                }
                if (is != null) {
                    is.close();
                }
                off.close();
            }
        }
        catch (IOException e) {
            OutputLogger.getInstance().log(e);
            ErrorManager.getDefault().notify((Throwable)e);
            OutputLogger.getInstance().log(NbBundle.getMessage(ProxyGenerator.class, (String)"TXT_FailProxyGeneration"));
            return null;
        }
        return generatedProxyName;
    }
}

