/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ant;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.java.testrunner.ant.utils.AntLoggerUtils;
import org.netbeans.modules.java.testrunner.ant.utils.AntProject;
import org.netbeans.modules.java.testrunner.ant.utils.TestCounter;
import org.netbeans.modules.junit.ant.AntSessionInfo;
import org.netbeans.modules.junit.ant.JUnitOutputReader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class JUnitAntLogger
extends AntLogger {
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 3};
    private static final String[] INTERESTING_TASKS = new String[]{"java", "junit"};
    private static final String ANT_TEST_RUNNER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner";
    private static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";
    private static final Logger LOGGER = Logger.getLogger(JUnitAntLogger.class.getName());

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return INTERESTING_TASKS;
    }

    public boolean interestedInScript(File script, AntSession session) {
        return true;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent event) {
        if (this.isTestTaskRunning(event)) {
            if (event.getLogLevel() != 3) {
                this.getOutputReader(event).messageLogged(event);
            } else {
                this.getOutputReader(event).verboseMessageLogged(event);
            }
        }
    }

    private boolean isTestTaskRunning(AntEvent event) {
        return AntLoggerUtils.isTestSessionType((TestSession.SessionType)this.getSessionInfo(event.getSession()).getCurrentSessionType());
    }

    public void taskStarted(AntEvent event) {
        TestSession.SessionType sessionType = AntLoggerUtils.detectSessionType((AntEvent)event, (String)"junit");
        if (AntLoggerUtils.isTestSessionType((TestSession.SessionType)sessionType)) {
            int testClassCount;
            AntSessionInfo sessionInfo = this.getSessionInfo(event.getSession());
            assert (!AntLoggerUtils.isTestSessionType((TestSession.SessionType)sessionInfo.getCurrentSessionType()));
            sessionInfo.setTimeOfTestTaskStart(System.currentTimeMillis());
            sessionInfo.setCurrentSessionType(sessionType);
            if (sessionInfo.getSessionType() == null) {
                sessionInfo.setSessionType(sessionType);
            }
            try {
                testClassCount = TestCounter.getTestClassCount((AntEvent)event);
            }
            catch (Exception ex) {
                testClassCount = 0;
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
            boolean hasXmlOutput = JUnitAntLogger.hasXmlOutput(event);
            this.getOutputReader(event).testTaskStarted(testClassCount, hasXmlOutput);
        }
    }

    public void taskFinished(AntEvent event) {
        AntSessionInfo sessionInfo = this.getSessionInfo(event.getSession());
        if (AntLoggerUtils.isTestSessionType((TestSession.SessionType)sessionInfo.getCurrentSessionType())) {
            this.getOutputReader(event).testTaskFinished();
            sessionInfo.setCurrentSessionType(null);
        }
    }

    public void buildFinished(AntEvent event) {
        AntSession session = event.getSession();
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        if (AntLoggerUtils.isTestSessionType((TestSession.SessionType)sessionInfo.getSessionType())) {
            this.getOutputReader(event).buildFinished(event);
        }
        session.putCustomData((AntLogger)this, null);
    }

    private JUnitOutputReader getOutputReader(AntEvent event) {
        assert (AntLoggerUtils.isTestSessionType((TestSession.SessionType)this.getSessionInfo(event.getSession()).getSessionType()));
        AntSession session = event.getSession();
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        JUnitOutputReader outputReader = sessionInfo.outputReader;
        if (outputReader == null) {
            File antScript;
            FileObject fileObj;
            String[] propsOfInterest;
            String projectDir = null;
            Project project = this.getProjectFromTaskStructure(event);
            if (project == null) {
                try {
                    projectDir = event.getProperty("work.dir");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    File pd;
                    File f;
                    if (projectDir == null) {
                        projectDir = event.getProperty("basedir");
                    }
                    if (projectDir != null && projectDir.length() != 0 && (project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)(f = FileUtil.normalizeFile((File)(pd = new File(projectDir))))))) == null) {
                        LOGGER.log(Level.INFO, "Project was null for project dir: {0}", f.getPath());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Properties props = new Properties();
            for (String prop : propsOfInterest = new String[]{"includes", "test.class", "test.methods", "test.includes", "javac.includes", "classname", "methodname", "work.dir", "classpath", "platform.java"}) {
                String val = event.getProperty(prop);
                if (val == null) continue;
                props.setProperty(prop, val);
            }
            if (project == null && (project = FileOwnerQuery.getOwner((FileObject)(fileObj = FileUtil.toFileObject((File)(antScript = FileUtil.normalizeFile((File)session.getOriginatingScript())))))) == null) {
                LOGGER.log(Level.WARNING, "Project was null for ant script: {0}", antScript.getPath());
            }
            sessionInfo.outputReader = outputReader = new JUnitOutputReader(session, sessionInfo, project, props);
        }
        return outputReader;
    }

    private Project getProjectFromTaskStructure(AntEvent event) {
        Project project = null;
        TaskStructure taskStructure = event.getTaskStructure();
        if (taskStructure != null) {
            String dir;
            FileObject dirFO;
            String attribute = taskStructure.getAttribute("dir");
            if (attribute == null) {
                attribute = taskStructure.getAttribute("tempdir");
            }
            if (taskStructure.getName().equals("junit") && attribute != null && (dirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(dir = event.evaluate(attribute))))) != null) {
                project = FileOwnerQuery.getOwner((FileObject)dirFO);
            }
            if (project == null) {
                project = this.getProjectFromNestedElements(event, taskStructure);
            }
        }
        return project;
    }

    private Project getProjectFromNestedElements(AntEvent event, TaskStructure taskStructure) {
        for (TaskStructure nestedElement : taskStructure.getChildren()) {
            if (nestedElement.getName().equals("batchtest")) {
                return this.getProjectFromNestedElements(event, nestedElement);
            }
            if (!nestedElement.getName().equals("test") && !nestedElement.getName().equals("fileset")) continue;
            return this.getProjectFromAttributes(event, nestedElement);
        }
        return null;
    }

    private Project getProjectFromAttributes(AntEvent event, TaskStructure taskStructure) {
        String attribute;
        if (taskStructure.getName().equals("test") && (attribute = taskStructure.getAttribute("name")) != null) {
            String name = event.evaluate(attribute);
            String fileName = name.replace(".", "/").concat(".java");
            FileObject fo = GlobalPathRegistry.getDefault().findResource(fileName);
            if (fo != null) {
                return FileOwnerQuery.getOwner((FileObject)fo);
            }
        }
        if (taskStructure.getName().equals("fileset")) {
            String dir;
            FileObject fo;
            attribute = taskStructure.getAttribute("dir");
            if (attribute == null) {
                attribute = taskStructure.getAttribute("file");
            }
            if (attribute != null && (fo = FileUtil.toFileObject((File)new File(FileUtil.normalizePath((String)(dir = event.evaluate(attribute)))))) != null) {
                return FileOwnerQuery.getOwner((FileObject)fo);
            }
        }
        return null;
    }

    private AntSessionInfo getSessionInfo(AntSession session) {
        AntSessionInfo sessionInfo;
        Object o = session.getCustomData((AntLogger)this);
        assert (o == null || o instanceof AntSessionInfo);
        if (o != null) {
            sessionInfo = (AntSessionInfo)o;
        } else {
            sessionInfo = new AntSessionInfo();
            session.putCustomData((AntLogger)this, (Object)sessionInfo);
        }
        return sessionInfo;
    }

    private static boolean hasXmlOutput(AntEvent event) {
        String taskName = event.getTaskName();
        if (taskName.equals("junit")) {
            return JUnitAntLogger.hasXmlOutputJunit(event);
        }
        if (taskName.equals("java")) {
            return JUnitAntLogger.hasXmlOutputJava(event);
        }
        assert (false);
        return false;
    }

    private static boolean hasXmlOutputJunit(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        for (TaskStructure child : taskStruct.getChildren()) {
            String childName = child.getName();
            if (!childName.equals("formatter")) continue;
            String type = child.getAttribute("type");
            type = type != null ? event.evaluate(type) : null;
            String usefile = child.getAttribute("usefile");
            String string = usefile = usefile != null ? event.evaluate(usefile) : null;
            if (type == null || !type.equals("xml") || usefile == null || AntProject.toBoolean((String)usefile)) continue;
            String ifPropName = child.getAttribute("if");
            String unlessPropName = child.getAttribute("unless");
            if (ifPropName != null && event.getProperty(ifPropName) == null || unlessPropName != null && event.getProperty(unlessPropName) != null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasXmlOutputJava(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        String classname = taskStruct.getAttribute("classname");
        if (classname == null || !event.evaluate(classname).equals(ANT_TEST_RUNNER_CLASS_NAME)) {
            return false;
        }
        for (TaskStructure child : taskStruct.getChildren()) {
            String childName = child.getName();
            if (!childName.equals("arg")) continue;
            String argValue = child.getAttribute("value");
            if (argValue == null) {
                argValue = child.getAttribute("line");
            }
            if (argValue == null || !(argValue = event.evaluate(argValue)).equals("formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter")) continue;
            return true;
        }
        return false;
    }
}

