/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.project.PhpProject;
import org.openide.filesystems.FileObject;

public abstract class PhpVisibilityQuery {
    private static final PhpVisibilityQuery DEFAULT = new PhpVisibilityQuery(){

        @Override
        public boolean isVisible(FileObject file) {
            return VisibilityQuery.getDefault().isVisible(file);
        }

        @Override
        public boolean isVisible(File file) {
            return VisibilityQuery.getDefault().isVisible(file);
        }
    };

    private PhpVisibilityQuery() {
    }

    public abstract boolean isVisible(FileObject var1);

    public abstract boolean isVisible(File var1);

    public static PhpVisibilityQuery forProject(final PhpProject project) {
        return new PhpVisibilityQuery(){

            @Override
            public boolean isVisible(FileObject file) {
                return project.isVisible(file);
            }

            @Override
            public boolean isVisible(File file) {
                return project.isVisible(file);
            }
        };
    }

    public static PhpVisibilityQuery getDefault() {
        return DEFAULT;
    }

    public static final class PhpVisibilityQueryImpl
    implements org.netbeans.modules.php.api.queries.PhpVisibilityQuery {
        private final PhpProject project;

        public PhpVisibilityQueryImpl(PhpProject project) {
            assert (project != null);
            this.project = project;
        }

        public boolean isVisible(File file) {
            return PhpVisibilityQuery.forProject(this.project).isVisible(file);
        }

        public boolean isVisible(FileObject file) {
            return PhpVisibilityQuery.forProject(this.project).isVisible(file);
        }

        public Collection<FileObject> getIgnoredFiles() {
            return this.project.getIgnoredFileObjects();
        }

        public Collection<FileObject> getCodeAnalysisExcludeFiles() {
            HashSet<FileObject> excludedFileObjects = new HashSet<FileObject>();
            excludedFileObjects.addAll(this.getIgnoredFiles());
            excludedFileObjects.addAll(this.project.getCodeAnalysisExcludeFileObjects());
            return excludedFileObjects;
        }
    }
}

