/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.connections.ftp.Bundle;
import org.netbeans.modules.php.project.connections.ftp.FtpConfiguration;
import org.openide.util.Pair;

public class FtpConfigurationValidator {
    private static Pair<String, Boolean> lastProxy = null;
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return new ValidationResult(this.result);
    }

    public FtpConfigurationValidator validate(FtpConfiguration configuration) {
        return this.validate(configuration.getHost(), String.valueOf(configuration.getPort()), configuration.isAnonymousLogin(), configuration.getUserName(), configuration.getInitialDirectory(), String.valueOf(configuration.getTimeout()), String.valueOf(configuration.getKeepAliveInterval()), configuration.isPassiveMode());
    }

    public FtpConfigurationValidator validate(String host, String port, boolean isAnonymousLogin, String user, String initialDirectory, String timeout, String keepAliveInterval, boolean passiveMode) {
        String err = RemoteValidator.validateHost(host);
        if (err != null) {
            this.result.addError(new ValidationResult.Message((Object)"host", err));
        }
        if ((err = RemoteValidator.validatePort(port)) != null) {
            this.result.addError(new ValidationResult.Message((Object)"port", err));
        }
        this.validateUser(isAnonymousLogin, user);
        err = RemoteValidator.validateUploadDirectory(initialDirectory);
        if (err != null) {
            this.result.addError(new ValidationResult.Message((Object)"initialDirectory", err));
        }
        if ((err = RemoteValidator.validateTimeout(timeout)) != null) {
            this.result.addError(new ValidationResult.Message((Object)"timeout", err));
        }
        if ((err = RemoteValidator.validateKeepAliveInterval(keepAliveInterval)) != null) {
            this.result.addError(new ValidationResult.Message((Object)"keepAliveInterval", err));
        }
        if (this.result.isFaultless()) {
            this.validateProxy(host, passiveMode);
        }
        return this;
    }

    private void validateUser(boolean anonymousLogin, String user) {
        if (anonymousLogin) {
            return;
        }
        String err = RemoteValidator.validateUser(user);
        if (err != null) {
            this.result.addError(new ValidationResult.Message((Object)"user", err));
        }
    }

    private void validateProxy(String host, boolean passiveMode) {
        if (FtpConfigurationValidator.hasProxy(host)) {
            if (!passiveMode) {
                this.result.addError(new ValidationResult.Message((Object)"proxy", Bundle.FtpConfigurationValidator_error_proxyAndNotPassive()));
            }
            this.result.addWarning(new ValidationResult.Message((Object)"proxy", Bundle.FtpConfigurationValidator_warning_proxy()));
        }
    }

    private static synchronized boolean hasProxy(final String host) {
        assert (Thread.holdsLock(FtpConfigurationValidator.class));
        if (lastProxy != null && ((String)lastProxy.first()).equals(host)) {
            return (Boolean)lastProxy.second();
        }
        final AtomicBoolean hasProxy = new AtomicBoolean();
        BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                hasProxy.set(RemoteUtils.hasHttpProxy(host));
            }
        }, (String)Bundle.FtpConfigurationValidator_proxy_detecting(), (AtomicBoolean)new AtomicBoolean(), (boolean)false);
        lastProxy = Pair.of((Object)host, (Object)hasProxy.get());
        return (Boolean)lastProxy.second();
    }
}

