/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.copysupport;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.transfer.TransferInfo;
import org.netbeans.modules.php.project.copysupport.Bundle;
import org.netbeans.modules.php.project.copysupport.FileOperationFactory;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigRemoteValidator;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

@SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
final class RemoteOperationFactory
extends FileOperationFactory {
    private static final Logger LOGGER = Logger.getLogger(RemoteOperationFactory.class.getName());
    private RemoteClient remoteClient;

    RemoteOperationFactory(PhpProject project) {
        super(project);
    }

    @Override
    protected boolean isEnabled() {
        return this.isEnabled(true);
    }

    private boolean isEnabled(boolean verbose) {
        boolean remoteConfigSelected = this.isRemoteConfigSelected();
        boolean uploadOnSave = false;
        if (remoteConfigSelected) {
            uploadOnSave = this.isUploadOnSave();
        }
        if (verbose) {
            LOGGER.log(Level.FINE, "REMOTE copying enabled for project {0}: {1}", new Object[]{this.project.getName(), remoteConfigSelected && uploadOnSave});
            if (!remoteConfigSelected) {
                LOGGER.fine("\t-> remote config not selected");
            }
            if (!uploadOnSave) {
                LOGGER.fine("\t-> upload on save not selected");
            }
        }
        return remoteConfigSelected && uploadOnSave;
    }

    @Override
    protected synchronized void resetInternal() {
        if (this.remoteClient != null) {
            RemoteOperationFactory.disconnect(this.remoteClient, true);
        }
        this.remoteClient = null;
    }

    static void disconnect(RemoteClient client, boolean force) {
        assert (client != null);
        try {
            client.disconnect(force);
        }
        catch (RemoteException ex) {
            LOGGER.log(Level.INFO, "Error while disconnecting", ex);
        }
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected Callable<Boolean> createInitHandlerInternal(FileObject source) {
        LOGGER.log(Level.FINE, "No INIT handler needed for project {0}", this.project.getName());
        return null;
    }

    @Override
    protected Callable<Boolean> createReinitHandlerInternal(FileObject source) {
        LOGGER.log(Level.FINE, "No REINIT handler needed for project {0}", this.project.getName());
        return null;
    }

    @Override
    protected Callable<Boolean> createCopyHandlerInternal(final FileObject source, FileEvent fileEvent) {
        LOGGER.log(Level.FINE, "Creating COPY handler for {0} (project {1})", new Object[]{RemoteOperationFactory.getPath(source), this.project.getName()});
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.FINE, "Running COPY handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(source), RemoteOperationFactory.this.project.getName()});
                if (!RemoteOperationFactory.this.isValid(source)) {
                    return null;
                }
                RemoteClient client = RemoteOperationFactory.this.getRemoteClient();
                try {
                    Boolean bl = RemoteOperationFactory.this.doCopy(client, source);
                    return bl;
                }
                finally {
                    RemoteOperationFactory.disconnect(client, false);
                }
            }
        };
    }

    @Override
    protected Callable<Boolean> createRenameHandlerInternal(final FileObject source, final String oldName, FileRenameEvent fileRenameEvent) {
        LOGGER.log(Level.FINE, "Creating RENAME handler for {0} (project {1})", new Object[]{RemoteOperationFactory.getPath(source), this.project.getName()});
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.FINE, "Running RENAME handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(source), RemoteOperationFactory.this.project.getName()});
                if (!RemoteOperationFactory.this.isValid(source)) {
                    return null;
                }
                RemoteClient client = RemoteOperationFactory.this.getRemoteClient();
                try {
                    Boolean bl = RemoteOperationFactory.this.doRename(client, source, oldName);
                    return bl;
                }
                finally {
                    RemoteOperationFactory.disconnect(client, false);
                }
            }
        };
    }

    @Override
    protected Callable<Boolean> createDeleteHandlerInternal(final FileObject source, FileEvent fileEvent) {
        LOGGER.log(Level.FINE, "Creating DELETE handler for {0} (project {1})", new Object[]{RemoteOperationFactory.getPath(source), this.project.getName()});
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.FINE, "Running DELETE handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(source), RemoteOperationFactory.this.project.getName()});
                if (!RemoteOperationFactory.this.isValid(source)) {
                    return null;
                }
                RemoteClient client = RemoteOperationFactory.this.getRemoteClient();
                try {
                    Boolean bl = RemoteOperationFactory.this.doDelete(client, source);
                    return bl;
                }
                finally {
                    RemoteOperationFactory.disconnect(client, false);
                }
            }
        };
    }

    private boolean isValid(FileObject source) {
        LOGGER.log(Level.FINE, "Validating source {0} for {1}", new Object[]{RemoteOperationFactory.getPath(source), this.project.getName()});
        if (!this.isRemoteConfigValid()) {
            LOGGER.fine("\t-> invalid (invalid config)");
            return false;
        }
        if (!this.isSourceFileValid(source)) {
            LOGGER.fine("\t-> invalid (invalid source)");
            return false;
        }
        return true;
    }

    protected boolean isRemoteConfigValid() {
        if (!this.isEnabled(false)) {
            LOGGER.log(Level.FINE, "REMOTE copying not enabled for project {0}", this.project.getName());
            return false;
        }
        if (this.isInvalid()) {
            LOGGER.log(Level.FINE, "REMOTE copying invalid for project {0}", this.project.getName());
            return false;
        }
        if (this.getSources() == null) {
            LOGGER.log(Level.WARNING, "REMOTE copying disabled for project {0}. Reason: source root is null", this.project.getName());
            return false;
        }
        String error = RunConfigRemoteValidator.validateRemoteTransfer(RunConfigRemote.forProject(this.project));
        if (error != null) {
            LOGGER.log(Level.INFO, "REMOTE copying disabled for project {0}. Reason: {1}", new Object[]{this.project.getName(), error});
            if (this.askUser(Bundle.RemoteOperationFactory_error(this.project.getName(), error))) {
                this.showCustomizer("Run");
            }
            this.invalidate();
            return false;
        }
        return true;
    }

    protected synchronized RemoteClient getRemoteClient() {
        if (this.remoteClient == null) {
            InputOutput remoteLog = RemoteCommand.getRemoteLog(NbBundle.getMessage(RemoteOperationFactory.class, (String)"LBL_RemoteSynchronizationLog", (Object)this.project.getName(), (Object)false));
            this.remoteClient = new RemoteClient(this.getRemoteConfiguration(), new RemoteClient.AdvancedProperties().setAdditionalInitialSubdirectory(ProjectPropertiesSupport.getRemoteDirectory(this.project)).setPreservePermissions(ProjectPropertiesSupport.areRemotePermissionsPreserved(this.project)).setUploadDirectly(ProjectPropertiesSupport.isRemoteUploadDirectly(this.project)).setInputOutput(remoteLog).setPhpVisibilityQuery(PhpVisibilityQuery.forProject(this.project)));
        }
        return this.remoteClient;
    }

    protected boolean isUploadOnSave() {
        return PhpProjectProperties.UploadFiles.ON_SAVE.equals((Object)ProjectPropertiesSupport.getRemoteUpload(this.project));
    }

    protected boolean isRemoteConfigSelected() {
        return PhpProjectProperties.RunAsType.REMOTE.equals((Object)ProjectPropertiesSupport.getRunAs(this.project));
    }

    protected RemoteConfiguration getRemoteConfiguration() {
        String configName = ProjectPropertiesSupport.getRemoteConnection(this.project);
        assert (StringUtils.hasText((String)configName)) : "Remote configuration name must be selected for project " + this.project.getName();
        return RemoteConnections.get().remoteConfigurationForName(configName);
    }

    Boolean doCopy(RemoteClient client, FileObject source) throws RemoteException {
        LOGGER.log(Level.FINE, "Uploading file {0} for project {1}", new Object[]{RemoteOperationFactory.getPath(source), this.project.getName()});
        FileObject sourceRoot = this.getSources();
        Set<TransferFile> transferFiles = client.prepareUpload(sourceRoot, source);
        if (transferFiles.size() > 0) {
            TransferInfo transferInfo = client.upload(transferFiles);
            if (!(transferInfo.hasAnyFailed() || transferInfo.hasAnyPartiallyFailed() || transferInfo.hasAnyIgnored())) {
                LOGGER.fine("\t-> success");
                return true;
            }
            LOGGER.fine("\t-> failure");
            LOGGER.log(Level.INFO, "Upload failed: {0}", transferInfo);
            return false;
        }
        LOGGER.fine("\t-> nothing to upload?!");
        return null;
    }

    Boolean doRename(RemoteClient client, FileObject source, String oldName) throws RemoteException {
        FileObject sourceRoot = this.getSources();
        String baseDirectory = FileUtil.toFile((FileObject)sourceRoot).getAbsolutePath();
        File sourceFile = FileUtil.toFile((FileObject)source);
        TransferFile toTransferFile = TransferFile.fromFileObject(client.createRemoteClientImplementation(baseDirectory), null, source);
        TransferFile fromTransferFile = TransferFile.fromFile(client.createRemoteClientImplementation(baseDirectory), null, new File(sourceFile.getParentFile(), oldName));
        LOGGER.log(Level.FINE, "Renaming file {0} -> {1} for project {2}", new Object[]{fromTransferFile.getRemotePath(), toTransferFile.getRemotePath(), this.project.getName()});
        if (client.exists(fromTransferFile)) {
            if (client.rename(fromTransferFile, toTransferFile)) {
                LOGGER.fine("\t-> success");
                return true;
            }
            LOGGER.fine("\t-> failure");
            return false;
        }
        LOGGER.fine("\t-> does not exist -> uploading");
        return this.doCopy(client, source);
    }

    Boolean doDelete(RemoteClient client, FileObject source) throws RemoteException {
        LOGGER.log(Level.FINE, "Deleting file {0} for project {1}", new Object[]{RemoteOperationFactory.getPath(source), this.project.getName()});
        Boolean success = null;
        Set<TransferFile> transferFiles = client.prepareDelete(this.getSources(), source);
        for (TransferFile file : transferFiles) {
            LOGGER.log(Level.FINE, "Deleting remote file {0}", file.getRemotePath());
            if (!client.exists(file)) {
                LOGGER.fine("\t-> does not exist -> ignoring");
                continue;
            }
            TransferInfo transferInfo = client.delete(file);
            if (transferInfo.hasAnyTransfered()) {
                LOGGER.fine("\t-> success");
                continue;
            }
            LOGGER.fine("\t-> failure");
            LOGGER.log(Level.INFO, "Remote delete failed: {0}", transferInfo);
            success = false;
        }
        return success;
    }

    @Override
    protected boolean isValid(FileEvent fileEvent) {
        boolean valid;
        boolean bl = valid = !fileEvent.firedFrom(RemoteClient.DOWNLOAD_ATOMIC_ACTION);
        if (valid) {
            LOGGER.log(Level.FINE, "FS event fired from thread: {0}", Thread.currentThread().getName());
        }
        return valid;
    }
}

