/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.impl.RemoteLogger;

public class AutoMountsProvider {
    private final ExecutionEnvironment env;
    private final TreeSet<String> autoMounts;

    public AutoMountsProvider(ExecutionEnvironment env) {
        this.env = env;
        this.autoMounts = new TreeSet();
    }

    public boolean analyze() {
        try {
            if (!ConnectionManager.getInstance().isConnectedTo(this.env)) {
                return false;
            }
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
            switch (hostInfo.getOSFamily()) {
                case SUNOS: {
                    return this.analyzeSolarisAutoMounts();
                }
                case LINUX: {
                    return this.analyzeLinuxAutoMounts();
                }
            }
            return false;
        }
        catch (IOException | InterruptedException | ExecutionException | ConnectionManager.CancellationException ex) {
            RemoteLogger.fine((Exception)ex);
            return false;
        }
    }

    public List<String> getAutoMounts() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.autoMounts);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile(String path) throws IOException, InterruptedException, ExecutionException {
        File dstFile = File.createTempFile(path.length() < 3 ? path + "___" : path, ".tmp");
        try {
            Future task = CommonTasksSupport.downloadFile((String)path, (ExecutionEnvironment)this.env, (File)dstFile, null);
            Integer rc = (Integer)task.get();
            if (rc != 0) {
                throw new IOException("Error reading file " + path + " rc=" + rc);
            }
            ArrayList<String> result = new ArrayList<String>();
            try (BufferedReader rdr = new BufferedReader(new FileReader(dstFile));){
                String line;
                while ((line = rdr.readLine()) != null) {
                    result.add(line);
                }
            }
            if (Boolean.getBoolean("remote.dump.automounts")) {
                StringBuilder sb = new StringBuilder("AutoMounts analyzer: the content of ");
                sb.append(this.env).append(':').append(path).append(" [comments filtered out]:");
                for (String l : result) {
                    if (l.startsWith("#")) continue;
                    sb.append('\n').append(l);
                }
                System.out.println(sb);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            dstFile.delete();
        }
    }

    private boolean analyzeLinuxAutoMounts() throws IOException, InterruptedException, ExecutionException {
        List<String> lines = this.readFile("/etc/auto.master");
        for (String l : lines) {
            String path;
            String[] words;
            if (!l.startsWith("/") || (words = l.split("\\s+")).length <= 0 || (path = words[0]).equals("/-")) continue;
            this.autoMounts.add(path);
        }
        return true;
    }

    private boolean analyzeSolarisAutoMounts() throws IOException, InterruptedException, ExecutionException {
        String path;
        String[] words;
        List<String> lines = this.readFile("/etc/auto_master");
        for (String l : lines) {
            if (!l.startsWith("/") || (words = l.split("\\s+")).length <= 0 || (path = words[0]).equals("/-")) continue;
            this.autoMounts.add(path);
        }
        lines = this.readFile("/etc/mnttab");
        for (String l : lines) {
            if (!l.startsWith("auto_") || (words = l.split("\\s+")).length <= 1 || (path = words[1]).equals("/-") || this.containsParent(path)) continue;
            this.autoMounts.add(path);
        }
        return true;
    }

    private boolean containsParent(String path) {
        String parent = PathUtilities.getDirName((String)path);
        while (parent != null && !parent.isEmpty()) {
            if (this.autoMounts.contains(parent)) {
                return true;
            }
            parent = PathUtilities.getDirName((String)parent);
        }
        return false;
    }
}

