/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.actions.FastPasteAction;
import org.netbeans.modules.remote.api.ui.ConnectionNotifier;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fileoperations.spi.AnnotationProvider;
import org.netbeans.modules.remote.impl.fileoperations.spi.FileOperationsProvider;
import org.netbeans.modules.remote.impl.fileoperations.spi.FilesystemInterceptorProvider;
import org.netbeans.modules.remote.impl.fs.AutoMountsProvider;
import org.netbeans.modules.remote.impl.fs.RefreshManager;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectFactory;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileZipper;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.netbeans.modules.remote.spi.FileSystemCacheProvider;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.spi.RemoteFileSystemHintsProvider;
import org.openide.actions.FileSystemRefreshAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.ImageDecorator;
import org.openide.filesystems.StatusDecorator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbObjectInputStream;
import org.openide.windows.WindowManager;

@SuppressWarnings(value={"Se"})
public final class RemoteFileSystem
extends FileSystem
implements ConnectionListener {
    private static final boolean ATTR_STATS = Boolean.getBoolean("remote.attr.stats");
    public static final String ATTRIBUTES_FILE_NAME = ".rfs_attr";
    public static final String CACHE_FILE_NAME = ".rfs_cache";
    protected static final String CACHE_ZIP_FILE_NAME = ".rfs_zip.zip";
    protected static final String CACHE_ZIP_PART_NAME = ".rfs_zip.part";
    public static final String RESERVED_PREFIX = ".rfs_";
    public static final String RESERVED_PREFIX_ESCAPED = "._rfs_";
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    private final ExecutionEnvironment execEnv;
    private final String filePrefix;
    private final RemoteFileObject root;
    private final RemoteDirectory rootDelegate;
    private final RemoteFileSupport remoteFileSupport;
    private final RefreshManager refreshManager;
    private final File cache;
    private final RemoteFileObjectFactory factory;
    private final AtomicInteger fileCopyCount = new AtomicInteger(0);
    private final AtomicInteger dirSyncCount = new AtomicInteger(0);
    private static final Object mainLock = new Object();
    private static final Map<File, WeakReference<ReadWriteLock>> locks = new HashMap<File, WeakReference<ReadWriteLock>>();
    private final AtomicBoolean readOnlyConnectNotification = new AtomicBoolean(false);
    private static final List<FileSystemProvider.FileSystemProblemListener> globalProblemListeners = new CopyOnWriteArrayList<FileSystemProvider.FileSystemProblemListener>();
    private final List<FileSystemProvider.FileSystemProblemListener> problemListeners = new ArrayList<FileSystemProvider.FileSystemProblemListener>(globalProblemListeners);
    private final transient StatusImpl status = new StatusImpl();
    private final LinkedHashSet<String> deleteOnExitFiles = new LinkedHashSet();
    private final ThreadLocal<RemoteFileObjectBase> beingRemoved = new ThreadLocal();
    private final ThreadLocal<RemoteFileObjectBase> beingCreated = new ThreadLocal();
    private final ThreadLocal<RemoteFileObjectBase> externallyRemoved = new ThreadLocal();
    private final RemoteFileZipper remoteFileZipper;
    private final ThreadLocal<Integer> isInsideVCS = new ThreadLocal();
    private final RequestProcessor.Task connectionTask;
    private volatile boolean connectionChanged;
    private final List<String> autoMounts;
    private static final Map<String, AttrStat> attrStats = new TreeMap<String, AttrStat>();

    RemoteFileSystem(ExecutionEnvironment execEnv) throws IOException {
        RemoteLogger.assertTrue(execEnv.isRemote());
        this.execEnv = execEnv;
        this.remoteFileSupport = new RemoteFileSupport();
        this.factory = new RemoteFileObjectFactory(this);
        this.refreshManager = new RefreshManager(execEnv, this.factory);
        this.filePrefix = FileSystemCacheProvider.getCacheRoot((ExecutionEnvironment)execEnv);
        if (this.filePrefix == null) {
            throw new IllegalStateException("Can not find cache root for remote file system at " + execEnv);
        }
        this.cache = new File(this.filePrefix);
        if (!this.cache.exists() && !this.cache.mkdirs()) {
            throw new IOException(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_CreateDir", (Object)this.cache.getAbsolutePath()));
        }
        this.root = new RemoteFileObject(this);
        this.rootDelegate = new RootFileObject(this.root, this, execEnv, this.cache);
        this.factory.register(this.rootDelegate);
        final WindowFocusListener windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (e.getOppositeWindow() == null && ConnectionManager.getInstance().isConnectedTo(RemoteFileSystem.this.execEnv)) {
                    RemoteFileSystem.this.refreshManager.scheduleRefreshOnFocusGained();
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!GraphicsEnvironment.isHeadless()) {
                    WindowManager.getDefault().getMainWindow().addWindowFocusListener(windowFocusListener);
                }
            }
        });
        this.connectionTask = new RequestProcessor("Connection and R/W change", 1).create((Runnable)new ConnectionChangeRunnable());
        this.connectionChanged = false;
        this.connectionTask.schedule(0);
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)this);
        this.remoteFileZipper = new RemoteFileZipper(execEnv);
        this.autoMounts = this.getFixedAutoMounts();
    }

    private List<String> getFixedAutoMounts() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("/net", "/set", "/import", "/shared", "/home", "/ade_autofs", "/ade", "/workspace"));
        String t = System.getProperty("remote.autofs.list");
        if (t != null) {
            String[] paths;
            for (String p : paths = t.split(",")) {
                if (!p.startsWith("/")) continue;
                list.add(p);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAutoMount(String path) {
        List<String> list = this.autoMounts;
        synchronized (list) {
            return this.autoMounts.contains(path);
        }
    }

    public boolean isDirectAutoMountChild(String path) {
        String parent = PathUtilities.getDirName((String)path);
        if (parent != null && !parent.isEmpty()) {
            return this.isAutoMount(parent);
        }
        return false;
    }

    public static boolean isSniffing(String childName) {
        if (childName != null) {
            for (RemoteFileSystemHintsProvider hp : Lookup.getDefault().lookupAll(RemoteFileSystemHintsProvider.class)) {
                if (!hp.isSniffing(childName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInsideVCS() {
        Integer currValue = this.isInsideVCS.get();
        int level = currValue == null ? 0 : currValue;
        return level > 0;
    }

    public void setInsideVCS(boolean value) {
        Integer currValue = this.isInsideVCS.get();
        int newValue = (currValue == null ? 0 : currValue) + (value ? 1 : -1);
        this.isInsideVCS.set(newValue);
    }

    void warmup(Collection<String> paths, FileSystemProvider.WarmupMode mode, Collection<String> extensions) {
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            RemoteLogger.fine("Warmup: no connection to host {0}", this.execEnv);
            return;
        }
        for (String path : paths) {
            RemoteFileObject fo = this.findResource(path);
            if (fo == null) {
                if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                    RemoteLogger.info("Warmup: no connection to host while warmiong up {0} at {1}", path, this.execEnv);
                    break;
                }
                RemoteLogger.info("Warmup: can't find file object {0} at {1}", path, this.execEnv);
                continue;
            }
            fo.getImplementor().warmup(mode, extensions);
        }
    }

    RemoteFileZipper getZipper() {
        return this.remoteFileZipper;
    }

    void dispose() {
        ConnectionManager.getInstance().removeConnectionListener((ConnectionListener)this);
    }

    public void connected(ExecutionEnvironment env) {
        if (this.execEnv.equals((Object)env)) {
            this.readOnlyConnectNotification.compareAndSet(true, false);
            this.connectionChanged = true;
            this.connectionTask.schedule(0);
        }
    }

    public void disconnected(ExecutionEnvironment env) {
        if (this.execEnv.equals((Object)env)) {
            this.readOnlyConnectNotification.compareAndSet(true, false);
            this.connectionChanged = true;
            this.connectionTask.schedule(0);
        }
        if (ATTR_STATS) {
            this.dumpAttrStat();
        }
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    public RemoteFileObjectFactory getFactory() {
        return this.factory;
    }

    public int getCachedFileObjectsCount() {
        return this.factory.getCachedFileObjectsCount();
    }

    public RefreshManager getRefreshManager() {
        return this.refreshManager;
    }

    public String normalizeAbsolutePath(String absPath) {
        return PathUtilities.normalizeUnixPath((String)absPath);
    }

    File getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadWriteLock getLock(File file) {
        Object object = mainLock;
        synchronized (object) {
            ReadWriteLock result;
            WeakReference<ReadWriteLock> ref = locks.get(file);
            ReadWriteLock readWriteLock = result = ref == null ? null : (ReadWriteLock)ref.get();
            if (result == null) {
                result = new ReentrantReadWriteLock();
                locks.put(file, new WeakReference<ReadWriteLock>(result));
            }
            return result;
        }
    }

    final void resetStatistic() {
        this.dirSyncCount.set(0);
        this.fileCopyCount.set(0);
    }

    final int getDirSyncCount() {
        return this.dirSyncCount.get();
    }

    final int getFileCopyCount() {
        return this.fileCopyCount.get();
    }

    final void incrementDirSyncCount() {
        this.dirSyncCount.incrementAndGet();
    }

    final void incrementFileCopyCount() {
        this.fileCopyCount.incrementAndGet();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RFS_DISPLAY_NAME", (Object)this.execEnv.getDisplayName());
    }

    public boolean isReadOnly() {
        return !ConnectionManager.getInstance().isConnectedTo(this.execEnv);
    }

    public RemoteFileObject getRoot() {
        return this.root;
    }

    public RemoteFileObject findResource(String name) {
        return this.findResource(name, new HashSet<String>());
    }

    public RemoteFileObject findResource(String name, Set<String> antiLoop) {
        if (name.isEmpty() || name.equals("/")) {
            return this.getRoot();
        }
        return this.getRoot().getFileObject(name, antiLoop);
    }

    public FileObject getTempFolder() throws IOException {
        try {
            String dirName;
            RemoteFileObject parentFO;
            String tmpName = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getTempDir();
            RemoteFileObject tmpDir = this.findResource(tmpName);
            if (tmpDir == null && (parentFO = this.findResource(dirName = PathUtilities.getDirName((String)tmpName))) != null) {
                parentFO.refresh();
                tmpDir = this.findResource(tmpName);
            }
            if (tmpDir != null && tmpDir.isFolder() && tmpDir.isValid()) {
                return tmpDir;
            }
            throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteFileSystem.class, (String)"EXC_CantFindTemp"));
        }
        catch (ConnectionManager.CancellationException ex) {
            throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteFileSystem.class, (String)"EXC_CantFindTemp", (Object)((Object)ex)));
        }
    }

    public FileObject createTempFile(FileObject parent, String prefix, String suffix, boolean deleteOnExit) throws IOException {
        if (parent.isFolder() && parent.isValid()) {
            while (true) {
                File tmpFile = File.createTempFile(prefix, suffix);
                String tmpName = tmpFile.getName();
                tmpFile.delete();
                try {
                    FileObject fo = parent.createData(tmpName);
                    if (fo != null && fo.isData() && fo.isValid()) {
                        if (deleteOnExit) {
                            this.addDeleteOnExit(fo.getPath());
                        }
                        return fo;
                    }
                }
                catch (IOException ex) {
                    FileObject test = parent.getFileObject(tmpName);
                    if (test != null) continue;
                    throw ex;
                }
                break;
            }
        }
        throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteFileSystem.class, (String)"EXC_CantCantCreateTemp"));
    }

    public RemoteFileObjectBase findResourceImpl(String name, @NonNull Set<String> antiloop) {
        if (name.isEmpty() || name.equals("/")) {
            return this.getRoot().getImplementor();
        }
        RemoteFileObject fo = this.rootDelegate.getFileObject(name, antiloop);
        return fo == null ? null : fo.getImplementor();
    }

    public void addPendingFile(RemoteFileObjectBase fo) {
        this.remoteFileSupport.addPendingFile(fo);
        this.fireProblemListeners(fo.getPath());
    }

    public String toString() {
        return this.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttribute(RemoteFileObjectBase file, String attrName, Object value) {
        RemoteFileObjectBase parent = file.getParent();
        boolean hasParent = true;
        if (parent == null) {
            parent = file;
            hasParent = false;
        }
        File attr = this.getAttrFile(parent);
        Properties table = this.readProperties(attr);
        String translatedAttributeName = this.translateAttributeName(file, attrName);
        String encodedValue = this.encodeValue(value);
        Object oldValue = null;
        if (encodedValue == null) {
            table.remove(translatedAttributeName);
        } else {
            oldValue = table.setProperty(translatedAttributeName, encodedValue);
        }
        FileOutputStream fileOtputStream = null;
        try {
            fileOtputStream = new FileOutputStream(attr);
            table.store(fileOtputStream, "Set attribute " + attrName);
        }
        catch (IOException ex) {
            File attrParentFile;
            boolean report = true;
            StringBuilder sb = new StringBuilder();
            sb.append("Can not set attribute for ").append(file).append("; attr. cache is ").append(attr.getAbsolutePath());
            if (ex instanceof FileNotFoundException && (attrParentFile = attr.getParentFile()) != null) {
                boolean parentExists = attrParentFile.exists();
                sb.append("; attr. cache parent exists ? ").append(parentExists);
                if (!parentExists) {
                    report = false;
                }
            }
            IOException ioEx = new IOException(sb.toString(), ex);
            if (report) {
                Exceptions.printStackTrace((Throwable)ioEx);
            } else {
                ioEx.printStackTrace(System.err);
            }
        }
        finally {
            if (fileOtputStream != null) {
                try {
                    fileOtputStream.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (hasParent) {
            file.fireFileAttributeChangedEvent(file.getListeners(), new FileAttributeEvent((FileObject)file.getOwnerFileObject(), (FileObject)file.getOwnerFileObject(), attrName, oldValue, value));
            parent.fireFileAttributeChangedEvent(parent.getListeners(), new FileAttributeEvent((FileObject)parent.getOwnerFileObject(), (FileObject)file.getOwnerFileObject(), attrName, oldValue, value));
        } else {
            file.fireFileAttributeChangedEvent(file.getListeners(), new FileAttributeEvent((FileObject)file.getOwnerFileObject(), (FileObject)file.getOwnerFileObject(), attrName, oldValue, value));
        }
        RemoteFileSystem.logAttrName(attrName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logAttrName(String name, boolean write) {
        Map<String, AttrStat> map = attrStats;
        synchronized (map) {
            AttrStat stat = attrStats.get(name);
            if (stat == null) {
                stat = new AttrStat(name);
                attrStats.put(name, stat);
            }
            if (write) {
                if (stat.writeCount++ == 0) {
                    stat.firstWriteStack = Thread.currentThread().getStackTrace();
                }
            } else if (stat.readCount++ == 0) {
                stat.firstReadStack = Thread.currentThread().getStackTrace();
            }
        }
        System.out.printf("%sAttribute %s\n", write ? "set" : "get", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpAttrStat() {
        TreeMap<String, AttrStat> toDump;
        Map<String, AttrStat> map = attrStats;
        synchronized (map) {
            toDump = new TreeMap<String, AttrStat>(attrStats);
        }
        System.out.printf("\n\nDumping attributes statistics (%d elements)\n\n", toDump.size());
        for (Map.Entry entry : toDump.entrySet()) {
            AttrStat stat = (AttrStat)entry.getValue();
            System.out.printf("%s %d %d\n", stat.name, stat.readCount, stat.writeCount);
            if (stat.firstReadStack != null) {
                System.out.printf("\t%s first read stack:\n", stat.name);
                for (StackTraceElement e : stat.firstReadStack) {
                    System.out.printf("\t\t%s\n", e);
                }
            }
            if (stat.firstWriteStack == null) continue;
            System.out.printf("\t%s first write stack:\n", stat.name);
            for (StackTraceElement e : stat.firstWriteStack) {
                System.out.printf("\t\t%s\n", e);
            }
        }
    }

    private File getAttrFile(RemoteFileObjectBase parent) {
        File attr = new File(parent.getCache(), ATTRIBUTES_FILE_NAME);
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getAttribute(RemoteFileObjectBase file, String attrName) {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        RemoteFileObjectBase parent = file.getParent();
        if (parent == null) {
            parent = file;
        }
        if (attrName.equals("default-line-separator")) {
            return "\n";
        }
        if (attrName.equals("default-pathname-separator")) {
            return "/";
        }
        if (attrName.equals(READONLY_ATTRIBUTES)) {
            return Boolean.FALSE;
        }
        if (attrName.equals("isRemoteAndSlow")) {
            return Boolean.TRUE;
        }
        if (attrName.equals("FileSystem.rootPath")) {
            return this.getRoot().getPath();
        }
        if (attrName.equals("java.io.File")) {
            return null;
        }
        if (attrName.equals("ExistsParentNoPublicAPI")) {
            return true;
        }
        if (attrName.startsWith("ProvidedExtensions") && RemoteFileObjectBase.USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this)) != null) {
            try {
                this.setInsideVCS(true);
                Object object = interceptor.getAttribute(FilesystemInterceptorProvider.toFileProxy(file.getOwnerFileObject()), attrName);
                return object;
            }
            finally {
                this.setInsideVCS(false);
            }
        }
        if (ATTR_STATS) {
            RemoteFileSystem.logAttrName(attrName, false);
        }
        File attr = this.getAttrFile(parent);
        Properties table = this.readProperties(attr);
        return this.decodeValue(table.getProperty(this.translateAttributeName(file, attrName)));
    }

    Enumeration<String> getAttributes(RemoteFileObjectBase file) {
        RemoteFileObjectBase parent = file.getParent();
        if (parent != null) {
            File attr = this.getAttrFile(parent);
            Properties table = this.readProperties(attr);
            ArrayList<String> res = new ArrayList<String>();
            Enumeration<Object> keys = table.keys();
            String prefix = file.getNameExt() + "[";
            while (keys.hasMoreElements()) {
                String aKey = keys.nextElement().toString();
                if (!aKey.startsWith(prefix)) continue;
                aKey = aKey.substring(prefix.length(), aKey.length() - 1);
                res.add(aKey);
            }
            return Collections.enumeration(res);
        }
        return Collections.enumeration(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(File attr) {
        Properties table = new Properties();
        if (attr.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(attr);
                table.load(fileInputStream);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return table;
    }

    private String translateAttributeName(RemoteFileObjectBase file, String attrName) {
        return file.getNameExt() + "[" + attrName + "]";
    }

    private Object decodeValue(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[value.length() / 2];
        int count = 0;
        for (int i = 0; i < value.length(); i += 2) {
            try {
                int tempI = Integer.parseInt(value.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
        try {
            NbObjectInputStream ois = new NbObjectInputStream((InputStream)bis);
            Object ret = ois.readObject();
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String encodeValue(Object value) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] bArray = bos.toByteArray();
        StringBuilder strBuff = new StringBuilder(bArray.length * 2);
        for (int i = 0; i < bArray.length; ++i) {
            if (bArray[i] < 16 && bArray[i] >= 0) {
                strBuff.append("0");
            }
            strBuff.append(Integer.toHexString(bArray[i] < 0 ? bArray[i] + 256 : bArray[i]));
        }
        return strBuff.toString();
    }

    void addReadOnlyConnectNotification(RemoteFileObjectBase fo) {
        if (this.readOnlyConnectNotification.compareAndSet(false, true)) {
            this.remoteFileSupport.addPendingFile(fo);
        }
    }

    public static void addGlobalFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener) {
        globalProblemListeners.add(listener);
        for (RemoteFileSystem fs : RemoteFileSystemManager.getInstance().getAllFileSystems()) {
            fs.addFileSystemProblemListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener) {
        List<FileSystemProvider.FileSystemProblemListener> list = this.problemListeners;
        synchronized (list) {
            this.problemListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener) {
        List<FileSystemProvider.FileSystemProblemListener> list = this.problemListeners;
        synchronized (list) {
            this.problemListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProblemListeners(String path) {
        ArrayList<FileSystemProvider.FileSystemProblemListener> listenersCopy;
        List<FileSystemProvider.FileSystemProblemListener> list = this.problemListeners;
        synchronized (list) {
            listenersCopy = new ArrayList<FileSystemProvider.FileSystemProblemListener>(this.problemListeners);
        }
        for (FileSystemProvider.FileSystemProblemListener l : listenersCopy) {
            if (path == null) {
                l.recovered((FileSystem)this);
                continue;
            }
            l.problemOccurred((FileSystem)this, path);
        }
    }

    public final SystemAction[] getActions(Set<FileObject> foSet) {
        FileSystemRefreshAction refreshAction;
        SystemAction[] result = this.status.getActions(foSet);
        FileSystemRefreshAction fileSystemRefreshAction = refreshAction = RemoteFileSystem.isManualRefresh() ? null : (FileSystemRefreshAction)FileSystemRefreshAction.get(FileSystemRefreshAction.class);
        if (result == null) {
            SystemAction[] systemActionArray;
            if (refreshAction == null) {
                systemActionArray = new SystemAction[]{};
            } else {
                SystemAction[] systemActionArray2 = new SystemAction[1];
                systemActionArray = systemActionArray2;
                systemActionArray2[0] = refreshAction;
            }
            result = systemActionArray;
        } else {
            result = refreshAction == null ? result : RemoteFileSystem.append(result, (SystemAction)refreshAction);
        }
        return RemoteFileSystem.append(result, FastPasteAction.get(FastPasteAction.class));
    }

    private static boolean isManualRefresh() {
        return NbPreferences.root().node("org/openide/actions/FileSystemRefreshAction").getBoolean("manual", false);
    }

    private static SystemAction[] append(SystemAction[] actions, SystemAction actionToAppend) {
        SystemAction[] result = new SystemAction[actions.length + 1];
        System.arraycopy(actions, 0, result, 0, actions.length);
        result[actions.length] = actionToAppend;
        return result;
    }

    public StatusDecorator getDecorator() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeleteOnExit(String path) {
        LinkedHashSet<String> linkedHashSet = this.deleteOnExitFiles;
        synchronized (linkedHashSet) {
            if (this.deleteOnExitFiles.isEmpty()) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        RemoteFileSystem.this.releaseResources();
                    }
                });
            }
            this.deleteOnExitFiles.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResources() {
        ArrayList<String> toBeDeleted;
        LinkedHashSet<String> linkedHashSet = this.deleteOnExitFiles;
        synchronized (linkedHashSet) {
            toBeDeleted = new ArrayList<String>(this.deleteOnExitFiles);
        }
        Collections.reverse(toBeDeleted);
        for (String filename : toBeDeleted) {
            if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                return;
            }
            CommonTasksSupport.rmFile((ExecutionEnvironment)this.execEnv, (String)filename, null);
        }
    }

    void setBeingRemoved(RemoteFileObjectBase fo) {
        this.beingRemoved.set(fo);
    }

    void setBeingCreated(RemoteFileObjectBase fo) {
        this.beingCreated.set(fo);
    }

    public RemoteFileObjectBase getBeingCreated() {
        return this.beingCreated.get();
    }

    void setExternallyRemoved(RemoteFileObjectBase fo) {
        this.externallyRemoved.set(fo);
    }

    private RemoteFileObjectBase vcsSafeGetFileObject(String path) {
        RemoteFileObjectBase removing;
        RemoteFileObjectBase fo = this.factory.getCachedFileObject(path);
        if (fo == null && (removing = this.beingRemoved.get()) != null && removing.getPath().equals(path)) {
            fo = removing;
        }
        return fo;
    }

    @SuppressWarnings(value={"NP"})
    public Boolean vcsSafeIsDirectory(String path) {
        path = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase removed = this.externallyRemoved.get();
        if (removed != null && removed.getPath().equals(path)) {
            return this.isDirectoryByFileObjectType(removed);
        }
        RemoteFileObjectBase fo = this.vcsSafeGetFileObject(path);
        if (fo == null) {
            return null;
        }
        return fo.isFolder() ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean isDirectoryByFileObjectType(RemoteFileObjectBase removed) {
        switch (removed.getType()) {
            case Directory: {
                return true;
            }
        }
        return false;
    }

    @SuppressWarnings(value={"NP"})
    public Boolean vcsSafeIsFile(String path) {
        path = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase removed = this.externallyRemoved.get();
        if (removed != null && removed.getPath().equals(path)) {
            return !this.isDirectoryByFileObjectType(removed);
        }
        RemoteFileObjectBase fo = this.vcsSafeGetFileObject(path);
        if (fo == null) {
            return null;
        }
        switch (fo.getType()) {
            case Regular: {
                return true;
            }
            case SymbolicLink: {
                return fo.isData() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return false;
    }

    @SuppressWarnings(value={"NP"})
    public Boolean vcsSafeIsSymbolicLink(String path) {
        path = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase removed = this.externallyRemoved.get();
        if (removed != null && removed.getPath().equals(path)) {
            return removed.getType() == FileInfoProvider.StatInfo.FileType.SymbolicLink;
        }
        RemoteFileObjectBase fo = this.vcsSafeGetFileObject(path);
        if (fo == null) {
            return null;
        }
        return fo.getType() == FileInfoProvider.StatInfo.FileType.SymbolicLink;
    }

    @SuppressWarnings(value={"NP"})
    public Boolean vcsSafeCanonicalPathDiffers(String path) {
        path = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase removed = this.externallyRemoved.get();
        if (removed != null && removed.getPath().equals(path)) {
            return removed instanceof RemoteLinkBase;
        }
        RemoteFileObjectBase fo = this.vcsSafeGetFileObject(path);
        if (fo == null) {
            return null;
        }
        return fo instanceof RemoteLinkBase;
    }

    @SuppressWarnings(value={"NP"})
    public Boolean vcsSafeExists(String path) {
        RemoteFileObjectBase fo = this.vcsSafeGetFileObject(path = PathUtilities.normalizeUnixPath((String)path));
        if (fo == null) {
            RemoteFileObjectBase parentFO;
            String parentPath = PathUtilities.getDirName((String)path);
            if (parentPath != null && (parentFO = this.vcsSafeGetFileObject(parentPath)) != null) {
                String childNameExt = PathUtilities.getBaseName((String)path);
                RemoteFileObject childFO = parentFO.getFileObject(childNameExt, new HashSet<String>());
                return childFO != null && childFO.isValid() ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }
        return fo.isValid() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Long vcsSafeLastModified(String path) {
        String childNameExt;
        RemoteFileObject childFO;
        RemoteFileObjectBase parentFO;
        String parentPath;
        RemoteFileObjectBase fo = this.vcsSafeGetFileObject(path = PathUtilities.normalizeUnixPath((String)path));
        if (fo == null && (parentPath = PathUtilities.getDirName((String)path)) != null && (parentFO = this.vcsSafeGetFileObject(parentPath)) != null && (childFO = parentFO.getFileObject(childNameExt = PathUtilities.getBaseName((String)path), new HashSet<String>())) != null) {
            fo = childFO.getImplementor();
        }
        if (fo == null) {
            return null;
        }
        return fo.lastModified().getTime();
    }

    private class RemoteFileSupport
    extends ConnectionNotifier.NamedRunnable {
        public RemoteFileSupport() {
            super(NbBundle.getMessage(RemoteFileSupport.class, (String)"RemoteDownloadTask.TITLE", (Object)RemoteFileSystem.this.execEnv.getDisplayName()));
        }

        protected void runImpl() {
            try {
                this.onConnect();
            }
            catch (ConnectException ex) {
                RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)RemoteFileSystem.this.execEnv), ex);
                ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
            }
            catch (InterruptedIOException | InterruptedException ex) {
                RemoteLogger.finest(ex);
            }
            catch (IOException ex) {
                RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)RemoteFileSystem.this.execEnv), ex);
                ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
            }
            catch (ExecutionException ex) {
                RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)RemoteFileSystem.this.execEnv), ex);
                ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
            }
        }

        public String getName() {
            return NbBundle.getMessage(RemoteFileSupport.class, (String)(RemoteFileSystem.this.readOnlyConnectNotification.get() ? "RemoteDownloadTask.TEXT_RO" : "RemoteDownloadTask.TEXT"), (Object)RemoteFileSystem.this.execEnv.getDisplayName());
        }

        private void onConnect() throws InterruptedException, ConnectException, InterruptedIOException, IOException, ExecutionException {
            RemoteFileSystem.this.fireProblemListeners(null);
        }

        public void addPendingFile(RemoteFileObjectBase fo) {
            RemoteLogger.getInstance().log(Level.FINEST, "Adding notification for {0}:{1}", new Object[]{RemoteFileSystem.this.execEnv, fo.getPath()});
            ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
        }
    }

    private static class RootFileObject
    extends RemoteDirectory {
        private RootFileObject(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, File cache) {
            super(wrapper, fileSystem, execEnv, null, "", cache);
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public RemoteDirectory getParent() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getAttribute(String attrName) {
            if ("FileProxyOperations".equals(attrName) && USE_VCS) {
                FileOperationsProvider.FileOperations fileOperations = FileOperationsProvider.getDefault().getFileOperations(this.getFileSystem());
                return fileOperations;
            }
            return super.getAttribute(attrName);
        }
    }

    private final class StatusImpl
    implements StatusDecorator,
    ImageDecorator,
    LookupListener,
    FileStatusListener {
        private final Lookup.Result<AnnotationProvider> annotationProviders = Lookup.getDefault().lookupResult(AnnotationProvider.class);
        private Collection<? extends AnnotationProvider> previousProviders;

        private StatusImpl() {
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public void resultChanged(LookupEvent ev) {
            HashSet<? extends AnnotationProvider> add;
            HashSet<? extends AnnotationProvider> now = this.annotationProviders.allInstances();
            if (this.previousProviders != null) {
                add = new HashSet<AnnotationProvider>(now);
                add.removeAll(this.previousProviders);
                HashSet<? extends AnnotationProvider> toRemove = new HashSet<AnnotationProvider>(this.previousProviders);
                toRemove.removeAll(now);
                for (AnnotationProvider annotationProvider : toRemove) {
                    annotationProvider.removeFileStatusListener(this);
                }
            } else {
                add = now;
            }
            for (AnnotationProvider annotationProvider : add) {
                try {
                    annotationProvider.addFileStatusListener(this);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    Exceptions.printStackTrace((Throwable)tooManyListenersException);
                }
            }
            this.previousProviders = now;
        }

        public SystemAction[] getActions(Set<FileObject> foSet) {
            Action[] retVal = null;
            Iterator it = this.annotationProviders.allInstances().iterator();
            while (retVal == null && it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                retVal = ap.actions(foSet);
            }
            if (retVal != null) {
                SystemAction[] ret = new SystemAction[retVal.length];
                for (int i = 0; i < retVal.length; ++i) {
                    if (!(retVal[i] instanceof SystemAction)) continue;
                    ret[i] = (SystemAction)retVal[i];
                }
                return ret;
            }
            return null;
        }

        public void annotationChanged(FileStatusEvent ev) {
            RemoteFileSystem.this.fireFileStatusChanged(ev);
        }

        public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
            for (AnnotationProvider ap : this.annotationProviders.allInstances()) {
                Image retVal = ap.annotateIcon(icon, iconType, files);
                if (retVal == null) continue;
                return retVal;
            }
            return icon;
        }

        public String annotateName(String name, Set<? extends FileObject> files) {
            for (AnnotationProvider ap : this.annotationProviders.allInstances()) {
                String retVal = ap.annotateName(name, files);
                if (retVal == null) continue;
                return retVal;
            }
            return name;
        }

        public String annotateNameHtml(String name, Set<? extends FileObject> files) {
            for (AnnotationProvider ap : this.annotationProviders.allInstances()) {
                String retVal = ap.annotateNameHtml(name, files);
                if (retVal == null) continue;
                return retVal;
            }
            return null;
        }
    }

    private static class AttrStat {
        public final String name;
        public int readCount = 0;
        public int writeCount = 0;
        public StackTraceElement[] firstReadStack;
        public StackTraceElement[] firstWriteStack;

        public AttrStat(String name) {
            this.name = name;
        }
    }

    private class ConnectionChangeRunnable
    implements Runnable {
        @Override
        public void run() {
            if (RemoteFileSystem.this.connectionChanged) {
                if (ConnectionManager.getInstance().isConnectedTo(RemoteFileSystem.this.execEnv)) {
                    RemoteFileSystem.this.refreshManager.scheduleRefreshOnConnect();
                }
                for (RemoteFileObjectBase fo : RemoteFileSystem.this.factory.getCachedFileObjects()) {
                    fo.connectionChanged();
                }
            }
            if (ConnectionManager.getInstance().isConnectedTo(RemoteFileSystem.this.execEnv)) {
                this.maintainAutoMounts();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maintainAutoMounts() {
            long time = System.currentTimeMillis();
            RemoteLogger.fine("Getting automount list for {0}...", RemoteFileSystem.this.execEnv);
            AutoMountsProvider amp = new AutoMountsProvider(RemoteFileSystem.this.execEnv);
            if (amp.analyze()) {
                List<String> newAutoMounts = amp.getAutoMounts();
                List list = RemoteFileSystem.this.autoMounts;
                synchronized (list) {
                    RemoteFileSystem.this.autoMounts.clear();
                    RemoteFileSystem.this.autoMounts.addAll(newAutoMounts);
                }
                if (RemoteLogger.isLoggable(Level.FINE)) {
                    RemoteLogger.fine("Getting automount list for {0} took {1} ms", RemoteFileSystem.this.execEnv, System.currentTimeMillis() - time);
                    for (String path : newAutoMounts) {
                        RemoteLogger.fine("\t{0}", path);
                    }
                }
            }
        }
    }
}

