/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntryImpl;
import org.netbeans.modules.remote.impl.fs.DirEntryList;
import org.netbeans.modules.remote.impl.fs.RefreshManager;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.util.NbBundle;

public class SftpTransport
extends RemoteFileSystemTransport {
    private final ExecutionEnvironment execEnv;

    private SftpTransport(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
    }

    public static SftpTransport getInstance(ExecutionEnvironment execEnv) {
        return new SftpTransport(execEnv);
    }

    @Override
    protected DirEntry stat(String path) throws ConnectException, InterruptedException, ExecutionException {
        return this.stat_or_lstat(path, false);
    }

    @Override
    protected DirEntry lstat(String path) throws ConnectException, InterruptedException, ExecutionException {
        return this.stat_or_lstat(path, true);
    }

    private DirEntry stat_or_lstat(String path, boolean lstat) throws ConnectException, InterruptedException, ExecutionException {
        Future stat;
        Future future = stat = lstat ? FileInfoProvider.lstat((ExecutionEnvironment)this.execEnv, (String)path) : FileInfoProvider.stat((ExecutionEnvironment)this.execEnv, (String)path);
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(this.execEnv));
        }
        return DirEntryImpl.create((FileInfoProvider.StatInfo)stat.get(), this.execEnv);
    }

    @Override
    protected boolean canCopy(String from, String to) {
        return false;
    }

    @Override
    protected DirEntryList copy(String from, String to, Collection<IOException> subdirectoryExceptions) throws ConnectException, InterruptedException, CancellationException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean canMove(String from, String to) {
        return true;
    }

    @Override
    protected RemoteFileSystemTransport.MoveInfo move(String from, String to) throws ConnectException, InterruptedException, CancellationException, ExecutionException {
        Future f = FileInfoProvider.move((ExecutionEnvironment)this.execEnv, (String)from, (String)to);
        f.get();
        String fromParent = PathUtilities.getDirName((String)from);
        DirEntryList fromList = this.readDirectory(fromParent == null ? "/" : fromParent);
        String toParent = PathUtilities.getDirName((String)to);
        DirEntryList toList = this.readDirectory(toParent == null ? "/" : toParent);
        return new RemoteFileSystemTransport.MoveInfo(fromList, toList);
    }

    @Override
    protected DirEntryList readDirectory(String remotePath) throws ConnectException, InterruptedException, CancellationException, ExecutionException {
        FileInfoProvider.StatInfo[] infos;
        if (remotePath.length() == 0) {
            remotePath = "/";
        } else if (!remotePath.startsWith("/")) {
            throw new IllegalArgumentException("path should be absolute: " + remotePath);
        }
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(this.execEnv));
        }
        Future res = FileInfoProvider.ls((ExecutionEnvironment)this.execEnv, (String)remotePath);
        try {
            infos = (FileInfoProvider.StatInfo[])res.get();
        }
        catch (InterruptedException ex) {
            res.cancel(true);
            throw ex;
        }
        ArrayList<DirEntry> newEntries = new ArrayList<DirEntry>(infos.length);
        for (FileInfoProvider.StatInfo statInfo : infos) {
            newEntries.add(DirEntryImpl.create(statInfo, this.execEnv));
        }
        return new DirEntryList(newEntries, System.currentTimeMillis());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    protected boolean needsClientSidePollingRefresh() {
        return true;
    }

    @Override
    protected boolean canRefreshFast() {
        return false;
    }

    @Override
    protected void refreshFast(String path, boolean expected) {
        throw new UnsupportedOperationException("fast refresh not supported for sftp transport");
    }

    @Override
    protected void registerDirectoryImpl(RemoteDirectory directory) {
        if (RefreshManager.REFRESH_ON_CONNECT && directory.getCache().exists() && ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            directory.getFileSystem().getRefreshManager().scheduleRefresh(Arrays.asList(directory), false);
        }
    }

    @Override
    protected void unregisterDirectoryImpl(String path) {
    }

    @Override
    protected void scheduleRefresh(Collection<String> paths) {
        RemoteFileSystemManager.getInstance().getFileSystem(this.execEnv).getRefreshManager().scheduleRefreshExistent(paths, true);
    }

    @Override
    protected DirEntryList delete(String path, boolean directory) throws IOException {
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(this.execEnv));
        }
        StringWriter writer = new StringWriter();
        Future task = directory ? CommonTasksSupport.rmDir((ExecutionEnvironment)this.execEnv, (String)path, (boolean)true, (Writer)writer) : CommonTasksSupport.rmFile((ExecutionEnvironment)this.execEnv, (String)path, (Writer)writer);
        try {
            if ((Integer)task.get() != 0) {
                throw RemoteExceptions.createIOException(NbBundle.getMessage(SftpTransport.class, (String)"EXC_CantDelete", (Object)RemoteFileObjectBase.getDisplayName(this.execEnv, path)));
            }
        }
        catch (InterruptedException ex) {
            throw RemoteExceptions.createInterruptedIOException(ex.getLocalizedMessage(), ex);
        }
        catch (ExecutionException ex) {
            String errorText = writer.getBuffer().toString();
            throw RemoteExceptions.createIOException(NbBundle.getMessage(SftpTransport.class, (String)"EXC_CantDeleteWReason", (Object)RemoteFileObjectBase.getDisplayName(this.execEnv, path), (Object)errorText), ex);
        }
        return null;
    }

    @Override
    protected DirEntry uploadAndRename(File srcFile, String pathToUpload, String pathToRename) throws ConnectException, IOException, InterruptedException, ExecutionException, InterruptedException {
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(this.execEnv));
        }
        CommonTasksSupport.UploadParameters params = new CommonTasksSupport.UploadParameters(srcFile, this.execEnv, pathToUpload, pathToRename, -1, false, null);
        Future task = CommonTasksSupport.uploadFile((CommonTasksSupport.UploadParameters)params);
        CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)task.get();
        if (uploadStatus.isOK()) {
            RemoteLogger.getInstance().log(Level.FINEST, "WritingQueue: uploading {0} succeeded", this);
            return DirEntryImpl.create(uploadStatus.getStatInfo(), this.execEnv);
        }
        RemoteLogger.getInstance().log(Level.FINEST, "WritingQueue: uploading {0} failed", this);
        throw RemoteExceptions.createIOException("" + uploadStatus.getError() + " " + uploadStatus.getExitCode());
    }

    @Override
    protected boolean canSetAccessCheckType() {
        return false;
    }

    @Override
    protected void setAccessCheckType(FileSystemProvider.AccessCheckType accessCheckType) {
    }

    @Override
    protected FileSystemProvider.AccessCheckType getAccessCheckType() {
        return null;
    }
}

