/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmAbstractHyperlinkProvider;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class CsmIncludeHyperlinkProvider
extends CsmAbstractHyperlinkProvider {
    private static final boolean NEED_TO_TRACE_UNRESOLVED_INCLUDE = CndUtils.getBoolean((String)"cnd.modelimpl.trace.failed.include", (boolean)false);
    private static final boolean TRACE_INCLUDES = CndUtils.getBoolean((String)"cnd.trace.includes", (boolean)false);
    private static final CsmOffsetable.Position DUMMY_POSITION = new CsmOffsetable.Position(){

        public int getOffset() {
            return -1;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }
    };

    @Override
    protected boolean isValidToken(TokenItem<TokenId> token, HyperlinkType type) {
        return CsmIncludeHyperlinkProvider.isSupportedToken(token, type);
    }

    public static boolean isSupportedToken(TokenItem<TokenId> token, HyperlinkType type) {
        if (token != null) {
            if (type == HyperlinkType.ALT_HYPERLINK) {
                return !"whitespace".equals(token.id().primaryCategory()) && !"comment".equals(token.id().primaryCategory());
            }
            if (token.id() == CppTokenId.PREPROCESSOR_INCLUDE || token.id() == CppTokenId.PREPROCESSOR_INCLUDE_NEXT || token.id() == CppTokenId.PREPROCESSOR_SYS_INCLUDE || token.id() == CppTokenId.PREPROCESSOR_USER_INCLUDE || token.id() == CppTokenId.PREPROCESSOR_ERROR) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void performAction(Document originalDoc, JTextComponent target, int offset, HyperlinkType type) {
        UIGesturesSupport.submit((String)"USG_CND_INCLUDE_HYPERLINK", (Object[])new Object[]{type});
        this.goToInclude(originalDoc, target, offset, type);
    }

    public boolean goToInclude(Document doc, JTextComponent target, int offset, HyperlinkType type) {
        if (!this.preJump(doc, target, offset, "opening-include-element", type)) {
            return false;
        }
        IncludeTarget item = this.findTargetObject(doc, offset);
        if (type == HyperlinkType.ALT_HYPERLINK && item != null) {
            CsmInclude incl = item.getInclude();
            CsmFile toShow = incl.getIncludeFile();
            if (toShow == null) {
                toShow = incl.getContainingFile();
            } else {
                CsmInclude brokenInclude = this.getFirstBrokenIncludeInsideIncludedFiles(toShow, new HashSet<CsmFile>());
                if (brokenInclude != null) {
                    toShow = brokenInclude.getContainingFile();
                    return this.postJump((CsmOffsetable)brokenInclude, "goto_source_source_not_found", "cannot-open-include-element");
                }
            }
            CsmIncludeHierarchyResolver.showIncludeHierachyView((CsmFile)toShow);
            return true;
        }
        return this.postJump(item, "goto_source_source_not_found", "cannot-open-include-element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IncludeTarget findTargetObject(Document doc, int offset) {
        IncludeTarget item;
        CsmInclude incl = this.findInclude(doc, offset);
        IncludeTarget includeTarget = item = incl == null ? null : new IncludeTarget(incl);
        if (incl != null && NEED_TO_TRACE_UNRESOLVED_INCLUDE && incl.getIncludeFile() == null) {
            System.setProperty("cnd.modelimpl.trace.trace_now", "yes");
            try {
                incl.getIncludeFile();
            }
            finally {
                System.setProperty("cnd.modelimpl.trace.trace_now", "no");
            }
        }
        return item;
    }

    private CsmInclude findInclude(Document doc, int offset) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (csmFile != null) {
            return ReferencesSupport.findInclude(csmFile, offset);
        }
        return null;
    }

    @Override
    protected String getTooltipText(Document doc, TokenItem<TokenId> token, int offset, HyperlinkType type) {
        boolean extraText;
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (csmFile == null) {
            return null;
        }
        CsmInclude includeTarget = ReferencesSupport.findInclude(csmFile, offset);
        CsmErrorDirective errorDirective = null;
        if (includeTarget == null) {
            errorDirective = ReferencesSupport.findErrorDirective(csmFile, offset);
        }
        CharSequence tooltip = null;
        if (includeTarget != null) {
            tooltip = CsmDisplayUtilities.getTooltipText((CsmObject)includeTarget);
        } else if (errorDirective != null) {
            tooltip = CsmDisplayUtilities.getTooltipText((CsmObject)errorDirective);
        }
        boolean bl = extraText = type == HyperlinkType.ALT_HYPERLINK;
        if (tooltip != null) {
            CsmInclude brokenInclude;
            CsmFile includedFile;
            StringBuilder buf = new StringBuilder();
            String altKey = "AltIncludeHyperlinkHint";
            List includeStack = includeTarget != null ? CsmFileInfoQuery.getDefault().getIncludeStack(csmFile) : CsmFileInfoQuery.getDefault().getIncludeStack(errorDirective);
            CsmFile csmFile2 = includedFile = includeTarget == null ? null : includeTarget.getIncludeFile();
            if (includedFile != null && (brokenInclude = this.getFirstBrokenIncludeInsideIncludedFiles(includedFile, new HashSet<CsmFile>())) != null) {
                altKey = "AltIncludeHyperlinkHintBrokenIncludeFile";
                buf = new StringBuilder(tooltip);
                String inclString = brokenInclude.isSystem() ? "#include <" + brokenInclude.getIncludeName() + ">" : "#include \"" + brokenInclude.getIncludeName() + "\"";
                String key = brokenInclude.getIncludeState() == CsmInclude.IncludeState.Recursive ? "RecursionInFile" : "UnresolvedInFile";
                buf.append(this.i18n(key, CsmDisplayUtilities.htmlize((CharSequence)inclString), brokenInclude.getContainingFile().getAbsolutePath()));
                tooltip = buf.toString();
            }
            if (extraText || includedFile == null) {
                buf = new StringBuilder(tooltip);
                buf.append("<br><pre>");
                this.appendPaths(buf, this.i18n("SourceUserPaths"), CsmFileInfoQuery.getDefault().getUserIncludePaths(csmFile));
                this.appendPaths(buf, this.i18n("SourceSystemPaths"), CsmFileInfoQuery.getDefault().getSystemIncludePaths(csmFile));
                this.appendInclStack(buf, includeStack);
                buf.append("</pre>");
                altKey = "AltIncludeHyperlinkHintNoPaths";
                tooltip = buf.toString();
            }
            if (extraText && (TRACE_INCLUDES || NEED_TO_TRACE_UNRESOLVED_INCLUDE)) {
                InputOutput io = IOProvider.getDefault().getIO("Test Inlcudes", false);
                OutputWriter out = io.getOut();
                if (!includeStack.isEmpty()) {
                    try {
                        out.println("path to file " + csmFile.getAbsolutePath(), (OutputListener)new RefLink(csmFile));
                        for (CsmInclude incl : includeStack) {
                            out.println(incl.getText() + " from file " + incl.getContainingFile().getAbsolutePath(), (OutputListener)new RefLink(incl));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                out.println(buf.toString().replaceAll("<br>", "\n"));
                out.flush();
            }
            tooltip = this.getAlternativeHyperlinkTip(doc, altKey, tooltip);
        }
        return tooltip == null ? null : tooltip.toString();
    }

    private void appendInclStack(StringBuilder buf, List<CsmInclude> includeStack) {
        if (!includeStack.isEmpty()) {
            buf.append("<i>").append(this.i18n("PathToCurFile")).append("</i>\n");
            for (CsmInclude inc : includeStack) {
                if (inc == null) continue;
                CsmFile file = inc.getContainingFile();
                CharSequence path = null;
                if (file != null) {
                    path = file.getAbsolutePath();
                }
                if (path == null) {
                    path = "?";
                }
                CsmOffsetable.Position startPosition = inc.getStartPosition();
                int line = -1;
                if (startPosition != null) {
                    line = startPosition.getLine();
                }
                if (file == null || startPosition == null) continue;
                String msg = this.i18n("PathToHeaderOnLine", path.toString(), line);
                buf.append(msg).append('\n');
            }
        }
    }

    private void appendPaths(StringBuilder buf, String title, List<FSPath> includePaths) {
        if (!includePaths.isEmpty()) {
            buf.append("<i>").append(title).append("</i>\n");
            for (FSPath path : includePaths) {
                FileObject fo = path.getFileObject();
                if (fo != null && fo.isValid() && fo.isFolder()) {
                    buf.append(path.getPath());
                } else if (fo != null && fo.isValid() && fo.isData()) {
                    buf.append("<font color='blue'>");
                    buf.append(path.getPath());
                    buf.append("</font>");
                } else {
                    buf.append("<font color='red'>");
                    buf.append(path.getPath());
                    buf.append("</font>");
                }
                buf.append('\n');
            }
        }
    }

    private String i18n(String key) {
        return NbBundle.getMessage(CsmIncludeHyperlinkProvider.class, (String)key);
    }

    private String i18n(String key, Object param1, Object param2) {
        return NbBundle.getMessage(CsmIncludeHyperlinkProvider.class, (String)key, (Object)param1, (Object)param2);
    }

    private CsmInclude getFirstBrokenIncludeInsideIncludedFiles(CsmFile file, Collection<CsmFile> visited) {
        Collection brokenIncludes;
        if (visited.contains(file)) {
            return null;
        }
        visited.add(file);
        if (CsmFileInfoQuery.getDefault().hasBrokenIncludes(file) && !(brokenIncludes = CsmFileInfoQuery.getDefault().getBrokenIncludes(file)).isEmpty()) {
            return (CsmInclude)brokenIncludes.iterator().next();
        }
        for (CsmInclude incl : file.getIncludes()) {
            CsmInclude brokenIncl;
            CsmFile newFile = incl.getIncludeFile();
            if (newFile == null || (brokenIncl = this.getFirstBrokenIncludeInsideIncludedFiles(newFile, visited)) == null) continue;
            return brokenIncl;
        }
        return null;
    }

    private static final class RefLink
    implements OutputListener {
        private final CsmUID<? extends CsmObject> uid;

        public RefLink(CsmInclude incl) {
            this.uid = UIDs.get((Object)incl);
        }

        public RefLink(CsmFile file) {
            this.uid = UIDs.get((Object)file);
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            CsmObject obj = (CsmObject)this.uid.getObject();
            if (obj != null) {
                CsmUtilities.openSource((CsmObject)obj);
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static final class IncludeTarget
    implements CsmOffsetable {
        private final CsmInclude include;

        public IncludeTarget(CsmInclude include) {
            this.include = include;
        }

        public CsmInclude getInclude() {
            return this.include;
        }

        public CsmFile getContainingFile() {
            return this.include.getIncludeFile();
        }

        public int getStartOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public int getEndOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return DUMMY_POSITION;
        }

        public CsmOffsetable.Position getEndPosition() {
            return DUMMY_POSITION;
        }

        public CharSequence getText() {
            return this.include.getIncludeName();
        }
    }
}

