/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class LineHyperlinkProvider
implements HyperlinkProviderExt {
    private LineTarget jumpToken;
    private Cancellable hyperLinkTask;

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        LineTarget lineTarget = this.getLineDirective(doc, offset);
        return lineTarget != null && lineTarget.fileToken != null;
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        LineTarget lineTarget = this.getLineDirective(doc, offset);
        if (lineTarget != null && lineTarget.fileToken != null) {
            this.jumpToken = lineTarget;
            return new int[]{lineTarget.directiveToken.offset(), lineTarget.fileToken.offset() + lineTarget.fileToken.length()};
        }
        return null;
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        UIGesturesSupport.submit((String)"USG_CND_LINE_HYPERLINK", (Object[])new Object[]{type});
        this.goToLine(doc, Utilities.getFocusedComponent(), offset, type);
    }

    public boolean goToLine(final Document doc, final JTextComponent target, final int offset, final HyperlinkType type) {
        if (target == null || target.getDocument() != doc) {
            return false;
        }
        if (!this.isHyperlinkPoint(doc, offset, type)) {
            return false;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                LineHyperlinkProvider.this.performAction(doc, target, offset, type);
            }
        };
        if (this.hyperLinkTask != null) {
            this.hyperLinkTask.cancel();
        }
        this.hyperLinkTask = CsmModelAccessor.getModel().enqueue(run, (CharSequence)"Following hyperlink");
        return true;
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        FileObject toOpen;
        if (doc == null || offset < 0 || offset > doc.getLength()) {
            return null;
        }
        LineTarget token = this.jumpToken;
        if (token == null || token.fileToken == null) {
            token = this.getLineDirective(doc, offset);
        }
        if (token != null && token.fileToken != null && (toOpen = this.getTargetFileObject(token, doc)) != null) {
            return NbBundle.getMessage(LineHyperlinkProvider.class, (String)"LineDirective", (Object)("" + token.line), (Object)toOpen.getPath());
        }
        return null;
    }

    private LineTarget getLineDirective(final Document doc, final int offset) {
        final AtomicReference out = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence cppTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (boolean)true);
                if (cppTokenSequence == null) {
                    return;
                }
                if (!cppTokenSequence.language().equals((Object)CppTokenId.languagePreproc())) {
                    return;
                }
                cppTokenSequence.moveStart();
                if (cppTokenSequence.moveNext()) {
                    while (cppTokenSequence.moveNext()) {
                        Token token = cppTokenSequence.token();
                        TokenId id = token.id();
                        if (!(id instanceof CppTokenId) || !"preprocessor-keyword-directive".equals(((CppTokenId)id).primaryCategory())) continue;
                        if (id == CppTokenId.PREPROCESSOR_LINE) {
                            int tokenOffset = cppTokenSequence.offset();
                            TokenItemImpl lineDirective = new TokenItemImpl(id, tokenOffset, (Token<TokenId>)token);
                            int lineNumber = -1;
                            String fileName = null;
                            TokenItemImpl fileToken = null;
                            while (cppTokenSequence.moveNext()) {
                                Token t = cppTokenSequence.token();
                                TokenId kind = t.id();
                                if (kind == CppTokenId.INT_LITERAL) {
                                    try {
                                        lineNumber = Integer.parseInt(t.text().toString());
                                    }
                                    catch (NumberFormatException ex) {}
                                    continue;
                                }
                                if (kind != CppTokenId.STRING_LITERAL || !(fileName = t.text().toString()).startsWith("\"") || !fileName.endsWith("\"") || fileName.length() < 2) continue;
                                fileName = fileName.substring(1, fileName.length() - 1);
                                fileToken = new TokenItemImpl(kind, cppTokenSequence.offset(), (Token<TokenId>)t);
                            }
                            out.set(new LineTarget(lineDirective, fileToken, lineNumber, fileName));
                        }
                        return;
                    }
                }
            }
        });
        return (LineTarget)out.get();
    }

    private void performAction(Document doc, JTextComponent target, int offset, HyperlinkType type) {
        UIGesturesSupport.submit((String)"USG_CND_INCLUDE_HYPERLINK", (Object[])new Object[]{type});
        LineTarget item = this.getLineDirective(doc, offset);
        FileObject toOpen = this.getTargetFileObject(item, doc);
        if (toOpen != null && toOpen.isValid()) {
            CsmUtilities.openSource((FileObject)toOpen, (int)item.line, (int)0);
        }
    }

    private FileObject getTargetFileObject(LineTarget item, Document doc) {
        FileObject fileObject;
        CsmFile csmFile;
        if (item != null && item.file != null && (csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false)) != null && (fileObject = csmFile.getFileObject()) != null) {
            String path = item.file;
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                FSPath fs = CndPathUtilities.isAbsolute((FileSystem)fileSystem, (String)path) ? new FSPath(fileSystem, path) : new FSPath(fileObject.getFileSystem(), fileObject.getParent().getPath() + "/" + path);
                FileObject toOpen = fs.getFileObject();
                if (toOpen != null && toOpen.isValid()) {
                    return toOpen;
                }
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private static final class LineTarget {
        private final TokenItem<TokenId> directiveToken;
        private final TokenItem<TokenId> fileToken;
        private final int line;
        private final String file;

        public LineTarget(TokenItem<TokenId> directiveToken, TokenItem<TokenId> fileToken, int line, String file) {
            this.directiveToken = directiveToken;
            this.fileToken = fileToken;
            this.line = line;
            this.file = file;
        }
    }

    private static class TokenItemImpl
    implements TokenItem {
        private final TokenId id;
        private final int tokenOffset;
        private final Token<TokenId> token;

        public TokenItemImpl(TokenId id, int tokenOffset, Token<TokenId> token) {
            this.id = id;
            this.tokenOffset = tokenOffset;
            this.token = token;
        }

        public TokenId id() {
            return this.id;
        }

        public int offset() {
            return this.tokenOffset;
        }

        public CharSequence text() {
            return this.token.text();
        }

        public int index() {
            return 0;
        }

        public int length() {
            return this.text().length();
        }

        public PartType partType() {
            return null;
        }
    }
}

