/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class RemoteFileUtil {
    public static boolean fileExists(String absolutePath, ExecutionEnvironment executionEnvironment) {
        FileObject fo = RemoteFileUtil.getFileObject(RemoteFileUtil.normalizeAbsolutePath(absolutePath, executionEnvironment), executionEnvironment);
        return fo != null && fo.isValid();
    }

    public static boolean isDirectory(String absolutePath, ExecutionEnvironment executionEnvironment) {
        FileObject fo = RemoteFileUtil.getFileObject(absolutePath, executionEnvironment);
        return fo != null && fo.isFolder();
    }

    public static FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        FileObject result = FileSystemProvider.getFileObject((FileObject)baseFileObject, (String)relativeOrAbsolutePath);
        if (result == null) {
            String absRootPath = CndPathUtilities.toAbsolutePath((FileObject)baseFileObject, (String)relativeOrAbsolutePath);
            try {
                FileSystem fs = baseFileObject.getFileSystem();
                result = CndFileUtils.isLocalFileSystem((FileSystem)fs) ? CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)absRootPath)) : InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fs, (CharSequence)absRootPath);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                result = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)InvalidFileObjectSupport.getDummyFileSystem(), (CharSequence)absRootPath);
            }
        }
        return result;
    }

    private RemoteFileUtil() {
    }

    public static FileObject getFileObject(String absolutePath, ExecutionEnvironment execEnv) {
        CndUtils.assertAbsolutePathInConsole((String)absolutePath, (String)"path for must be absolute");
        if (execEnv.isRemote()) {
            String normalizedPath;
            if (CndUtils.isDebugMode() && !(normalizedPath = RemoteFileUtil.normalizeAbsolutePath(absolutePath, execEnv)).equals(absolutePath)) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("Warning: path is not normalized:  absolute path is _" + absolutePath + "_ normailzed path is _" + normalizedPath + "_"));
            }
            return FileSystemProvider.getFileSystem((ExecutionEnvironment)execEnv).findResource(absolutePath);
        }
        return CndFileUtils.toFileObject((CharSequence)absolutePath);
    }

    public static FileSystem getProjectSourceFileSystem(Lookup.Provider project) {
        if (project != null) {
            RemoteProject rp = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
            if (rp == null) {
                return null;
            }
            FileObject projectDir = rp.getSourceBaseDirFileObject();
            if (projectDir != null) {
                try {
                    return projectDir.getFileSystem();
                }
                catch (FileStateInvalidException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return CndFileUtils.getLocalFileSystem();
    }

    public static FileObject getProjectSourceBaseFileObject(Lookup.Provider project) {
        if (project != null) {
            RemoteProject rp = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
            if (rp == null) {
                return null;
            }
            return rp.getSourceBaseDirFileObject();
        }
        return null;
    }

    public static ExecutionEnvironment getProjectSourceExecutionEnvironment(Project project) {
        RemoteProject remoteProject;
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null) {
            return remoteProject.getSourceFileSystemHost();
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    public static FileObject getFileObject(String absolutePath, Project project) {
        ExecutionEnvironment execEnv = RemoteFileUtil.getProjectSourceExecutionEnvironment(project);
        absolutePath = FileSystemProvider.normalizeAbsolutePath((String)absolutePath, (ExecutionEnvironment)execEnv);
        if (execEnv != null && execEnv.isRemote()) {
            return RemoteFileUtil.getFileObject(absolutePath, execEnv);
        }
        FileObject projectDir = project.getProjectDirectory();
        CndUtils.assertNotNull((Object)projectDir, (CharSequence)"Null project dir for ", (Object)project);
        try {
            FileSystem fs = projectDir.getFileSystem();
            return fs.findResource(absolutePath);
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static String normalizeAbsolutePath(String absPath, Project project) {
        ExecutionEnvironment execEnv = RemoteFileUtil.getProjectSourceExecutionEnvironment(project);
        if (execEnv != null && execEnv.isRemote()) {
            return RemoteFileUtil.normalizeAbsolutePath(absPath, execEnv);
        }
        return CndFileUtils.normalizeAbsolutePath((String)absPath);
    }

    public static String normalizeAbsolutePath(String absPath, ExecutionEnvironment execEnv) {
        if (execEnv.isRemote()) {
            return FileSystemProvider.normalizeAbsolutePath((String)absPath, (ExecutionEnvironment)execEnv);
        }
        return FileUtil.normalizePath((String)absPath);
    }

    public static String getAbsolutePath(FileObject fileObject) {
        return fileObject.getPath();
    }

    public static String getCanonicalPath(FileObject fo) throws IOException {
        if (FileSystemProvider.getExecutionEnvironment((FileObject)fo).isLocal()) {
            File file = FileUtil.toFile((FileObject)fo);
            return file == null ? fo.getPath() : file.getCanonicalPath();
        }
        FileObject file = FileSystemProvider.getCanonicalFileObject((FileObject)fo);
        return file == null ? fo.getPath() : file.getPath();
    }

    public static boolean isRemote(FileSystem fs) {
        if (fs != null) {
            ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
            return env == null ? false : env.isRemote();
        }
        return false;
    }

    public static JFileChooser createFileChooser(FileSystem fs, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
        return RemoteFileUtil.createFileChooser(env, titleText, buttonText, mode, filters, initialPath, useParent);
    }

    public static JFileChooser createFileChooser(ExecutionEnvironment execEnv, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(execEnv).setPreferences(NbPreferences.forModule(RemoteFileUtil.class));
        FileChooserBuilder.JFileChooserEx fileChooser = fileChooserBuilder.createFileChooser(initialPath);
        fileChooser.setApproveButtonText(buttonText);
        fileChooser.setDialogTitle(titleText);
        fileChooser.setFileSelectionMode(mode);
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                fileChooser.addChoosableFileFilter(filters[i]);
            }
            fileChooser.setFileFilter(filters[0]);
        }
        return fileChooser;
    }

    public static JFileChooser createFileChooser(ExecutionEnvironment execEnv, String titleText, String buttonText, int mode, FileFilter[] filters, Callable<String> initialPath, boolean useParent) {
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(execEnv).setPreferences(NbPreferences.forModule(RemoteFileUtil.class));
        FileChooserBuilder.JFileChooserEx fileChooser = fileChooserBuilder.createFileChooser(initialPath);
        fileChooser.setApproveButtonText(buttonText);
        fileChooser.setDialogTitle(titleText);
        fileChooser.setFileSelectionMode(mode);
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                fileChooser.addChoosableFileFilter(filters[i]);
            }
            fileChooser.setFileFilter(filters[0]);
        }
        return fileChooser;
    }

    public static JFileChooser createProjectChooser(ExecutionEnvironment execEnv, String titleText, String description, String buttonText, String initialPath) {
        FileChooserBuilder.JFileChooserEx fileChooser = (FileChooserBuilder.JFileChooserEx)RemoteFileUtil.createFileChooser(execEnv, titleText, buttonText, 1, null, initialPath, true);
        fileChooser.setFileView(new ProjectSelectionFileView((JFileChooser)fileChooser));
        return fileChooser;
    }

    public static String getProjectsFolder(ExecutionEnvironment env) {
        Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
        String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        return pref.get("ProjectPath" + envID, null);
    }

    public static void setProjectsFolder(String folder, ExecutionEnvironment env) {
        Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
        String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        pref.put("ProjectPath" + envID, folder);
    }

    public static String getCurrentChooserFile(String key, ExecutionEnvironment env) {
        if (env.isLocal()) {
            if (FileChooser.getCurrentChooserFile() != null) {
                return FileChooser.getCurrentChooserFile().getPath();
            }
            return null;
        }
        Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
        String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        return pref.get("FileChooserPath" + envID + key, null);
    }

    public static void setCurrentChooserFile(String key, String path, ExecutionEnvironment env) {
        if (path == null) {
            return;
        }
        if (env.isLocal()) {
            FileChooser.setCurrentChooserFile((File)new File(path));
        } else {
            Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
            String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
            pref.put("FileChooserPath" + envID + key, path);
        }
    }

    public static String getCurrentChooserFile(ExecutionEnvironment env) {
        if (env.isLocal()) {
            if (FileChooser.getCurrentChooserFile() != null) {
                return FileChooser.getCurrentChooserFile().getPath();
            }
            return null;
        }
        Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
        String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        return pref.get("FileChooserPath" + envID, null);
    }

    public static void setCurrentChooserFile(String path, ExecutionEnvironment env) {
        if (path == null) {
            return;
        }
        if (env.isLocal()) {
            FileChooser.setCurrentChooserFile((File)new File(path));
        } else {
            Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
            String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
            pref.put("FileChooserPath" + envID, path);
        }
    }

    private static final class ProjectSelectionFileView
    extends FileView
    implements Runnable {
        private final JFileChooser chooser;
        private final Map<File, Icon> knownProjectIcons = new HashMap<File, Icon>();
        private final RequestProcessor.Task task = new RequestProcessor("ProjectIconFileView").create((Runnable)this);
        private File lookingForIcon;

        public ProjectSelectionFileView(JFileChooser chooser) {
            this.chooser = chooser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getIcon(File f) {
            if (f.isDirectory() && !f.toString().matches("/[^/]+") && f.getParentFile() != null) {
                ProjectSelectionFileView projectSelectionFileView = this;
                synchronized (projectSelectionFileView) {
                    Icon icon = this.knownProjectIcons.get(f);
                    if (icon != null) {
                        return icon;
                    }
                    if (this.lookingForIcon == null) {
                        this.lookingForIcon = f;
                        this.task.schedule(20);
                    }
                }
            }
            return this.chooser.getFileSystemView().getSystemIcon(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String path = this.lookingForIcon.getAbsolutePath();
            String project = path + "/nbproject";
            File projectDir = this.chooser.getFileSystemView().createFileObject(project);
            Icon icon = this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
            if (projectDir.exists() && projectDir.isDirectory() && projectDir.canRead()) {
                String projectXml = path + "/nbproject/project.xml";
                File projectFile = this.chooser.getFileSystemView().createFileObject(projectXml);
                if (projectFile.exists()) {
                    String conf = path + "/nbproject/configurations.xml";
                    File configuration = this.chooser.getFileSystemView().createFileObject(conf);
                    if (configuration.exists()) {
                        icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)true);
                    }
                }
            }
            ProjectSelectionFileView projectSelectionFileView = this;
            synchronized (projectSelectionFileView) {
                this.knownProjectIcons.put(this.lookingForIcon, icon);
                this.lookingForIcon = null;
            }
            this.chooser.repaint();
        }
    }
}

