/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

public class WordDelineator {
    private String delimiters = new String();

    protected int charClass(char c) {
        if (Character.isWhitespace(c)) {
            return 1;
        }
        if (this.delimiters.indexOf(c) >= 0) {
            return 2;
        }
        return 0;
    }

    protected void setWordDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    protected int findLeft(StringBuffer buf, int start) {
        int lx;
        int cclass = this.charClass(buf.charAt(start));
        for (lx = start; lx > 0 && this.charClass(buf.charAt(lx - 1)) == cclass; --lx) {
        }
        return lx;
    }

    protected int findRight(StringBuffer buf, int start) {
        int rx;
        int cclass = this.charClass(buf.charAt(start));
        for (rx = start; rx < buf.length() && this.charClass(buf.charAt(rx)) == cclass; ++rx) {
        }
        return --rx;
    }
}

