/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JToggleButton;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.VariableModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.VariablesViewButtons;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.MaxObjectAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineCapability;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;

public final class LocalModel
extends VariableModel
implements NodeActionsProvider {
    private static final WarningMessage NO_CODEMODEL_WARNING = new WarningMessage("CTL_WatchesModel_Warning_Watch_Hint");
    private Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node("variables_view");
    private VariablesPreferenceChangeListener prefListener = new VariablesPreferenceChangeListener();

    public LocalModel(ContextProvider ctx) {
        super(ctx);
        this.preferences.addPreferenceChangeListener(this.prefListener);
        VariablesViewButtons.createShowAutosButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    JToggleButton b = (JToggleButton)e.getSource();
                    LocalModel.this.debugger.setShowAutos(b.isSelected());
                }
            }
        });
    }

    @Override
    protected boolean isLocal() {
        return true;
    }

    @Override
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        Object[] children;
        if (parent == "Root") {
            if (VariablesViewButtons.isShowAutos()) {
                children = this.debugger.getAutos();
                if (children != null && children.length > 0 && children[0] == null) {
                    Object[] newChildren = new Object[]{NO_CODEMODEL_WARNING};
                    children = newChildren;
                }
            } else {
                children = this.debugger.getLocals();
            }
        } else if (parent instanceof Variable) {
            Variable v = (Variable)parent;
            children = v.getChildren();
            if (v.hasMore()) {
                Object[] newChildren = new Object[children.length + 1];
                System.arraycopy(children, 0, newChildren, 0, children.length);
                newChildren[newChildren.length - 1] = new VariableModel.ShowMoreMessage(v);
                children = newChildren;
            }
        } else {
            throw new UnknownTypeException(parent);
        }
        return children;
    }

    @Override
    public int getChildrenCount(Object parent) throws UnknownTypeException {
        int count;
        if (parent == "Root") {
            count = VariablesViewButtons.isShowAutos() ? this.debugger.getAutosCount() : this.debugger.getLocalsCount();
        } else if (parent instanceof Variable) {
            Variable v = (Variable)parent;
            count = v.getNumChild();
        } else {
            throw new UnknownTypeException(parent);
        }
        return count;
    }

    @Override
    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof WarningMessage) {
            return ((WarningMessage)node).getMessage();
        }
        return super.getDisplayName(original, node);
    }

    @Override
    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof WarningMessage) {
            return null;
        }
        return super.getIconBaseWithExtension(original, node);
    }

    @Override
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof WarningMessage) {
            return "";
        }
        return super.getValueAt(node, columnID);
    }

    public void addModelListener(ModelListener l) {
        if (super.addModelListenerHelp(l)) {
            this.debugger.setShowAutos(VariablesViewButtons.isShowAutos());
            this.debugger.registerLocalModel(this);
        }
    }

    public void removeModelListener(ModelListener l) {
        if (super.removeModelListenerHelp(l)) {
            this.debugger.setShowAutos(false);
            this.debugger.registerLocalModel(null);
        }
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        EngineDescriptor desp = this.debugger.getNDI().getEngineDescriptor();
        boolean canDoMaxObject = desp.hasCapability(EngineCapability.MAX_OBJECT);
        boolean canDoDy = desp.hasCapability(EngineCapability.DYNAMIC_TYPE);
        boolean canDoIn = desp.hasCapability(EngineCapability.INHERITED_MEMBERS);
        boolean canDoSt = desp.hasCapability(EngineCapability.STATIC_MEMBERS);
        boolean canDoPP = desp.hasCapability(EngineCapability.PRETTY_PRINT);
        if (node == "Root") {
            return new Action[]{WatchModel.NEW_WATCH_ACTION, new WatchModel.DeleteAllAction(), null, canDoIn ? Action_INHERITED_MEMBERS : null, canDoDy ? Action_DYNAMIC_TYPE : null, canDoSt ? Action_STATIC_MEMBERS : null, canDoPP ? Action_PRETTY_PRINT : null, null, canDoMaxObject ? (MaxObjectAction)SystemAction.get(MaxObjectAction.class) : null, null};
        }
        if (node instanceof Variable) {
            Variable v = (Variable)node;
            return v.getActions(false);
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof Variable) {
            Variable variable = (Variable)node;
        } else if (node instanceof VariableModel.ShowMoreMessage) {
            ((VariableModel.ShowMoreMessage)node).getMore();
        } else {
            throw new UnknownTypeException(node);
        }
    }

    private static class WarningMessage {
        private String key;

        WarningMessage(String keyStr) {
            this.key = keyStr;
        }

        public String getMessage() {
            return Catalog.get(this.key);
        }
    }

    private class VariablesPreferenceChangeListener
    implements PreferenceChangeListener {
        private VariablesPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if ("show_autos".equals(key)) {
                this.refresh();
            }
        }

        private void refresh() {
            try {
                LocalModel.this.treeChanged();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        }
    }
}

