/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchModel;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class ToolTipView
extends JComponent
implements ExplorerManager.Provider {
    private static final ToolTipView INSTANCE = new ToolTipView();
    private static final ExplorerManager manager = new ExplorerManager();
    private static RequestProcessor RP = new RequestProcessor(ToolTipView.class.getName());
    private ActionListener listener;
    public static final int ON_DISPOSE = 0;

    public static ToolTipView getDefault() {
        return INSTANCE;
    }

    public ToolTipView() {
        OutlineView ov = new OutlineView();
        ov.setPropertyColumns(new String[]{"value", "Value"});
        ov.getOutline().getColumnModel().getColumn(0).setHeaderValue("Name");
        ov.getOutline().setRootVisible(true);
        ov.setVerticalScrollBarPolicy(22);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getForeground()), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.setLayout(new BorderLayout());
        this.add((Component)ov, "Center");
    }

    public ToolTipView setRootElement(Node node) {
        this.getExplorerManager().setRootContext(node);
        return this;
    }

    public ToolTipView setOnDisposeListener(ActionListener listener) {
        this.listener = listener;
        return this;
    }

    public void showTooltip() {
        JEditorPane ep = EditorContextDispatcher.getDefault().getMostRecentEditor();
        EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
        ToolTipSupport toolTipSupport = eui.getToolTipSupport();
        toolTipSupport.setToolTip((JComponent)this, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0, 4);
    }

    public ExplorerManager getExplorerManager() {
        return manager;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag && this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, null));
            this.listener = null;
        }
    }

    public static ExpandableTooltip getExpTooltipForText(String toolTipText) {
        return new ExpandableTooltip(toolTipText);
    }

    public static class ExpandableTooltip
    extends JPanel {
        private static final String UI_PREFIX = "ToolTip";
        private JButton expButton;
        private JComponent textToolTip;
        private boolean widthCheck = true;
        private boolean sizeSet = false;

        public ExpandableTooltip(String toolTipText) {
            Font font = UIManager.getFont("ToolTip.font");
            Color backColor = UIManager.getColor("ToolTip.background");
            Color foreColor = UIManager.getColor("ToolTip.foreground");
            if (backColor != null) {
                this.setBackground(backColor);
            }
            this.setOpaque(true);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
            this.setLayout(new BoxLayout(this, 0));
            Icon expIcon = UIManager.getIcon("Tree.collapsedIcon");
            this.expButton = new JButton(expIcon);
            this.expButton.setBorder(new EmptyBorder(0, 0, 0, 5));
            this.expButton.setBorderPainted(false);
            this.expButton.setContentAreaFilled(false);
            this.add(this.expButton);
            JTextArea l = ExpandableTooltip.createMultiLineToolTip(toolTipText, true);
            if (font != null) {
                l.setFont(font);
            }
            if (foreColor != null) {
                l.setForeground(foreColor);
            }
            if (backColor != null) {
                l.setBackground(backColor);
            }
            this.textToolTip = l;
            this.add(l);
        }

        public void addExpansionListener(ActionListener treeExpansionListener) {
            this.expButton.addActionListener(treeExpansionListener);
        }

        void setWidthCheck(boolean widthCheck) {
            this.widthCheck = widthCheck;
        }

        @Override
        public Dimension getPreferredSize() {
            if (!this.sizeSet) {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            return super.getPreferredSize();
        }

        @Override
        public void setSize(int width, int height) {
            Dimension prefSize = this.getPreferredSize();
            Dimension buttonSize = this.expButton.getPreferredSize();
            if (this.widthCheck) {
                Insets insets = this.getInsets();
                int textWidth = width - insets.left - buttonSize.width - insets.right;
                height = Math.max(height, buttonSize.height);
                this.textToolTip.setSize(textWidth, height);
                Dimension textPreferredSize = this.textToolTip.getPreferredSize();
                super.setSize(insets.left + buttonSize.width + textPreferredSize.width + insets.right, insets.top + Math.max(buttonSize.height, textPreferredSize.height) + insets.bottom);
            } else {
                if (height >= prefSize.height) {
                    height = prefSize.height;
                }
                super.setSize(width, height);
            }
            this.sizeSet = true;
        }

        public void showTooltip() {
            JEditorPane ep = EditorContextDispatcher.getDefault().getMostRecentEditor();
            EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
            ToolTipSupport toolTipSupport = eui.getToolTipSupport();
            toolTipSupport.setToolTip((JComponent)this);
        }

        private static JTextArea createMultiLineToolTip(String toolTipText, boolean wrapLines) {
            TextToolTip ta = new TextToolTip(wrapLines);
            ta.setText(toolTipText);
            return ta;
        }

        private static class TextToolTip
        extends JTextArea {
            private static final String ELIPSIS = "...";
            private final boolean wrapLines;

            public TextToolTip(boolean wrapLines) {
                this.wrapLines = wrapLines;
                this.setLineWrap(false);
            }

            @Override
            public void setSize(int width, int height) {
                Dimension prefSize = this.getPreferredSize();
                if (width >= prefSize.width) {
                    width = prefSize.width;
                } else {
                    if (this.wrapLines) {
                        this.setLineWrap(true);
                        this.setWrapStyleWord(true);
                    }
                    super.setSize(width, Integer.MAX_VALUE);
                    prefSize = this.getPreferredSize();
                }
                if (height >= prefSize.height) {
                    height = prefSize.height;
                } else {
                    super.setSize(width, Integer.MAX_VALUE);
                    int offset = this.viewToModel(new Point(0, height));
                    Document doc = this.getDocument();
                    try {
                        if (offset > ELIPSIS.length()) {
                            doc.remove(offset -= ELIPSIS.length(), doc.getLength() - offset);
                            doc.insertString(offset, ELIPSIS, null);
                        }
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                    height = Math.min(height, this.getPreferredSize().height);
                }
                super.setSize(width, height);
            }

            @Override
            public void setKeymap(Keymap map) {
                super.setKeymap(TextToolTip.addKeymap(null, map));
            }
        }
    }

    public static abstract class VariableNodeChildren
    extends Children.Keys<Variable> {
        private final Variable var;

        public VariableNodeChildren(Variable v) {
            this.var = v;
        }

        private void updateKeys() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VariableNodeChildren.this.setKeys(VariableNodeChildren.this.var.getChildren());
                        }
                    });
                }
            });
        }

        protected Node[] createNodes(Variable key) {
            return new Node[]{new VariableNode(key, Children.LEAF)};
        }
    }

    public static final class VariableNode
    extends AbstractNode {
        private Variable v;
        private static final Map<Variable, VariableNode> variables = new HashMap<Variable, VariableNode>();
        private static WatchModel watchModel = new WatchModel();

        public VariableNode(Variable v, Children ch) {
            super(ch);
            this.v = v;
            this.add(v);
        }

        private void add(Variable v) {
            variables.put(v, this);
        }

        public static void propertyChanged(Variable v) {
            final VariableNode node = variables.get(v);
            if (node == null) {
                return;
            }
            if (EventQueue.isDispatchThread()) {
                node.propertyChanged();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        node.propertyChanged();
                    }
                });
            }
        }

        public String getDisplayName() {
            return this.v.getVariableName();
        }

        public Image getIcon(int type) {
            String path = "";
            try {
                path = watchModel.getIconBaseWithExtension(null, this.v);
            }
            catch (UnknownTypeException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.setIconBaseWithExtension(path);
            return super.getIcon(type);
        }

        private void propertyChanged() {
            if (this.v.getNumChild() < 1) {
                this.setChildren(Children.LEAF);
            } else if (this.getChildren() instanceof VariableNodeChildren) {
                ((VariableNodeChildren)this.getChildren()).updateKeys();
            }
            String path = "";
            try {
                path = watchModel.getIconBaseWithExtension(null, this.v);
            }
            catch (UnknownTypeException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.setIconBaseWithExtension(path);
            this.fireDisplayNameChange("old", "new");
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{new VariableNodePropertySet(this.v)};
        }

        private final class VariableNodePropertySet
        extends Node.PropertySet {
            private Variable v;

            public VariableNodePropertySet(Variable v) {
                this.v = v;
            }

            public Node.Property<?>[] getProperties() {
                Node.Property[] ps = new Node.Property[]{new Node.Property<String>(String.class){

                    public String getName() {
                        return "value";
                    }

                    public boolean canRead() {
                        return true;
                    }

                    public String getValue() throws IllegalAccessException, InvocationTargetException {
                        return VariableNodePropertySet.this.v.getAsText();
                    }

                    public boolean canWrite() {
                        return false;
                    }

                    public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    }
                }};
                return ps;
            }
        }
    }
}

