/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.api;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.EngineNodeProp;
import org.netbeans.modules.cnd.debugger.common2.debugger.spi.EngineCapabilityProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class EngineTypeManager {
    private static final EngineType INHERIT = new EngineType(true, "INHERIT", NbBundle.getMessage(EngineNodeProp.class, (String)"InheritedFromToolCollection"));

    private EngineTypeManager() {
    }

    public static EngineType create(String debuggerID, String displayName) {
        return new EngineType(false, debuggerID, displayName);
    }

    public static EngineType getInherited() {
        return INHERIT;
    }

    public static EngineType getEngineTypeByID(String debuggerID) {
        return EngineTypeManager.getEngineTypeByIDImpl(debuggerID, true);
    }

    private static EngineType getEngineTypeByIDImpl(String debuggerID, boolean useFallback) {
        if (debuggerID != null && debuggerID.equalsIgnoreCase(INHERIT.getDebuggerID())) {
            return INHERIT;
        }
        Collection<EngineType> engineTypes = EngineTypeManager.getEngineTypes(false);
        assert (!engineTypes.isEmpty()) : "at least one engine is expected to be registered";
        if (debuggerID != null) {
            for (EngineType engineType : engineTypes) {
                if (!debuggerID.equalsIgnoreCase(engineType.getDebuggerID())) continue;
                return engineType;
            }
        }
        if (useFallback) {
            return engineTypes.iterator().next();
        }
        return null;
    }

    public static EngineType getEngineTypeForDebuggerDescriptor(ToolchainManager.DebuggerDescriptor descriptor) {
        Collection services = Lookup.getDefault().lookupAll(EngineCapabilityProvider.class);
        for (EngineCapabilityProvider provider : services) {
            if (!provider.isSupported(descriptor)) continue;
            return provider.engineType();
        }
        return null;
    }

    public static EngineType getEngineTypeByDisplayName(String debuggerDispalyName) {
        if (debuggerDispalyName != null && debuggerDispalyName.equals(INHERIT.getDisplayName())) {
            return INHERIT;
        }
        Collection<EngineType> engineTypes = EngineTypeManager.getEngineTypes(false);
        assert (!engineTypes.isEmpty()) : "at least one engine is expected to be registered";
        if (debuggerDispalyName != null) {
            for (EngineType engineType : engineTypes) {
                if (!debuggerDispalyName.equals(engineType.getDisplayName())) continue;
                return engineType;
            }
        }
        return engineTypes.iterator().next();
    }

    public static EngineType getOverrideEngineType() {
        return EngineTypeManager.getEngineTypeByIDImpl(System.getProperty("cnd.nativedebugger"), false);
    }

    public static EngineType getFallbackEnineType() {
        return EngineTypeManager.getEngineTypeByIDImpl(null, true);
    }

    public static Collection<EngineType> getEngineTypes(boolean withInherited) {
        ArrayList<EngineType> out = new ArrayList<EngineType>();
        if (withInherited) {
            out.add(INHERIT);
        }
        Collection services = Lookup.getDefault().lookupAll(EngineCapabilityProvider.class);
        for (EngineCapabilityProvider provider : services) {
            out.add(provider.engineType());
        }
        return out;
    }

    public static String engine2DebugProfileID(EngineType engine) {
        Collection<EngineType> engineTypes = EngineTypeManager.getEngineTypes(false);
        assert (!engineTypes.isEmpty()) : "at least one engine is expected to be registered";
        Collection services = Lookup.getDefault().lookupAll(EngineCapabilityProvider.class);
        for (EngineCapabilityProvider provider : services) {
            if (!provider.engineType().equals(engine)) continue;
            return provider.debuggerProfileID();
        }
        assert (false) : "unexpected engine " + engine;
        return ((EngineCapabilityProvider)services.iterator().next()).debuggerProfileID();
    }
}

