/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionPropertySupport;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

class OptionDirectoriesEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private OptionPropertySupport ops;
    private final String baseDir;
    private final FileSystem fileSystem;
    private PropertyEnv env;

    public OptionDirectoriesEditor(OptionPropertySupport ops, String baseDir) {
        this(ops, baseDir, FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()));
    }

    public OptionDirectoriesEditor(OptionPropertySupport ops, String baseDir, FileSystem fileSystem) {
        this.ops = ops;
        this.baseDir = baseDir;
        this.fileSystem = fileSystem;
    }

    @Override
    public void setAsText(String text) {
        this.ops.setValue(text);
    }

    @Override
    public String getAsText() {
        return (String)this.getValue();
    }

    @Override
    public void setValue(Object v) {
        if (v instanceof List) {
            boolean addSep = false;
            StringBuilder ret = new StringBuilder();
            for (Object row : (List)v) {
                if (addSep) {
                    ret.append(File.pathSeparator);
                }
                ret.append(row.toString());
                addSep = true;
            }
            this.ops.setValue(ret.toString());
        }
    }

    @Override
    public Object getValue() {
        return this.ops.getValue();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new DirectoriesChooser(this, this.env, this.baseDir, (String)this.ops.getValue(), this.fileSystem);
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    static class DirectoriesChooser
    extends ListEditorPanel<String>
    implements PropertyChangeListener {
        private final PropertyEditorSupport editor;
        private final String baseDir;
        private final String path;
        private final FileSystem fileSystem;

        private DirectoriesChooser(PropertyEditorSupport editor, PropertyEnv env, String baseDir, String path, FileSystem fileSystem) {
            super((Collection)DirectoriesChooser.getPathsFromString(path));
            this.getDefaultButton().setVisible(false);
            this.editor = editor;
            this.baseDir = baseDir;
            this.path = path;
            this.fileSystem = fileSystem;
            env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            env.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private static String fullPath(String baseDir, String path) {
            String seed = path;
            if (seed.length() == 0) {
                seed = ".";
            }
            if (!CndPathUtilities.isPathAbsolute((CharSequence)seed)) {
                seed = baseDir + File.separatorChar + seed;
            }
            return seed;
        }

        private static List getPathsFromString(String inpStr) {
            ArrayList<String> newList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(inpStr, File.pathSeparator);
            while (st.hasMoreTokens()) {
                newList.add(st.nextToken());
            }
            return newList;
        }

        public String addAction() {
            JFileChooser fileChooser = RemoteFileUtil.isRemote((FileSystem)this.fileSystem) ? RemoteFileUtil.createFileChooser((FileSystem)this.fileSystem, (String)DirectoriesChooser.getString("ADD_DIRECTORY_DIALOG_TITLE"), (String)DirectoriesChooser.getString("ADD_DIRECTORY_BUTTON_TXT"), (int)1, null, (String)DirectoriesChooser.fullPath(this.baseDir, this.path), (boolean)true) : new FileChooser(DirectoriesChooser.getString("ADD_DIRECTORY_DIALOG_TITLE"), DirectoriesChooser.getString("ADD_DIRECTORY_BUTTON_TXT"), 1, null, DirectoriesChooser.fullPath(this.baseDir, this.path), true);
            int ret = fileChooser.showOpenDialog((Component)((Object)this));
            if (ret == 1) {
                return null;
            }
            String itemPath = fileChooser.getSelectedFile().getPath();
            itemPath = CndPathUtilities.naturalizeSlashes((String)itemPath);
            String bd = this.baseDir;
            if (bd != null) {
                bd = CndPathUtilities.naturalizeSlashes((String)bd);
            }
            itemPath = CndPathUtilities.toRelativePath((String)bd, (String)itemPath);
            itemPath = CndPathUtilities.normalizeSlashes((String)itemPath);
            return itemPath;
        }

        public String copyAction(String o) {
            return o;
        }

        public void editAction(String o, int i) {
            String s = o;
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(DirectoriesChooser.getString("EDIT_DIALOG_LABEL_TXT"), DirectoriesChooser.getString("EDIT_DIALOG_TITLE_TXT"));
            notifyDescriptor.setInputText(s);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String newS = notifyDescriptor.getInputText().trim();
            this.replaceElement(o, newS, i);
        }

        public String getListLabelText() {
            return DirectoriesChooser.getString("DIRECTORIES_LABEL_TXT");
        }

        public char getListLabelMnemonic() {
            return DirectoriesChooser.getString("DIRECTORIES_LABEL_MN").charAt(0);
        }

        public String getAddButtonText() {
            return DirectoriesChooser.getString("ADD_BUTTON_TXT");
        }

        public char getAddButtonMnemonics() {
            return DirectoriesChooser.getString("ADD_BUTTON_MN").charAt(0);
        }

        public String getRenameButtonText() {
            return DirectoriesChooser.getString("EDIT_BUTTON_TXT");
        }

        public char getRenameButtonMnemonics() {
            return DirectoriesChooser.getString("EDIT_BUTTON_MN").charAt(0);
        }

        public String getDownButtonText() {
            return DirectoriesChooser.getString("DOWN_BUTTON_TXT");
        }

        public char getDownButtonMnemonics() {
            return DirectoriesChooser.getString("DOWN_BUTTON_MN").charAt(0);
        }

        protected String getUpButtonText() {
            return DirectoriesChooser.getString("UP_BUTTON_TXT");
        }

        public char getUpButtonMnemonics() {
            return DirectoriesChooser.getString("UP_BUTTON_MN").charAt(0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
                this.editor.setValue(this.getListData());
            }
        }

        private static String getString(String key) {
            return NbBundle.getMessage(OptionDirectoriesEditor.class, (String)key);
        }
    }
}

