/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BIEditorSupport;
import org.netbeans.modules.beans.beaninfo.BeanInfoSource;
import org.netbeans.modules.beans.beaninfo.BiFeature;
import org.netbeans.modules.beans.beaninfo.GenerateBeanInfoAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class BiAnalyser {
    private static final String TAB = "    ";
    private static final String TABx2 = "        ";
    private static final String TABx3 = "            ";
    private static final String NOI18N_COMMENT = " // NOI18N";
    private static final String ICONNAME_C16 = "iconNameC16";
    private static final String ICONNAME_C32 = "iconNameC32";
    private static final String ICONNAME_M16 = "iconNameM16";
    private static final String ICONNAME_M32 = "iconNameM32";
    private static final String DEFAULT_PROPERTY_INDEX = "defaultPropertyIndex";
    private static final String DEFAULT_EVENT_INDEX = "defaultEventIndex";
    List<BiFeature.Descriptor> descriptor;
    List<BiFeature.Property> properties;
    List<BiFeature.IdxProperty> idxProperties;
    List<BiFeature.EventSet> eventSets;
    List<BiFeature.Method> methods;
    BeanInfoSource bis;
    private boolean nullDescriptor = false;
    private boolean nullProperties = false;
    private boolean nullEventSets = false;
    private boolean nullMethods = false;
    private boolean lazyDescriptor = true;
    private boolean lazyProperties = true;
    private boolean lazyEventSets = true;
    private boolean lazyMethods = true;
    private final boolean olderVersion;
    private boolean superClassVersion = true;
    private String classfqn;
    private String iconC16;
    private String iconM16;
    private String iconC32;
    private String iconM32;
    private int defaultPropertyIndex = -1;
    private int defaultEventIndex = -1;
    private boolean useSuperClass = false;
    private boolean isModified = false;
    private boolean isIconModified = false;
    private boolean isUpdateMode;
    private boolean isBeanBroken = false;

    private static void removeMethods(List<BiFeature.Method> methods, ElementHandle<ExecutableElement> ... removes) {
        ArrayList<ElementHandle<ExecutableElement>> realremoves = new ArrayList<ElementHandle<ExecutableElement>>(removes.length);
        for (ElementHandle<ExecutableElement> elementHandle : removes) {
            if (elementHandle == null) continue;
            realremoves.add(elementHandle);
        }
        if (realremoves.isEmpty()) {
            return;
        }
        for (int i = methods.size() - 1; i >= 0; --i) {
            ElementHandle<ExecutableElement> method = methods.get(i).getElement();
            for (int ri = 0; ri < realremoves.size(); ++ri) {
                ElementHandle elementHandle = (ElementHandle)realremoves.get(ri);
                if (!elementHandle.equals(method)) continue;
                methods.remove(i);
                realremoves.remove(ri);
                break;
            }
            if (!realremoves.isEmpty()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BiAnalyser(PatternAnalyser pa, CompilationInfo javac) throws GenerateBeanException {
        for (Diagnostic d : javac.getDiagnostics()) {
            this.isBeanBroken |= d.getKind() == Diagnostic.Kind.ERROR;
        }
        this.bis = new BeanInfoSource(pa.getFileObject());
        this.olderVersion = this.bis.isNbBeanInfo() && this.bis.getMethodsSection() == null;
        this.superClassVersion = this.bis.isNbSuperclass() || !this.bis.exists();
        TypeElement classElement = (TypeElement)pa.getClassElementHandle().resolve(javac);
        this.classfqn = classElement.getQualifiedName().toString();
        this.descriptor = new ArrayList<BiFeature.Descriptor>();
        this.descriptor.add(new BiFeature.Descriptor(classElement, this));
        this.methods = new ArrayList<BiFeature.Method>();
        if (!this.olderVersion) {
            for (ExecutableElement executableElement : BeanUtils.methodsIn(classElement, javac)) {
                this.methods.add(new BiFeature.Method(executableElement, pa, javac, this));
            }
        }
        List<PropertyPattern> propertyPatterns = pa.getPropertyPatterns();
        this.properties = new ArrayList<BiFeature.Property>(propertyPatterns.size());
        for (PropertyPattern pp : propertyPatterns) {
            this.properties.add(new BiFeature.Property(pp, javac, this));
            BiAnalyser.removeMethods(this.methods, pp.getGetterMethod(), pp.getSetterMethod());
        }
        List<IdxPropertyPattern> list = pa.getIdxPropertyPatterns();
        this.idxProperties = new ArrayList<BiFeature.IdxProperty>(list.size());
        for (IdxPropertyPattern ipp : list) {
            TypeMirror type = ipp.getType().resolve(javac);
            TypeMirror idxtype = ipp.getIndexedType().resolve(javac);
            if (type.getKind() != TypeKind.ARRAY || !javac.getTypes().isSameType(((ArrayType)type).getComponentType(), idxtype)) continue;
            this.idxProperties.add(new BiFeature.IdxProperty(ipp, javac, this));
            BiAnalyser.removeMethods(this.methods, ipp.getGetterMethod(), ipp.getSetterMethod(), ipp.getIndexedGetterMethod(), ipp.getIndexedSetterMethod());
        }
        List<EventSetPattern> eventSetPatterns = pa.getEventSetPatterns();
        this.eventSets = new ArrayList<BiFeature.EventSet>(eventSetPatterns.size());
        for (EventSetPattern esp : eventSetPatterns) {
            this.eventSets.add(new BiFeature.EventSet(esp, javac, this));
            BiAnalyser.removeMethods(this.methods, esp.getAddListenerMethod(), esp.getRemoveListenerMethod());
        }
        Collections.sort(this.methods);
        try {
            this.isUpdateMode = false;
            this.analyzeBeanInfoSource();
        }
        finally {
            this.isUpdateMode = true;
        }
    }

    List<BiFeature.Descriptor> getDescriptor() {
        return this.descriptor;
    }

    List<BiFeature.Property> getProperties() {
        return this.properties;
    }

    List<BiFeature.IdxProperty> getIdxProperties() {
        return this.idxProperties;
    }

    List<BiFeature.EventSet> getEventSets() {
        return this.eventSets;
    }

    List<BiFeature.Method> getMethods() {
        return this.methods;
    }

    public boolean isOlderVersion() {
        return this.olderVersion;
    }

    public boolean isSuperclassVersion() {
        return this.superClassVersion;
    }

    public String getIconC16() {
        return this.iconC16;
    }

    public void setIconC16(String iconC16) {
        this.iconC16 = iconC16;
        this.setIconModified();
    }

    public String getIconM16() {
        return this.iconM16;
    }

    public void setIconM16(String iconM16) {
        this.iconM16 = iconM16;
        this.setIconModified();
    }

    public String getIconC32() {
        return this.iconC32;
    }

    public void setIconC32(String iconC32) {
        this.iconC32 = iconC32;
        this.setIconModified();
    }

    public String getIconM32() {
        return this.iconM32;
    }

    public void setIconM32(String iconM32) {
        this.iconM32 = iconM32;
        this.setIconModified();
    }

    public int getDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    public void setDefaultPropertyIndex(int defaultPropertyIndex) {
        this.defaultPropertyIndex = defaultPropertyIndex;
        this.setModified();
    }

    public int getDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    public void setDefaultEventIndex(int defaultEventIndex) {
        this.defaultEventIndex = defaultEventIndex;
        this.setModified();
    }

    public boolean isUseSuperClass() {
        return this.useSuperClass;
    }

    public void setUseSuperClass(boolean useSuperClass) {
        this.useSuperClass = useSuperClass;
        this.setModified();
    }

    boolean isNullDescriptor() {
        return this.nullDescriptor;
    }

    boolean isNullProperties() {
        return this.nullProperties;
    }

    boolean isNullMethods() {
        return this.nullMethods;
    }

    void setNullDescriptor(boolean nullDescriptor) {
        this.nullDescriptor = nullDescriptor;
        this.setModified();
    }

    void setNullProperties(boolean nullProperties) {
        this.nullProperties = nullProperties;
        this.setModified();
    }

    void setNullMethods(boolean nullMethods) {
        this.nullMethods = nullMethods;
        this.setModified();
    }

    boolean isNullEventSets() {
        return this.nullEventSets;
    }

    void setNullEventSets(boolean nullEventSets) {
        this.nullEventSets = nullEventSets;
        this.setModified();
    }

    public boolean isLazyDescriptor() {
        return this.lazyDescriptor;
    }

    public boolean isLazyProperties() {
        return this.lazyProperties;
    }

    public boolean isLazyMethods() {
        return this.lazyMethods;
    }

    public void setLazyDescriptor(boolean lazyDescriptor) {
        this.lazyDescriptor = lazyDescriptor;
        this.setModified();
    }

    public void setLazyProperties(boolean lazyProperties) {
        this.lazyProperties = lazyProperties;
        this.setModified();
    }

    public void setLazyMethods(boolean lazyMethods) {
        this.lazyMethods = lazyMethods;
        this.setModified();
    }

    public boolean isLazyEventSets() {
        return this.lazyEventSets;
    }

    public void setLazyEventSets(boolean lazyEventSets) {
        this.lazyEventSets = lazyEventSets;
        this.setModified();
    }

    void regenerateSource() {
        if (this.bis.exists() && !this.bis.isNbBeanInfo()) {
            throw new IllegalStateException();
        }
        DataObject dataObject = this.bis.getDataObject();
        EditorCookie editor = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        final StyledDocument doc = editor.getDocument();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                BiAnalyser.this.regenerateSourceImpl(doc);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    void regenerateSourceImpl(StyledDocument doc) {
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            @Override
            public void run() {
                BiAnalyser.this.regenerateBeanDescriptor();
                BiAnalyser.this.regenerateProperties();
                BiAnalyser.this.regenerateEvents();
                if (!BiAnalyser.this.olderVersion) {
                    BiAnalyser.this.regenerateMethods();
                }
                BiAnalyser.this.regenerateIcons();
                BiAnalyser.this.regenerateDefaultIdx();
                BiAnalyser.this.regenerateSuperclass();
                BiAnalyser.this.isModified = false;
                BiAnalyser.this.isIconModified = false;
            }
        });
    }

    void openSource() {
        if (this.bis.exists()) {
            if (!this.bis.isNbBeanInfo()) {
                if (this.isBeanBroken) {
                    String mssg = NbBundle.getMessage(BiAnalyser.class, (String)"MSG_BrokenBean", (Object)this.bis.getSourceDataObject().getPrimaryFile().getNameExt());
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)mssg, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                String mssg = GenerateBeanInfoAction.getString("MSG_BeanInfoExists");
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    return;
                }
                try {
                    this.bis.delete();
                }
                catch (IOException e) {
                    mssg = GenerateBeanInfoAction.getString("MSG_BeanInfoCantDelete");
                    nd = new NotifyDescriptor.Message((Object)mssg);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                this.bis.createFromTemplate(true);
                this.regenerateSource();
                BIEditorSupport editor = (BIEditorSupport)((Object)this.bis.getDataObject().getLookup().lookup(BIEditorSupport.class));
                try {
                    editor.saveDocument();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else {
            if (this.isBeanBroken) {
                String mssg = NbBundle.getMessage(BiAnalyser.class, (String)"MSG_BrokenBean", (Object)this.bis.getSourceDataObject().getPrimaryFile().getNameExt());
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)mssg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
            String mssg = NbBundle.getMessage(BiAnalyser.class, (String)"MSG_BeanInfoNotExists");
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                return;
            }
            this.bis.createFromTemplate(true);
            this.regenerateSource();
            BIEditorSupport editor = (BIEditorSupport)((Object)this.bis.getDataObject().getLookup().lookup(BIEditorSupport.class));
            try {
                editor.saveDocument();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (!this.bis.isNbBeanInfo()) {
                return;
            }
        }
        this.bis.open();
    }

    private void regenerateBeanDescriptor() {
        StringBuilder sb = new StringBuilder(512);
        if (this.nullDescriptor) {
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullDescriptor"));
            sb.append("    private static BeanDescriptor beanDescriptor = null;\n");
            sb.append("    private static BeanDescriptor getBdescriptor(){\n\n");
            this.bis.setDescriptorSection(sb.toString(), "\n        return beanDescriptor;\n    }\n\n");
            return;
        }
        for (BiFeature.Descriptor bif : this.getDescriptor()) {
            if (!bif.isIncluded()) continue;
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_BeanDescriptor"));
            if (!this.lazyDescriptor) {
                sb.append("    private static BeanDescriptor beanDescriptor = ");
                sb.append(bif.getCreationString());
                sb.append(';');
                this.appendNoi18nText(sb);
                sb.append("\n\n");
                sb.append("    private static BeanDescriptor getBdescriptor(){\n");
                sb.append("        return beanDescriptor;\n    }\n\n");
                sb.append("    static {\n");
            } else {
                sb.append("    /*lazy BeanDescriptor*/\n");
                sb.append("    private static BeanDescriptor getBdescriptor(){\n");
                sb.append("        BeanDescriptor beanDescriptor = ");
                sb.append(bif.getCreationString());
                sb.append(';');
                this.appendNoi18nText(sb);
                sb.append('\n');
            }
            for (String line : bif.getCustomizationStrings()) {
                sb.append("        beanDescriptor.");
                sb.append(line).append(";\n");
            }
            if (!this.lazyDescriptor) {
                this.bis.setDescriptorSection(sb.toString(), "}\n");
                continue;
            }
            this.bis.setDescriptorSection(sb.toString(), "        return beanDescriptor;\n    }\n");
        }
    }

    private void regenerateProperties() {
        StringBuilder sb = new StringBuilder(512);
        int propertyCount = 0;
        if (this.nullProperties) {
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullProperties"));
            sb.append("    private static PropertyDescriptor[] properties = null;\n");
            sb.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            this.bis.setPropertiesSection(sb.toString(), "        return properties;\n    }\n\n");
            return;
        }
        TreeSet<BiFeature.Property> allProperties = new TreeSet<BiFeature.Property>(this.getProperties());
        allProperties.addAll(this.getIdxProperties());
        sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_PropertyIdentifiers"));
        for (BiFeature.Property bif : allProperties) {
            if (!bif.isIncluded()) continue;
            sb.append("    private static final int ");
            sb.append("PROPERTY_" + bif.getName());
            sb.append(" = " + propertyCount++ + ";");
            sb.append("\n");
        }
        sb.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_PropertyArray"));
        if (!this.lazyProperties) {
            sb.append("    private static PropertyDescriptor[] properties = new PropertyDescriptor[" + propertyCount + "];\n\n");
            sb.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            sb.append("        return properties;\n    }\n\n");
        } else {
            sb.append("    /*lazy PropertyDescriptor*/\n");
            sb.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            sb.append("        PropertyDescriptor[] properties = new PropertyDescriptor[");
            sb.append(propertyCount);
            sb.append("];\n");
        }
        if (propertyCount > 0) {
            if (!this.lazyProperties) {
                sb.append("    static {\n        try {\n");
            } else {
                sb.append("    \n        try {\n");
            }
        }
        for (BiFeature.Property bif : allProperties) {
            if (!bif.isIncluded()) continue;
            sb.append("            properties[PROPERTY_").append(bif.getName()).append("] = ");
            sb.append(bif.getCreationString());
            sb.append(';');
            this.appendNoi18nText(sb);
            sb.append('\n');
            for (String line : bif.getCustomizationStrings()) {
                sb.append("            properties[PROPERTY_").append(bif.getName()).append("].");
                sb.append(line).append(";\n");
            }
        }
        if (propertyCount > 0) {
            sb.append("        }\n        catch(IntrospectionException e) {\n            e.printStackTrace();\n        }");
        }
        if (!this.lazyProperties) {
            this.bis.setPropertiesSection(sb.toString(), propertyCount > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setPropertiesSection(sb.toString(), "        return properties;\n    }\n");
        }
    }

    private void regenerateMethods() {
        StringBuilder sb = new StringBuilder(512);
        int methodCount = 0;
        if (this.nullMethods) {
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullMethods"));
            sb.append("    private static MethodDescriptor[] methods = null;\n");
            sb.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            this.bis.setMethodsSection(sb.toString(), "        return methods;\n    }\n\n");
            return;
        }
        List<BiFeature.Method> allMethods = this.methods;
        sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_MethodIdentifiers"));
        for (BiFeature.Method bif : allMethods) {
            if (!bif.isIncluded()) continue;
            sb.append("    private static final int ");
            sb.append("METHOD_" + bif.getName() + methodCount);
            sb.append(" = " + methodCount++ + ";");
            sb.append("\n");
        }
        sb.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_MethodArray"));
        if (!this.lazyMethods) {
            sb.append("    private static MethodDescriptor[] methods = new MethodDescriptor[" + methodCount + "];\n\n");
            sb.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            sb.append("        return methods;\n    }\n\n");
        } else {
            sb.append("    /*lazy MethodDescriptor*/\n");
            sb.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            sb.append("        MethodDescriptor[] methods = new MethodDescriptor[");
            sb.append(methodCount);
            sb.append("];\n");
        }
        if (methodCount > 0) {
            if (!this.lazyMethods) {
                sb.append("    static {\n        try {\n");
            } else {
                sb.append("    \n        try {\n");
            }
        }
        Iterator<BiFeature.Method> it = allMethods.iterator();
        int i = 0;
        int lCurMethodCount = 0;
        while (it.hasNext()) {
            BiFeature bif = it.next();
            if (!bif.isIncluded()) continue;
            sb.append("            methods[METHOD_").append(bif.getName()).append(lCurMethodCount++ + "] = ");
            sb.append(bif.getCreationString());
            sb.append(';');
            this.appendNoi18nText(sb);
            sb.append('\n');
            for (String line : bif.getCustomizationStrings()) {
                sb.append("            methods[METHOD_").append(bif.getName()).append(i + "].");
                sb.append(line).append(";\n");
            }
            ++i;
        }
        if (methodCount > 0) {
            sb.append("        }\n        catch( Exception e) {}");
        }
        if (!this.lazyMethods) {
            this.bis.setMethodsSection(sb.toString(), methodCount > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setMethodsSection(sb.toString(), "        return methods;\n    }\n");
        }
    }

    private void regenerateEvents() {
        StringBuilder sb = new StringBuilder(512);
        int eventCount = 0;
        if (this.nullEventSets) {
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullEventSets"));
            sb.append("    private static EventSetDescriptor[] eventSets = null;\n");
            sb.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            this.bis.setEventSetsSection(sb.toString(), "        return eventSets;\n    }\n\n");
            return;
        }
        sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_EventSetsIdentifiers"));
        TreeSet<BiFeature.EventSet> events = new TreeSet<BiFeature.EventSet>(this.eventSets);
        for (BiFeature.EventSet bif : events) {
            if (!bif.isIncluded()) continue;
            sb.append("    private static final int ");
            sb.append("EVENT_" + bif.getName());
            sb.append(" = " + eventCount++ + ";");
            sb.append("\n");
        }
        sb.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_EventSetsArray"));
        if (!this.lazyEventSets) {
            sb.append("    private static EventSetDescriptor[] eventSets = new EventSetDescriptor[" + eventCount + "];\n\n");
            sb.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            sb.append("        return eventSets;\n    }\n\n");
        } else {
            sb.append("    /*lazy EventSetDescriptor*/\n");
            sb.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            sb.append("        EventSetDescriptor[] eventSets = new EventSetDescriptor[");
            sb.append(eventCount);
            sb.append("];\n");
        }
        if (eventCount > 0) {
            if (!this.lazyEventSets) {
                sb.append("    static {\n        try {\n");
            } else {
                sb.append("    \n        try {\n");
            }
        }
        for (BiFeature.EventSet bif : events) {
            if (!bif.isIncluded()) continue;
            sb.append("            eventSets[EVENT_").append(bif.getName()).append("] = ");
            sb.append(bif.getCreationString());
            sb.append(';');
            this.appendNoi18nText(sb);
            sb.append('\n');
            for (String line : bif.getCustomizationStrings()) {
                sb.append("            eventSets[EVENT_").append(bif.getName()).append("].");
                sb.append(line).append(";\n");
            }
        }
        if (eventCount > 0) {
            sb.append("        }\n        catch(IntrospectionException e) {\n            e.printStackTrace();\n        }");
        }
        if (!this.lazyEventSets) {
            this.bis.setEventSetsSection(sb.toString(), eventCount > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setEventSetsSection(sb.toString(), "        return eventSets;\n    }\n");
        }
    }

    private void regenerateIcons() {
        if (this.iconBlockRequired()) {
            StringBuilder sb = new StringBuilder(200);
            sb.append(BiAnalyser.getIconDeclaration(ICONNAME_C16, this.iconC16));
            sb.append(BiAnalyser.getIconDeclaration(ICONNAME_C32, this.iconC32));
            sb.append(BiAnalyser.getIconDeclaration(ICONNAME_M16, this.iconM16));
            sb.append(BiAnalyser.getIconDeclaration(ICONNAME_M32, this.iconM32));
            this.bis.setIconsSection(sb.toString());
        }
    }

    private boolean iconBlockRequired() {
        return this.iconC16 != null | this.iconC32 != null | this.iconM16 != null | this.iconM32 != null | this.isIconModified;
    }

    private static String getIconDeclaration(String name, String resource) {
        StringBuilder sb = new StringBuilder(80);
        sb.append("    private static String ").append(name).append(" = ");
        if (resource == null || resource.trim().length() == 0) {
            sb.append("null;\n");
        } else {
            sb.append("\"").append(resource.trim()).append("\";\n");
        }
        return sb.toString();
    }

    private void regenerateDefaultIdx() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("    private static final int defaultPropertyIndex = ").append(this.defaultPropertyIndex).append(";\n");
        sb.append("    private static final int defaultEventIndex = ").append(this.defaultEventIndex).append(";\n");
        this.bis.setDefaultIdxSection(sb.toString());
    }

    private void regenerateSuperclass() {
        StringBuilder sb = new StringBuilder(100);
        if (this.isUseSuperClass()) {
            sb.append("    public BeanInfo[] getAdditionalBeanInfo() {\n");
            sb.append("        Class superclass = " + this.classfqn + ".class.getSuperclass();\n");
            sb.append("        BeanInfo sbi = null;\n");
            sb.append("        try {\n");
            sb.append("            sbi = Introspector.getBeanInfo(superclass);\n");
            this.bis.setSuperclassSection(sb.toString(), "            }\ncatch(IntrospectionException ex) {\n}\n\nreturn new BeanInfo[] { sbi };\n}\n");
        } else {
            this.bis.setSuperclassSection("\n", "\n");
        }
    }

    private void analyzeBeanInfoSource() throws GenerateBeanException {
        if (!this.bis.isNbBeanInfo()) {
            return;
        }
        String section = this.bis.getIconsSection();
        List<String> code = BiAnalyser.normalizeText(section);
        this.setIconsFromBeanInfo(code);
        section = this.bis.getDefaultIdxSection();
        code = BiAnalyser.normalizeText(section);
        this.setDefaultIdxFromBeanInfo(code);
        section = this.bis.getDescriptorSection();
        code = BiAnalyser.normalizeText(section);
        this.nullDescriptor = this.setPropertiesFromBeanInfo(this.descriptor, code, "BeanDescriptor");
        if (!this.nullDescriptor) {
            this.setLazyDescriptor(BiAnalyser.isLazy(code, "BeanDescriptor"));
        }
        section = this.bis.getPropertiesSection();
        code = BiAnalyser.normalizeText(section);
        this.nullProperties = this.setPropertiesFromBeanInfo(this.properties, code, "PropertyDescriptor[]");
        if (!this.nullProperties) {
            this.setLazyProperties(BiAnalyser.isLazy(code, "PropertyDescriptor"));
            this.setPropertiesFromBeanInfo(this.idxProperties, code, "PropertyDescriptor[]");
        }
        if ((section = this.bis.getMethodsSection()) == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)GenerateBeanInfoAction.getString("MSG_Old_Version"), 2));
            this.nullMethods = true;
        } else {
            code = BiAnalyser.normalizeText(section);
            this.nullMethods = this.setPropertiesFromBeanInfo(this.methods, code, "MethodDescriptor[]");
            if (!this.nullMethods) {
                this.setLazyMethods(BiAnalyser.isLazy(code, "MethodDescriptor"));
            }
        }
        section = this.bis.getEventSetsSection();
        code = BiAnalyser.normalizeText(section);
        this.nullEventSets = this.setPropertiesFromBeanInfo(this.eventSets, code, "EventSetDescriptor[]");
        if (!this.nullEventSets) {
            this.setLazyEventSets(BiAnalyser.isLazy(code, "EventSetDescriptor"));
        }
        section = this.bis.getSuperclassSection();
        code = BiAnalyser.normalizeText(section);
        this.setUseSuperClass(BiAnalyser.hasSuperClass(code));
    }

    static List<String> normalizeText(String code) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(100);
        boolean IN_TEXT = false;
        boolean IN_WHITE = true;
        int mode = 1;
        int noi18n_length = NOI18N_COMMENT.length();
        boolean eo_javaid = false;
        boolean guarded = false;
        boolean escape = false;
        block4: for (int i = 0; code != null && i < code.length(); ++i) {
            char ch = code.charAt(i);
            if (ch != '\"') {
                escape = false;
            }
            switch (mode) {
                case 0: {
                    if (!Character.isWhitespace(ch)) {
                        if (ch == ';') {
                            sb.append(ch);
                            if (i + noi18n_length < code.length() && NOI18N_COMMENT.equals(code.substring(i + 1, i + 1 + noi18n_length))) {
                                sb.append(NOI18N_COMMENT);
                                i += noi18n_length;
                            }
                            result.add(sb.toString());
                            sb.setLength(0);
                            mode = 1;
                            eo_javaid = false;
                            continue block4;
                        }
                        if (ch == '\\') {
                            escape = true;
                            sb.append(ch);
                            continue block4;
                        }
                        if (ch == '\"') {
                            if (!escape) {
                                guarded = !guarded;
                            }
                            escape = false;
                            sb.append(ch);
                            continue block4;
                        }
                        sb.append(ch);
                        continue block4;
                    }
                    if (guarded) {
                        sb.append(ch);
                        continue block4;
                    }
                    char prevch = code.charAt(i - 1);
                    eo_javaid = Character.isJavaIdentifierPart(prevch) || prevch == ']';
                    mode = 1;
                    continue block4;
                }
                case 1: {
                    if (Character.isWhitespace(ch)) continue block4;
                    if (eo_javaid && Character.isJavaIdentifierStart(ch)) {
                        sb.append(' ');
                    } else if (ch == '\\') {
                        escape = true;
                        sb.append(ch);
                    } else if (ch == '\"') {
                        if (!escape) {
                            guarded = !guarded;
                        }
                        escape = false;
                    }
                    sb.append(ch);
                    mode = 0;
                }
            }
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
        }
        return result;
    }

    static String[] getParameters(String command) {
        int beg = command.indexOf(40);
        int end = command.lastIndexOf(41);
        if (beg == -1 || end == -1 || ++beg >= end) {
            return new String[0];
        }
        String paramString = command.substring(beg, end);
        StringTokenizer strTok = new StringTokenizer(paramString, ",");
        String[] resultStrs = new String[strTok.countTokens()];
        int i = 0;
        while (strTok.hasMoreTokens()) {
            resultStrs[i] = strTok.nextToken();
            ++i;
        }
        return resultStrs;
    }

    static String getArgumentParameter(String command) {
        int beg = command.indexOf(40);
        int end = command.lastIndexOf(41);
        if (beg != -1 && end != -1 && ++beg < end) {
            return command.substring(beg, end);
        }
        return null;
    }

    static String getInitializer(String command) {
        int beg = command.lastIndexOf(61);
        int end = command.lastIndexOf(59);
        if (beg != -1 && end != -1 && ++beg < end) {
            return command.substring(beg, end).trim();
        }
        return null;
    }

    static boolean isLazy(List<String> code, String name) {
        for (String statement : code) {
            if (statement.indexOf(name) == -1 || statement.indexOf("/*lazy " + name + "*/") == -1) continue;
            return true;
        }
        return false;
    }

    static boolean hasSuperClass(List<String> code) {
        for (String statement : code) {
            if (statement.indexOf("public BeanInfo[] getAdditionalBeanInfo()") == -1) continue;
            return true;
        }
        return false;
    }

    static String removeQuotation(String text) {
        int beg = text.indexOf(34);
        int end = text.lastIndexOf(34);
        if (beg != -1 && end != -1 && ++beg < end) {
            return text.substring(beg, end);
        }
        return null;
    }

    boolean setPropertiesFromBeanInfo(List<? extends BiFeature> features, List<String> code, String name) throws GenerateBeanException {
        for (String string : code) {
            if (string.indexOf(name) == -1) continue;
            if (!"null".equals(BiAnalyser.getInitializer(string))) break;
            return true;
        }
        for (BiFeature biFeature : features) {
            biFeature.setBrackets(biFeature.getBrackets());
            biFeature.analyzeCustomization(code);
        }
        return false;
    }

    void setIconsFromBeanInfo(List<String> code) {
        for (String statement : code) {
            if (statement.indexOf(ICONNAME_C16) != -1) {
                this.iconC16 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(statement));
                continue;
            }
            if (statement.indexOf(ICONNAME_C32) != -1) {
                this.iconC32 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(statement));
                continue;
            }
            if (statement.indexOf(ICONNAME_M16) != -1) {
                this.iconM16 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(statement));
                continue;
            }
            if (statement.indexOf(ICONNAME_M32) == -1) continue;
            this.iconM32 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(statement));
        }
    }

    void setDefaultIdxFromBeanInfo(List<String> code) {
        for (String statement : code) {
            if (statement.indexOf(DEFAULT_PROPERTY_INDEX) != -1) {
                try {
                    this.defaultPropertyIndex = Integer.parseInt(BiAnalyser.getInitializer(statement));
                }
                catch (NumberFormatException e) {
                    this.defaultPropertyIndex = -1;
                }
                continue;
            }
            if (statement.indexOf(DEFAULT_EVENT_INDEX) == -1) continue;
            try {
                this.defaultEventIndex = Integer.parseInt(BiAnalyser.getInitializer(statement));
            }
            catch (NumberFormatException e) {
                this.defaultEventIndex = -1;
            }
        }
    }

    private void appendNoi18nText(StringBuilder sb) {
        sb.append(NOI18N_COMMENT);
    }

    void setIconModified() {
        if (this.isUpdateMode && !this.isIconModified) {
            this.isIconModified = true;
            this.setModified();
        }
    }

    void setModified() {
        if (this.isUpdateMode && !this.isModified) {
            this.isModified = true;
            BIEditorSupport editor = (BIEditorSupport)((Object)this.bis.getDataObject().getLookup().lookup(BIEditorSupport.class));
            editor.notifyModified();
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public boolean isBeanBroken() {
        return this.isBeanBroken;
    }
}

