/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.ComponentsFieldFinder;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteAWTScreenshot;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.netbeans.modules.debugger.jpda.visual.RetrievalException;
import org.netbeans.modules.debugger.jpda.visual.actions.ComponentBreakpointActionProvider;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToAddIntoHierarchyAction;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToFieldDeclarationAction;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToSourceAction;
import org.netbeans.modules.debugger.jpda.visual.actions.ToggleComponentBreakpointAction;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.models.ComponentBreakpointsActionsProvider;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.RemoteScreenshot;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RemoteFXScreenshot {
    private static final Logger logger = Logger.getLogger(RemoteFXScreenshot.class.getName());
    private static final String FXAppThreadName = "JavaFX Application Thread";
    private static final RemoteScreenshot[] NO_SCREENSHOTS = new RemoteScreenshot[0];
    private static final Collection<ObjectReference> pausedPlayers = new ArrayList<ObjectReference>();

    private RemoteFXScreenshot() {
    }

    private static RemoteScreenshot createRemoteFXScreenshot(DebuggerEngine engine, VirtualMachine vm, ThreadReference tr, String title, ObjectReference window, SGComponentInfo componentInfo) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        ClassType bufImageClass = RemoteFXScreenshot.getClass(vm, tr, "java.awt.image.BufferedImage");
        ClassType imageClass = RemoteFXScreenshot.getClass(vm, tr, "javafx.scene.image.Image");
        ClassType sceneClass = RemoteFXScreenshot.getClass(vm, tr, "javafx.scene.Scene");
        ClassType windowClass = RemoteFXScreenshot.getClass(vm, tr, "javafx.stage.Window");
        ClassType utilsClass = RemoteFXScreenshot.getClass(vm, tr, "javafx.embed.swing.SwingFXUtils");
        Method getScene = windowClass.concreteMethodByName("getScene", "()Ljavafx/scene/Scene;");
        Method fromPlatformImage = imageClass.concreteMethodByName("impl_fromPlatformImage", "(Ljava/lang/Object;)Ljavafx/scene/image/Image;");
        Method convertImage = imageClass.concreteMethodByName("impl_toExternalImage", "(Ljava/lang/Object;)Ljava/lang/Object;");
        Method renderImage = sceneClass.concreteMethodByName("renderToImage", "(Ljava/lang/Object;FZ)Ljava/lang/Object;");
        Method fromFXImage = utilsClass != null ? utilsClass.concreteMethodByName("fromFXImage", "(Ljavafx/scene/image/Image;Ljava/awt/image/BufferedImage;)Ljava/awt/image/BufferedImage;") : null;
        Method snapshot = sceneClass.concreteMethodByName("snapshot", "(Ljavafx/scene/image/WritableImage;)Ljavafx/scene/image/WritableImage;");
        ObjectReference scene = (ObjectReference)window.invokeMethod(tr, getScene, Collections.EMPTY_LIST, 1);
        FloatValue factor = vm.mirrorOf(1.0f);
        BooleanValue syncNeeded = vm.mirrorOf(false);
        ObjectReference image = null;
        if (snapshot != null) {
            image = (ObjectReference)scene.invokeMethod(tr, snapshot, Arrays.asList(new Value[]{null}), 1);
        } else if (renderImage != null) {
            ObjectReference pImage = (ObjectReference)scene.invokeMethod(tr, renderImage, Arrays.asList(null, factor, syncNeeded), 1);
            image = (ObjectReference)imageClass.invokeMethod(tr, fromPlatformImage, Arrays.asList(pImage), 1);
        }
        ObjectReference bufImage = null;
        if (fromFXImage != null) {
            bufImage = (ObjectReference)utilsClass.invokeMethod(tr, fromFXImage, Arrays.asList(image, null), 1);
        } else if (convertImage != null) {
            bufImage = (ObjectReference)image.invokeMethod(tr, convertImage, Arrays.asList(bufImageClass.classObject()), 1);
        }
        Method getData = ((ClassType)bufImage.referenceType()).concreteMethodByName("getData", "()Ljava/awt/image/Raster;");
        ObjectReference rasterRef = (ObjectReference)bufImage.invokeMethod(tr, getData, Collections.EMPTY_LIST, 1);
        ClassType rasterType = (ClassType)rasterRef.referenceType();
        Method getWidth = rasterType.concreteMethodByName("getWidth", "()I");
        Method getHeight = rasterType.concreteMethodByName("getHeight", "()I");
        Method getDataElements = rasterType.concreteMethodByName("getDataElements", "(IIIILjava/lang/Object;)Ljava/lang/Object;");
        IntegerValue zero = vm.mirrorOf(0);
        IntegerValue width = (IntegerValue)rasterRef.invokeMethod(tr, getWidth, Collections.EMPTY_LIST, 1);
        IntegerValue height = (IntegerValue)rasterRef.invokeMethod(tr, getHeight, Collections.EMPTY_LIST, 1);
        ArrayReference data = (ArrayReference)rasterRef.invokeMethod(tr, getDataElements, Arrays.asList(zero, zero, width, height, null), 1);
        logger.log(Level.FINE, "Image data length = {0}", data.length());
        List<Value> dataValues = data.getValues();
        int[] dataArray = new int[data.length()];
        int i = 0;
        for (Value v : dataValues) {
            dataArray[i++] = ((IntegerValue)v).value();
        }
        BufferedImage bi = new BufferedImage(width.value(), height.value(), 2);
        WritableRaster raster = bi.getRaster();
        raster.setDataElements(0, 0, width.intValue(), height.intValue(), dataArray);
        if (RemoteAWTScreenshot.FAST_FIELDS_SEARCH) {
            ComponentsFieldFinder.findFieldsForComponents(componentInfo);
        }
        return new RemoteScreenshot(engine, title, width.intValue(), height.intValue(), bi, componentInfo);
    }

    public static RemoteScreenshot[] takeCurrent() throws RetrievalException {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine != null) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            RemoteFXScreenshot.takeCurrent(debugger);
        }
        return NO_SCREENSHOTS;
    }

    public static RemoteScreenshot[] takeCurrent(JPDADebugger debugger) throws RetrievalException {
        logger.log(Level.FINE, "Debugger = {0}", debugger);
        if (debugger != null) {
            DebuggerEngine engine = ((JPDADebuggerImpl)debugger).getSession().getCurrentEngine();
            List allThreads = debugger.getThreadsCollector().getAllThreads();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Threads = {0}", allThreads);
            }
            for (JPDAThread t : allThreads) {
                if (!t.getName().startsWith(FXAppThreadName)) continue;
                return RemoteFXScreenshot.take(t, engine, (JPDADebuggerImpl)debugger);
            }
        }
        return NO_SCREENSHOTS;
    }

    public static RemoteScreenshot[] take(final JPDAThread t, final DebuggerEngine engine, final JPDADebuggerImpl d) throws RetrievalException {
        final ThreadReference tawt = ((JPDAThreadImpl)t).getThreadReference();
        final VirtualMachine vm = tawt.virtualMachine();
        ClassType windowClass = RemoteFXScreenshot.getClass(vm, tawt, "javafx.stage.Window");
        if (windowClass == null) {
            logger.fine("No Window");
            return NO_SCREENSHOTS;
        }
        Method getWindows = windowClass.concreteMethodByName("impl_getWindows", "()Ljava/util/Iterator;");
        if (getWindows == null) {
            logger.fine("No getWindows() method!");
            String msg = NbBundle.getMessage(RemoteFXScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Window.getWindows()");
            throw new RetrievalException(msg);
        }
        final ArrayList screenshots = new ArrayList();
        RetrievalException[] retrievalExceptionPtr = new RetrievalException[]{null};
        final RetrievalException[] thrown = new RetrievalException[1];
        try {
            RemoteServices.runOnStoppedThread(t, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        RemoteFXScreenshot.pauseAll(tawt, vm);
                        RemoteFXScreenshot.retrieveScreenshots((JPDAThreadImpl)t, tawt, vm, engine, d, screenshots);
                    }
                    catch (RetrievalException e) {
                        thrown[0] = e;
                    }
                    finally {
                        try {
                            RemoteFXScreenshot.resumeAll(tawt, vm);
                        }
                        catch (RetrievalException e) {
                            thrown[0] = e;
                        }
                    }
                }
            }, RemoteServices.ServiceType.FX);
        }
        catch (PropertyVetoException pve) {
            throw new RetrievalException(pve.getMessage(), pve);
        }
        if (thrown[0] != null) {
            throw thrown[0];
        }
        if (retrievalExceptionPtr[0] != null) {
            throw retrievalExceptionPtr[0];
        }
        return screenshots.toArray(new RemoteScreenshot[0]);
    }

    private static void retrieveScreenshots(JPDAThreadImpl t, ThreadReference tr, VirtualMachine vm, DebuggerEngine engine, JPDADebuggerImpl d, List<RemoteScreenshot> screenshots) throws RetrievalException {
        try {
            ClassType windowClass = RemoteFXScreenshot.getClass(vm, tr, "javafx.stage.Window");
            Method getWindows = windowClass.concreteMethodByName("impl_getWindows", "()Ljava/util/Iterator;");
            Method windowName = windowClass.concreteMethodByName("impl_getMXWindowType", "()Ljava/lang/String;");
            ObjectReference iterator = (ObjectReference)windowClass.invokeMethod(tr, getWindows, Collections.EMPTY_LIST, 1);
            ClassType iteratorClass = (ClassType)iterator.referenceType();
            Method hasNext = iteratorClass.concreteMethodByName("hasNext", "()Z");
            Method next = iteratorClass.concreteMethodByName("next", "()Ljava/lang/Object;");
            boolean nextFlag = false;
            do {
                BooleanValue bv;
                if (!(nextFlag = (bv = (BooleanValue)iterator.invokeMethod(tr, hasNext, Collections.EMPTY_LIST, 1)).booleanValue())) continue;
                ObjectReference window = (ObjectReference)iterator.invokeMethod(tr, next, Collections.EMPTY_LIST, 1);
                StringReference name = (StringReference)window.invokeMethod(tr, windowName, Collections.EMPTY_LIST, 1);
                SGComponentInfo windowInfo = new SGComponentInfo(t, window);
                screenshots.add(RemoteFXScreenshot.createRemoteFXScreenshot(engine, vm, tr, name.value(), window, windowInfo));
            } while (nextFlag);
        }
        catch (Exception e) {
            throw new RetrievalException(e.getMessage(), e);
        }
    }

    private static boolean pauseAll(ThreadReference tr, VirtualMachine vm) throws RetrievalException {
        ClassType toolkitClass = RemoteFXScreenshot.getClass(vm, tr, "com.sun.javafx.tk.Toolkit");
        if (toolkitClass == null) {
            logger.fine("No Toolkiit");
            return false;
        }
        Method getDefaultTk = toolkitClass.concreteMethodByName("getToolkit", "()Lcom/sun/javafx/tk/Toolkit;");
        if (getDefaultTk == null) {
            logger.fine("No getToolkit() method!");
            String msg = NbBundle.getMessage(RemoteFXScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"com.sun.javafx.tk.Toolkit.getToolkit()");
            throw new RetrievalException(msg);
        }
        Method pauseScenes = toolkitClass.concreteMethodByName("pauseScenes", "()V");
        if (pauseScenes == null) {
            logger.fine("No pauseScenes() method!");
            String msg = NbBundle.getMessage(RemoteFXScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"com.sun.javafx.tk.Toolkit.pauseScenes()");
            throw new RetrievalException(msg);
        }
        try {
            ObjectReference tk = (ObjectReference)toolkitClass.invokeMethod(tr, getDefaultTk, Collections.EMPTY_LIST, 1);
            tk.invokeMethod(tr, pauseScenes, Collections.EMPTY_LIST, 1);
            RemoteFXScreenshot.pauseMedia(tr, vm);
            return true;
        }
        catch (InvalidTypeException e) {
            throw new RetrievalException(e.getMessage(), e);
        }
        catch (ClassNotLoadedException e) {
            throw new RetrievalException(e.getMessage(), e);
        }
        catch (IncompatibleThreadStateException e) {
            throw new RetrievalException(e.getMessage(), e);
        }
        catch (InvocationException e) {
            throw new RetrievalException(e.getMessage(), e);
        }
        catch (ClassNotPreparedException e) {
            throw new RetrievalException(e.getMessage(), e);
        }
    }

    private static boolean resumeAll(ThreadReference tr, VirtualMachine vm) throws RetrievalException {
        ClassType toolkitClass = RemoteFXScreenshot.getClass(vm, tr, "com.sun.javafx.tk.Toolkit");
        if (toolkitClass == null) {
            logger.fine("No Toolkiit");
            return false;
        }
        Method getDefaultTk = toolkitClass.concreteMethodByName("getToolkit", "()Lcom/sun/javafx/tk/Toolkit;");
        if (getDefaultTk == null) {
            logger.fine("No getToolkit() method!");
            String msg = NbBundle.getMessage(RemoteFXScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"com.sun.javafx.tk.Toolkit.getToolkit()");
            throw new RetrievalException(msg);
        }
        Method resumeScenes = toolkitClass.concreteMethodByName("resumeScenes", "()V");
        if (resumeScenes == null) {
            logger.fine("No pauseScenes() method!");
            String msg = NbBundle.getMessage(RemoteFXScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"com.sun.javafx.tk.Toolkit.resumeScenes()");
            throw new RetrievalException(msg);
        }
        try {
            ObjectReference tk = (ObjectReference)toolkitClass.invokeMethod(tr, getDefaultTk, Collections.EMPTY_LIST, 1);
            tk.invokeMethod(tr, resumeScenes, Collections.EMPTY_LIST, 1);
            RemoteFXScreenshot.resumeMedia(tr, vm);
            return true;
        }
        catch (InvalidTypeException e) {
            throw new RetrievalException(e.getMessage(), e);
        }
        catch (ClassNotLoadedException e) {
            throw new RetrievalException(e.getMessage(), e);
        }
        catch (IncompatibleThreadStateException e) {
            throw new RetrievalException(e.getMessage(), e);
        }
        catch (InvocationException e) {
            throw new RetrievalException(e.getMessage(), e);
        }
    }

    private static void pauseMedia(ThreadReference tr, VirtualMachine vm) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        Method getAllPlayers;
        ObjectReference plList;
        ClassType audioClipClass = RemoteFXScreenshot.getClass(vm, tr, "com.sun.media.jfxmedia.AudioClip");
        ClassType mediaManagerClass = RemoteFXScreenshot.getClass(vm, tr, "com.sun.media.jfxmedia.MediaManager");
        InterfaceType mediaPlayerClass = RemoteFXScreenshot.getInterface(vm, tr, "com.sun.media.jfxmedia.MediaPlayer");
        ClassType playerStateEnum = RemoteFXScreenshot.getClass(vm, tr, "com.sun.media.jfxmedia.events.PlayerStateEvent$PlayerState");
        if (audioClipClass != null) {
            Method stopAllClips = audioClipClass.concreteMethodByName("stopAllClips", "()V");
            audioClipClass.invokeMethod(tr, stopAllClips, Collections.EMPTY_LIST, 1);
        }
        if (mediaManagerClass != null && mediaPlayerClass != null && playerStateEnum != null && (plList = (ObjectReference)mediaManagerClass.invokeMethod(tr, getAllPlayers = mediaManagerClass.concreteMethodByName("getAllMediaPlayers", "()Ljava/util/List;"), Collections.EMPTY_LIST, 1)) != null) {
            ClassType listType = (ClassType)plList.referenceType();
            Method iterator = listType.concreteMethodByName("iterator", "()Ljava/util/Iterator;");
            ObjectReference plIter = (ObjectReference)plList.invokeMethod(tr, iterator, Collections.EMPTY_LIST, 1);
            ClassType iterType = (ClassType)plIter.referenceType();
            Method hasNext = iterType.concreteMethodByName("hasNext", "()Z");
            Method next = iterType.concreteMethodByName("next", "()Ljava/lang/Object;");
            Field playingState = playerStateEnum.fieldByName("PLAYING");
            Method getState = mediaPlayerClass.methodsByName("getState", "()Lcom/sun/media/jfxmedia/events/PlayerStateEvent$PlayerState;").get(0);
            Method pausePlayer = mediaPlayerClass.methodsByName("pause", "()V").get(0);
            boolean hasNextFlag = false;
            do {
                ObjectReference player;
                ObjectReference curState;
                BooleanValue v;
                if (!(hasNextFlag = (v = (BooleanValue)plIter.invokeMethod(tr, hasNext, Collections.EMPTY_LIST, 1)).booleanValue()) || !playingState.equals(curState = (ObjectReference)(player = (ObjectReference)plIter.invokeMethod(tr, next, Collections.EMPTY_LIST, 1)).invokeMethod(tr, getState, Collections.EMPTY_LIST, 1))) continue;
                player.invokeMethod(tr, pausePlayer, Collections.EMPTY_LIST, 1);
                pausedPlayers.add(player);
            } while (hasNextFlag);
        }
    }

    private static void resumeMedia(ThreadReference tr, VirtualMachine vm) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        if (!pausedPlayers.isEmpty()) {
            InterfaceType mediaPlayerClass = RemoteFXScreenshot.getInterface(vm, tr, "com.sun.media.jfxmedia.MediaPlayer");
            List<Method> play = mediaPlayerClass.methodsByName("play", "()V");
            if (play.isEmpty()) {
                return;
            }
            Method p = play.iterator().next();
            for (ObjectReference pR : pausedPlayers) {
                pR.invokeMethod(tr, p, Collections.EMPTY_LIST, 1);
            }
        }
    }

    private static ClassType getClass(VirtualMachine vm, ThreadReference tr, String name) {
        ReferenceType t = RemoteFXScreenshot.getType(vm, tr, name);
        if (t instanceof ClassType) {
            return (ClassType)t;
        }
        logger.log(Level.WARNING, "{0} is not a class but {1}", new Object[]{name, t});
        return null;
    }

    private static InterfaceType getInterface(VirtualMachine vm, ThreadReference tr, String name) {
        ReferenceType t = RemoteFXScreenshot.getType(vm, tr, name);
        if (t instanceof InterfaceType) {
            return (InterfaceType)t;
        }
        logger.log(Level.WARNING, "{0} is not an interface but {1}", new Object[]{name, t});
        return null;
    }

    private static ReferenceType getType(VirtualMachine vm, ThreadReference tr, String name) {
        List<ReferenceType> classList = vm.classesByName(name);
        if (!classList.isEmpty()) {
            return classList.iterator().next();
        }
        List<ReferenceType> classClassList = vm.classesByName("java.lang.Class");
        if (classClassList.isEmpty()) {
            throw new IllegalStateException("Cannot load class Class");
        }
        ClassType cls = (ClassType)classClassList.iterator().next();
        Method m = cls.concreteMethodByName("forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        StringReference mirrorOfName = vm.mirrorOf(name);
        try {
            cls.invokeMethod(tr, m, Collections.singletonList(mirrorOfName), 1);
            List<ReferenceType> classList2 = vm.classesByName(name);
            if (!classList2.isEmpty()) {
                return classList2.iterator().next();
            }
        }
        catch (InvalidTypeException ex) {
            logger.log(Level.FINE, "Cannot load class " + name, ex);
        }
        catch (ClassNotLoadedException ex) {
            logger.log(Level.FINE, "Cannot load class " + name, ex);
        }
        catch (IncompatibleThreadStateException ex) {
            logger.log(Level.FINE, "Cannot load class " + name, ex);
        }
        catch (InvocationException ex) {
            logger.log(Level.FINE, "Cannot load class " + name, ex);
        }
        return null;
    }

    public static class SGComponentInfo
    extends JavaComponentInfo {
        private static final Action CBP_CUSTOMIZE_ACTION = new NodeAction(){

            public String getName() {
                return NbBundle.getBundle(RemoteFXScreenshot.class).getString("CTL_Component_Breakpoint_Customize_Label");
            }

            protected boolean enable(Node[] activatedNodes) {
                return true;
            }

            protected boolean asynchronous() {
                return false;
            }

            protected void performAction(Node[] activatedNodes) {
                for (Node n : activatedNodes) {
                    JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
                    if (ci == null) continue;
                    ObjectReference component = ci.getComponent();
                    ComponentBreakpoint b = ComponentBreakpointActionProvider.findBreakpoint(component);
                    ComponentBreakpointsActionsProvider.customize(b);
                }
            }

            public HelpCtx getHelpCtx() {
                return new HelpCtx("ComponentBreakpoint_Customize");
            }
        };

        public SGComponentInfo(JPDAThreadImpl t, ObjectReference component) throws RetrievalException {
            super(t, component, RemoteServices.ServiceType.FX);
            this.init();
        }

        @Override
        protected String getFieldName() {
            String fName = super.getFieldName();
            if (fName.isEmpty()) {
                return this.getName();
            }
            return fName;
        }

        @Override
        protected void retrieve() throws RetrievalException {
            VirtualMachine vm = this.getThread().getDebugger().getVirtualMachine();
            if (vm == null) {
                throw RetrievalException.disconnected();
            }
            ThreadReference tr = this.getThread().getThreadReference();
            ClassType compClass = (ClassType)this.getComponent().referenceType();
            try {
                if (compClass.name().equals("javafx.stage.Window") || compClass.name().equals("javafx.stage.Stage")) {
                    Method getTitle = compClass.concreteMethodByName("getTitle", "()Ljava/lang/String;");
                    if (getTitle != null) {
                        StringReference nameR = (StringReference)this.getComponent().invokeMethod(tr, getTitle, Collections.EMPTY_LIST, 1);
                        this.setName(nameR != null ? nameR.value() : "");
                    }
                    Method getScene = compClass.concreteMethodByName("getScene", "()Ljavafx/scene/Scene;");
                    ObjectReference scene = (ObjectReference)this.getComponent().invokeMethod(tr, getScene, Collections.EMPTY_LIST, 1);
                    ClassType sceneClass = (ClassType)scene.referenceType();
                    Method getX = sceneClass.concreteMethodByName("getX", "()D");
                    Method getY = sceneClass.concreteMethodByName("getY", "()D");
                    Method getWidth = sceneClass.concreteMethodByName("getWidth", "()D");
                    Method getHeight = sceneClass.concreteMethodByName("getHeight", "()D");
                    DoubleValue x = (DoubleValue)scene.invokeMethod(tr, getX, Collections.EMPTY_LIST, 1);
                    DoubleValue y = (DoubleValue)scene.invokeMethod(tr, getY, Collections.EMPTY_LIST, 1);
                    DoubleValue width = (DoubleValue)scene.invokeMethod(tr, getWidth, Collections.EMPTY_LIST, 1);
                    DoubleValue height = (DoubleValue)scene.invokeMethod(tr, getHeight, Collections.EMPTY_LIST, 1);
                    Rectangle b = new Rectangle(x.intValue(), y.intValue(), width.intValue(), height.intValue());
                    b.x = 0;
                    b.y = 0;
                    this.setWindowBounds(b);
                    this.setBounds(b);
                    Method getRoot = sceneClass.concreteMethodByName("getRoot", "()Ljavafx/scene/Parent;");
                    ObjectReference root = (ObjectReference)scene.invokeMethod(tr, getRoot, Collections.EMPTY_LIST, 1);
                    SGComponentInfo rootInfo = new SGComponentInfo(this.getThread(), root);
                    this.setSubComponents(new JavaComponentInfo[]{rootInfo});
                } else {
                    Method getId = compClass.concreteMethodByName("getId", "()Ljava/lang/String;");
                    if (getId != null) {
                        StringReference id = (StringReference)this.getComponent().invokeMethod(tr, getId, Collections.EMPTY_LIST, 1);
                        this.setName(id != null ? id.value() : "");
                    }
                    Method getLocalBounds = compClass.concreteMethodByName("getBoundsInLocal", "()Ljavafx/geometry/Bounds;");
                    Method local2scene = compClass.concreteMethodByName("localToScene", "(Ljavafx/geometry/Bounds;)Ljavafx/geometry/Bounds;");
                    Method local2parent = compClass.concreteMethodByName("localToParent", "(Ljavafx/geometry/Bounds;)Ljavafx/geometry/Bounds;");
                    ObjectReference locBounds = (ObjectReference)this.getComponent().invokeMethod(tr, getLocalBounds, Collections.EMPTY_LIST, 1);
                    ObjectReference relBounds = (ObjectReference)this.getComponent().invokeMethod(tr, local2parent, Arrays.asList(locBounds), 1);
                    ObjectReference absBounds = (ObjectReference)this.getComponent().invokeMethod(tr, local2scene, Arrays.asList(locBounds), 1);
                    this.setBounds(SGComponentInfo.convertBounds(relBounds));
                    this.setWindowBounds(SGComponentInfo.convertBounds(absBounds));
                    Field children = compClass.fieldByName("children");
                    if (children != null) {
                        ObjectReference childrenList = (ObjectReference)this.getComponent().getValue(children);
                        ClassType listClass = (ClassType)childrenList.referenceType();
                        Method size = listClass.concreteMethodByName("size", "()I");
                        Method get = listClass.concreteMethodByName("get", "(I)Ljava/lang/Object;");
                        int cnt = ((IntegerValue)childrenList.invokeMethod(tr, size, Collections.EMPTY_LIST, 1)).intValue();
                        JavaComponentInfo[] cs = new JavaComponentInfo[cnt];
                        for (int i = 0; i < cnt; ++i) {
                            ObjectReference sub = (ObjectReference)childrenList.invokeMethod(tr, get, Arrays.asList(vm.mirrorOf(i)), 1);
                            cs[i] = new SGComponentInfo(this.getThread(), sub);
                        }
                        this.setSubComponents(cs);
                    }
                }
            }
            catch (InvalidTypeException e) {
            }
            catch (ClassNotLoadedException e) {
            }
            catch (IncompatibleThreadStateException e) {
            }
            catch (InvocationException e) {
                // empty catch block
            }
        }

        private static Rectangle convertBounds(ObjectReference bounds) {
            ClassType boundsClass = (ClassType)bounds.referenceType();
            Field minX = boundsClass.fieldByName("minX");
            Field minY = boundsClass.fieldByName("minY");
            Field width = boundsClass.fieldByName("width");
            Field height = boundsClass.fieldByName("height");
            return new Rectangle(((DoubleValue)bounds.getValue(minX)).intValue(), ((DoubleValue)bounds.getValue(minY)).intValue(), ((DoubleValue)bounds.getValue(width)).intValue(), ((DoubleValue)bounds.getValue(height)).intValue());
        }

        @Override
        public Action[] getActions(boolean context) {
            JavaComponentInfo.FieldInfo fieldInfo = this.getField();
            ObjectReference component = this.getComponent();
            ComponentBreakpoint b = ComponentBreakpointActionProvider.findBreakpoint(component);
            ArrayList<Object> actions = new ArrayList<Object>();
            if (fieldInfo != null) {
                actions.add(GoToFieldDeclarationAction.get(GoToFieldDeclarationAction.class));
            }
            actions.add(GoToSourceAction.get(GoToSourceAction.class));
            if (this.getAddCallStack() != null) {
                actions.add(GoToAddIntoHierarchyAction.get(GoToAddIntoHierarchyAction.class));
            }
            actions.add(null);
            actions.add(ToggleComponentBreakpointAction.get(ToggleComponentBreakpointAction.class));
            if (b != null) {
                actions.add(CBP_CUSTOMIZE_ACTION);
            }
            return actions.toArray(new Action[0]);
        }

        @Override
        public ComponentInfo findAt(int x, int y) {
            Rectangle bounds = this.getWindowBounds();
            if (!bounds.contains(x, y)) {
                return null;
            }
            JavaComponentInfo[] subComponents = this.getSubComponents();
            if (subComponents != null) {
                Rectangle tempRect = null;
                ComponentInfo tempRslt = null;
                for (int i = 0; i < subComponents.length; ++i) {
                    Rectangle tbounds;
                    Rectangle sb = subComponents[i].getWindowBounds();
                    if (!sb.contains(x, y)) continue;
                    tempRect = sb;
                    tempRslt = subComponents[i];
                    ComponentInfo tci = subComponents[i].findAt(x, y);
                    if (tci == null || !tempRect.intersects(tbounds = tci.getWindowBounds())) continue;
                    tempRect = tbounds;
                    tempRslt = tci;
                }
                return tempRslt;
            }
            return this;
        }
    }
}

