/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.ScanMonitor;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class FileScanningWorker
implements Runnable {
    private TaskList taskList;
    private boolean isCancel = false;
    private Set<FileTaskScanner> preparedScanners = new HashSet<FileTaskScanner>();
    private Iterator<FileObject> resourceIterator;
    private Queue<FileObject> priorityResourceIterator = new LinkedList<FileObject>();
    private Map<FileObject, Collection<FileTaskScanner>> priorityResource2scanner = new HashMap<FileObject, Collection<FileTaskScanner>>();
    private TaskFilter filter;
    private final Object SCAN_LOCK = new Object();
    private final Object SLEEP_LOCK = new Object();
    private boolean killed = false;
    private List<Task> scannedTasks = new LinkedList<Task>();

    public FileScanningWorker(TaskList taskList, TaskFilter filter) {
        this.taskList = taskList;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Iterator<FileObject> resources, TaskFilter filter) {
        this.abort();
        Object object = this.SLEEP_LOCK;
        synchronized (object) {
            this.filter = filter;
            List<FileTaskScanner> providers = ScannerList.getFileScannerList().getScanners();
            for (FileTaskScanner ts : providers) {
                if (!filter.isEnabled(ts) || this.preparedScanners.contains(ts)) continue;
                ts.notifyPrepare();
                this.preparedScanners.add(ts);
            }
            this.resourceIterator = resources;
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void priorityScan(FileTaskScanner scanner, FileObject ... res) {
        boolean wakeupNeeded = false;
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            boolean bl = wakeupNeeded = this.isCancel || !this.hasNext();
            if (this.filter.isEnabled(scanner)) {
                if (!this.preparedScanners.contains(scanner)) {
                    scanner.notifyPrepare();
                    this.preparedScanners.add(scanner);
                }
                for (FileObject rc : res) {
                    Collection<FileTaskScanner> scanners = this.priorityResource2scanner.get(rc);
                    if (null == scanners) {
                        scanners = new ArrayList<FileTaskScanner>(10);
                        this.priorityResource2scanner.put(rc, scanners);
                    }
                    if (this.priorityResourceIterator.contains(rc)) continue;
                    this.priorityResourceIterator.offer(rc);
                }
            }
        }
        if (wakeupNeeded) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void priorityScan(FileObject ... res) {
        boolean wakeupNeeded = false;
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            wakeupNeeded = this.isCancel || !this.hasNext();
            List<FileTaskScanner> scanners = ScannerList.getFileScannerList().getScanners();
            for (FileTaskScanner ts : scanners) {
                if (!this.filter.isEnabled(ts) || this.preparedScanners.contains(ts)) continue;
                ts.notifyPrepare();
                this.preparedScanners.add(ts);
            }
            for (FileObject rc : res) {
                this.priorityResource2scanner.remove(rc);
                if (this.priorityResourceIterator.contains(rc)) continue;
                this.priorityResourceIterator.offer(rc);
            }
        }
        if (wakeupNeeded) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.SLEEP_LOCK;
        synchronized (object) {
            block10: while (true) {
                while (true) {
                    try {
                        while (true) {
                            if (this.killed) {
                                return;
                            }
                            HashSet<FileTaskScanner> scannersToNotify = null;
                            ScanItem item = new ScanItem();
                            ScanMonitor monitor = ScanMonitor.getDefault();
                            do {
                                monitor.waitEnabled();
                                Object object2 = this.SCAN_LOCK;
                                synchronized (object2) {
                                    if (this.getNext(item)) {
                                        if (!this.scan(item)) {
                                            this.isCancel = true;
                                        }
                                    } else {
                                        this.isCancel = true;
                                    }
                                    if (this.isCancel) {
                                        scannersToNotify = new HashSet<FileTaskScanner>(this.preparedScanners);
                                    }
                                }
                            } while (!this.isCancel);
                            this.cleanUp(scannersToNotify);
                            try {
                                this.SLEEP_LOCK.wait();
                                continue block10;
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        Exceptions.printStackTrace((Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        Object object = this.SLEEP_LOCK;
        synchronized (object) {
            this.isCancel = false;
            this.SLEEP_LOCK.notifyAll();
        }
    }

    void abort() {
        this.isCancel = true;
    }

    void kill() {
        this.abort();
        this.killed = true;
        this.wakeup();
    }

    private boolean scan(ScanItem item) {
        if (this.isCancel) {
            return false;
        }
        boolean atLeastOneProviderIsActive = false;
        for (FileTaskScanner scanner : item.scanners) {
            if (!this.filter.isEnabled(scanner) || this.filter.isTaskCountLimitReached(this.taskList.countTasks(scanner))) continue;
            atLeastOneProviderIsActive = true;
            this.scannedTasks.clear();
            List newTasks = null;
            try {
                if (item.resource.isValid()) {
                    newTasks = scanner.scan(item.resource);
                }
            }
            catch (Throwable e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            if (newTasks != null) {
                this.scannedTasks.addAll(newTasks);
            }
            if (this.isCancel) {
                return false;
            }
            this.taskList.update(scanner, item.resource, this.scannedTasks, this.filter);
        }
        return atLeastOneProviderIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(Set<FileTaskScanner> scannersToNotify) {
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            this.resourceIterator = null;
            this.priorityResourceIterator.clear();
            this.priorityResource2scanner.clear();
        }
        this.notifyFinished(scannersToNotify);
    }

    private void notifyFinished(Set<FileTaskScanner> scannersToNotify) {
        if (null != scannersToNotify) {
            for (FileTaskScanner ts : scannersToNotify) {
                ts.notifyFinish();
            }
        }
        this.preparedScanners.clear();
    }

    private boolean getNext(ScanItem item) {
        item.resource = this.priorityResourceIterator.poll();
        item.scanners = this.preparedScanners;
        if (null != item.resource) {
            item.scanners = this.priorityResource2scanner.get(item.resource);
            if (null == item.scanners) {
                item.scanners = this.preparedScanners;
            }
        } else if (null != this.resourceIterator && this.resourceIterator.hasNext()) {
            item.resource = this.resourceIterator.next();
        }
        return null != item.resource;
    }

    private boolean hasNext() {
        return this.priorityResourceIterator.size() > 0 || null != this.resourceIterator && this.resourceIterator.hasNext();
    }

    private static class ScanItem {
        FileObject resource;
        Collection<FileTaskScanner> scanners;

        private ScanItem() {
        }
    }
}

